package software.amazon.awscdk.services.apigatewayv2;

/**
 * Props for WebSocket API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * // This function handles your WebSocket requests
 * Function handler;
 * WebSocketLambdaAuthorizer authorizer = new WebSocketLambdaAuthorizer("Authorizer", authHandler);
 * WebSocketLambdaIntegration integration = new WebSocketLambdaIntegration("Integration", handler);
 * WebSocketApi.Builder.create(this, "WebSocketApi")
 *         .connectRouteOptions(WebSocketRouteOptions.builder()
 *                 .integration(integration)
 *                 .authorizer(authorizer)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:32.239Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketApiProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An API key selection expression.
     * <p>
     * Providing this option will require an API Key be provided to access the API.
     * <p>
     * Default: - Key is not required to access these APIs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression getApiKeySelectionExpression() {
        return null;
    }

    /**
     * Name for the WebSocket API resource.
     * <p>
     * Default: - id of the WebSocketApi construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiName() {
        return null;
    }

    /**
     * Options to configure a '$connect' route.
     * <p>
     * Default: - no '$connect' route configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions getConnectRouteOptions() {
        return null;
    }

    /**
     * Options to configure a '$default' route.
     * <p>
     * Default: - no '$default' route configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions getDefaultRouteOptions() {
        return null;
    }

    /**
     * The description of the API.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Options to configure a '$disconnect' route.
     * <p>
     * Default: - no '$disconnect' route configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions getDisconnectRouteOptions() {
        return null;
    }

    /**
     * The route selection expression for the API.
     * <p>
     * Default: '$request.body.action'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRouteSelectionExpression() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketApiProps> {
        software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression apiKeySelectionExpression;
        java.lang.String apiName;
        software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions connectRouteOptions;
        software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions defaultRouteOptions;
        java.lang.String description;
        software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions disconnectRouteOptions;
        java.lang.String routeSelectionExpression;

        /**
         * Sets the value of {@link WebSocketApiProps#getApiKeySelectionExpression}
         * @param apiKeySelectionExpression An API key selection expression.
         *                                  Providing this option will require an API Key be provided to access the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySelectionExpression(software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiProps#getApiName}
         * @param apiName Name for the WebSocket API resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(java.lang.String apiName) {
            this.apiName = apiName;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiProps#getConnectRouteOptions}
         * @param connectRouteOptions Options to configure a '$connect' route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectRouteOptions(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions connectRouteOptions) {
            this.connectRouteOptions = connectRouteOptions;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiProps#getDefaultRouteOptions}
         * @param defaultRouteOptions Options to configure a '$default' route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteOptions(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions defaultRouteOptions) {
            this.defaultRouteOptions = defaultRouteOptions;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiProps#getDescription}
         * @param description The description of the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiProps#getDisconnectRouteOptions}
         * @param disconnectRouteOptions Options to configure a '$disconnect' route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disconnectRouteOptions(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions disconnectRouteOptions) {
            this.disconnectRouteOptions = disconnectRouteOptions;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiProps#getRouteSelectionExpression}
         * @param routeSelectionExpression The route selection expression for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSelectionExpression(java.lang.String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketApiProps {
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression apiKeySelectionExpression;
        private final java.lang.String apiName;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions connectRouteOptions;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions defaultRouteOptions;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions disconnectRouteOptions;
        private final java.lang.String routeSelectionExpression;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeySelectionExpression = software.amazon.jsii.Kernel.get(this, "apiKeySelectionExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression.class));
            this.apiName = software.amazon.jsii.Kernel.get(this, "apiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectRouteOptions = software.amazon.jsii.Kernel.get(this, "connectRouteOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions.class));
            this.defaultRouteOptions = software.amazon.jsii.Kernel.get(this, "defaultRouteOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disconnectRouteOptions = software.amazon.jsii.Kernel.get(this, "disconnectRouteOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions.class));
            this.routeSelectionExpression = software.amazon.jsii.Kernel.get(this, "routeSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
            this.apiName = builder.apiName;
            this.connectRouteOptions = builder.connectRouteOptions;
            this.defaultRouteOptions = builder.defaultRouteOptions;
            this.description = builder.description;
            this.disconnectRouteOptions = builder.disconnectRouteOptions;
            this.routeSelectionExpression = builder.routeSelectionExpression;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketApiKeySelectionExpression getApiKeySelectionExpression() {
            return this.apiKeySelectionExpression;
        }

        @Override
        public final java.lang.String getApiName() {
            return this.apiName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions getConnectRouteOptions() {
            return this.connectRouteOptions;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions getDefaultRouteOptions() {
            return this.defaultRouteOptions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteOptions getDisconnectRouteOptions() {
            return this.disconnectRouteOptions;
        }

        @Override
        public final java.lang.String getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeySelectionExpression() != null) {
                data.set("apiKeySelectionExpression", om.valueToTree(this.getApiKeySelectionExpression()));
            }
            if (this.getApiName() != null) {
                data.set("apiName", om.valueToTree(this.getApiName()));
            }
            if (this.getConnectRouteOptions() != null) {
                data.set("connectRouteOptions", om.valueToTree(this.getConnectRouteOptions()));
            }
            if (this.getDefaultRouteOptions() != null) {
                data.set("defaultRouteOptions", om.valueToTree(this.getDefaultRouteOptions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisconnectRouteOptions() != null) {
                data.set("disconnectRouteOptions", om.valueToTree(this.getDisconnectRouteOptions()));
            }
            if (this.getRouteSelectionExpression() != null) {
                data.set("routeSelectionExpression", om.valueToTree(this.getRouteSelectionExpression()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketApiProps.Jsii$Proxy that = (WebSocketApiProps.Jsii$Proxy) o;

            if (this.apiKeySelectionExpression != null ? !this.apiKeySelectionExpression.equals(that.apiKeySelectionExpression) : that.apiKeySelectionExpression != null) return false;
            if (this.apiName != null ? !this.apiName.equals(that.apiName) : that.apiName != null) return false;
            if (this.connectRouteOptions != null ? !this.connectRouteOptions.equals(that.connectRouteOptions) : that.connectRouteOptions != null) return false;
            if (this.defaultRouteOptions != null ? !this.defaultRouteOptions.equals(that.defaultRouteOptions) : that.defaultRouteOptions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disconnectRouteOptions != null ? !this.disconnectRouteOptions.equals(that.disconnectRouteOptions) : that.disconnectRouteOptions != null) return false;
            return this.routeSelectionExpression != null ? this.routeSelectionExpression.equals(that.routeSelectionExpression) : that.routeSelectionExpression == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeySelectionExpression != null ? this.apiKeySelectionExpression.hashCode() : 0;
            result = 31 * result + (this.apiName != null ? this.apiName.hashCode() : 0);
            result = 31 * result + (this.connectRouteOptions != null ? this.connectRouteOptions.hashCode() : 0);
            result = 31 * result + (this.defaultRouteOptions != null ? this.defaultRouteOptions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disconnectRouteOptions != null ? this.disconnectRouteOptions.hashCode() : 0);
            result = 31 * result + (this.routeSelectionExpression != null ? this.routeSelectionExpression.hashCode() : 0);
            return result;
        }
    }
}
