package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Properties for defining a <code>CfnScalingPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * CfnScalingPolicyProps cfnScalingPolicyProps = CfnScalingPolicyProps.builder()
 *         .policyName("policyName")
 *         .policyType("policyType")
 *         // the properties below are optional
 *         .predictiveScalingPolicyConfiguration(PredictiveScalingPolicyConfigurationProperty.builder()
 *                 .metricSpecifications(List.of(PredictiveScalingMetricSpecificationProperty.builder()
 *                         .targetValue(123)
 *                         // the properties below are optional
 *                         .customizedCapacityMetricSpecification(PredictiveScalingCustomizedCapacityMetricProperty.builder()
 *                                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
 *                                         .expression("expression")
 *                                         .id("id")
 *                                         .label("label")
 *                                         .metricStat(PredictiveScalingMetricStatProperty.builder()
 *                                                 .metric(PredictiveScalingMetricProperty.builder()
 *                                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .customizedLoadMetricSpecification(PredictiveScalingCustomizedLoadMetricProperty.builder()
 *                                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
 *                                         .expression("expression")
 *                                         .id("id")
 *                                         .label("label")
 *                                         .metricStat(PredictiveScalingMetricStatProperty.builder()
 *                                                 .metric(PredictiveScalingMetricProperty.builder()
 *                                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .customizedScalingMetricSpecification(PredictiveScalingCustomizedScalingMetricProperty.builder()
 *                                 .metricDataQueries(List.of(PredictiveScalingMetricDataQueryProperty.builder()
 *                                         .expression("expression")
 *                                         .id("id")
 *                                         .label("label")
 *                                         .metricStat(PredictiveScalingMetricStatProperty.builder()
 *                                                 .metric(PredictiveScalingMetricProperty.builder()
 *                                                         .dimensions(List.of(PredictiveScalingMetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .maxCapacityBreachBehavior("maxCapacityBreachBehavior")
 *                 .maxCapacityBuffer(123)
 *                 .mode("mode")
 *                 .schedulingBufferTime(123)
 *                 .build())
 *         .resourceId("resourceId")
 *         .scalableDimension("scalableDimension")
 *         .scalingTargetId("scalingTargetId")
 *         .serviceNamespace("serviceNamespace")
 *         .stepScalingPolicyConfiguration(StepScalingPolicyConfigurationProperty.builder()
 *                 .adjustmentType("adjustmentType")
 *                 .cooldown(123)
 *                 .metricAggregationType("metricAggregationType")
 *                 .minAdjustmentMagnitude(123)
 *                 .stepAdjustments(List.of(StepAdjustmentProperty.builder()
 *                         .scalingAdjustment(123)
 *                         // the properties below are optional
 *                         .metricIntervalLowerBound(123)
 *                         .metricIntervalUpperBound(123)
 *                         .build()))
 *                 .build())
 *         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                 .targetValue(123)
 *                 // the properties below are optional
 *                 .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .metricName("metricName")
 *                         .metrics(List.of(TargetTrackingMetricDataQueryProperty.builder()
 *                                 .expression("expression")
 *                                 .id("id")
 *                                 .label("label")
 *                                 .metricStat(TargetTrackingMetricStatProperty.builder()
 *                                         .metric(TargetTrackingMetricProperty.builder()
 *                                                 .dimensions(List.of(TargetTrackingMetricDimensionProperty.builder()
 *                                                         .name("name")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .metricName("metricName")
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .stat("stat")
 *                                         .unit("unit")
 *                                         .build())
 *                                 .returnData(false)
 *                                 .build()))
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         .unit("unit")
 *                         .build())
 *                 .disableScaleIn(false)
 *                 .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .scaleInCooldown(123)
 *                 .scaleOutCooldown(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:32.789Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScalingPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the scaling policy.
     * <p>
     * Updates to the name of a target tracking scaling policy are not supported, unless you also update the metric used for scaling. To change only a target tracking scaling policy's name, first delete the policy by removing the existing <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource from the template and updating the stack. Then, recreate the resource with the same settings and a different name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

    /**
     * The scaling policy type.
     * <p>
     * The following policy types are supported:
     * <p>
     * <code>TargetTrackingScaling</code> —Not supported for Amazon EMR
     * <p>
     * <code>StepScaling</code> —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyType();

    /**
     * The predictive scaling policy configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-predictivescalingpolicyconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveScalingPolicyConfiguration() {
        return null;
    }

    /**
     * The identifier of the resource associated with the scaling policy.
     * <p>
     * This string consists of the resource type and unique identifier.
     * <p>
     * <ul>
     * <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/my-cluster/my-service</code> .</li>
     * <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
     * <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
     * <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
     * <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
     * <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
     * <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
     * <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
     * <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
     * <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
     * <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
     * <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
     * <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
     * <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
     * <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
     * <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
     * <li>SageMaker serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
     * <li>SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier is the resource ID. Example: <code>inference-component/my-inference-component</code> .</li>
     * <li>Pool of WorkSpaces - The resource type is <code>workspacespool</code> and the unique identifier is the pool ID. Example: <code>workspacespool/wspool-123456</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
        return null;
    }

    /**
     * The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
     * <p>
     * <ul>
     * <li><code>ecs:service:DesiredCount</code> - The task count of an ECS service.</li>
     * <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
     * <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
     * <li><code>appstream:fleet:DesiredCapacity</code> - The capacity of an AppStream 2.0 fleet.</li>
     * <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
     * <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
     * <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
     * <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
     * <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
     * <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
     * <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
     * <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
     * <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
     * <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
     * <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
     * <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
     * <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
     * <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
     * <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
     * <li><code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker serverless endpoint.</li>
     * <li><code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a SageMaker inference component.</li>
     * <li><code>workspaces:workspacespool:DesiredUserSessions</code> - The number of user sessions for the WorkSpaces in the pool.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScalableDimension() {
        return null;
    }

    /**
     * The CloudFormation-generated ID of an Application Auto Scaling scalable target.
     * <p>
     * For more information about the ID, see the Return Value section of the <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource.
     * <p>
     * <blockquote>
     * <p>
     * You must specify either the <code>ScalingTargetId</code> property, or the <code>ResourceId</code> , <code>ScalableDimension</code> , and <code>ServiceNamespace</code> properties, but not both.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScalingTargetId() {
        return null;
    }

    /**
     * The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceNamespace() {
        return null;
    }

    /**
     * A step scaling policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStepScalingPolicyConfiguration() {
        return null;
    }

    /**
     * A target tracking scaling policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScalingPolicyProps> {
        java.lang.String policyName;
        java.lang.String policyType;
        java.lang.Object predictiveScalingPolicyConfiguration;
        java.lang.String resourceId;
        java.lang.String scalableDimension;
        java.lang.String scalingTargetId;
        java.lang.String serviceNamespace;
        java.lang.Object stepScalingPolicyConfiguration;
        java.lang.Object targetTrackingScalingPolicyConfiguration;

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPolicyName}
         * @param policyName The name of the scaling policy. This parameter is required.
         *                   Updates to the name of a target tracking scaling policy are not supported, unless you also update the metric used for scaling. To change only a target tracking scaling policy's name, first delete the policy by removing the existing <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> resource from the template and updating the stack. Then, recreate the resource with the same settings and a different name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPolicyType}
         * @param policyType The scaling policy type. This parameter is required.
         *                   The following policy types are supported:
         *                   <p>
         *                   <code>TargetTrackingScaling</code> —Not supported for Amazon EMR
         *                   <p>
         *                   <code>StepScaling</code> —Not supported for DynamoDB, Amazon Comprehend, Lambda, Amazon Keyspaces, Amazon MSK, Amazon ElastiCache, or Neptune.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(java.lang.String policyType) {
            this.policyType = policyType;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPredictiveScalingPolicyConfiguration}
         * @param predictiveScalingPolicyConfiguration The predictive scaling policy configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingPolicyConfiguration(software.amazon.awscdk.IResolvable predictiveScalingPolicyConfiguration) {
            this.predictiveScalingPolicyConfiguration = predictiveScalingPolicyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPredictiveScalingPolicyConfiguration}
         * @param predictiveScalingPolicyConfiguration The predictive scaling policy configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingPolicyConfiguration(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.PredictiveScalingPolicyConfigurationProperty predictiveScalingPolicyConfiguration) {
            this.predictiveScalingPolicyConfiguration = predictiveScalingPolicyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getResourceId}
         * @param resourceId The identifier of the resource associated with the scaling policy.
         *                   This string consists of the resource type and unique identifier.
         *                   <p>
         *                   <ul>
         *                   <li>ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service name. Example: <code>service/my-cluster/my-service</code> .</li>
         *                   <li>Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code> .</li>
         *                   <li>EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code> .</li>
         *                   <li>AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name. Example: <code>fleet/sample-fleet</code> .</li>
         *                   <li>DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>table/my-table</code> .</li>
         *                   <li>DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index name. Example: <code>table/my-table/index/my-table-index</code> .</li>
         *                   <li>Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:my-db-cluster</code> .</li>
         *                   <li>SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         *                   <li>Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique identifier is defined by the service provider. More information is available in our <a href="https://docs.aws.amazon.com/https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a> .</li>
         *                   <li>Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code> .</li>
         *                   <li>Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code> .</li>
         *                   <li>Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the function name with a function version or alias name suffix that is not <code>$LATEST</code> . Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code> .</li>
         *                   <li>Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name. Example: <code>keyspace/mykeyspace/table/mytable</code> .</li>
         *                   <li>Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example: <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code> .</li>
         *                   <li>Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique identifier is the replication group name. Example: <code>replication-group/mycluster</code> .</li>
         *                   <li>Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name. Example: <code>cluster:mycluster</code> .</li>
         *                   <li>SageMaker serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code> .</li>
         *                   <li>SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier is the resource ID. Example: <code>inference-component/my-inference-component</code> .</li>
         *                   <li>Pool of WorkSpaces - The resource type is <code>workspacespool</code> and the unique identifier is the pool ID. Example: <code>workspacespool/wspool-123456</code> .</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getScalableDimension}
         * @param scalableDimension The scalable dimension. This string consists of the service namespace, resource type, and scaling property.
         *                          <ul>
         *                          <li><code>ecs:service:DesiredCount</code> - The task count of an ECS service.</li>
         *                          <li><code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.</li>
         *                          <li><code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.</li>
         *                          <li><code>appstream:fleet:DesiredCapacity</code> - The capacity of an AppStream 2.0 fleet.</li>
         *                          <li><code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.</li>
         *                          <li><code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.</li>
         *                          <li><code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary index.</li>
         *                          <li><code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary index.</li>
         *                          <li><code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.</li>
         *                          <li><code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint variant.</li>
         *                          <li><code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by your own application or service.</li>
         *                          <li><code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend document classification endpoint.</li>
         *                          <li><code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an Amazon Comprehend entity recognizer endpoint.</li>
         *                          <li><code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.</li>
         *                          <li><code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.</li>
         *                          <li><code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.</li>
         *                          <li><code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK cluster.</li>
         *                          <li><code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache replication group.</li>
         *                          <li><code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon ElastiCache replication group.</li>
         *                          <li><code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.</li>
         *                          <li><code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker serverless endpoint.</li>
         *                          <li><code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a SageMaker inference component.</li>
         *                          <li><code>workspaces:workspacespool:DesiredUserSessions</code> - The number of user sessions for the WorkSpaces in the pool.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(java.lang.String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getScalingTargetId}
         * @param scalingTargetId The CloudFormation-generated ID of an Application Auto Scaling scalable target.
         *                        For more information about the ID, see the Return Value section of the <code>AWS::ApplicationAutoScaling::ScalableTarget</code> resource.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        You must specify either the <code>ScalingTargetId</code> property, or the <code>ResourceId</code> , <code>ScalableDimension</code> , and <code>ServiceNamespace</code> properties, but not both.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTargetId(java.lang.String scalingTargetId) {
            this.scalingTargetId = scalingTargetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getServiceNamespace}
         * @param serviceNamespace The namespace of the AWS service that provides the resource, or a <code>custom-resource</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(java.lang.String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getStepScalingPolicyConfiguration}
         * @param stepScalingPolicyConfiguration A step scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepScalingPolicyConfiguration(software.amazon.awscdk.IResolvable stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getStepScalingPolicyConfiguration}
         * @param stepScalingPolicyConfiguration A step scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepScalingPolicyConfiguration(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepScalingPolicyConfigurationProperty stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getTargetTrackingScalingPolicyConfiguration}
         * @param targetTrackingScalingPolicyConfiguration A target tracking scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingScalingPolicyConfiguration(software.amazon.awscdk.IResolvable targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getTargetTrackingScalingPolicyConfiguration}
         * @param targetTrackingScalingPolicyConfiguration A target tracking scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingScalingPolicyConfiguration(software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScalingPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScalingPolicyProps {
        private final java.lang.String policyName;
        private final java.lang.String policyType;
        private final java.lang.Object predictiveScalingPolicyConfiguration;
        private final java.lang.String resourceId;
        private final java.lang.String scalableDimension;
        private final java.lang.String scalingTargetId;
        private final java.lang.String serviceNamespace;
        private final java.lang.Object stepScalingPolicyConfiguration;
        private final java.lang.Object targetTrackingScalingPolicyConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.predictiveScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "predictiveScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalableDimension = software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingTargetId = software.amazon.jsii.Kernel.get(this, "scalingTargetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceNamespace = software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stepScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "stepScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetTrackingScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "targetTrackingScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyName = java.util.Objects.requireNonNull(builder.policyName, "policyName is required");
            this.policyType = java.util.Objects.requireNonNull(builder.policyType, "policyType is required");
            this.predictiveScalingPolicyConfiguration = builder.predictiveScalingPolicyConfiguration;
            this.resourceId = builder.resourceId;
            this.scalableDimension = builder.scalableDimension;
            this.scalingTargetId = builder.scalingTargetId;
            this.serviceNamespace = builder.serviceNamespace;
            this.stepScalingPolicyConfiguration = builder.stepScalingPolicyConfiguration;
            this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final java.lang.String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final java.lang.Object getPredictiveScalingPolicyConfiguration() {
            return this.predictiveScalingPolicyConfiguration;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final java.lang.String getScalingTargetId() {
            return this.scalingTargetId;
        }

        @Override
        public final java.lang.String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final java.lang.Object getStepScalingPolicyConfiguration() {
            return this.stepScalingPolicyConfiguration;
        }

        @Override
        public final java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyName", om.valueToTree(this.getPolicyName()));
            data.set("policyType", om.valueToTree(this.getPolicyType()));
            if (this.getPredictiveScalingPolicyConfiguration() != null) {
                data.set("predictiveScalingPolicyConfiguration", om.valueToTree(this.getPredictiveScalingPolicyConfiguration()));
            }
            if (this.getResourceId() != null) {
                data.set("resourceId", om.valueToTree(this.getResourceId()));
            }
            if (this.getScalableDimension() != null) {
                data.set("scalableDimension", om.valueToTree(this.getScalableDimension()));
            }
            if (this.getScalingTargetId() != null) {
                data.set("scalingTargetId", om.valueToTree(this.getScalingTargetId()));
            }
            if (this.getServiceNamespace() != null) {
                data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));
            }
            if (this.getStepScalingPolicyConfiguration() != null) {
                data.set("stepScalingPolicyConfiguration", om.valueToTree(this.getStepScalingPolicyConfiguration()));
            }
            if (this.getTargetTrackingScalingPolicyConfiguration() != null) {
                data.set("targetTrackingScalingPolicyConfiguration", om.valueToTree(this.getTargetTrackingScalingPolicyConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.CfnScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScalingPolicyProps.Jsii$Proxy that = (CfnScalingPolicyProps.Jsii$Proxy) o;

            if (!policyName.equals(that.policyName)) return false;
            if (!policyType.equals(that.policyType)) return false;
            if (this.predictiveScalingPolicyConfiguration != null ? !this.predictiveScalingPolicyConfiguration.equals(that.predictiveScalingPolicyConfiguration) : that.predictiveScalingPolicyConfiguration != null) return false;
            if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
            if (this.scalableDimension != null ? !this.scalableDimension.equals(that.scalableDimension) : that.scalableDimension != null) return false;
            if (this.scalingTargetId != null ? !this.scalingTargetId.equals(that.scalingTargetId) : that.scalingTargetId != null) return false;
            if (this.serviceNamespace != null ? !this.serviceNamespace.equals(that.serviceNamespace) : that.serviceNamespace != null) return false;
            if (this.stepScalingPolicyConfiguration != null ? !this.stepScalingPolicyConfiguration.equals(that.stepScalingPolicyConfiguration) : that.stepScalingPolicyConfiguration != null) return false;
            return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.equals(that.targetTrackingScalingPolicyConfiguration) : that.targetTrackingScalingPolicyConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyName.hashCode();
            result = 31 * result + (this.policyType.hashCode());
            result = 31 * result + (this.predictiveScalingPolicyConfiguration != null ? this.predictiveScalingPolicyConfiguration.hashCode() : 0);
            result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
            result = 31 * result + (this.scalableDimension != null ? this.scalableDimension.hashCode() : 0);
            result = 31 * result + (this.scalingTargetId != null ? this.scalingTargetId.hashCode() : 0);
            result = 31 * result + (this.serviceNamespace != null ? this.serviceNamespace.hashCode() : 0);
            result = 31 * result + (this.stepScalingPolicyConfiguration != null ? this.stepScalingPolicyConfiguration.hashCode() : 0);
            result = 31 * result + (this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.hashCode() : 0);
            return result;
        }
    }
}
