package software.amazon.awscdk.services.appmesh;

/**
 * Configuration for gateway route host name match.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * GatewayRouteHostnameMatchConfig gatewayRouteHostnameMatchConfig = GatewayRouteHostnameMatchConfig.builder()
 *         .hostnameMatch(GatewayRouteHostnameMatchProperty.builder()
 *                 .exact("exact")
 *                 .suffix("suffix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.010Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GatewayRouteHostnameMatchConfig")
@software.amazon.jsii.Jsii.Proxy(GatewayRouteHostnameMatchConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayRouteHostnameMatchConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * GatewayRoute CFN configuration for host name match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty getHostnameMatch();

    /**
     * @return a {@link Builder} of {@link GatewayRouteHostnameMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayRouteHostnameMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteHostnameMatchConfig> {
        software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty hostnameMatch;

        /**
         * Sets the value of {@link GatewayRouteHostnameMatchConfig#getHostnameMatch}
         * @param hostnameMatch GatewayRoute CFN configuration for host name match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostnameMatch(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty hostnameMatch) {
            this.hostnameMatch = hostnameMatch;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayRouteHostnameMatchConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayRouteHostnameMatchConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayRouteHostnameMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteHostnameMatchConfig {
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty hostnameMatch;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostnameMatch = software.amazon.jsii.Kernel.get(this, "hostnameMatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostnameMatch = java.util.Objects.requireNonNull(builder.hostnameMatch, "hostnameMatch is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty getHostnameMatch() {
            return this.hostnameMatch;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostnameMatch", om.valueToTree(this.getHostnameMatch()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GatewayRouteHostnameMatchConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayRouteHostnameMatchConfig.Jsii$Proxy that = (GatewayRouteHostnameMatchConfig.Jsii$Proxy) o;

            return this.hostnameMatch.equals(that.hostnameMatch);
        }

        @Override
        public final int hashCode() {
            int result = this.hostnameMatch.hashCode();
            return result;
        }
    }
}
