package software.amazon.awscdk.services.appmesh;

/**
 * Represents the properties needed to define client policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Service service;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8080)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5))
 *                         .path("/ping")
 *                         .timeout(Duration.seconds(2))
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .timeout(HttpTimeout.builder()
 *                         .idle(Duration.seconds(5))
 *                         .build())
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("/keys/local_cert_chain.pem"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * Tags.of(node).add("Environment", "Dev");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.TlsClientPolicy")
@software.amazon.jsii.Jsii.Proxy(TlsClientPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TlsClientPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Represents the object for TLS validation context.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsValidation getValidation();

    /**
     * Whether the policy is enforced.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnforce() {
        return null;
    }

    /**
     * Represents a client TLS certificate.
     * <p>
     * The certificate will be sent only if the server requests it, enabling mutual TLS.
     * <p>
     * Default: - client TLS certificate is not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.MutualTlsCertificate getMutualTlsCertificate() {
        return null;
    }

    /**
     * TLS is enforced on the ports specified here.
     * <p>
     * If no ports are specified, TLS will be enforced on all the ports.
     * <p>
     * Default: - all ports
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getPorts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TlsClientPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TlsClientPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TlsClientPolicy> {
        software.amazon.awscdk.services.appmesh.TlsValidation validation;
        java.lang.Boolean enforce;
        software.amazon.awscdk.services.appmesh.MutualTlsCertificate mutualTlsCertificate;
        java.util.List<java.lang.Number> ports;

        /**
         * Sets the value of {@link TlsClientPolicy#getValidation}
         * @param validation Represents the object for TLS validation context. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validation(software.amazon.awscdk.services.appmesh.TlsValidation validation) {
            this.validation = validation;
            return this;
        }

        /**
         * Sets the value of {@link TlsClientPolicy#getEnforce}
         * @param enforce Whether the policy is enforced.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforce(java.lang.Boolean enforce) {
            this.enforce = enforce;
            return this;
        }

        /**
         * Sets the value of {@link TlsClientPolicy#getMutualTlsCertificate}
         * @param mutualTlsCertificate Represents a client TLS certificate.
         *                             The certificate will be sent only if the server requests it, enabling mutual TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualTlsCertificate(software.amazon.awscdk.services.appmesh.MutualTlsCertificate mutualTlsCertificate) {
            this.mutualTlsCertificate = mutualTlsCertificate;
            return this;
        }

        /**
         * Sets the value of {@link TlsClientPolicy#getPorts}
         * @param ports TLS is enforced on the ports specified here.
         *              If no ports are specified, TLS will be enforced on all the ports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder ports(java.util.List<? extends java.lang.Number> ports) {
            this.ports = (java.util.List<java.lang.Number>)ports;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TlsClientPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TlsClientPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TlsClientPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsClientPolicy {
        private final software.amazon.awscdk.services.appmesh.TlsValidation validation;
        private final java.lang.Boolean enforce;
        private final software.amazon.awscdk.services.appmesh.MutualTlsCertificate mutualTlsCertificate;
        private final java.util.List<java.lang.Number> ports;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.validation = software.amazon.jsii.Kernel.get(this, "validation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsValidation.class));
            this.enforce = software.amazon.jsii.Kernel.get(this, "enforce", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mutualTlsCertificate = software.amazon.jsii.Kernel.get(this, "mutualTlsCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MutualTlsCertificate.class));
            this.ports = software.amazon.jsii.Kernel.get(this, "ports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.validation = java.util.Objects.requireNonNull(builder.validation, "validation is required");
            this.enforce = builder.enforce;
            this.mutualTlsCertificate = builder.mutualTlsCertificate;
            this.ports = (java.util.List<java.lang.Number>)builder.ports;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.TlsValidation getValidation() {
            return this.validation;
        }

        @Override
        public final java.lang.Boolean getEnforce() {
            return this.enforce;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.MutualTlsCertificate getMutualTlsCertificate() {
            return this.mutualTlsCertificate;
        }

        @Override
        public final java.util.List<java.lang.Number> getPorts() {
            return this.ports;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("validation", om.valueToTree(this.getValidation()));
            if (this.getEnforce() != null) {
                data.set("enforce", om.valueToTree(this.getEnforce()));
            }
            if (this.getMutualTlsCertificate() != null) {
                data.set("mutualTlsCertificate", om.valueToTree(this.getMutualTlsCertificate()));
            }
            if (this.getPorts() != null) {
                data.set("ports", om.valueToTree(this.getPorts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.TlsClientPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TlsClientPolicy.Jsii$Proxy that = (TlsClientPolicy.Jsii$Proxy) o;

            if (!validation.equals(that.validation)) return false;
            if (this.enforce != null ? !this.enforce.equals(that.enforce) : that.enforce != null) return false;
            if (this.mutualTlsCertificate != null ? !this.mutualTlsCertificate.equals(that.mutualTlsCertificate) : that.mutualTlsCertificate != null) return false;
            return this.ports != null ? this.ports.equals(that.ports) : that.ports == null;
        }

        @Override
        public final int hashCode() {
            int result = this.validation.hashCode();
            result = 31 * result + (this.enforce != null ? this.enforce.hashCode() : 0);
            result = 31 * result + (this.mutualTlsCertificate != null ? this.mutualTlsCertificate.hashCode() : 0);
            result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
            return result;
        }
    }
}
