package software.amazon.awscdk.services.appsync;

/**
 * Utility class for specifying specific appsync runtime versions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction myJsFunction = AppsyncFunction.Builder.create(this, "function")
 *         .name("my_js_function")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .code(Code.fromAsset("directory/function_code.js"))
 *         .runtime(FunctionRuntime.JS_1_0_0)
 *         .build();
 * Resolver.Builder.create(this, "PipelineResolver")
 *         .api(api)
 *         .typeName("typeName")
 *         .fieldName("fieldName")
 *         .code(Code.fromInline("\n    // The before step\n    export function request(...args) {\n      console.log(args);\n      return {}\n    }\n\n    // The after step\n    export function response(ctx) {\n      return ctx.prev.result\n    }\n  "))
 *         .runtime(FunctionRuntime.JS_1_0_0)
 *         .pipelineConfig(List.of(myJsFunction))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.310Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.FunctionRuntime")
public class FunctionRuntime extends software.amazon.jsii.JsiiObject {

    protected FunctionRuntime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionRuntime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        JS_1_0_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.FunctionRuntime.class, "JS_1_0_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.FunctionRuntime.class));
    }

    /**
     * @param family This parameter is required.
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionRuntime(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.FunctionRuntimeFamily family, final @org.jetbrains.annotations.NotNull java.lang.String version) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(family, "family is required"), java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Convert to Cfn runtime configuration property format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.RuntimeConfig toProperties() {
        return software.amazon.jsii.Kernel.call(this, "toProperties", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.RuntimeConfig.class));
    }

    /**
     * APPSYNC_JS v1.0.0 runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.appsync.FunctionRuntime JS_1_0_0;

    /**
     * The name of the runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The runtime version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
