package software.amazon.awscdk.services.appsync;

/**
 * Configuration for Cognito user-pools in AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * import software.amazon.awscdk.services.cognito.*;
 * UserPool userPool;
 * UserPoolConfig userPoolConfig = UserPoolConfig.builder()
 *         .userPool(userPool)
 *         // the properties below are optional
 *         .appIdClientRegex("appIdClientRegex")
 *         .defaultAction(UserPoolDefaultAction.ALLOW)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.357Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.UserPoolConfig")
@software.amazon.jsii.Jsii.Proxy(UserPoolConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Cognito user pool to use as identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * the optional app id regex.
     * <p>
     * Default: -  None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
        return null;
    }

    /**
     * Default auth action.
     * <p>
     * Default: ALLOW
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.UserPoolDefaultAction getDefaultAction() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolConfig> {
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        java.lang.String appIdClientRegex;
        software.amazon.awscdk.services.appsync.UserPoolDefaultAction defaultAction;

        /**
         * Sets the value of {@link UserPoolConfig#getUserPool}
         * @param userPool The Cognito user pool to use as identity source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolConfig#getAppIdClientRegex}
         * @param appIdClientRegex the optional app id regex.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolConfig#getDefaultAction}
         * @param defaultAction Default auth action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.services.appsync.UserPoolDefaultAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolConfig {
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final java.lang.String appIdClientRegex;
        private final software.amazon.awscdk.services.appsync.UserPoolDefaultAction defaultAction;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.UserPoolDefaultAction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.appIdClientRegex = builder.appIdClientRegex;
            this.defaultAction = builder.defaultAction;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final java.lang.String getAppIdClientRegex() {
            return this.appIdClientRegex;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.UserPoolDefaultAction getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAppIdClientRegex() != null) {
                data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
            }
            if (this.getDefaultAction() != null) {
                data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.UserPoolConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolConfig.Jsii$Proxy that = (UserPoolConfig.Jsii$Proxy) o;

            if (!userPool.equals(that.userPool)) return false;
            if (this.appIdClientRegex != null ? !this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex != null) return false;
            return this.defaultAction != null ? this.defaultAction.equals(that.defaultAction) : that.defaultAction == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPool.hashCode();
            result = 31 * result + (this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0);
            result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
            return result;
        }
    }
}
