package software.amazon.awscdk.services.autoscaling;

/**
 * Define a step scaling action.
 * <p>
 * This kind of scaling policy adjusts the target capacity in configurable
 * steps. The size of the step is configurable based on the metric's distance
 * to its alarm threshold.
 * <p>
 * This Action must be used as the target of a CloudWatch alarm to take effect.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * AutoScalingGroup autoScalingGroup;
 * StepScalingAction stepScalingAction = StepScalingAction.Builder.create(this, "MyStepScalingAction")
 *         .autoScalingGroup(autoScalingGroup)
 *         // the properties below are optional
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .cooldown(Duration.minutes(30))
 *         .estimatedInstanceWarmup(Duration.minutes(30))
 *         .metricAggregationType(MetricAggregationType.AVERAGE)
 *         .minAdjustmentMagnitude(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.StepScalingAction")
public class StepScalingAction extends software.constructs.Construct {

    protected StepScalingAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepScalingAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StepScalingAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add an adjusment interval to the ScalingAction.
     * <p>
     * @param adjustment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAdjustment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AdjustmentTier adjustment) {
        software.amazon.jsii.Kernel.call(this, "addAdjustment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(adjustment, "adjustment is required") });
    }

    /**
     * ARN of the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalingPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "scalingPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.StepScalingAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.StepScalingAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.StepScalingActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.StepScalingActionProps.Builder();
        }

        /**
         * The auto scaling group.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The auto scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * How the adjustment numbers are interpreted.
         * <p>
         * Default: ChangeInCapacity
         * <p>
         * @return {@code this}
         * @param adjustmentType How the adjustment numbers are interpreted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(final software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType) {
            this.props.adjustmentType(adjustmentType);
            return this;
        }

        /**
         * (deprecated) Period after a scaling completes before another scaling activity can start.
         * <p>
         * Default: The default cooldown configured on the AutoScalingGroup
         * <p>
         * @return {@code this}
         * @deprecated cooldown is not valid with step scaling action
         * @param cooldown Period after a scaling completes before another scaling activity can start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder cooldown(final software.amazon.awscdk.Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * Estimated time until a newly launched instance can send metrics to CloudWatch.
         * <p>
         * Default: Same as the cooldown
         * <p>
         * @return {@code this}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(final software.amazon.awscdk.Duration estimatedInstanceWarmup) {
            this.props.estimatedInstanceWarmup(estimatedInstanceWarmup);
            return this;
        }

        /**
         * The aggregation type for the CloudWatch metrics.
         * <p>
         * Default: Average
         * <p>
         * @return {@code this}
         * @param metricAggregationType The aggregation type for the CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(final software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType) {
            this.props.metricAggregationType(metricAggregationType);
            return this;
        }

        /**
         * Minimum absolute number to adjust capacity with as result of percentage scaling.
         * <p>
         * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         * the minimum absolute effect size.
         * <p>
         * Default: No minimum scaling effect
         * <p>
         * @return {@code this}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(final java.lang.Number minAdjustmentMagnitude) {
            this.props.minAdjustmentMagnitude(minAdjustmentMagnitude);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.autoscaling.StepScalingAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.StepScalingAction build() {
            return new software.amazon.awscdk.services.autoscaling.StepScalingAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
