package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnBackupVault</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object accessPolicy;
 * CfnBackupVaultProps cfnBackupVaultProps = CfnBackupVaultProps.builder()
 *         .backupVaultName("backupVaultName")
 *         // the properties below are optional
 *         .accessPolicy(accessPolicy)
 *         .backupVaultTags(Map.of(
 *                 "backupVaultTagsKey", "backupVaultTags"))
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .lockConfiguration(LockConfigurationTypeProperty.builder()
 *                 .minRetentionDays(123)
 *                 // the properties below are optional
 *                 .changeableForDays(123)
 *                 .maxRetentionDays(123)
 *                 .build())
 *         .notifications(NotificationObjectTypeProperty.builder()
 *                 .backupVaultEvents(List.of("backupVaultEvents"))
 *                 .snsTopicArn("snsTopicArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.695Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnBackupVaultProps")
@software.amazon.jsii.Jsii.Proxy(CfnBackupVaultProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBackupVaultProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of a logical container where backups are stored.
     * <p>
     * Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBackupVaultName();

    /**
     * A resource-based policy that is used to manage access permissions on the target backup vault.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicy() {
        return null;
    }

    /**
     * The tags to assign to the backup vault.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBackupVaultTags() {
        return null;
    }

    /**
     * A server-side encryption key you can specify to encrypt your backups from services that support full AWS Backup management;
     * <p>
     * for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> . If you specify a key, you must specify its ARN, not its alias. If you do not specify a key, AWS Backup creates a KMS key for you by default.
     * <p>
     * To learn which AWS Backup services support full AWS Backup management and how AWS Backup handles encryption for backups from services that do not yet support full AWS Backup , see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/encryption.html">Encryption for backups in AWS Backup</a>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return null;
    }

    /**
     * Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-lockconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-lockconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLockConfiguration() {
        return null;
    }

    /**
     * The SNS event notifications for the specified backup vault.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotifications() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBackupVaultProps> {
        java.lang.String backupVaultName;
        java.lang.Object accessPolicy;
        java.util.Map<java.lang.String, java.lang.String> backupVaultTags;
        java.lang.String encryptionKeyArn;
        java.lang.Object lockConfiguration;
        java.lang.Object notifications;

        /**
         * Sets the value of {@link CfnBackupVaultProps#getBackupVaultName}
         * @param backupVaultName The name of a logical container where backups are stored. This parameter is required.
         *                        Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultName(java.lang.String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getAccessPolicy}
         * @param accessPolicy A resource-based policy that is used to manage access permissions on the target backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicy(java.lang.Object accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getBackupVaultTags}
         * @param backupVaultTags The tags to assign to the backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultTags(java.util.Map<java.lang.String, java.lang.String> backupVaultTags) {
            this.backupVaultTags = backupVaultTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getEncryptionKeyArn}
         * @param encryptionKeyArn A server-side encryption key you can specify to encrypt your backups from services that support full AWS Backup management;.
         *                         for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> . If you specify a key, you must specify its ARN, not its alias. If you do not specify a key, AWS Backup creates a KMS key for you by default.
         *                         <p>
         *                         To learn which AWS Backup services support full AWS Backup management and how AWS Backup handles encryption for backups from services that do not yet support full AWS Backup , see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/encryption.html">Encryption for backups in AWS Backup</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(java.lang.String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getLockConfiguration}
         * @param lockConfiguration Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lockConfiguration(software.amazon.awscdk.IResolvable lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getLockConfiguration}
         * @param lockConfiguration Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lockConfiguration(software.amazon.awscdk.services.backup.CfnBackupVault.LockConfigurationTypeProperty lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getNotifications}
         * @param notifications The SNS event notifications for the specified backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(software.amazon.awscdk.IResolvable notifications) {
            this.notifications = notifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupVaultProps#getNotifications}
         * @param notifications The SNS event notifications for the specified backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(software.amazon.awscdk.services.backup.CfnBackupVault.NotificationObjectTypeProperty notifications) {
            this.notifications = notifications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBackupVaultProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBackupVaultProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBackupVaultProps {
        private final java.lang.String backupVaultName;
        private final java.lang.Object accessPolicy;
        private final java.util.Map<java.lang.String, java.lang.String> backupVaultTags;
        private final java.lang.String encryptionKeyArn;
        private final java.lang.Object lockConfiguration;
        private final java.lang.Object notifications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupVaultName = software.amazon.jsii.Kernel.get(this, "backupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessPolicy = software.amazon.jsii.Kernel.get(this, "accessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.backupVaultTags = software.amazon.jsii.Kernel.get(this, "backupVaultTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.encryptionKeyArn = software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lockConfiguration = software.amazon.jsii.Kernel.get(this, "lockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notifications = software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupVaultName = java.util.Objects.requireNonNull(builder.backupVaultName, "backupVaultName is required");
            this.accessPolicy = builder.accessPolicy;
            this.backupVaultTags = builder.backupVaultTags;
            this.encryptionKeyArn = builder.encryptionKeyArn;
            this.lockConfiguration = builder.lockConfiguration;
            this.notifications = builder.notifications;
        }

        @Override
        public final java.lang.String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final java.lang.Object getAccessPolicy() {
            return this.accessPolicy;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBackupVaultTags() {
            return this.backupVaultTags;
        }

        @Override
        public final java.lang.String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final java.lang.Object getLockConfiguration() {
            return this.lockConfiguration;
        }

        @Override
        public final java.lang.Object getNotifications() {
            return this.notifications;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backupVaultName", om.valueToTree(this.getBackupVaultName()));
            if (this.getAccessPolicy() != null) {
                data.set("accessPolicy", om.valueToTree(this.getAccessPolicy()));
            }
            if (this.getBackupVaultTags() != null) {
                data.set("backupVaultTags", om.valueToTree(this.getBackupVaultTags()));
            }
            if (this.getEncryptionKeyArn() != null) {
                data.set("encryptionKeyArn", om.valueToTree(this.getEncryptionKeyArn()));
            }
            if (this.getLockConfiguration() != null) {
                data.set("lockConfiguration", om.valueToTree(this.getLockConfiguration()));
            }
            if (this.getNotifications() != null) {
                data.set("notifications", om.valueToTree(this.getNotifications()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnBackupVaultProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBackupVaultProps.Jsii$Proxy that = (CfnBackupVaultProps.Jsii$Proxy) o;

            if (!backupVaultName.equals(that.backupVaultName)) return false;
            if (this.accessPolicy != null ? !this.accessPolicy.equals(that.accessPolicy) : that.accessPolicy != null) return false;
            if (this.backupVaultTags != null ? !this.backupVaultTags.equals(that.backupVaultTags) : that.backupVaultTags != null) return false;
            if (this.encryptionKeyArn != null ? !this.encryptionKeyArn.equals(that.encryptionKeyArn) : that.encryptionKeyArn != null) return false;
            if (this.lockConfiguration != null ? !this.lockConfiguration.equals(that.lockConfiguration) : that.lockConfiguration != null) return false;
            return this.notifications != null ? this.notifications.equals(that.notifications) : that.notifications == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupVaultName.hashCode();
            result = 31 * result + (this.accessPolicy != null ? this.accessPolicy.hashCode() : 0);
            result = 31 * result + (this.backupVaultTags != null ? this.backupVaultTags.hashCode() : 0);
            result = 31 * result + (this.encryptionKeyArn != null ? this.encryptionKeyArn.hashCode() : 0);
            result = 31 * result + (this.lockConfiguration != null ? this.lockConfiguration.hashCode() : 0);
            result = 31 * result + (this.notifications != null ? this.notifications.hashCode() : 0);
            return result;
        }
    }
}
