package software.amazon.awscdk.services.batch;

/**
 * A Batch MachineImage that is compatible with ECS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.ec2.*;
 * IMachineImage machineImage;
 * EcsMachineImage ecsMachineImage = EcsMachineImage.builder()
 *         .image(machineImage)
 *         .imageType(EcsMachineImageType.ECS_AL2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.841Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsMachineImage")
@software.amazon.jsii.Jsii.Proxy(EcsMachineImage.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsMachineImage extends software.amazon.jsii.JsiiSerializable {

    /**
     * The machine image to use.
     * <p>
     * Default: - chosen by batch
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getImage() {
        return null;
    }

    /**
     * Tells Batch which instance type to launch this image on.
     * <p>
     * Default: - 'ECS_AL2' for non-gpu instances, 'ECS_AL2_NVIDIA' for gpu instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.EcsMachineImageType getImageType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsMachineImage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsMachineImage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsMachineImage> {
        software.amazon.awscdk.services.ec2.IMachineImage image;
        software.amazon.awscdk.services.batch.EcsMachineImageType imageType;

        /**
         * Sets the value of {@link EcsMachineImage#getImage}
         * @param image The machine image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ec2.IMachineImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link EcsMachineImage#getImageType}
         * @param imageType Tells Batch which instance type to launch this image on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageType(software.amazon.awscdk.services.batch.EcsMachineImageType imageType) {
            this.imageType = imageType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsMachineImage}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsMachineImage build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsMachineImage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsMachineImage {
        private final software.amazon.awscdk.services.ec2.IMachineImage image;
        private final software.amazon.awscdk.services.batch.EcsMachineImageType imageType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.imageType = software.amazon.jsii.Kernel.get(this, "imageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsMachineImageType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = builder.image;
            this.imageType = builder.imageType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getImage() {
            return this.image;
        }

        @Override
        public final software.amazon.awscdk.services.batch.EcsMachineImageType getImageType() {
            return this.imageType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getImageType() != null) {
                data.set("imageType", om.valueToTree(this.getImageType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EcsMachineImage"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsMachineImage.Jsii$Proxy that = (EcsMachineImage.Jsii$Proxy) o;

            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            return this.imageType != null ? this.imageType.equals(that.imageType) : that.imageType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image != null ? this.image.hashCode() : 0;
            result = 31 * result + (this.imageType != null ? this.imageType.hashCode() : 0);
            return result;
        }
    }
}
