package software.amazon.awscdk.services.batch;

/**
 * A ManagedComputeEnvironment that uses ECS orchestration on Fargate instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * FargateComputeEnvironment sharedComputeEnv = FargateComputeEnvironment.Builder.create(this, "spotEnv")
 *         .vpc(vpc)
 *         .spot(true)
 *         .build();
 * JobQueue lowPriorityQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .priority(1)
 *         .build();
 * JobQueue highPriorityQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .priority(10)
 *         .build();
 * lowPriorityQueue.addComputeEnvironment(sharedComputeEnv, 1);
 * highPriorityQueue.addComputeEnvironment(sharedComputeEnv, 1);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:33.869Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.FargateComputeEnvironment")
public class FargateComputeEnvironment extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IFargateComputeEnvironment, software.amazon.awscdk.services.batch.IManagedComputeEnvironment, software.amazon.awscdk.services.batch.IComputeEnvironment {

    protected FargateComputeEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FargateComputeEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FargateComputeEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.FargateComputeEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Reference an existing FargateComputeEnvironment by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param fargateComputeEnvironmentArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IFargateComputeEnvironment fromFargateComputeEnvironmentArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String fargateComputeEnvironmentArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.FargateComputeEnvironment.class, "fromFargateComputeEnvironmentArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IFargateComputeEnvironment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(fargateComputeEnvironmentArn, "fargateComputeEnvironmentArn is required") });
    }

    /**
     * The ARN of this compute environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentArn() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ComputeEnvironment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComputeEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Whether or not this ComputeEnvironment can accept jobs from a Queue.
     * <p>
     * Enabled ComputeEnvironments can accept jobs from a Queue and
     * can scale instances up or down.
     * Disabled ComputeEnvironments cannot accept jobs from a Queue or
     * scale instances up or down.
     * <p>
     * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
     * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
     * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
     * <p>
     * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to.
     * <p>
     * <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
     * <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
     * The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
     * or <code>instanceClasses</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxvCpus() {
        return software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The security groups this Compute Environment will launch instances in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
    }

    /**
     * TagManager to set, remove and format tags.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
     * <p>
     * To enable more properties to be updated,
     * set this property to <code>false</code>. When changing the value of this property to false,
     * do not change any other properties at the same time.
     * If other properties are changed at the same time,
     * and the change needs to be rolled back but it can't,
     * it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
     * You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
     * However, if you can continue to roll it back,
     * you can return the stack to its original settings and then try to update it again.
     * <p>
     * The properties which require a replacement of the Compute Environment are:
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceComputeEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * Whether or not to use spot instances.
     * <p>
     * Spot instances are less expensive EC2 instances that can be
     * reclaimed by EC2 at any time; your job will be given two minutes
     * of notice before reclamation.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getSpot() {
        return software.amazon.jsii.Kernel.get(this, "spot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
     * <p>
     * If this is enabled, any terminated jobs may be retried, depending on the job's
     * retry policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminateOnUpdate() {
        return software.amazon.jsii.Kernel.get(this, "terminateOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
     * <p>
     * If so,
     * when an infrastructure update is triggered, any running jobs
     * will be allowed to run until <code>updateTimeout</code> has expired.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getUpdateTimeout() {
        return software.amazon.jsii.Kernel.get(this, "updateTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
     * <p>
     * If you specify a specific AMI, this property will be ignored.
     * <p>
     * Note: the CDK will never set this value by default, <code>false</code> will set by CFN.
     * This is to avoid a deployment failure that occurs when this value is set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateToLatestImageVersion() {
        return software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.FargateComputeEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.FargateComputeEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.FargateComputeEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.FargateComputeEnvironmentProps.Builder();
        }

        /**
         * The name of the ComputeEnvironment.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param computeEnvironmentName The name of the ComputeEnvironment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(final java.lang.String computeEnvironmentName) {
            this.props.computeEnvironmentName(computeEnvironmentName);
            return this;
        }

        /**
         * Whether or not this ComputeEnvironment can accept jobs from a Queue.
         * <p>
         * Enabled ComputeEnvironments can accept jobs from a Queue and
         * can scale instances up or down.
         * Disabled ComputeEnvironments cannot accept jobs from a Queue or
         * scale instances up or down.
         * <p>
         * If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         * Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         * be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         * <p>
         * To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Whether or not this ComputeEnvironment can accept jobs from a Queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * <p>
         * Default: - a serviceRole will be created for managed CEs, none for unmanaged CEs
         * <p>
         * @return {@code this}
         * @param serviceRole The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * VPC in which this Compute Environment will launch Instances.
         * <p>
         * @return {@code this}
         * @param vpc VPC in which this Compute Environment will launch Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to. Each vCPU is equivalent to 1024 CPU shares.
         * <p>
         * <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
         * <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
         * The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
         * or <code>instanceClasses</code>.
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param maxvCpus The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to. Each vCPU is equivalent to 1024 CPU shares. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxvCpus(final java.lang.Number maxvCpus) {
            this.props.maxvCpus(maxvCpus);
            return this;
        }

        /**
         * Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
         * <p>
         * To enable more properties to be updated,
         * set this property to <code>false</code>. When changing the value of this property to false,
         * do not change any other properties at the same time.
         * If other properties are changed at the same time,
         * and the change needs to be rolled back but it can't,
         * it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
         * You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
         * However, if you can continue to roll it back,
         * you can return the stack to its original settings and then try to update it again.
         * <p>
         * The properties which require a replacement of the Compute Environment are:
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html</a>
         * @param replaceComputeEnvironment Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(final java.lang.Boolean replaceComputeEnvironment) {
            this.props.replaceComputeEnvironment(replaceComputeEnvironment);
            return this;
        }

        /**
         * The security groups this Compute Environment will launch instances in.
         * <p>
         * Default: new security groups will be created
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups this Compute Environment will launch instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Whether or not to use spot instances.
         * <p>
         * Spot instances are less expensive EC2 instances that can be
         * reclaimed by EC2 at any time; your job will be given two minutes
         * of notice before reclamation.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param spot Whether or not to use spot instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spot(final java.lang.Boolean spot) {
            this.props.spot(spot);
            return this;
        }

        /**
         * Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
         * <p>
         * If this is enabled, any terminated jobs may be retried, depending on the job's
         * retry policy.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         * @param terminateOnUpdate Whether or not any running jobs will be immediately terminated when an infrastructure update occurs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateOnUpdate(final java.lang.Boolean terminateOnUpdate) {
            this.props.terminateOnUpdate(terminateOnUpdate);
            return this;
        }

        /**
         * Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
         * <p>
         * If so,
         * when an infrastructure update is triggered, any running jobs
         * will be allowed to run until <code>updateTimeout</code> has expired.
         * <p>
         * Default: 30 minutes
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html</a>
         * @param updateTimeout Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateTimeout(final software.amazon.awscdk.Duration updateTimeout) {
            this.props.updateTimeout(updateTimeout);
            return this;
        }

        /**
         * Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
         * <p>
         * If you specify a specific AMI, this property will be ignored.
         * <p>
         * Note: the CDK will never set this value by default, <code>false</code> will set by CFN.
         * This is to avoid a deployment failure that occurs when this value is set.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://github.com/aws/aws-cdk/issues/27054">https://github.com/aws/aws-cdk/issues/27054</a>
         * @param updateToLatestImageVersion Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateToLatestImageVersion(final java.lang.Boolean updateToLatestImageVersion) {
            this.props.updateToLatestImageVersion(updateToLatestImageVersion);
            return this;
        }

        /**
         * The VPC Subnets this Compute Environment will launch instances in.
         * <p>
         * Default: new subnets will be created
         * <p>
         * @return {@code this}
         * @param vpcSubnets The VPC Subnets this Compute Environment will launch instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.FargateComputeEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.FargateComputeEnvironment build() {
            return new software.amazon.awscdk.services.batch.FargateComputeEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
