package software.amazon.awscdk.services.cloudfront;

/**
 * Options for creating a new behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a distribution from an Application Load Balancer
 * Vpc vpc;
 * // Create an application load balancer in a VPC. 'internetFacing' can be 'false'.
 * ApplicationLoadBalancer alb = ApplicationLoadBalancer.Builder.create(this, "ALB")
 *         .vpc(vpc)
 *         .internetFacing(false)
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_ISOLATED).build())
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(VpcOrigin.withApplicationLoadBalancer(alb)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:34.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.BehaviorOptions")
@software.amazon.jsii.Jsii.Proxy(BehaviorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BehaviorOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudfront.AddBehaviorOptions {

    /**
     * The origin that you want CloudFront to route requests to when they match this behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin getOrigin();

    /**
     * @return a {@link Builder} of {@link BehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BehaviorOptions> {
        software.amazon.awscdk.services.cloudfront.IOrigin origin;
        software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy;
        java.lang.Boolean compress;
        java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        java.lang.Boolean enableGrpc;
        java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy;
        software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig realtimeLogConfig;
        software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy;
        java.lang.Boolean smoothStreaming;
        java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Sets the value of {@link BehaviorOptions#getOrigin}
         * @param origin The origin that you want CloudFront to route requests to when they match this behavior. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origin(software.amazon.awscdk.services.cloudfront.IOrigin origin) {
            this.origin = origin;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getAllowedMethods}
         * @param allowedMethods HTTP methods to allow for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedMethods(software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getCachedMethods}
         * @param cachedMethods HTTP methods to cache for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedMethods(software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getCachePolicy}
         * @param cachePolicy The cache policy for this behavior.
         *                    The cache policy determines what values are included in the cache key,
         *                    and the time-to-live (TTL) values for the cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicy(software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getCompress}
         * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
         *                 See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
         *                 for file types CloudFront will compress.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getEdgeLambdas}
         * @param edgeLambdas The Lambda&#64;Edge functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder edgeLambdas(java.util.List<? extends software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas) {
            this.edgeLambdas = (java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda>)edgeLambdas;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getEnableGrpc}
         * @param enableGrpc Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
         *                   If the <code>enableGrpc</code> is set to true, the following restrictions apply:
         *                   <p>
         *                   <ul>
         *                   <li>The <code>allowedMethods</code> property must be <code>AllowedMethods.ALLOW_ALL</code> to include POST method because gRPC only supports POST method.</li>
         *                   <li>The <code>httpVersion</code> property must be <code>HttpVersion.HTTP2</code> or <code>HttpVersion.HTTP2_AND_3</code> because gRPC only supports versions including HTTP/2.</li>
         *                   <li>The <code>edgeLambdas</code> property can't be specified because gRPC is not supported with Lambda&#64;Edge.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableGrpc(java.lang.Boolean enableGrpc) {
            this.enableGrpc = enableGrpc;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getFunctionAssociations}
         * @param functionAssociations The CloudFront functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder functionAssociations(java.util.List<? extends software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations) {
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)functionAssociations;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getOriginRequestPolicy}
         * @param originRequestPolicy The origin request policy for this behavior.
         *                            The origin request policy determines which values (e.g., headers, cookies)
         *                            are included in requests that CloudFront sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicy(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getRealtimeLogConfig}
         * @param realtimeLogConfig The real-time log configuration to be attached to this cache behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder realtimeLogConfig(software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig realtimeLogConfig) {
            this.realtimeLogConfig = realtimeLogConfig;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getResponseHeadersPolicy}
         * @param responseHeadersPolicy The response headers policy for this behavior.
         *                              The response headers policy determines which headers are included in responses
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicy(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getSmoothStreaming}
         * @param smoothStreaming Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getTrustedKeyGroups}
         * @param trustedKeyGroups A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder trustedKeyGroups(java.util.List<? extends software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups) {
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)trustedKeyGroups;
            return this;
        }

        /**
         * Sets the value of {@link BehaviorOptions#getViewerProtocolPolicy}
         * @param viewerProtocolPolicy The protocol that viewers can use to access the files controlled by this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewerProtocolPolicy(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BehaviorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BehaviorOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BehaviorOptions {
        private final software.amazon.awscdk.services.cloudfront.IOrigin origin;
        private final software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        private final software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        private final software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy;
        private final java.lang.Boolean compress;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        private final java.lang.Boolean enableGrpc;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        private final software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy;
        private final software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig realtimeLogConfig;
        private final software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy;
        private final java.lang.Boolean smoothStreaming;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        private final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.origin = software.amazon.jsii.Kernel.get(this, "origin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class));
            this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AllowedMethods.class));
            this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CachedMethods.class));
            this.cachePolicy = software.amazon.jsii.Kernel.get(this, "cachePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ICachePolicy.class));
            this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.edgeLambdas = software.amazon.jsii.Kernel.get(this, "edgeLambdas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.EdgeLambda.class)));
            this.enableGrpc = software.amazon.jsii.Kernel.get(this, "enableGrpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionAssociation.class)));
            this.originRequestPolicy = software.amazon.jsii.Kernel.get(this, "originRequestPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
            this.realtimeLogConfig = software.amazon.jsii.Kernel.get(this, "realtimeLogConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig.class));
            this.responseHeadersPolicy = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
            this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyGroup.class)));
            this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.origin = java.util.Objects.requireNonNull(builder.origin, "origin is required");
            this.allowedMethods = builder.allowedMethods;
            this.cachedMethods = builder.cachedMethods;
            this.cachePolicy = builder.cachePolicy;
            this.compress = builder.compress;
            this.edgeLambdas = (java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda>)builder.edgeLambdas;
            this.enableGrpc = builder.enableGrpc;
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)builder.functionAssociations;
            this.originRequestPolicy = builder.originRequestPolicy;
            this.realtimeLogConfig = builder.realtimeLogConfig;
            this.responseHeadersPolicy = builder.responseHeadersPolicy;
            this.smoothStreaming = builder.smoothStreaming;
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)builder.trustedKeyGroups;
            this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOrigin getOrigin() {
            return this.origin;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.AllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CachedMethods getCachedMethods() {
            return this.cachedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ICachePolicy getCachePolicy() {
            return this.cachePolicy;
        }

        @Override
        public final java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> getEdgeLambdas() {
            return this.edgeLambdas;
        }

        @Override
        public final java.lang.Boolean getEnableGrpc() {
            return this.enableGrpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> getFunctionAssociations() {
            return this.functionAssociations;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy getOriginRequestPolicy() {
            return this.originRequestPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig getRealtimeLogConfig() {
            return this.realtimeLogConfig;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy getResponseHeadersPolicy() {
            return this.responseHeadersPolicy;
        }

        @Override
        public final java.lang.Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
            return this.trustedKeyGroups;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("origin", om.valueToTree(this.getOrigin()));
            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getCachedMethods() != null) {
                data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
            }
            if (this.getCachePolicy() != null) {
                data.set("cachePolicy", om.valueToTree(this.getCachePolicy()));
            }
            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getEdgeLambdas() != null) {
                data.set("edgeLambdas", om.valueToTree(this.getEdgeLambdas()));
            }
            if (this.getEnableGrpc() != null) {
                data.set("enableGrpc", om.valueToTree(this.getEnableGrpc()));
            }
            if (this.getFunctionAssociations() != null) {
                data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
            }
            if (this.getOriginRequestPolicy() != null) {
                data.set("originRequestPolicy", om.valueToTree(this.getOriginRequestPolicy()));
            }
            if (this.getRealtimeLogConfig() != null) {
                data.set("realtimeLogConfig", om.valueToTree(this.getRealtimeLogConfig()));
            }
            if (this.getResponseHeadersPolicy() != null) {
                data.set("responseHeadersPolicy", om.valueToTree(this.getResponseHeadersPolicy()));
            }
            if (this.getSmoothStreaming() != null) {
                data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
            }
            if (this.getTrustedKeyGroups() != null) {
                data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
            }
            if (this.getViewerProtocolPolicy() != null) {
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.BehaviorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BehaviorOptions.Jsii$Proxy that = (BehaviorOptions.Jsii$Proxy) o;

            if (!origin.equals(that.origin)) return false;
            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
            if (this.cachePolicy != null ? !this.cachePolicy.equals(that.cachePolicy) : that.cachePolicy != null) return false;
            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.edgeLambdas != null ? !this.edgeLambdas.equals(that.edgeLambdas) : that.edgeLambdas != null) return false;
            if (this.enableGrpc != null ? !this.enableGrpc.equals(that.enableGrpc) : that.enableGrpc != null) return false;
            if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
            if (this.originRequestPolicy != null ? !this.originRequestPolicy.equals(that.originRequestPolicy) : that.originRequestPolicy != null) return false;
            if (this.realtimeLogConfig != null ? !this.realtimeLogConfig.equals(that.realtimeLogConfig) : that.realtimeLogConfig != null) return false;
            if (this.responseHeadersPolicy != null ? !this.responseHeadersPolicy.equals(that.responseHeadersPolicy) : that.responseHeadersPolicy != null) return false;
            if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
            if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
            return this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.equals(that.viewerProtocolPolicy) : that.viewerProtocolPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.origin.hashCode();
            result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
            result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
            result = 31 * result + (this.cachePolicy != null ? this.cachePolicy.hashCode() : 0);
            result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
            result = 31 * result + (this.edgeLambdas != null ? this.edgeLambdas.hashCode() : 0);
            result = 31 * result + (this.enableGrpc != null ? this.enableGrpc.hashCode() : 0);
            result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
            result = 31 * result + (this.originRequestPolicy != null ? this.originRequestPolicy.hashCode() : 0);
            result = 31 * result + (this.realtimeLogConfig != null ? this.realtimeLogConfig.hashCode() : 0);
            result = 31 * result + (this.responseHeadersPolicy != null ? this.responseHeadersPolicy.hashCode() : 0);
            result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
            result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
            result = 31 * result + (this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.hashCode() : 0);
            return result;
        }
    }
}
