package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnOriginRequestPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnOriginRequestPolicyProps cfnOriginRequestPolicyProps = CfnOriginRequestPolicyProps.builder()
 *         .originRequestPolicyConfig(OriginRequestPolicyConfigProperty.builder()
 *                 .cookiesConfig(CookiesConfigProperty.builder()
 *                         .cookieBehavior("cookieBehavior")
 *                         // the properties below are optional
 *                         .cookies(List.of("cookies"))
 *                         .build())
 *                 .headersConfig(HeadersConfigProperty.builder()
 *                         .headerBehavior("headerBehavior")
 *                         // the properties below are optional
 *                         .headers(List.of("headers"))
 *                         .build())
 *                 .name("name")
 *                 .queryStringsConfig(QueryStringsConfigProperty.builder()
 *                         .queryStringBehavior("queryStringBehavior")
 *                         // the properties below are optional
 *                         .queryStrings(List.of("queryStrings"))
 *                         .build())
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:34.523Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnOriginRequestPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOriginRequestPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The origin request policy configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originrequestpolicy.html#cfn-cloudfront-originrequestpolicy-originrequestpolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOriginRequestPolicyConfig();

    /**
     * @return a {@link Builder} of {@link CfnOriginRequestPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOriginRequestPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOriginRequestPolicyProps> {
        java.lang.Object originRequestPolicyConfig;

        /**
         * Sets the value of {@link CfnOriginRequestPolicyProps#getOriginRequestPolicyConfig}
         * @param originRequestPolicyConfig The origin request policy configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicyConfig(software.amazon.awscdk.IResolvable originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnOriginRequestPolicyProps#getOriginRequestPolicyConfig}
         * @param originRequestPolicyConfig The origin request policy configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicyConfig(software.amazon.awscdk.services.cloudfront.CfnOriginRequestPolicy.OriginRequestPolicyConfigProperty originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOriginRequestPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOriginRequestPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOriginRequestPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOriginRequestPolicyProps {
        private final java.lang.Object originRequestPolicyConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.originRequestPolicyConfig = software.amazon.jsii.Kernel.get(this, "originRequestPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.originRequestPolicyConfig = java.util.Objects.requireNonNull(builder.originRequestPolicyConfig, "originRequestPolicyConfig is required");
        }

        @Override
        public final java.lang.Object getOriginRequestPolicyConfig() {
            return this.originRequestPolicyConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("originRequestPolicyConfig", om.valueToTree(this.getOriginRequestPolicyConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnOriginRequestPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOriginRequestPolicyProps.Jsii$Proxy that = (CfnOriginRequestPolicyProps.Jsii$Proxy) o;

            return this.originRequestPolicyConfig.equals(that.originRequestPolicyConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.originRequestPolicyConfig.hashCode();
            return result;
        }
    }
}
