package software.amazon.awscdk.services.cloudfront;

/**
 * A response headers policy.
 * <p>
 * A response headers policy contains information about a set of HTTP response headers.
 * <p>
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or removes response headers according to the configuration of the response headers policy.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html">Adding or removing HTTP headers in CloudFront responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnResponseHeadersPolicy cfnResponseHeadersPolicy = CfnResponseHeadersPolicy.Builder.create(this, "MyCfnResponseHeadersPolicy")
 *         .responseHeadersPolicyConfig(ResponseHeadersPolicyConfigProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .corsConfig(CorsConfigProperty.builder()
 *                         .accessControlAllowCredentials(false)
 *                         .accessControlAllowHeaders(AccessControlAllowHeadersProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .accessControlAllowMethods(AccessControlAllowMethodsProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .accessControlAllowOrigins(AccessControlAllowOriginsProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .originOverride(false)
 *                         // the properties below are optional
 *                         .accessControlExposeHeaders(AccessControlExposeHeadersProperty.builder()
 *                                 .items(List.of("items"))
 *                                 .build())
 *                         .accessControlMaxAgeSec(123)
 *                         .build())
 *                 .customHeadersConfig(CustomHeadersConfigProperty.builder()
 *                         .items(List.of(CustomHeaderProperty.builder()
 *                                 .header("header")
 *                                 .override(false)
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .removeHeadersConfig(RemoveHeadersConfigProperty.builder()
 *                         .items(List.of(RemoveHeaderProperty.builder()
 *                                 .header("header")
 *                                 .build()))
 *                         .build())
 *                 .securityHeadersConfig(SecurityHeadersConfigProperty.builder()
 *                         .contentSecurityPolicy(ContentSecurityPolicyProperty.builder()
 *                                 .contentSecurityPolicy("contentSecurityPolicy")
 *                                 .override(false)
 *                                 .build())
 *                         .contentTypeOptions(ContentTypeOptionsProperty.builder()
 *                                 .override(false)
 *                                 .build())
 *                         .frameOptions(FrameOptionsProperty.builder()
 *                                 .frameOption("frameOption")
 *                                 .override(false)
 *                                 .build())
 *                         .referrerPolicy(ReferrerPolicyProperty.builder()
 *                                 .override(false)
 *                                 .referrerPolicy("referrerPolicy")
 *                                 .build())
 *                         .strictTransportSecurity(StrictTransportSecurityProperty.builder()
 *                                 .accessControlMaxAgeSec(123)
 *                                 .override(false)
 *                                 // the properties below are optional
 *                                 .includeSubdomains(false)
 *                                 .preload(false)
 *                                 .build())
 *                         .xssProtection(XSSProtectionProperty.builder()
 *                                 .override(false)
 *                                 .protection(false)
 *                                 // the properties below are optional
 *                                 .modeBlock(false)
 *                                 .reportUri("reportUri")
 *                                 .build())
 *                         .build())
 *                 .serverTimingHeadersConfig(ServerTimingHeadersConfigProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .samplingRate(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:34.528Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy")
public class CfnResponseHeadersPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnResponseHeadersPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResponseHeadersPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResponseHeadersPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the response headers policy.
     * <p>
     * For example: <code>57f99797-3b20-4e1b-a728-27972a74082a</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the response headers policy was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A response headers policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResponseHeadersPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "responseHeadersPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A response headers policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseHeadersPolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "responseHeadersPolicyConfig", java.util.Objects.requireNonNull(value, "responseHeadersPolicyConfig is required"));
    }

    /**
     * A response headers policy configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseHeadersPolicyConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "responseHeadersPolicyConfig", java.util.Objects.requireNonNull(value, "responseHeadersPolicyConfig is required"));
    }
    /**
     * A list of HTTP header names that CloudFront includes as values for the <code>Access-Control-Allow-Headers</code> HTTP response header.
     * <p>
     * For more information about the <code>Access-Control-Allow-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * AccessControlAllowHeadersProperty accessControlAllowHeadersProperty = AccessControlAllowHeadersProperty.builder()
     *         .items(List.of("items"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowheaders.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowheaders.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlAllowHeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlAllowHeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlAllowHeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of HTTP header names.
         * <p>
         * You can specify <code>*</code> to allow all headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowheaders.html#cfn-cloudfront-responseheaderspolicy-accesscontrolallowheaders-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowheaders.html#cfn-cloudfront-responseheaderspolicy-accesscontrolallowheaders-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getItems();

        /**
         * @return a {@link Builder} of {@link AccessControlAllowHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlAllowHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlAllowHeadersProperty> {
            java.util.List<java.lang.String> items;

            /**
             * Sets the value of {@link AccessControlAllowHeadersProperty#getItems}
             * @param items The list of HTTP header names. This parameter is required.
             *              You can specify <code>*</code> to allow all headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.String> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlAllowHeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlAllowHeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessControlAllowHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlAllowHeadersProperty {
            private final java.util.List<java.lang.String> items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            }

            @Override
            public final java.util.List<java.lang.String> getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlAllowHeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlAllowHeadersProperty.Jsii$Proxy that = (AccessControlAllowHeadersProperty.Jsii$Proxy) o;

                return this.items.equals(that.items);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                return result;
            }
        }
    }
    /**
     * A list of HTTP methods that CloudFront includes as values for the <code>Access-Control-Allow-Methods</code> HTTP response header.
     * <p>
     * For more information about the <code>Access-Control-Allow-Methods</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * AccessControlAllowMethodsProperty accessControlAllowMethodsProperty = AccessControlAllowMethodsProperty.builder()
     *         .items(List.of("items"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowmethods.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowmethods.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlAllowMethodsProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlAllowMethodsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlAllowMethodsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of HTTP methods. Valid values are:.
         * <p>
         * <ul>
         * <li><code>GET</code></li>
         * <li><code>DELETE</code></li>
         * <li><code>HEAD</code></li>
         * <li><code>OPTIONS</code></li>
         * <li><code>PATCH</code></li>
         * <li><code>POST</code></li>
         * <li><code>PUT</code></li>
         * <li><code>ALL</code></li>
         * </ul>
         * <p>
         * <code>ALL</code> is a special value that includes all of the listed HTTP methods.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowmethods.html#cfn-cloudfront-responseheaderspolicy-accesscontrolallowmethods-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolallowmethods.html#cfn-cloudfront-responseheaderspolicy-accesscontrolallowmethods-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getItems();

        /**
         * @return a {@link Builder} of {@link AccessControlAllowMethodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlAllowMethodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlAllowMethodsProperty> {
            java.util.List<java.lang.String> items;

            /**
             * Sets the value of {@link AccessControlAllowMethodsProperty#getItems}
             * @param items The list of HTTP methods. Valid values are:. This parameter is required.
             *              <ul>
             *              <li><code>GET</code></li>
             *              <li><code>DELETE</code></li>
             *              <li><code>HEAD</code></li>
             *              <li><code>OPTIONS</code></li>
             *              <li><code>PATCH</code></li>
             *              <li><code>POST</code></li>
             *              <li><code>PUT</code></li>
             *              <li><code>ALL</code></li>
             *              </ul>
             *              <p>
             *              <code>ALL</code> is a special value that includes all of the listed HTTP methods.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.String> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlAllowMethodsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlAllowMethodsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessControlAllowMethodsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlAllowMethodsProperty {
            private final java.util.List<java.lang.String> items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            }

            @Override
            public final java.util.List<java.lang.String> getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlAllowMethodsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlAllowMethodsProperty.Jsii$Proxy that = (AccessControlAllowMethodsProperty.Jsii$Proxy) o;

                return this.items.equals(that.items);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                return result;
            }
        }
    }
    /**
     * A list of origins (domain names) that CloudFront can use as the value for the <code>Access-Control-Allow-Origin</code> HTTP response header.
     * <p>
     * For more information about the <code>Access-Control-Allow-Origin</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * AccessControlAllowOriginsProperty accessControlAllowOriginsProperty = AccessControlAllowOriginsProperty.builder()
     *         .items(List.of("items"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolalloworigins.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolalloworigins.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlAllowOriginsProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlAllowOriginsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlAllowOriginsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of origins (domain names).
         * <p>
         * You can specify <code>*</code> to allow all origins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolalloworigins.html#cfn-cloudfront-responseheaderspolicy-accesscontrolalloworigins-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolalloworigins.html#cfn-cloudfront-responseheaderspolicy-accesscontrolalloworigins-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getItems();

        /**
         * @return a {@link Builder} of {@link AccessControlAllowOriginsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlAllowOriginsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlAllowOriginsProperty> {
            java.util.List<java.lang.String> items;

            /**
             * Sets the value of {@link AccessControlAllowOriginsProperty#getItems}
             * @param items The list of origins (domain names). This parameter is required.
             *              You can specify <code>*</code> to allow all origins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.String> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlAllowOriginsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlAllowOriginsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessControlAllowOriginsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlAllowOriginsProperty {
            private final java.util.List<java.lang.String> items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            }

            @Override
            public final java.util.List<java.lang.String> getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlAllowOriginsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlAllowOriginsProperty.Jsii$Proxy that = (AccessControlAllowOriginsProperty.Jsii$Proxy) o;

                return this.items.equals(that.items);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                return result;
            }
        }
    }
    /**
     * A list of HTTP headers that CloudFront includes as values for the <code>Access-Control-Expose-Headers</code> HTTP response header.
     * <p>
     * For more information about the <code>Access-Control-Expose-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * AccessControlExposeHeadersProperty accessControlExposeHeadersProperty = AccessControlExposeHeadersProperty.builder()
     *         .items(List.of("items"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolexposeheaders.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolexposeheaders.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlExposeHeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlExposeHeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlExposeHeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of HTTP headers.
         * <p>
         * You can specify <code>*</code> to expose all headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolexposeheaders.html#cfn-cloudfront-responseheaderspolicy-accesscontrolexposeheaders-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-accesscontrolexposeheaders.html#cfn-cloudfront-responseheaderspolicy-accesscontrolexposeheaders-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getItems();

        /**
         * @return a {@link Builder} of {@link AccessControlExposeHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlExposeHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlExposeHeadersProperty> {
            java.util.List<java.lang.String> items;

            /**
             * Sets the value of {@link AccessControlExposeHeadersProperty#getItems}
             * @param items The list of HTTP headers. This parameter is required.
             *              You can specify <code>*</code> to expose all headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.String> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlExposeHeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlExposeHeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessControlExposeHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlExposeHeadersProperty {
            private final java.util.List<java.lang.String> items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            }

            @Override
            public final java.util.List<java.lang.String> getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.AccessControlExposeHeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlExposeHeadersProperty.Jsii$Proxy that = (AccessControlExposeHeadersProperty.Jsii$Proxy) o;

                return this.items.equals(that.items);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                return result;
            }
        }
    }
    /**
     * The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.
     * <p>
     * For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ContentSecurityPolicyProperty contentSecurityPolicyProperty = ContentSecurityPolicyProperty.builder()
     *         .contentSecurityPolicy("contentSecurityPolicy")
     *         .override(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contentsecuritypolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contentsecuritypolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ContentSecurityPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentSecurityPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentSecurityPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contentsecuritypolicy.html#cfn-cloudfront-responseheaderspolicy-contentsecuritypolicy-contentsecuritypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contentsecuritypolicy.html#cfn-cloudfront-responseheaderspolicy-contentsecuritypolicy-contentsecuritypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentSecurityPolicy();

        /**
         * A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contentsecuritypolicy.html#cfn-cloudfront-responseheaderspolicy-contentsecuritypolicy-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contentsecuritypolicy.html#cfn-cloudfront-responseheaderspolicy-contentsecuritypolicy-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * @return a {@link Builder} of {@link ContentSecurityPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentSecurityPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentSecurityPolicyProperty> {
            java.lang.String contentSecurityPolicy;
            java.lang.Object override;

            /**
             * Sets the value of {@link ContentSecurityPolicyProperty#getContentSecurityPolicy}
             * @param contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentSecurityPolicy(java.lang.String contentSecurityPolicy) {
                this.contentSecurityPolicy = contentSecurityPolicy;
                return this;
            }

            /**
             * Sets the value of {@link ContentSecurityPolicyProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link ContentSecurityPolicyProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentSecurityPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentSecurityPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentSecurityPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentSecurityPolicyProperty {
            private final java.lang.String contentSecurityPolicy;
            private final java.lang.Object override;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentSecurityPolicy = software.amazon.jsii.Kernel.get(this, "contentSecurityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentSecurityPolicy = java.util.Objects.requireNonNull(builder.contentSecurityPolicy, "contentSecurityPolicy is required");
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
            }

            @Override
            public final java.lang.String getContentSecurityPolicy() {
                return this.contentSecurityPolicy;
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contentSecurityPolicy", om.valueToTree(this.getContentSecurityPolicy()));
                data.set("override", om.valueToTree(this.getOverride()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ContentSecurityPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentSecurityPolicyProperty.Jsii$Proxy that = (ContentSecurityPolicyProperty.Jsii$Proxy) o;

                if (!contentSecurityPolicy.equals(that.contentSecurityPolicy)) return false;
                return this.override.equals(that.override);
            }

            @Override
            public final int hashCode() {
                int result = this.contentSecurityPolicy.hashCode();
                result = 31 * result + (this.override.hashCode());
                return result;
            }
        }
    }
    /**
     * Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value set to <code>nosniff</code> .
     * <p>
     * For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ContentTypeOptionsProperty contentTypeOptionsProperty = ContentTypeOptionsProperty.builder()
     *         .override(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contenttypeoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contenttypeoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ContentTypeOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentTypeOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentTypeOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP response header received from the origin with the one specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contenttypeoptions.html#cfn-cloudfront-responseheaderspolicy-contenttypeoptions-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-contenttypeoptions.html#cfn-cloudfront-responseheaderspolicy-contenttypeoptions-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * @return a {@link Builder} of {@link ContentTypeOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentTypeOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentTypeOptionsProperty> {
            java.lang.Object override;

            /**
             * Sets the value of {@link ContentTypeOptionsProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link ContentTypeOptionsProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentTypeOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentTypeOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentTypeOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentTypeOptionsProperty {
            private final java.lang.Object override;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("override", om.valueToTree(this.getOverride()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ContentTypeOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentTypeOptionsProperty.Jsii$Proxy that = (ContentTypeOptionsProperty.Jsii$Proxy) o;

                return this.override.equals(that.override);
            }

            @Override
            public final int hashCode() {
                int result = this.override.hashCode();
                return result;
            }
        }
    }
    /**
     * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
     * <p>
     * CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.
     * <p>
     * For more information about CORS, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CorsConfigProperty corsConfigProperty = CorsConfigProperty.builder()
     *         .accessControlAllowCredentials(false)
     *         .accessControlAllowHeaders(AccessControlAllowHeadersProperty.builder()
     *                 .items(List.of("items"))
     *                 .build())
     *         .accessControlAllowMethods(AccessControlAllowMethodsProperty.builder()
     *                 .items(List.of("items"))
     *                 .build())
     *         .accessControlAllowOrigins(AccessControlAllowOriginsProperty.builder()
     *                 .items(List.of("items"))
     *                 .build())
     *         .originOverride(false)
     *         // the properties below are optional
     *         .accessControlExposeHeaders(AccessControlExposeHeadersProperty.builder()
     *                 .items(List.of("items"))
     *                 .build())
     *         .accessControlMaxAgeSec(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.CorsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code> HTTP response header.
         * <p>
         * For more information about the <code>Access-Control-Allow-Credentials</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolallowcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolallowcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccessControlAllowCredentials();

        /**
         * A list of HTTP header names that CloudFront includes as values for the <code>Access-Control-Allow-Headers</code> HTTP response header.
         * <p>
         * For more information about the <code>Access-Control-Allow-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolallowheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolallowheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccessControlAllowHeaders();

        /**
         * A list of HTTP methods that CloudFront includes as values for the <code>Access-Control-Allow-Methods</code> HTTP response header.
         * <p>
         * For more information about the <code>Access-Control-Allow-Methods</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolallowmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolallowmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccessControlAllowMethods();

        /**
         * A list of origins (domain names) that CloudFront can use as the value for the <code>Access-Control-Allow-Origin</code> HTTP response header.
         * <p>
         * For more information about the <code>Access-Control-Allow-Origin</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolalloworigins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolalloworigins</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAccessControlAllowOrigins();

        /**
         * A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-originoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-originoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOriginOverride();

        /**
         * A list of HTTP headers that CloudFront includes as values for the <code>Access-Control-Expose-Headers</code> HTTP response header.
         * <p>
         * For more information about the <code>Access-Control-Expose-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolexposeheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolexposeheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessControlExposeHeaders() {
            return null;
        }

        /**
         * A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP response header.
         * <p>
         * For more information about the <code>Access-Control-Max-Age</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolmaxagesec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-corsconfig.html#cfn-cloudfront-responseheaderspolicy-corsconfig-accesscontrolmaxagesec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAccessControlMaxAgeSec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsConfigProperty> {
            java.lang.Object accessControlAllowCredentials;
            java.lang.Object accessControlAllowHeaders;
            java.lang.Object accessControlAllowMethods;
            java.lang.Object accessControlAllowOrigins;
            java.lang.Object originOverride;
            java.lang.Object accessControlExposeHeaders;
            java.lang.Number accessControlMaxAgeSec;

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowCredentials}
             * @param accessControlAllowCredentials A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code> HTTP response header. This parameter is required.
             *                                      For more information about the <code>Access-Control-Allow-Credentials</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowCredentials(java.lang.Boolean accessControlAllowCredentials) {
                this.accessControlAllowCredentials = accessControlAllowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowCredentials}
             * @param accessControlAllowCredentials A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code> HTTP response header. This parameter is required.
             *                                      For more information about the <code>Access-Control-Allow-Credentials</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowCredentials(software.amazon.awscdk.IResolvable accessControlAllowCredentials) {
                this.accessControlAllowCredentials = accessControlAllowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowHeaders}
             * @param accessControlAllowHeaders A list of HTTP header names that CloudFront includes as values for the <code>Access-Control-Allow-Headers</code> HTTP response header. This parameter is required.
             *                                  For more information about the <code>Access-Control-Allow-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowHeaders(software.amazon.awscdk.IResolvable accessControlAllowHeaders) {
                this.accessControlAllowHeaders = accessControlAllowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowHeaders}
             * @param accessControlAllowHeaders A list of HTTP header names that CloudFront includes as values for the <code>Access-Control-Allow-Headers</code> HTTP response header. This parameter is required.
             *                                  For more information about the <code>Access-Control-Allow-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowHeaders(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlAllowHeadersProperty accessControlAllowHeaders) {
                this.accessControlAllowHeaders = accessControlAllowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowMethods}
             * @param accessControlAllowMethods A list of HTTP methods that CloudFront includes as values for the <code>Access-Control-Allow-Methods</code> HTTP response header. This parameter is required.
             *                                  For more information about the <code>Access-Control-Allow-Methods</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowMethods(software.amazon.awscdk.IResolvable accessControlAllowMethods) {
                this.accessControlAllowMethods = accessControlAllowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowMethods}
             * @param accessControlAllowMethods A list of HTTP methods that CloudFront includes as values for the <code>Access-Control-Allow-Methods</code> HTTP response header. This parameter is required.
             *                                  For more information about the <code>Access-Control-Allow-Methods</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowMethods(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlAllowMethodsProperty accessControlAllowMethods) {
                this.accessControlAllowMethods = accessControlAllowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowOrigins}
             * @param accessControlAllowOrigins A list of origins (domain names) that CloudFront can use as the value for the <code>Access-Control-Allow-Origin</code> HTTP response header. This parameter is required.
             *                                  For more information about the <code>Access-Control-Allow-Origin</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowOrigins(software.amazon.awscdk.IResolvable accessControlAllowOrigins) {
                this.accessControlAllowOrigins = accessControlAllowOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlAllowOrigins}
             * @param accessControlAllowOrigins A list of origins (domain names) that CloudFront can use as the value for the <code>Access-Control-Allow-Origin</code> HTTP response header. This parameter is required.
             *                                  For more information about the <code>Access-Control-Allow-Origin</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlAllowOrigins(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlAllowOriginsProperty accessControlAllowOrigins) {
                this.accessControlAllowOrigins = accessControlAllowOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getOriginOverride}
             * @param originOverride A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originOverride(java.lang.Boolean originOverride) {
                this.originOverride = originOverride;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getOriginOverride}
             * @param originOverride A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originOverride(software.amazon.awscdk.IResolvable originOverride) {
                this.originOverride = originOverride;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlExposeHeaders}
             * @param accessControlExposeHeaders A list of HTTP headers that CloudFront includes as values for the <code>Access-Control-Expose-Headers</code> HTTP response header.
             *                                   For more information about the <code>Access-Control-Expose-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlExposeHeaders(software.amazon.awscdk.IResolvable accessControlExposeHeaders) {
                this.accessControlExposeHeaders = accessControlExposeHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlExposeHeaders}
             * @param accessControlExposeHeaders A list of HTTP headers that CloudFront includes as values for the <code>Access-Control-Expose-Headers</code> HTTP response header.
             *                                   For more information about the <code>Access-Control-Expose-Headers</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlExposeHeaders(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.AccessControlExposeHeadersProperty accessControlExposeHeaders) {
                this.accessControlExposeHeaders = accessControlExposeHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsConfigProperty#getAccessControlMaxAgeSec}
             * @param accessControlMaxAgeSec A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP response header.
             *                               For more information about the <code>Access-Control-Max-Age</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlMaxAgeSec(java.lang.Number accessControlMaxAgeSec) {
                this.accessControlMaxAgeSec = accessControlMaxAgeSec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsConfigProperty {
            private final java.lang.Object accessControlAllowCredentials;
            private final java.lang.Object accessControlAllowHeaders;
            private final java.lang.Object accessControlAllowMethods;
            private final java.lang.Object accessControlAllowOrigins;
            private final java.lang.Object originOverride;
            private final java.lang.Object accessControlExposeHeaders;
            private final java.lang.Number accessControlMaxAgeSec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessControlAllowCredentials = software.amazon.jsii.Kernel.get(this, "accessControlAllowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.accessControlAllowHeaders = software.amazon.jsii.Kernel.get(this, "accessControlAllowHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.accessControlAllowMethods = software.amazon.jsii.Kernel.get(this, "accessControlAllowMethods", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.accessControlAllowOrigins = software.amazon.jsii.Kernel.get(this, "accessControlAllowOrigins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originOverride = software.amazon.jsii.Kernel.get(this, "originOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.accessControlExposeHeaders = software.amazon.jsii.Kernel.get(this, "accessControlExposeHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.accessControlMaxAgeSec = software.amazon.jsii.Kernel.get(this, "accessControlMaxAgeSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessControlAllowCredentials = java.util.Objects.requireNonNull(builder.accessControlAllowCredentials, "accessControlAllowCredentials is required");
                this.accessControlAllowHeaders = java.util.Objects.requireNonNull(builder.accessControlAllowHeaders, "accessControlAllowHeaders is required");
                this.accessControlAllowMethods = java.util.Objects.requireNonNull(builder.accessControlAllowMethods, "accessControlAllowMethods is required");
                this.accessControlAllowOrigins = java.util.Objects.requireNonNull(builder.accessControlAllowOrigins, "accessControlAllowOrigins is required");
                this.originOverride = java.util.Objects.requireNonNull(builder.originOverride, "originOverride is required");
                this.accessControlExposeHeaders = builder.accessControlExposeHeaders;
                this.accessControlMaxAgeSec = builder.accessControlMaxAgeSec;
            }

            @Override
            public final java.lang.Object getAccessControlAllowCredentials() {
                return this.accessControlAllowCredentials;
            }

            @Override
            public final java.lang.Object getAccessControlAllowHeaders() {
                return this.accessControlAllowHeaders;
            }

            @Override
            public final java.lang.Object getAccessControlAllowMethods() {
                return this.accessControlAllowMethods;
            }

            @Override
            public final java.lang.Object getAccessControlAllowOrigins() {
                return this.accessControlAllowOrigins;
            }

            @Override
            public final java.lang.Object getOriginOverride() {
                return this.originOverride;
            }

            @Override
            public final java.lang.Object getAccessControlExposeHeaders() {
                return this.accessControlExposeHeaders;
            }

            @Override
            public final java.lang.Number getAccessControlMaxAgeSec() {
                return this.accessControlMaxAgeSec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessControlAllowCredentials", om.valueToTree(this.getAccessControlAllowCredentials()));
                data.set("accessControlAllowHeaders", om.valueToTree(this.getAccessControlAllowHeaders()));
                data.set("accessControlAllowMethods", om.valueToTree(this.getAccessControlAllowMethods()));
                data.set("accessControlAllowOrigins", om.valueToTree(this.getAccessControlAllowOrigins()));
                data.set("originOverride", om.valueToTree(this.getOriginOverride()));
                if (this.getAccessControlExposeHeaders() != null) {
                    data.set("accessControlExposeHeaders", om.valueToTree(this.getAccessControlExposeHeaders()));
                }
                if (this.getAccessControlMaxAgeSec() != null) {
                    data.set("accessControlMaxAgeSec", om.valueToTree(this.getAccessControlMaxAgeSec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.CorsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsConfigProperty.Jsii$Proxy that = (CorsConfigProperty.Jsii$Proxy) o;

                if (!accessControlAllowCredentials.equals(that.accessControlAllowCredentials)) return false;
                if (!accessControlAllowHeaders.equals(that.accessControlAllowHeaders)) return false;
                if (!accessControlAllowMethods.equals(that.accessControlAllowMethods)) return false;
                if (!accessControlAllowOrigins.equals(that.accessControlAllowOrigins)) return false;
                if (!originOverride.equals(that.originOverride)) return false;
                if (this.accessControlExposeHeaders != null ? !this.accessControlExposeHeaders.equals(that.accessControlExposeHeaders) : that.accessControlExposeHeaders != null) return false;
                return this.accessControlMaxAgeSec != null ? this.accessControlMaxAgeSec.equals(that.accessControlMaxAgeSec) : that.accessControlMaxAgeSec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessControlAllowCredentials.hashCode();
                result = 31 * result + (this.accessControlAllowHeaders.hashCode());
                result = 31 * result + (this.accessControlAllowMethods.hashCode());
                result = 31 * result + (this.accessControlAllowOrigins.hashCode());
                result = 31 * result + (this.originOverride.hashCode());
                result = 31 * result + (this.accessControlExposeHeaders != null ? this.accessControlExposeHeaders.hashCode() : 0);
                result = 31 * result + (this.accessControlMaxAgeSec != null ? this.accessControlMaxAgeSec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An HTTP response header name and its value.
     * <p>
     * CloudFront includes this header in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CustomHeaderProperty customHeaderProperty = CustomHeaderProperty.builder()
     *         .header("header")
     *         .override(false)
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.CustomHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP response header name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html#cfn-cloudfront-responseheaderspolicy-customheader-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html#cfn-cloudfront-responseheaderspolicy-customheader-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeader();

        /**
         * A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html#cfn-cloudfront-responseheaderspolicy-customheader-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html#cfn-cloudfront-responseheaderspolicy-customheader-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * The value for the HTTP response header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html#cfn-cloudfront-responseheaderspolicy-customheader-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheader.html#cfn-cloudfront-responseheaderspolicy-customheader-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomHeaderProperty> {
            java.lang.String header;
            java.lang.Object override;
            java.lang.String value;

            /**
             * Sets the value of {@link CustomHeaderProperty#getHeader}
             * @param header The HTTP response header name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.String header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link CustomHeaderProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link CustomHeaderProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link CustomHeaderProperty#getValue}
             * @param value The value for the HTTP response header. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomHeaderProperty {
            private final java.lang.String header;
            private final java.lang.Object override;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.header = java.util.Objects.requireNonNull(builder.header, "header is required");
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("header", om.valueToTree(this.getHeader()));
                data.set("override", om.valueToTree(this.getOverride()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.CustomHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomHeaderProperty.Jsii$Proxy that = (CustomHeaderProperty.Jsii$Proxy) o;

                if (!header.equals(that.header)) return false;
                if (!override.equals(that.override)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.header.hashCode();
                result = 31 * result + (this.override.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of HTTP response header names and their values.
     * <p>
     * CloudFront includes these headers in HTTP responses that it sends for requests that match a cache behavior that's associated with this response headers policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CustomHeadersConfigProperty customHeadersConfigProperty = CustomHeadersConfigProperty.builder()
     *         .items(List.of(CustomHeaderProperty.builder()
     *                 .header("header")
     *                 .override(false)
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheadersconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheadersconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.CustomHeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomHeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomHeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of HTTP response headers and their values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheadersconfig.html#cfn-cloudfront-responseheaderspolicy-customheadersconfig-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-customheadersconfig.html#cfn-cloudfront-responseheaderspolicy-customheadersconfig-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * @return a {@link Builder} of {@link CustomHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomHeadersConfigProperty> {
            java.lang.Object items;

            /**
             * Sets the value of {@link CustomHeadersConfigProperty#getItems}
             * @param items The list of HTTP response headers and their values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link CustomHeadersConfigProperty#getItems}
             * @param items The list of HTTP response headers and their values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomHeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomHeadersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomHeadersConfigProperty {
            private final java.lang.Object items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.CustomHeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomHeadersConfigProperty.Jsii$Proxy that = (CustomHeadersConfigProperty.Jsii$Proxy) o;

                return this.items.equals(that.items);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                return result;
            }
        }
    }
    /**
     * Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and the header's value.
     * <p>
     * For more information about the <code>X-Frame-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * FrameOptionsProperty frameOptionsProperty = FrameOptionsProperty.builder()
     *         .frameOption("frameOption")
     *         .override(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-frameoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-frameoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.FrameOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are <code>DENY</code> and <code>SAMEORIGIN</code> .
         * <p>
         * For more information about these values, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-frameoptions.html#cfn-cloudfront-responseheaderspolicy-frameoptions-frameoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-frameoptions.html#cfn-cloudfront-responseheaderspolicy-frameoptions-frameoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFrameOption();

        /**
         * A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP response header received from the origin with the one specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-frameoptions.html#cfn-cloudfront-responseheaderspolicy-frameoptions-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-frameoptions.html#cfn-cloudfront-responseheaderspolicy-frameoptions-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * @return a {@link Builder} of {@link FrameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameOptionsProperty> {
            java.lang.String frameOption;
            java.lang.Object override;

            /**
             * Sets the value of {@link FrameOptionsProperty#getFrameOption}
             * @param frameOption The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are <code>DENY</code> and <code>SAMEORIGIN</code> . This parameter is required.
             *                    For more information about these values, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameOption(java.lang.String frameOption) {
                this.frameOption = frameOption;
                return this;
            }

            /**
             * Sets the value of {@link FrameOptionsProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link FrameOptionsProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameOptionsProperty {
            private final java.lang.String frameOption;
            private final java.lang.Object override;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frameOption = software.amazon.jsii.Kernel.get(this, "frameOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frameOption = java.util.Objects.requireNonNull(builder.frameOption, "frameOption is required");
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
            }

            @Override
            public final java.lang.String getFrameOption() {
                return this.frameOption;
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frameOption", om.valueToTree(this.getFrameOption()));
                data.set("override", om.valueToTree(this.getOverride()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.FrameOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameOptionsProperty.Jsii$Proxy that = (FrameOptionsProperty.Jsii$Proxy) o;

                if (!frameOption.equals(that.frameOption)) return false;
                return this.override.equals(that.override);
            }

            @Override
            public final int hashCode() {
                int result = this.frameOption.hashCode();
                result = 31 * result + (this.override.hashCode());
                return result;
            }
        }
    }
    /**
     * Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and the header's value.
     * <p>
     * For more information about the <code>Referrer-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ReferrerPolicyProperty referrerPolicyProperty = ReferrerPolicyProperty.builder()
     *         .override(false)
     *         .referrerPolicy("referrerPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-referrerpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-referrerpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ReferrerPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ReferrerPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferrerPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-referrerpolicy.html#cfn-cloudfront-responseheaderspolicy-referrerpolicy-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-referrerpolicy.html#cfn-cloudfront-responseheaderspolicy-referrerpolicy-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * The value of the <code>Referrer-Policy</code> HTTP response header. Valid values are:.
         * <p>
         * <ul>
         * <li><code>no-referrer</code></li>
         * <li><code>no-referrer-when-downgrade</code></li>
         * <li><code>origin</code></li>
         * <li><code>origin-when-cross-origin</code></li>
         * <li><code>same-origin</code></li>
         * <li><code>strict-origin</code></li>
         * <li><code>strict-origin-when-cross-origin</code></li>
         * <li><code>unsafe-url</code></li>
         * </ul>
         * <p>
         * For more information about these values, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-referrerpolicy.html#cfn-cloudfront-responseheaderspolicy-referrerpolicy-referrerpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-referrerpolicy.html#cfn-cloudfront-responseheaderspolicy-referrerpolicy-referrerpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReferrerPolicy();

        /**
         * @return a {@link Builder} of {@link ReferrerPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReferrerPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReferrerPolicyProperty> {
            java.lang.Object override;
            java.lang.String referrerPolicy;

            /**
             * Sets the value of {@link ReferrerPolicyProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link ReferrerPolicyProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link ReferrerPolicyProperty#getReferrerPolicy}
             * @param referrerPolicy The value of the <code>Referrer-Policy</code> HTTP response header. Valid values are:. This parameter is required.
             *                       <ul>
             *                       <li><code>no-referrer</code></li>
             *                       <li><code>no-referrer-when-downgrade</code></li>
             *                       <li><code>origin</code></li>
             *                       <li><code>origin-when-cross-origin</code></li>
             *                       <li><code>same-origin</code></li>
             *                       <li><code>strict-origin</code></li>
             *                       <li><code>strict-origin-when-cross-origin</code></li>
             *                       <li><code>unsafe-url</code></li>
             *                       </ul>
             *                       <p>
             *                       For more information about these values, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referrerPolicy(java.lang.String referrerPolicy) {
                this.referrerPolicy = referrerPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferrerPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReferrerPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReferrerPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReferrerPolicyProperty {
            private final java.lang.Object override;
            private final java.lang.String referrerPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.referrerPolicy = software.amazon.jsii.Kernel.get(this, "referrerPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
                this.referrerPolicy = java.util.Objects.requireNonNull(builder.referrerPolicy, "referrerPolicy is required");
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            public final java.lang.String getReferrerPolicy() {
                return this.referrerPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("override", om.valueToTree(this.getOverride()));
                data.set("referrerPolicy", om.valueToTree(this.getReferrerPolicy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ReferrerPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReferrerPolicyProperty.Jsii$Proxy that = (ReferrerPolicyProperty.Jsii$Proxy) o;

                if (!override.equals(that.override)) return false;
                return this.referrerPolicy.equals(that.referrerPolicy);
            }

            @Override
            public final int hashCode() {
                int result = this.override.hashCode();
                result = 31 * result + (this.referrerPolicy.hashCode());
                return result;
            }
        }
    }
    /**
     * The name of an HTTP header that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * RemoveHeaderProperty removeHeaderProperty = RemoveHeaderProperty.builder()
     *         .header("header")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.RemoveHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(RemoveHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RemoveHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP header name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheader.html#cfn-cloudfront-responseheaderspolicy-removeheader-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheader.html#cfn-cloudfront-responseheaderspolicy-removeheader-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeader();

        /**
         * @return a {@link Builder} of {@link RemoveHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RemoveHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RemoveHeaderProperty> {
            java.lang.String header;

            /**
             * Sets the value of {@link RemoveHeaderProperty#getHeader}
             * @param header The HTTP header name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.String header) {
                this.header = header;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RemoveHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RemoveHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RemoveHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RemoveHeaderProperty {
            private final java.lang.String header;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.header = java.util.Objects.requireNonNull(builder.header, "header is required");
            }

            @Override
            public final java.lang.String getHeader() {
                return this.header;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("header", om.valueToTree(this.getHeader()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.RemoveHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RemoveHeaderProperty.Jsii$Proxy that = (RemoveHeaderProperty.Jsii$Proxy) o;

                return this.header.equals(that.header);
            }

            @Override
            public final int hashCode() {
                int result = this.header.hashCode();
                return result;
            }
        }
    }
    /**
     * A list of HTTP header names that CloudFront removes from HTTP responses to requests that match the cache behavior that this response headers policy is attached to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * RemoveHeadersConfigProperty removeHeadersConfigProperty = RemoveHeadersConfigProperty.builder()
     *         .items(List.of(RemoveHeaderProperty.builder()
     *                 .header("header")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheadersconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheadersconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.RemoveHeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RemoveHeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RemoveHeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of HTTP header names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheadersconfig.html#cfn-cloudfront-responseheaderspolicy-removeheadersconfig-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-removeheadersconfig.html#cfn-cloudfront-responseheaderspolicy-removeheadersconfig-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * @return a {@link Builder} of {@link RemoveHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RemoveHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RemoveHeadersConfigProperty> {
            java.lang.Object items;

            /**
             * Sets the value of {@link RemoveHeadersConfigProperty#getItems}
             * @param items The list of HTTP header names. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link RemoveHeadersConfigProperty#getItems}
             * @param items The list of HTTP header names. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RemoveHeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RemoveHeadersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RemoveHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RemoveHeadersConfigProperty {
            private final java.lang.Object items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.RemoveHeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RemoveHeadersConfigProperty.Jsii$Proxy that = (RemoveHeadersConfigProperty.Jsii$Proxy) o;

                return this.items.equals(that.items);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                return result;
            }
        }
    }
    /**
     * A response headers policy configuration.
     * <p>
     * A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ResponseHeadersPolicyConfigProperty responseHeadersPolicyConfigProperty = ResponseHeadersPolicyConfigProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .comment("comment")
     *         .corsConfig(CorsConfigProperty.builder()
     *                 .accessControlAllowCredentials(false)
     *                 .accessControlAllowHeaders(AccessControlAllowHeadersProperty.builder()
     *                         .items(List.of("items"))
     *                         .build())
     *                 .accessControlAllowMethods(AccessControlAllowMethodsProperty.builder()
     *                         .items(List.of("items"))
     *                         .build())
     *                 .accessControlAllowOrigins(AccessControlAllowOriginsProperty.builder()
     *                         .items(List.of("items"))
     *                         .build())
     *                 .originOverride(false)
     *                 // the properties below are optional
     *                 .accessControlExposeHeaders(AccessControlExposeHeadersProperty.builder()
     *                         .items(List.of("items"))
     *                         .build())
     *                 .accessControlMaxAgeSec(123)
     *                 .build())
     *         .customHeadersConfig(CustomHeadersConfigProperty.builder()
     *                 .items(List.of(CustomHeaderProperty.builder()
     *                         .header("header")
     *                         .override(false)
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .removeHeadersConfig(RemoveHeadersConfigProperty.builder()
     *                 .items(List.of(RemoveHeaderProperty.builder()
     *                         .header("header")
     *                         .build()))
     *                 .build())
     *         .securityHeadersConfig(SecurityHeadersConfigProperty.builder()
     *                 .contentSecurityPolicy(ContentSecurityPolicyProperty.builder()
     *                         .contentSecurityPolicy("contentSecurityPolicy")
     *                         .override(false)
     *                         .build())
     *                 .contentTypeOptions(ContentTypeOptionsProperty.builder()
     *                         .override(false)
     *                         .build())
     *                 .frameOptions(FrameOptionsProperty.builder()
     *                         .frameOption("frameOption")
     *                         .override(false)
     *                         .build())
     *                 .referrerPolicy(ReferrerPolicyProperty.builder()
     *                         .override(false)
     *                         .referrerPolicy("referrerPolicy")
     *                         .build())
     *                 .strictTransportSecurity(StrictTransportSecurityProperty.builder()
     *                         .accessControlMaxAgeSec(123)
     *                         .override(false)
     *                         // the properties below are optional
     *                         .includeSubdomains(false)
     *                         .preload(false)
     *                         .build())
     *                 .xssProtection(XSSProtectionProperty.builder()
     *                         .override(false)
     *                         .protection(false)
     *                         // the properties below are optional
     *                         .modeBlock(false)
     *                         .reportUri("reportUri")
     *                         .build())
     *                 .build())
     *         .serverTimingHeadersConfig(ServerTimingHeadersConfigProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .samplingRate(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseHeadersPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseHeadersPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name to identify the response headers policy.
         * <p>
         * The name must be unique for response headers policies in this AWS account .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A comment to describe the response headers policy.
         * <p>
         * The comment cannot be longer than 128 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-corsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-corsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCorsConfig() {
            return null;
        }

        /**
         * A configuration for a set of custom HTTP response headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-customheadersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-customheadersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomHeadersConfig() {
            return null;
        }

        /**
         * A configuration for a set of HTTP headers to remove from the HTTP response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-removeheadersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-removeheadersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveHeadersConfig() {
            return null;
        }

        /**
         * A configuration for a set of security-related HTTP response headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-securityheadersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-securityheadersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityHeadersConfig() {
            return null;
        }

        /**
         * A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-servertimingheadersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-responseheaderspolicyconfig.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig-servertimingheadersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerTimingHeadersConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResponseHeadersPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseHeadersPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseHeadersPolicyConfigProperty> {
            java.lang.String name;
            java.lang.String comment;
            java.lang.Object corsConfig;
            java.lang.Object customHeadersConfig;
            java.lang.Object removeHeadersConfig;
            java.lang.Object securityHeadersConfig;
            java.lang.Object serverTimingHeadersConfig;

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getName}
             * @param name A name to identify the response headers policy. This parameter is required.
             *             The name must be unique for response headers policies in this AWS account .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getComment}
             * @param comment A comment to describe the response headers policy.
             *                The comment cannot be longer than 128 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getCorsConfig}
             * @param corsConfig A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder corsConfig(software.amazon.awscdk.IResolvable corsConfig) {
                this.corsConfig = corsConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getCorsConfig}
             * @param corsConfig A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder corsConfig(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.CorsConfigProperty corsConfig) {
                this.corsConfig = corsConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getCustomHeadersConfig}
             * @param customHeadersConfig A configuration for a set of custom HTTP response headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customHeadersConfig(software.amazon.awscdk.IResolvable customHeadersConfig) {
                this.customHeadersConfig = customHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getCustomHeadersConfig}
             * @param customHeadersConfig A configuration for a set of custom HTTP response headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customHeadersConfig(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.CustomHeadersConfigProperty customHeadersConfig) {
                this.customHeadersConfig = customHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getRemoveHeadersConfig}
             * @param removeHeadersConfig A configuration for a set of HTTP headers to remove from the HTTP response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeHeadersConfig(software.amazon.awscdk.IResolvable removeHeadersConfig) {
                this.removeHeadersConfig = removeHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getRemoveHeadersConfig}
             * @param removeHeadersConfig A configuration for a set of HTTP headers to remove from the HTTP response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeHeadersConfig(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.RemoveHeadersConfigProperty removeHeadersConfig) {
                this.removeHeadersConfig = removeHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getSecurityHeadersConfig}
             * @param securityHeadersConfig A configuration for a set of security-related HTTP response headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityHeadersConfig(software.amazon.awscdk.IResolvable securityHeadersConfig) {
                this.securityHeadersConfig = securityHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getSecurityHeadersConfig}
             * @param securityHeadersConfig A configuration for a set of security-related HTTP response headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityHeadersConfig(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.SecurityHeadersConfigProperty securityHeadersConfig) {
                this.securityHeadersConfig = securityHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getServerTimingHeadersConfig}
             * @param serverTimingHeadersConfig A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverTimingHeadersConfig(software.amazon.awscdk.IResolvable serverTimingHeadersConfig) {
                this.serverTimingHeadersConfig = serverTimingHeadersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResponseHeadersPolicyConfigProperty#getServerTimingHeadersConfig}
             * @param serverTimingHeadersConfig A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverTimingHeadersConfig(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ServerTimingHeadersConfigProperty serverTimingHeadersConfig) {
                this.serverTimingHeadersConfig = serverTimingHeadersConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseHeadersPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResponseHeadersPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResponseHeadersPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseHeadersPolicyConfigProperty {
            private final java.lang.String name;
            private final java.lang.String comment;
            private final java.lang.Object corsConfig;
            private final java.lang.Object customHeadersConfig;
            private final java.lang.Object removeHeadersConfig;
            private final java.lang.Object securityHeadersConfig;
            private final java.lang.Object serverTimingHeadersConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.corsConfig = software.amazon.jsii.Kernel.get(this, "corsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customHeadersConfig = software.amazon.jsii.Kernel.get(this, "customHeadersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeHeadersConfig = software.amazon.jsii.Kernel.get(this, "removeHeadersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityHeadersConfig = software.amazon.jsii.Kernel.get(this, "securityHeadersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverTimingHeadersConfig = software.amazon.jsii.Kernel.get(this, "serverTimingHeadersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.comment = builder.comment;
                this.corsConfig = builder.corsConfig;
                this.customHeadersConfig = builder.customHeadersConfig;
                this.removeHeadersConfig = builder.removeHeadersConfig;
                this.securityHeadersConfig = builder.securityHeadersConfig;
                this.serverTimingHeadersConfig = builder.serverTimingHeadersConfig;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.Object getCorsConfig() {
                return this.corsConfig;
            }

            @Override
            public final java.lang.Object getCustomHeadersConfig() {
                return this.customHeadersConfig;
            }

            @Override
            public final java.lang.Object getRemoveHeadersConfig() {
                return this.removeHeadersConfig;
            }

            @Override
            public final java.lang.Object getSecurityHeadersConfig() {
                return this.securityHeadersConfig;
            }

            @Override
            public final java.lang.Object getServerTimingHeadersConfig() {
                return this.serverTimingHeadersConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getCorsConfig() != null) {
                    data.set("corsConfig", om.valueToTree(this.getCorsConfig()));
                }
                if (this.getCustomHeadersConfig() != null) {
                    data.set("customHeadersConfig", om.valueToTree(this.getCustomHeadersConfig()));
                }
                if (this.getRemoveHeadersConfig() != null) {
                    data.set("removeHeadersConfig", om.valueToTree(this.getRemoveHeadersConfig()));
                }
                if (this.getSecurityHeadersConfig() != null) {
                    data.set("securityHeadersConfig", om.valueToTree(this.getSecurityHeadersConfig()));
                }
                if (this.getServerTimingHeadersConfig() != null) {
                    data.set("serverTimingHeadersConfig", om.valueToTree(this.getServerTimingHeadersConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResponseHeadersPolicyConfigProperty.Jsii$Proxy that = (ResponseHeadersPolicyConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.corsConfig != null ? !this.corsConfig.equals(that.corsConfig) : that.corsConfig != null) return false;
                if (this.customHeadersConfig != null ? !this.customHeadersConfig.equals(that.customHeadersConfig) : that.customHeadersConfig != null) return false;
                if (this.removeHeadersConfig != null ? !this.removeHeadersConfig.equals(that.removeHeadersConfig) : that.removeHeadersConfig != null) return false;
                if (this.securityHeadersConfig != null ? !this.securityHeadersConfig.equals(that.securityHeadersConfig) : that.securityHeadersConfig != null) return false;
                return this.serverTimingHeadersConfig != null ? this.serverTimingHeadersConfig.equals(that.serverTimingHeadersConfig) : that.serverTimingHeadersConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.corsConfig != null ? this.corsConfig.hashCode() : 0);
                result = 31 * result + (this.customHeadersConfig != null ? this.customHeadersConfig.hashCode() : 0);
                result = 31 * result + (this.removeHeadersConfig != null ? this.removeHeadersConfig.hashCode() : 0);
                result = 31 * result + (this.securityHeadersConfig != null ? this.securityHeadersConfig.hashCode() : 0);
                result = 31 * result + (this.serverTimingHeadersConfig != null ? this.serverTimingHeadersConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A configuration for a set of security-related HTTP response headers.
     * <p>
     * CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * SecurityHeadersConfigProperty securityHeadersConfigProperty = SecurityHeadersConfigProperty.builder()
     *         .contentSecurityPolicy(ContentSecurityPolicyProperty.builder()
     *                 .contentSecurityPolicy("contentSecurityPolicy")
     *                 .override(false)
     *                 .build())
     *         .contentTypeOptions(ContentTypeOptionsProperty.builder()
     *                 .override(false)
     *                 .build())
     *         .frameOptions(FrameOptionsProperty.builder()
     *                 .frameOption("frameOption")
     *                 .override(false)
     *                 .build())
     *         .referrerPolicy(ReferrerPolicyProperty.builder()
     *                 .override(false)
     *                 .referrerPolicy("referrerPolicy")
     *                 .build())
     *         .strictTransportSecurity(StrictTransportSecurityProperty.builder()
     *                 .accessControlMaxAgeSec(123)
     *                 .override(false)
     *                 // the properties below are optional
     *                 .includeSubdomains(false)
     *                 .preload(false)
     *                 .build())
     *         .xssProtection(XSSProtectionProperty.builder()
     *                 .override(false)
     *                 .protection(false)
     *                 // the properties below are optional
     *                 .modeBlock(false)
     *                 .reportUri("reportUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.SecurityHeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityHeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityHeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.
         * <p>
         * For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-contentsecuritypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-contentsecuritypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContentSecurityPolicy() {
            return null;
        }

        /**
         * Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value set to <code>nosniff</code> .
         * <p>
         * For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-contenttypeoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-contenttypeoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContentTypeOptions() {
            return null;
        }

        /**
         * Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and the header's value.
         * <p>
         * For more information about the <code>X-Frame-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-frameoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-frameoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFrameOptions() {
            return null;
        }

        /**
         * Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and the header's value.
         * <p>
         * For more information about the <code>Referrer-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-referrerpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-referrerpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReferrerPolicy() {
            return null;
        }

        /**
         * Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the header's value.
         * <p>
         * For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security">Security headers</a> in the <em>Amazon CloudFront Developer Guide</em> and <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-stricttransportsecurity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-stricttransportsecurity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStrictTransportSecurity() {
            return null;
        }

        /**
         * Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and the header's value.
         * <p>
         * For more information about the <code>X-XSS-Protection</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-xssprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-securityheadersconfig.html#cfn-cloudfront-responseheaderspolicy-securityheadersconfig-xssprotection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getXssProtection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityHeadersConfigProperty> {
            java.lang.Object contentSecurityPolicy;
            java.lang.Object contentTypeOptions;
            java.lang.Object frameOptions;
            java.lang.Object referrerPolicy;
            java.lang.Object strictTransportSecurity;
            java.lang.Object xssProtection;

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getContentSecurityPolicy}
             * @param contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.
             *                              For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentSecurityPolicy(software.amazon.awscdk.IResolvable contentSecurityPolicy) {
                this.contentSecurityPolicy = contentSecurityPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getContentSecurityPolicy}
             * @param contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.
             *                              For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentSecurityPolicy(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ContentSecurityPolicyProperty contentSecurityPolicy) {
                this.contentSecurityPolicy = contentSecurityPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getContentTypeOptions}
             * @param contentTypeOptions Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value set to <code>nosniff</code> .
             *                           For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentTypeOptions(software.amazon.awscdk.IResolvable contentTypeOptions) {
                this.contentTypeOptions = contentTypeOptions;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getContentTypeOptions}
             * @param contentTypeOptions Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value set to <code>nosniff</code> .
             *                           For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentTypeOptions(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ContentTypeOptionsProperty contentTypeOptions) {
                this.contentTypeOptions = contentTypeOptions;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getFrameOptions}
             * @param frameOptions Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and the header's value.
             *                     For more information about the <code>X-Frame-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameOptions(software.amazon.awscdk.IResolvable frameOptions) {
                this.frameOptions = frameOptions;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getFrameOptions}
             * @param frameOptions Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and the header's value.
             *                     For more information about the <code>X-Frame-Options</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameOptions(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.FrameOptionsProperty frameOptions) {
                this.frameOptions = frameOptions;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getReferrerPolicy}
             * @param referrerPolicy Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and the header's value.
             *                       For more information about the <code>Referrer-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referrerPolicy(software.amazon.awscdk.IResolvable referrerPolicy) {
                this.referrerPolicy = referrerPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getReferrerPolicy}
             * @param referrerPolicy Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and the header's value.
             *                       For more information about the <code>Referrer-Policy</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referrerPolicy(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ReferrerPolicyProperty referrerPolicy) {
                this.referrerPolicy = referrerPolicy;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getStrictTransportSecurity}
             * @param strictTransportSecurity Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the header's value.
             *                                For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security">Security headers</a> in the <em>Amazon CloudFront Developer Guide</em> and <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strictTransportSecurity(software.amazon.awscdk.IResolvable strictTransportSecurity) {
                this.strictTransportSecurity = strictTransportSecurity;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getStrictTransportSecurity}
             * @param strictTransportSecurity Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the header's value.
             *                                For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security">Security headers</a> in the <em>Amazon CloudFront Developer Guide</em> and <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder strictTransportSecurity(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.StrictTransportSecurityProperty strictTransportSecurity) {
                this.strictTransportSecurity = strictTransportSecurity;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getXssProtection}
             * @param xssProtection Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and the header's value.
             *                      For more information about the <code>X-XSS-Protection</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xssProtection(software.amazon.awscdk.IResolvable xssProtection) {
                this.xssProtection = xssProtection;
                return this;
            }

            /**
             * Sets the value of {@link SecurityHeadersConfigProperty#getXssProtection}
             * @param xssProtection Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and the header's value.
             *                      For more information about the <code>X-XSS-Protection</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xssProtection(software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.XSSProtectionProperty xssProtection) {
                this.xssProtection = xssProtection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityHeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityHeadersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityHeadersConfigProperty {
            private final java.lang.Object contentSecurityPolicy;
            private final java.lang.Object contentTypeOptions;
            private final java.lang.Object frameOptions;
            private final java.lang.Object referrerPolicy;
            private final java.lang.Object strictTransportSecurity;
            private final java.lang.Object xssProtection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentSecurityPolicy = software.amazon.jsii.Kernel.get(this, "contentSecurityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contentTypeOptions = software.amazon.jsii.Kernel.get(this, "contentTypeOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.frameOptions = software.amazon.jsii.Kernel.get(this, "frameOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.referrerPolicy = software.amazon.jsii.Kernel.get(this, "referrerPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.strictTransportSecurity = software.amazon.jsii.Kernel.get(this, "strictTransportSecurity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.xssProtection = software.amazon.jsii.Kernel.get(this, "xssProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentSecurityPolicy = builder.contentSecurityPolicy;
                this.contentTypeOptions = builder.contentTypeOptions;
                this.frameOptions = builder.frameOptions;
                this.referrerPolicy = builder.referrerPolicy;
                this.strictTransportSecurity = builder.strictTransportSecurity;
                this.xssProtection = builder.xssProtection;
            }

            @Override
            public final java.lang.Object getContentSecurityPolicy() {
                return this.contentSecurityPolicy;
            }

            @Override
            public final java.lang.Object getContentTypeOptions() {
                return this.contentTypeOptions;
            }

            @Override
            public final java.lang.Object getFrameOptions() {
                return this.frameOptions;
            }

            @Override
            public final java.lang.Object getReferrerPolicy() {
                return this.referrerPolicy;
            }

            @Override
            public final java.lang.Object getStrictTransportSecurity() {
                return this.strictTransportSecurity;
            }

            @Override
            public final java.lang.Object getXssProtection() {
                return this.xssProtection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContentSecurityPolicy() != null) {
                    data.set("contentSecurityPolicy", om.valueToTree(this.getContentSecurityPolicy()));
                }
                if (this.getContentTypeOptions() != null) {
                    data.set("contentTypeOptions", om.valueToTree(this.getContentTypeOptions()));
                }
                if (this.getFrameOptions() != null) {
                    data.set("frameOptions", om.valueToTree(this.getFrameOptions()));
                }
                if (this.getReferrerPolicy() != null) {
                    data.set("referrerPolicy", om.valueToTree(this.getReferrerPolicy()));
                }
                if (this.getStrictTransportSecurity() != null) {
                    data.set("strictTransportSecurity", om.valueToTree(this.getStrictTransportSecurity()));
                }
                if (this.getXssProtection() != null) {
                    data.set("xssProtection", om.valueToTree(this.getXssProtection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.SecurityHeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityHeadersConfigProperty.Jsii$Proxy that = (SecurityHeadersConfigProperty.Jsii$Proxy) o;

                if (this.contentSecurityPolicy != null ? !this.contentSecurityPolicy.equals(that.contentSecurityPolicy) : that.contentSecurityPolicy != null) return false;
                if (this.contentTypeOptions != null ? !this.contentTypeOptions.equals(that.contentTypeOptions) : that.contentTypeOptions != null) return false;
                if (this.frameOptions != null ? !this.frameOptions.equals(that.frameOptions) : that.frameOptions != null) return false;
                if (this.referrerPolicy != null ? !this.referrerPolicy.equals(that.referrerPolicy) : that.referrerPolicy != null) return false;
                if (this.strictTransportSecurity != null ? !this.strictTransportSecurity.equals(that.strictTransportSecurity) : that.strictTransportSecurity != null) return false;
                return this.xssProtection != null ? this.xssProtection.equals(that.xssProtection) : that.xssProtection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.contentSecurityPolicy != null ? this.contentSecurityPolicy.hashCode() : 0;
                result = 31 * result + (this.contentTypeOptions != null ? this.contentTypeOptions.hashCode() : 0);
                result = 31 * result + (this.frameOptions != null ? this.frameOptions.hashCode() : 0);
                result = 31 * result + (this.referrerPolicy != null ? this.referrerPolicy.hashCode() : 0);
                result = 31 * result + (this.strictTransportSecurity != null ? this.strictTransportSecurity.hashCode() : 0);
                result = 31 * result + (this.xssProtection != null ? this.xssProtection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ServerTimingHeadersConfigProperty serverTimingHeadersConfigProperty = ServerTimingHeadersConfigProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .samplingRate(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-servertimingheadersconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-servertimingheadersconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ServerTimingHeadersConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerTimingHeadersConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerTimingHeadersConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-servertimingheadersconfig.html#cfn-cloudfront-responseheaderspolicy-servertimingheadersconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-servertimingheadersconfig.html#cfn-cloudfront-responseheaderspolicy-servertimingheadersconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the <code>Server-Timing</code> header to.
         * <p>
         * When you set the sampling rate to 100, CloudFront adds the <code>Server-Timing</code> header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-servertimingheadersconfig.html#cfn-cloudfront-responseheaderspolicy-servertimingheadersconfig-samplingrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-servertimingheadersconfig.html#cfn-cloudfront-responseheaderspolicy-servertimingheadersconfig-samplingrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSamplingRate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerTimingHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerTimingHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerTimingHeadersConfigProperty> {
            java.lang.Object enabled;
            java.lang.Number samplingRate;

            /**
             * Sets the value of {@link ServerTimingHeadersConfigProperty#getEnabled}
             * @param enabled A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ServerTimingHeadersConfigProperty#getEnabled}
             * @param enabled A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP responses that it sends in response to requests that match a cache behavior that's associated with this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ServerTimingHeadersConfigProperty#getSamplingRate}
             * @param samplingRate A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the <code>Server-Timing</code> header to.
             *                     When you set the sampling rate to 100, CloudFront adds the <code>Server-Timing</code> header to the HTTP response for every request that matches the cache behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up to four decimal places.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samplingRate(java.lang.Number samplingRate) {
                this.samplingRate = samplingRate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerTimingHeadersConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerTimingHeadersConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerTimingHeadersConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerTimingHeadersConfigProperty {
            private final java.lang.Object enabled;
            private final java.lang.Number samplingRate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.samplingRate = software.amazon.jsii.Kernel.get(this, "samplingRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.samplingRate = builder.samplingRate;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getSamplingRate() {
                return this.samplingRate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getSamplingRate() != null) {
                    data.set("samplingRate", om.valueToTree(this.getSamplingRate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.ServerTimingHeadersConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerTimingHeadersConfigProperty.Jsii$Proxy that = (ServerTimingHeadersConfigProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.samplingRate != null ? this.samplingRate.equals(that.samplingRate) : that.samplingRate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.samplingRate != null ? this.samplingRate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the header's value.
     * <p>
     * For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * StrictTransportSecurityProperty strictTransportSecurityProperty = StrictTransportSecurityProperty.builder()
     *         .accessControlMaxAgeSec(123)
     *         .override(false)
     *         // the properties below are optional
     *         .includeSubdomains(false)
     *         .preload(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.StrictTransportSecurityProperty")
    @software.amazon.jsii.Jsii.Proxy(StrictTransportSecurityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StrictTransportSecurityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A number that CloudFront uses as the value for the <code>max-age</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-accesscontrolmaxagesec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-accesscontrolmaxagesec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getAccessControlMaxAgeSec();

        /**
         * A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP response header received from the origin with the one specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-includesubdomains">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-includesubdomains</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSubdomains() {
            return null;
        }

        /**
         * A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-preload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-stricttransportsecurity.html#cfn-cloudfront-responseheaderspolicy-stricttransportsecurity-preload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StrictTransportSecurityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StrictTransportSecurityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StrictTransportSecurityProperty> {
            java.lang.Number accessControlMaxAgeSec;
            java.lang.Object override;
            java.lang.Object includeSubdomains;
            java.lang.Object preload;

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getAccessControlMaxAgeSec}
             * @param accessControlMaxAgeSec A number that CloudFront uses as the value for the <code>max-age</code> directive in the <code>Strict-Transport-Security</code> HTTP response header. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlMaxAgeSec(java.lang.Number accessControlMaxAgeSec) {
                this.accessControlMaxAgeSec = accessControlMaxAgeSec;
                return this;
            }

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getIncludeSubdomains}
             * @param includeSubdomains A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSubdomains(java.lang.Boolean includeSubdomains) {
                this.includeSubdomains = includeSubdomains;
                return this;
            }

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getIncludeSubdomains}
             * @param includeSubdomains A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSubdomains(software.amazon.awscdk.IResolvable includeSubdomains) {
                this.includeSubdomains = includeSubdomains;
                return this;
            }

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getPreload}
             * @param preload A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preload(java.lang.Boolean preload) {
                this.preload = preload;
                return this;
            }

            /**
             * Sets the value of {@link StrictTransportSecurityProperty#getPreload}
             * @param preload A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preload(software.amazon.awscdk.IResolvable preload) {
                this.preload = preload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StrictTransportSecurityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StrictTransportSecurityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StrictTransportSecurityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StrictTransportSecurityProperty {
            private final java.lang.Number accessControlMaxAgeSec;
            private final java.lang.Object override;
            private final java.lang.Object includeSubdomains;
            private final java.lang.Object preload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessControlMaxAgeSec = software.amazon.jsii.Kernel.get(this, "accessControlMaxAgeSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSubdomains = software.amazon.jsii.Kernel.get(this, "includeSubdomains", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preload = software.amazon.jsii.Kernel.get(this, "preload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessControlMaxAgeSec = java.util.Objects.requireNonNull(builder.accessControlMaxAgeSec, "accessControlMaxAgeSec is required");
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
                this.includeSubdomains = builder.includeSubdomains;
                this.preload = builder.preload;
            }

            @Override
            public final java.lang.Number getAccessControlMaxAgeSec() {
                return this.accessControlMaxAgeSec;
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            public final java.lang.Object getIncludeSubdomains() {
                return this.includeSubdomains;
            }

            @Override
            public final java.lang.Object getPreload() {
                return this.preload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessControlMaxAgeSec", om.valueToTree(this.getAccessControlMaxAgeSec()));
                data.set("override", om.valueToTree(this.getOverride()));
                if (this.getIncludeSubdomains() != null) {
                    data.set("includeSubdomains", om.valueToTree(this.getIncludeSubdomains()));
                }
                if (this.getPreload() != null) {
                    data.set("preload", om.valueToTree(this.getPreload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.StrictTransportSecurityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StrictTransportSecurityProperty.Jsii$Proxy that = (StrictTransportSecurityProperty.Jsii$Proxy) o;

                if (!accessControlMaxAgeSec.equals(that.accessControlMaxAgeSec)) return false;
                if (!override.equals(that.override)) return false;
                if (this.includeSubdomains != null ? !this.includeSubdomains.equals(that.includeSubdomains) : that.includeSubdomains != null) return false;
                return this.preload != null ? this.preload.equals(that.preload) : that.preload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessControlMaxAgeSec.hashCode();
                result = 31 * result + (this.override.hashCode());
                result = 31 * result + (this.includeSubdomains != null ? this.includeSubdomains.hashCode() : 0);
                result = 31 * result + (this.preload != null ? this.preload.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and the header's value.
     * <p>
     * For more information about the <code>X-XSS-Protection</code> HTTP response header, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * XSSProtectionProperty xSSProtectionProperty = XSSProtectionProperty.builder()
     *         .override(false)
     *         .protection(false)
     *         // the properties below are optional
     *         .modeBlock(false)
     *         .reportUri("reportUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.XSSProtectionProperty")
    @software.amazon.jsii.Jsii.Proxy(XSSProtectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface XSSProtectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP response header received from the origin with the one specified in this response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-override">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-override</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOverride();

        /**
         * A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response header.
         * <p>
         * When this setting is <code>true</code> , the value of the <code>X-XSS-Protection</code> header is <code>1</code> . When this setting is <code>false</code> , the value of the <code>X-XSS-Protection</code> header is <code>0</code> .
         * <p>
         * For more information about these settings, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-protection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-protection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProtection();

        /**
         * A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the <code>X-XSS-Protection</code> header.
         * <p>
         * For more information about this directive, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-modeblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-modeblock</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModeBlock() {
            return null;
        }

        /**
         * A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the <code>X-XSS-Protection</code> header.
         * <p>
         * You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is <code>true</code> .
         * <p>
         * For more information about using a reporting URL, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-reporturi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-responseheaderspolicy-xssprotection.html#cfn-cloudfront-responseheaderspolicy-xssprotection-reporturi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReportUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link XSSProtectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link XSSProtectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<XSSProtectionProperty> {
            java.lang.Object override;
            java.lang.Object protection;
            java.lang.Object modeBlock;
            java.lang.String reportUri;

            /**
             * Sets the value of {@link XSSProtectionProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(java.lang.Boolean override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link XSSProtectionProperty#getOverride}
             * @param override A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder override(software.amazon.awscdk.IResolvable override) {
                this.override = override;
                return this;
            }

            /**
             * Sets the value of {@link XSSProtectionProperty#getProtection}
             * @param protection A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response header. This parameter is required.
             *                   When this setting is <code>true</code> , the value of the <code>X-XSS-Protection</code> header is <code>1</code> . When this setting is <code>false</code> , the value of the <code>X-XSS-Protection</code> header is <code>0</code> .
             *                   <p>
             *                   For more information about these settings, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protection(java.lang.Boolean protection) {
                this.protection = protection;
                return this;
            }

            /**
             * Sets the value of {@link XSSProtectionProperty#getProtection}
             * @param protection A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response header. This parameter is required.
             *                   When this setting is <code>true</code> , the value of the <code>X-XSS-Protection</code> header is <code>1</code> . When this setting is <code>false</code> , the value of the <code>X-XSS-Protection</code> header is <code>0</code> .
             *                   <p>
             *                   For more information about these settings, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protection(software.amazon.awscdk.IResolvable protection) {
                this.protection = protection;
                return this;
            }

            /**
             * Sets the value of {@link XSSProtectionProperty#getModeBlock}
             * @param modeBlock A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the <code>X-XSS-Protection</code> header.
             *                  For more information about this directive, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modeBlock(java.lang.Boolean modeBlock) {
                this.modeBlock = modeBlock;
                return this;
            }

            /**
             * Sets the value of {@link XSSProtectionProperty#getModeBlock}
             * @param modeBlock A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the <code>X-XSS-Protection</code> header.
             *                  For more information about this directive, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modeBlock(software.amazon.awscdk.IResolvable modeBlock) {
                this.modeBlock = modeBlock;
                return this;
            }

            /**
             * Sets the value of {@link XSSProtectionProperty#getReportUri}
             * @param reportUri A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the <code>X-XSS-Protection</code> header.
             *                  You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is <code>true</code> .
             *                  <p>
             *                  For more information about using a reporting URL, see <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportUri(java.lang.String reportUri) {
                this.reportUri = reportUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link XSSProtectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public XSSProtectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link XSSProtectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements XSSProtectionProperty {
            private final java.lang.Object override;
            private final java.lang.Object protection;
            private final java.lang.Object modeBlock;
            private final java.lang.String reportUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protection = software.amazon.jsii.Kernel.get(this, "protection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modeBlock = software.amazon.jsii.Kernel.get(this, "modeBlock", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.reportUri = software.amazon.jsii.Kernel.get(this, "reportUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
                this.protection = java.util.Objects.requireNonNull(builder.protection, "protection is required");
                this.modeBlock = builder.modeBlock;
                this.reportUri = builder.reportUri;
            }

            @Override
            public final java.lang.Object getOverride() {
                return this.override;
            }

            @Override
            public final java.lang.Object getProtection() {
                return this.protection;
            }

            @Override
            public final java.lang.Object getModeBlock() {
                return this.modeBlock;
            }

            @Override
            public final java.lang.String getReportUri() {
                return this.reportUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("override", om.valueToTree(this.getOverride()));
                data.set("protection", om.valueToTree(this.getProtection()));
                if (this.getModeBlock() != null) {
                    data.set("modeBlock", om.valueToTree(this.getModeBlock()));
                }
                if (this.getReportUri() != null) {
                    data.set("reportUri", om.valueToTree(this.getReportUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnResponseHeadersPolicy.XSSProtectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                XSSProtectionProperty.Jsii$Proxy that = (XSSProtectionProperty.Jsii$Proxy) o;

                if (!override.equals(that.override)) return false;
                if (!protection.equals(that.protection)) return false;
                if (this.modeBlock != null ? !this.modeBlock.equals(that.modeBlock) : that.modeBlock != null) return false;
                return this.reportUri != null ? this.reportUri.equals(that.reportUri) : that.reportUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.override.hashCode();
                result = 31 * result + (this.protection.hashCode());
                result = 31 * result + (this.modeBlock != null ? this.modeBlock.hashCode() : 0);
                result = 31 * result + (this.reportUri != null ? this.reportUri.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicyProps.Builder();
        }

        /**
         * A response headers policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig</a>
         * @param responseHeadersPolicyConfig A response headers policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicyConfig(final software.amazon.awscdk.IResolvable responseHeadersPolicyConfig) {
            this.props.responseHeadersPolicyConfig(responseHeadersPolicyConfig);
            return this;
        }
        /**
         * A response headers policy configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-responseheaderspolicy.html#cfn-cloudfront-responseheaderspolicy-responseheaderspolicyconfig</a>
         * @param responseHeadersPolicyConfig A response headers policy configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicyConfig(final software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy.ResponseHeadersPolicyConfigProperty responseHeadersPolicyConfig) {
            this.props.responseHeadersPolicyConfig(responseHeadersPolicyConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy build() {
            return new software.amazon.awscdk.services.cloudfront.CfnResponseHeadersPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
