package software.amazon.awscdk.services.cloudfront;

/**
 * Options passed to Origin.bind().
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * OriginBindOptions originBindOptions = OriginBindOptions.builder()
 *         .originId("originId")
 *         // the properties below are optional
 *         .distributionId("distributionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:34.585Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginBindOptions")
@software.amazon.jsii.Jsii.Proxy(OriginBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of this Origin, as assigned by the Distribution this Origin has been used added to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOriginId();

    /**
     * The identifier of the Distribution this Origin is used for.
     * <p>
     * This is used to grant origin access permissions to the distribution for origin access control.
     * <p>
     * Default: - no distribution id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistributionId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginBindOptions> {
        java.lang.String originId;
        java.lang.String distributionId;

        /**
         * Sets the value of {@link OriginBindOptions#getOriginId}
         * @param originId The identifier of this Origin, as assigned by the Distribution this Origin has been used added to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originId(java.lang.String originId) {
            this.originId = originId;
            return this;
        }

        /**
         * Sets the value of {@link OriginBindOptions#getDistributionId}
         * @param distributionId The identifier of the Distribution this Origin is used for.
         *                       This is used to grant origin access permissions to the distribution for origin access control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionId(java.lang.String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginBindOptions {
        private final java.lang.String originId;
        private final java.lang.String distributionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.originId = software.amazon.jsii.Kernel.get(this, "originId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributionId = software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.originId = java.util.Objects.requireNonNull(builder.originId, "originId is required");
            this.distributionId = builder.distributionId;
        }

        @Override
        public final java.lang.String getOriginId() {
            return this.originId;
        }

        @Override
        public final java.lang.String getDistributionId() {
            return this.distributionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("originId", om.valueToTree(this.getOriginId()));
            if (this.getDistributionId() != null) {
                data.set("distributionId", om.valueToTree(this.getDistributionId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.OriginBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginBindOptions.Jsii$Proxy that = (OriginBindOptions.Jsii$Proxy) o;

            if (!originId.equals(that.originId)) return false;
            return this.distributionId != null ? this.distributionId.equals(that.distributionId) : that.distributionId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.originId.hashCode();
            result = 31 * result + (this.distributionId != null ? this.distributionId.hashCode() : 0);
            return result;
        }
    }
}
