package software.amazon.awscdk.services.cloudfront.origins;

/**
 * A S3 Bucket Origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.LIST))
 *         .build());
 * Distribution.Builder.create(this, "distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .defaultRootObject("index.html")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:34.664Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.S3BucketOrigin")
public abstract class S3BucketOrigin extends software.amazon.awscdk.services.cloudfront.OriginBase {

    protected S3BucketOrigin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3BucketOrigin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected S3BucketOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.S3BucketOriginBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected S3BucketOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Create a S3 Origin with default S3 bucket settings (no origin access control).
     * <p>
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin withBucketDefaults(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin.class, "withBucketDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * Create a S3 Origin with default S3 bucket settings (no origin access control).
     * <p>
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin withBucketDefaults(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin.class, "withBucketDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Create a S3 Origin with Origin Access Control (OAC) configured.
     * <p>
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin withOriginAccessControl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.S3BucketOriginWithOACProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin.class, "withOriginAccessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * Create a S3 Origin with Origin Access Control (OAC) configured.
     * <p>
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin withOriginAccessControl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin.class, "withOriginAccessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Create a S3 Origin with Origin Access Identity (OAI) configured OAI is a legacy feature and we <strong>strongly</strong> recommend you to use OAC via <code>withOriginAccessControl()</code> unless it is not supported in your required region (e.g. China regions).
     * <p>
     * @param bucket This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin withOriginAccessIdentity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.S3BucketOriginWithOAIProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin.class, "withOriginAccessIdentity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * Create a S3 Origin with Origin Access Identity (OAI) configured OAI is a legacy feature and we <strong>strongly</strong> recommend you to use OAC via <code>withOriginAccessControl()</code> unless it is not supported in your required region (e.g. China regions).
     * <p>
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin withOriginAccessIdentity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin.class, "withOriginAccessIdentity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty renderS3OriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderS3OriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.origins.S3BucketOrigin implements software.amazon.awscdk.services.cloudfront.IOrigin.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
