package software.amazon.awscdk.services.cloudwatch;

/**
 * A CustomWidget shows the result of a AWS lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * // Import or create a lambda function
 * IFunction fn = Function.fromFunctionArn(dashboard, "Function", "arn:aws:lambda:us-east-1:123456789012:function:MyFn");
 * dashboard.addWidgets(CustomWidget.Builder.create()
 *         .functionArn(fn.getFunctionArn())
 *         .title("My lambda baked widget")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:34.800Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CustomWidget")
public class CustomWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected CustomWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CustomWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.CustomWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.CustomWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.CustomWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.CustomWidgetProps.Builder();
        }

        /**
         * The Arn of the AWS Lambda function that returns HTML or JSON that will be displayed in the widget.
         * <p>
         * @return {@code this}
         * @param functionArn The Arn of the AWS Lambda function that returns HTML or JSON that will be displayed in the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionArn(final java.lang.String functionArn) {
            this.props.functionArn(functionArn);
            return this;
        }

        /**
         * The title of the widget.
         * <p>
         * @return {@code this}
         * @param title The title of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * Height of the widget.
         * <p>
         * Default: - 6 for Alarm and Graph widgets.
         * 3 for single value widgets where most recent value of a metric is displayed.
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * Parameters passed to the lambda function.
         * <p>
         * Default: - no parameters are passed to the lambda function
         * <p>
         * @return {@code this}
         * @param params Parameters passed to the lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder params(final java.lang.Object params) {
            this.props.params(params);
            return this;
        }

        /**
         * Update the widget on refresh.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param updateOnRefresh Update the widget on refresh. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateOnRefresh(final java.lang.Boolean updateOnRefresh) {
            this.props.updateOnRefresh(updateOnRefresh);
            return this;
        }

        /**
         * Update the widget on resize.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param updateOnResize Update the widget on resize. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateOnResize(final java.lang.Boolean updateOnResize) {
            this.props.updateOnResize(updateOnResize);
            return this;
        }

        /**
         * Update the widget on time range change.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param updateOnTimeRangeChange Update the widget on time range change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateOnTimeRangeChange(final java.lang.Boolean updateOnTimeRangeChange) {
            this.props.updateOnTimeRangeChange(updateOnTimeRangeChange);
            return this;
        }

        /**
         * Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.CustomWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.CustomWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.CustomWidget(
                this.props.build()
            );
        }
    }
}
