package software.amazon.awscdk.services.codedeploy;

/**
 * Minimum number of healthy hosts per availability zone for a server deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ServerDeploymentConfig deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .minimumHealthyHosts(MinimumHealthyHosts.count(2))
 *         .zonalConfig(ZonalConfig.builder()
 *                 .monitorDuration(Duration.minutes(30))
 *                 .firstZoneMonitorDuration(Duration.minutes(60))
 *                 .minimumHealthyHostsPerZone(MinimumHealthyHostsPerZone.count(1))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:35.116Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.MinimumHealthyHostsPerZone")
public class MinimumHealthyHostsPerZone extends software.amazon.jsii.JsiiObject {

    protected MinimumHealthyHostsPerZone(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MinimumHealthyHostsPerZone(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The minimum healthy hosts threshold expressed as an absolute number.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone count(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone.class, "count", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The minimum healthy hosts threshold expressed as a percentage of the fleet.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone percentage(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone.class, "percentage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHostsPerZone.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }
}
