package software.amazon.awscdk.services.codepipeline;

/**
 * Properties for defining a <code>CfnPipeline</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Object configuration;
 * CfnPipelineProps cfnPipelineProps = CfnPipelineProps.builder()
 *         .roleArn("roleArn")
 *         .stages(List.of(StageDeclarationProperty.builder()
 *                 .actions(List.of(ActionDeclarationProperty.builder()
 *                         .actionTypeId(ActionTypeIdProperty.builder()
 *                                 .category("category")
 *                                 .owner("owner")
 *                                 .provider("provider")
 *                                 .version("version")
 *                                 .build())
 *                         .name("name")
 *                         // the properties below are optional
 *                         .commands(List.of("commands"))
 *                         .configuration(configuration)
 *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .namespace("namespace")
 *                         .outputArtifacts(List.of(OutputArtifactProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .files(List.of("files"))
 *                                 .build()))
 *                         .outputVariables(List.of("outputVariables"))
 *                         .region("region")
 *                         .roleArn("roleArn")
 *                         .runOrder(123)
 *                         .timeoutInMinutes(123)
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .beforeEntry(BeforeEntryConditionsProperty.builder()
 *                         .conditions(List.of(ConditionProperty.builder()
 *                                 .result("result")
 *                                 .rules(List.of(RuleDeclarationProperty.builder()
 *                                         .commands(List.of("commands"))
 *                                         .configuration(configuration)
 *                                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                                 .name("name")
 *                                                 .build()))
 *                                         .name("name")
 *                                         .region("region")
 *                                         .roleArn("roleArn")
 *                                         .ruleTypeId(RuleTypeIdProperty.builder()
 *                                                 .category("category")
 *                                                 .owner("owner")
 *                                                 .provider("provider")
 *                                                 .version("version")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .blockers(List.of(BlockerDeclarationProperty.builder()
 *                         .name("name")
 *                         .type("type")
 *                         .build()))
 *                 .onFailure(FailureConditionsProperty.builder()
 *                         .conditions(List.of(ConditionProperty.builder()
 *                                 .result("result")
 *                                 .rules(List.of(RuleDeclarationProperty.builder()
 *                                         .commands(List.of("commands"))
 *                                         .configuration(configuration)
 *                                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                                 .name("name")
 *                                                 .build()))
 *                                         .name("name")
 *                                         .region("region")
 *                                         .roleArn("roleArn")
 *                                         .ruleTypeId(RuleTypeIdProperty.builder()
 *                                                 .category("category")
 *                                                 .owner("owner")
 *                                                 .provider("provider")
 *                                                 .version("version")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .result("result")
 *                         .retryConfiguration(RetryConfigurationProperty.builder()
 *                                 .retryMode("retryMode")
 *                                 .build())
 *                         .build())
 *                 .onSuccess(SuccessConditionsProperty.builder()
 *                         .conditions(List.of(ConditionProperty.builder()
 *                                 .result("result")
 *                                 .rules(List.of(RuleDeclarationProperty.builder()
 *                                         .commands(List.of("commands"))
 *                                         .configuration(configuration)
 *                                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                                 .name("name")
 *                                                 .build()))
 *                                         .name("name")
 *                                         .region("region")
 *                                         .roleArn("roleArn")
 *                                         .ruleTypeId(RuleTypeIdProperty.builder()
 *                                                 .category("category")
 *                                                 .owner("owner")
 *                                                 .provider("provider")
 *                                                 .version("version")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .artifactStore(ArtifactStoreProperty.builder()
 *                 .location("location")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .encryptionKey(EncryptionKeyProperty.builder()
 *                         .id("id")
 *                         .type("type")
 *                         .build())
 *                 .build())
 *         .artifactStores(List.of(ArtifactStoreMapProperty.builder()
 *                 .artifactStore(ArtifactStoreProperty.builder()
 *                         .location("location")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .encryptionKey(EncryptionKeyProperty.builder()
 *                                 .id("id")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .region("region")
 *                 .build()))
 *         .disableInboundStageTransitions(List.of(StageTransitionProperty.builder()
 *                 .reason("reason")
 *                 .stageName("stageName")
 *                 .build()))
 *         .executionMode("executionMode")
 *         .name("name")
 *         .pipelineType("pipelineType")
 *         .restartExecutionOnUpdate(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggers(List.of(PipelineTriggerDeclarationProperty.builder()
 *                 .providerType("providerType")
 *                 // the properties below are optional
 *                 .gitConfiguration(GitConfigurationProperty.builder()
 *                         .sourceActionName("sourceActionName")
 *                         // the properties below are optional
 *                         .pullRequest(List.of(GitPullRequestFilterProperty.builder()
 *                                 .branches(GitBranchFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .events(List.of("events"))
 *                                 .filePaths(GitFilePathFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .build()))
 *                         .push(List.of(GitPushFilterProperty.builder()
 *                                 .branches(GitBranchFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .filePaths(GitFilePathFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .tags(GitTagFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .variables(List.of(VariableDeclarationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .defaultValue("defaultValue")
 *                 .description("description")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:35.183Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipelineProps")
@software.amazon.jsii.Jsii.Proxy(CfnPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no <code>actionRoleArn</code> , or to use to assume roles for actions with an <code>actionRoleArn</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Represents information about a stage and its definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getStages();

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStore() {
        return null;
    }

    /**
     * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStores() {
        return null;
    }

    /**
     * Represents the input of a <code>DisableStageTransition</code> action.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableInboundStageTransitions() {
        return null;
    }

    /**
     * The method that the pipeline will use to handle multiple executions.
     * <p>
     * The default mode is SUPERSEDED.
     * <p>
     * Default: - "SUPERSEDED"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-executionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-executionmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionMode() {
        return null;
    }

    /**
     * The name of the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
     * <p>
     * <ul>
     * <li>V1 type pipelines have a JSON structure that contains standard pipeline, stage, and action-level parameters.</li>
     * <li>V2 type pipelines have the same structure as a V1 type, along with additional parameters for release safety and trigger configuration.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Including V2 parameters, such as triggers on Git tags, in the pipeline JSON when creating or updating a pipeline will result in the pipeline having the V2 type of pipeline and the associated costs.
     * <p>
     * </blockquote>
     * <p>
     * For information about pricing for CodePipeline, see <a href="https://docs.aws.amazon.com/codepipeline/pricing/">Pricing</a> .
     * <p>
     * For information about which type of pipeline to choose, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html">What type of pipeline is right for me?</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-pipelinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-pipelinetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineType() {
        return null;
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRestartExecutionOnUpdate() {
        return null;
    }

    /**
     * Specifies the tags applied to the pipeline.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-triggers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return null;
    }

    /**
     * A list that defines the pipeline variables for a pipeline resource.
     * <p>
     * Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9&#64;\-_]+</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-variables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPipelineProps> {
        java.lang.String roleArn;
        java.lang.Object stages;
        java.lang.Object artifactStore;
        java.lang.Object artifactStores;
        java.lang.Object disableInboundStageTransitions;
        java.lang.String executionMode;
        java.lang.String name;
        java.lang.String pipelineType;
        java.lang.Object restartExecutionOnUpdate;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object triggers;
        java.lang.Object variables;

        /**
         * Sets the value of {@link CfnPipelineProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no <code>actionRoleArn</code> , or to use to assume roles for actions with an <code>actionRoleArn</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getStages}
         * @param stages Represents information about a stage and its definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(software.amazon.awscdk.IResolvable stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getStages}
         * @param stages Represents information about a stage and its definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(java.util.List<? extends java.lang.Object> stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStore}
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored.
         *                      <blockquote>
         *                      <p>
         *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(software.amazon.awscdk.IResolvable artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStore}
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored.
         *                      <blockquote>
         *                      <p>
         *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStores}
         * @param artifactStores A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
         *                       There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(software.amazon.awscdk.IResolvable artifactStores) {
            this.artifactStores = artifactStores;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getArtifactStores}
         * @param artifactStores A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
         *                       There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(java.util.List<? extends java.lang.Object> artifactStores) {
            this.artifactStores = artifactStores;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getDisableInboundStageTransitions}
         * @param disableInboundStageTransitions Represents the input of a <code>DisableStageTransition</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(software.amazon.awscdk.IResolvable disableInboundStageTransitions) {
            this.disableInboundStageTransitions = disableInboundStageTransitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getDisableInboundStageTransitions}
         * @param disableInboundStageTransitions Represents the input of a <code>DisableStageTransition</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(java.util.List<? extends java.lang.Object> disableInboundStageTransitions) {
            this.disableInboundStageTransitions = disableInboundStageTransitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getExecutionMode}
         * @param executionMode The method that the pipeline will use to handle multiple executions.
         *                      The default mode is SUPERSEDED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionMode(java.lang.String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getName}
         * @param name The name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getPipelineType}
         * @param pipelineType CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
         *                     <ul>
         *                     <li>V1 type pipelines have a JSON structure that contains standard pipeline, stage, and action-level parameters.</li>
         *                     <li>V2 type pipelines have the same structure as a V1 type, along with additional parameters for release safety and trigger configuration.</li>
         *                     </ul>
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     Including V2 parameters, such as triggers on Git tags, in the pipeline JSON when creating or updating a pipeline will result in the pipeline having the V2 type of pipeline and the associated costs.
         *                     <p>
         *                     </blockquote>
         *                     <p>
         *                     For information about pricing for CodePipeline, see <a href="https://docs.aws.amazon.com/codepipeline/pricing/">Pricing</a> .
         *                     <p>
         *                     For information about which type of pipeline to choose, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html">What type of pipeline is right for me?</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineType(java.lang.String pipelineType) {
            this.pipelineType = pipelineType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(java.lang.Boolean restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(software.amazon.awscdk.IResolvable restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTags}
         * @param tags Specifies the tags applied to the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTriggers}
         * @param triggers The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
         *                 <blockquote>
         *                 <p>
         *                 When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(software.amazon.awscdk.IResolvable triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getTriggers}
         * @param triggers The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
         *                 <blockquote>
         *                 <p>
         *                 When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(java.util.List<? extends java.lang.Object> triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getVariables}
         * @param variables A list that defines the pipeline variables for a pipeline resource.
         *                  Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9&#64;\-_]+</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(software.amazon.awscdk.IResolvable variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Sets the value of {@link CfnPipelineProps#getVariables}
         * @param variables A list that defines the pipeline variables for a pipeline resource.
         *                  Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9&#64;\-_]+</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(java.util.List<? extends java.lang.Object> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPipelineProps {
        private final java.lang.String roleArn;
        private final java.lang.Object stages;
        private final java.lang.Object artifactStore;
        private final java.lang.Object artifactStores;
        private final java.lang.Object disableInboundStageTransitions;
        private final java.lang.String executionMode;
        private final java.lang.String name;
        private final java.lang.String pipelineType;
        private final java.lang.Object restartExecutionOnUpdate;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object triggers;
        private final java.lang.Object variables;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stages = software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.artifactStore = software.amazon.jsii.Kernel.get(this, "artifactStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.artifactStores = software.amazon.jsii.Kernel.get(this, "artifactStores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.disableInboundStageTransitions = software.amazon.jsii.Kernel.get(this, "disableInboundStageTransitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionMode = software.amazon.jsii.Kernel.get(this, "executionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pipelineType = software.amazon.jsii.Kernel.get(this, "pipelineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restartExecutionOnUpdate = software.amazon.jsii.Kernel.get(this, "restartExecutionOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.triggers = software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.stages = java.util.Objects.requireNonNull(builder.stages, "stages is required");
            this.artifactStore = builder.artifactStore;
            this.artifactStores = builder.artifactStores;
            this.disableInboundStageTransitions = builder.disableInboundStageTransitions;
            this.executionMode = builder.executionMode;
            this.name = builder.name;
            this.pipelineType = builder.pipelineType;
            this.restartExecutionOnUpdate = builder.restartExecutionOnUpdate;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.triggers = builder.triggers;
            this.variables = builder.variables;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getStages() {
            return this.stages;
        }

        @Override
        public final java.lang.Object getArtifactStore() {
            return this.artifactStore;
        }

        @Override
        public final java.lang.Object getArtifactStores() {
            return this.artifactStores;
        }

        @Override
        public final java.lang.Object getDisableInboundStageTransitions() {
            return this.disableInboundStageTransitions;
        }

        @Override
        public final java.lang.String getExecutionMode() {
            return this.executionMode;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPipelineType() {
            return this.pipelineType;
        }

        @Override
        public final java.lang.Object getRestartExecutionOnUpdate() {
            return this.restartExecutionOnUpdate;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTriggers() {
            return this.triggers;
        }

        @Override
        public final java.lang.Object getVariables() {
            return this.variables;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("stages", om.valueToTree(this.getStages()));
            if (this.getArtifactStore() != null) {
                data.set("artifactStore", om.valueToTree(this.getArtifactStore()));
            }
            if (this.getArtifactStores() != null) {
                data.set("artifactStores", om.valueToTree(this.getArtifactStores()));
            }
            if (this.getDisableInboundStageTransitions() != null) {
                data.set("disableInboundStageTransitions", om.valueToTree(this.getDisableInboundStageTransitions()));
            }
            if (this.getExecutionMode() != null) {
                data.set("executionMode", om.valueToTree(this.getExecutionMode()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPipelineType() != null) {
                data.set("pipelineType", om.valueToTree(this.getPipelineType()));
            }
            if (this.getRestartExecutionOnUpdate() != null) {
                data.set("restartExecutionOnUpdate", om.valueToTree(this.getRestartExecutionOnUpdate()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTriggers() != null) {
                data.set("triggers", om.valueToTree(this.getTriggers()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPipelineProps.Jsii$Proxy that = (CfnPipelineProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (!stages.equals(that.stages)) return false;
            if (this.artifactStore != null ? !this.artifactStore.equals(that.artifactStore) : that.artifactStore != null) return false;
            if (this.artifactStores != null ? !this.artifactStores.equals(that.artifactStores) : that.artifactStores != null) return false;
            if (this.disableInboundStageTransitions != null ? !this.disableInboundStageTransitions.equals(that.disableInboundStageTransitions) : that.disableInboundStageTransitions != null) return false;
            if (this.executionMode != null ? !this.executionMode.equals(that.executionMode) : that.executionMode != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.pipelineType != null ? !this.pipelineType.equals(that.pipelineType) : that.pipelineType != null) return false;
            if (this.restartExecutionOnUpdate != null ? !this.restartExecutionOnUpdate.equals(that.restartExecutionOnUpdate) : that.restartExecutionOnUpdate != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) return false;
            return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.stages.hashCode());
            result = 31 * result + (this.artifactStore != null ? this.artifactStore.hashCode() : 0);
            result = 31 * result + (this.artifactStores != null ? this.artifactStores.hashCode() : 0);
            result = 31 * result + (this.disableInboundStageTransitions != null ? this.disableInboundStageTransitions.hashCode() : 0);
            result = 31 * result + (this.executionMode != null ? this.executionMode.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.pipelineType != null ? this.pipelineType.hashCode() : 0);
            result = 31 * result + (this.restartExecutionOnUpdate != null ? this.restartExecutionOnUpdate.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.triggers != null ? this.triggers.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            return result;
        }
    }
}
