package software.amazon.awscdk.services.cognito;

/**
 * The different ways in which users of this pool can sign up or sign in.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         // ...
 *         .signInAliases(SignInAliases.builder().username(true).email(true).build())
 *         .autoVerify(AutoVerifiedAttrs.builder().email(true).phone(true).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:35.518Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.SignInAliases")
@software.amazon.jsii.Jsii.Proxy(SignInAliases.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SignInAliases extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether a user is allowed to sign up or sign in with an email address.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmail() {
        return null;
    }

    /**
     * Whether a user is allowed to sign up or sign in with a phone number.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPhone() {
        return null;
    }

    /**
     * Whether a user is allowed to sign in with a secondary username, that can be set and modified after sign up.
     * <p>
     * Can only be used in conjunction with <code>USERNAME</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreferredUsername() {
        return null;
    }

    /**
     * Whether user is allowed to sign up or sign in with a username.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUsername() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SignInAliases}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SignInAliases}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SignInAliases> {
        java.lang.Boolean email;
        java.lang.Boolean phone;
        java.lang.Boolean preferredUsername;
        java.lang.Boolean username;

        /**
         * Sets the value of {@link SignInAliases#getEmail}
         * @param email Whether a user is allowed to sign up or sign in with an email address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(java.lang.Boolean email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link SignInAliases#getPhone}
         * @param phone Whether a user is allowed to sign up or sign in with a phone number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phone(java.lang.Boolean phone) {
            this.phone = phone;
            return this;
        }

        /**
         * Sets the value of {@link SignInAliases#getPreferredUsername}
         * @param preferredUsername Whether a user is allowed to sign in with a secondary username, that can be set and modified after sign up.
         *                          Can only be used in conjunction with <code>USERNAME</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredUsername(java.lang.Boolean preferredUsername) {
            this.preferredUsername = preferredUsername;
            return this;
        }

        /**
         * Sets the value of {@link SignInAliases#getUsername}
         * @param username Whether user is allowed to sign up or sign in with a username.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.Boolean username) {
            this.username = username;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SignInAliases}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SignInAliases build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SignInAliases}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignInAliases {
        private final java.lang.Boolean email;
        private final java.lang.Boolean phone;
        private final java.lang.Boolean preferredUsername;
        private final java.lang.Boolean username;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.phone = software.amazon.jsii.Kernel.get(this, "phone", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.preferredUsername = software.amazon.jsii.Kernel.get(this, "preferredUsername", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.email = builder.email;
            this.phone = builder.phone;
            this.preferredUsername = builder.preferredUsername;
            this.username = builder.username;
        }

        @Override
        public final java.lang.Boolean getEmail() {
            return this.email;
        }

        @Override
        public final java.lang.Boolean getPhone() {
            return this.phone;
        }

        @Override
        public final java.lang.Boolean getPreferredUsername() {
            return this.preferredUsername;
        }

        @Override
        public final java.lang.Boolean getUsername() {
            return this.username;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getPhone() != null) {
                data.set("phone", om.valueToTree(this.getPhone()));
            }
            if (this.getPreferredUsername() != null) {
                data.set("preferredUsername", om.valueToTree(this.getPreferredUsername()));
            }
            if (this.getUsername() != null) {
                data.set("username", om.valueToTree(this.getUsername()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.SignInAliases"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SignInAliases.Jsii$Proxy that = (SignInAliases.Jsii$Proxy) o;

            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) return false;
            if (this.preferredUsername != null ? !this.preferredUsername.equals(that.preferredUsername) : that.preferredUsername != null) return false;
            return this.username != null ? this.username.equals(that.username) : that.username == null;
        }

        @Override
        public final int hashCode() {
            int result = this.email != null ? this.email.hashCode() : 0;
            result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
            result = 31 * result + (this.preferredUsername != null ? this.preferredUsername.hashCode() : 0);
            result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
            return result;
        }
    }
}
