package software.amazon.awscdk.services.cognito;

/**
 * Triggers for a user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authChallengeFn = Function.Builder.create(this, "authChallengeFn")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "path/to/asset")))
 *         .build();
 * UserPool userpool = UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .lambdaTriggers(UserPoolTriggers.builder()
 *                 .createAuthChallenge(authChallengeFn)
 *                 .build())
 *         .build();
 * userpool.addTrigger(UserPoolOperation.USER_MIGRATION, Function.Builder.create(this, "userMigrationFn")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "path/to/asset")))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:35.565Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolTriggers")
@software.amazon.jsii.Jsii.Proxy(UserPoolTriggers.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolTriggers extends software.amazon.jsii.JsiiSerializable {

    /**
     * Creates an authentication challenge.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getCreateAuthChallenge() {
        return null;
    }

    /**
     * Amazon Cognito invokes this trigger to send email notifications to users.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-email-sender.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-email-sender.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getCustomEmailSender() {
        return null;
    }

    /**
     * A custom Message AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getCustomMessage() {
        return null;
    }

    /**
     * Amazon Cognito invokes this trigger to send SMS notifications to users.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sms-sender.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sms-sender.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getCustomSmsSender() {
        return null;
    }

    /**
     * Defines the authentication challenge.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getDefineAuthChallenge() {
        return null;
    }

    /**
     * A post-authentication AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getPostAuthentication() {
        return null;
    }

    /**
     * A post-confirmation AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getPostConfirmation() {
        return null;
    }

    /**
     * A pre-authentication AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getPreAuthentication() {
        return null;
    }

    /**
     * A pre-registration AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getPreSignUp() {
        return null;
    }

    /**
     * A pre-token-generation AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getPreTokenGeneration() {
        return null;
    }

    /**
     * A user-migration AWS Lambda trigger.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getUserMigration() {
        return null;
    }

    /**
     * Verifies the authentication challenge response.
     * <p>
     * Default: - no trigger configured
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getVerifyAuthChallengeResponse() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolTriggers}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolTriggers}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolTriggers> {
        software.amazon.awscdk.services.lambda.IFunction createAuthChallenge;
        software.amazon.awscdk.services.lambda.IFunction customEmailSender;
        software.amazon.awscdk.services.lambda.IFunction customMessage;
        software.amazon.awscdk.services.lambda.IFunction customSmsSender;
        software.amazon.awscdk.services.lambda.IFunction defineAuthChallenge;
        software.amazon.awscdk.services.lambda.IFunction postAuthentication;
        software.amazon.awscdk.services.lambda.IFunction postConfirmation;
        software.amazon.awscdk.services.lambda.IFunction preAuthentication;
        software.amazon.awscdk.services.lambda.IFunction preSignUp;
        software.amazon.awscdk.services.lambda.IFunction preTokenGeneration;
        software.amazon.awscdk.services.lambda.IFunction userMigration;
        software.amazon.awscdk.services.lambda.IFunction verifyAuthChallengeResponse;

        /**
         * Sets the value of {@link UserPoolTriggers#getCreateAuthChallenge}
         * @param createAuthChallenge Creates an authentication challenge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAuthChallenge(software.amazon.awscdk.services.lambda.IFunction createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getCustomEmailSender}
         * @param customEmailSender Amazon Cognito invokes this trigger to send email notifications to users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEmailSender(software.amazon.awscdk.services.lambda.IFunction customEmailSender) {
            this.customEmailSender = customEmailSender;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getCustomMessage}
         * @param customMessage A custom Message AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customMessage(software.amazon.awscdk.services.lambda.IFunction customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getCustomSmsSender}
         * @param customSmsSender Amazon Cognito invokes this trigger to send SMS notifications to users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSmsSender(software.amazon.awscdk.services.lambda.IFunction customSmsSender) {
            this.customSmsSender = customSmsSender;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getDefineAuthChallenge}
         * @param defineAuthChallenge Defines the authentication challenge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defineAuthChallenge(software.amazon.awscdk.services.lambda.IFunction defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getPostAuthentication}
         * @param postAuthentication A post-authentication AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postAuthentication(software.amazon.awscdk.services.lambda.IFunction postAuthentication) {
            this.postAuthentication = postAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getPostConfirmation}
         * @param postConfirmation A post-confirmation AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postConfirmation(software.amazon.awscdk.services.lambda.IFunction postConfirmation) {
            this.postConfirmation = postConfirmation;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getPreAuthentication}
         * @param preAuthentication A pre-authentication AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preAuthentication(software.amazon.awscdk.services.lambda.IFunction preAuthentication) {
            this.preAuthentication = preAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getPreSignUp}
         * @param preSignUp A pre-registration AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preSignUp(software.amazon.awscdk.services.lambda.IFunction preSignUp) {
            this.preSignUp = preSignUp;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getPreTokenGeneration}
         * @param preTokenGeneration A pre-token-generation AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preTokenGeneration(software.amazon.awscdk.services.lambda.IFunction preTokenGeneration) {
            this.preTokenGeneration = preTokenGeneration;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getUserMigration}
         * @param userMigration A user-migration AWS Lambda trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userMigration(software.amazon.awscdk.services.lambda.IFunction userMigration) {
            this.userMigration = userMigration;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolTriggers#getVerifyAuthChallengeResponse}
         * @param verifyAuthChallengeResponse Verifies the authentication challenge response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifyAuthChallengeResponse(software.amazon.awscdk.services.lambda.IFunction verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolTriggers}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolTriggers build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolTriggers}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolTriggers {
        private final software.amazon.awscdk.services.lambda.IFunction createAuthChallenge;
        private final software.amazon.awscdk.services.lambda.IFunction customEmailSender;
        private final software.amazon.awscdk.services.lambda.IFunction customMessage;
        private final software.amazon.awscdk.services.lambda.IFunction customSmsSender;
        private final software.amazon.awscdk.services.lambda.IFunction defineAuthChallenge;
        private final software.amazon.awscdk.services.lambda.IFunction postAuthentication;
        private final software.amazon.awscdk.services.lambda.IFunction postConfirmation;
        private final software.amazon.awscdk.services.lambda.IFunction preAuthentication;
        private final software.amazon.awscdk.services.lambda.IFunction preSignUp;
        private final software.amazon.awscdk.services.lambda.IFunction preTokenGeneration;
        private final software.amazon.awscdk.services.lambda.IFunction userMigration;
        private final software.amazon.awscdk.services.lambda.IFunction verifyAuthChallengeResponse;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.createAuthChallenge = software.amazon.jsii.Kernel.get(this, "createAuthChallenge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.customEmailSender = software.amazon.jsii.Kernel.get(this, "customEmailSender", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.customMessage = software.amazon.jsii.Kernel.get(this, "customMessage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.customSmsSender = software.amazon.jsii.Kernel.get(this, "customSmsSender", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.defineAuthChallenge = software.amazon.jsii.Kernel.get(this, "defineAuthChallenge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.postAuthentication = software.amazon.jsii.Kernel.get(this, "postAuthentication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.postConfirmation = software.amazon.jsii.Kernel.get(this, "postConfirmation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.preAuthentication = software.amazon.jsii.Kernel.get(this, "preAuthentication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.preSignUp = software.amazon.jsii.Kernel.get(this, "preSignUp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.preTokenGeneration = software.amazon.jsii.Kernel.get(this, "preTokenGeneration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.userMigration = software.amazon.jsii.Kernel.get(this, "userMigration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.verifyAuthChallengeResponse = software.amazon.jsii.Kernel.get(this, "verifyAuthChallengeResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.createAuthChallenge = builder.createAuthChallenge;
            this.customEmailSender = builder.customEmailSender;
            this.customMessage = builder.customMessage;
            this.customSmsSender = builder.customSmsSender;
            this.defineAuthChallenge = builder.defineAuthChallenge;
            this.postAuthentication = builder.postAuthentication;
            this.postConfirmation = builder.postConfirmation;
            this.preAuthentication = builder.preAuthentication;
            this.preSignUp = builder.preSignUp;
            this.preTokenGeneration = builder.preTokenGeneration;
            this.userMigration = builder.userMigration;
            this.verifyAuthChallengeResponse = builder.verifyAuthChallengeResponse;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getCreateAuthChallenge() {
            return this.createAuthChallenge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getCustomEmailSender() {
            return this.customEmailSender;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getCustomMessage() {
            return this.customMessage;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getCustomSmsSender() {
            return this.customSmsSender;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getDefineAuthChallenge() {
            return this.defineAuthChallenge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getPostAuthentication() {
            return this.postAuthentication;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getPostConfirmation() {
            return this.postConfirmation;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getPreAuthentication() {
            return this.preAuthentication;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getPreSignUp() {
            return this.preSignUp;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getPreTokenGeneration() {
            return this.preTokenGeneration;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getUserMigration() {
            return this.userMigration;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getVerifyAuthChallengeResponse() {
            return this.verifyAuthChallengeResponse;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCreateAuthChallenge() != null) {
                data.set("createAuthChallenge", om.valueToTree(this.getCreateAuthChallenge()));
            }
            if (this.getCustomEmailSender() != null) {
                data.set("customEmailSender", om.valueToTree(this.getCustomEmailSender()));
            }
            if (this.getCustomMessage() != null) {
                data.set("customMessage", om.valueToTree(this.getCustomMessage()));
            }
            if (this.getCustomSmsSender() != null) {
                data.set("customSmsSender", om.valueToTree(this.getCustomSmsSender()));
            }
            if (this.getDefineAuthChallenge() != null) {
                data.set("defineAuthChallenge", om.valueToTree(this.getDefineAuthChallenge()));
            }
            if (this.getPostAuthentication() != null) {
                data.set("postAuthentication", om.valueToTree(this.getPostAuthentication()));
            }
            if (this.getPostConfirmation() != null) {
                data.set("postConfirmation", om.valueToTree(this.getPostConfirmation()));
            }
            if (this.getPreAuthentication() != null) {
                data.set("preAuthentication", om.valueToTree(this.getPreAuthentication()));
            }
            if (this.getPreSignUp() != null) {
                data.set("preSignUp", om.valueToTree(this.getPreSignUp()));
            }
            if (this.getPreTokenGeneration() != null) {
                data.set("preTokenGeneration", om.valueToTree(this.getPreTokenGeneration()));
            }
            if (this.getUserMigration() != null) {
                data.set("userMigration", om.valueToTree(this.getUserMigration()));
            }
            if (this.getVerifyAuthChallengeResponse() != null) {
                data.set("verifyAuthChallengeResponse", om.valueToTree(this.getVerifyAuthChallengeResponse()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolTriggers"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolTriggers.Jsii$Proxy that = (UserPoolTriggers.Jsii$Proxy) o;

            if (this.createAuthChallenge != null ? !this.createAuthChallenge.equals(that.createAuthChallenge) : that.createAuthChallenge != null) return false;
            if (this.customEmailSender != null ? !this.customEmailSender.equals(that.customEmailSender) : that.customEmailSender != null) return false;
            if (this.customMessage != null ? !this.customMessage.equals(that.customMessage) : that.customMessage != null) return false;
            if (this.customSmsSender != null ? !this.customSmsSender.equals(that.customSmsSender) : that.customSmsSender != null) return false;
            if (this.defineAuthChallenge != null ? !this.defineAuthChallenge.equals(that.defineAuthChallenge) : that.defineAuthChallenge != null) return false;
            if (this.postAuthentication != null ? !this.postAuthentication.equals(that.postAuthentication) : that.postAuthentication != null) return false;
            if (this.postConfirmation != null ? !this.postConfirmation.equals(that.postConfirmation) : that.postConfirmation != null) return false;
            if (this.preAuthentication != null ? !this.preAuthentication.equals(that.preAuthentication) : that.preAuthentication != null) return false;
            if (this.preSignUp != null ? !this.preSignUp.equals(that.preSignUp) : that.preSignUp != null) return false;
            if (this.preTokenGeneration != null ? !this.preTokenGeneration.equals(that.preTokenGeneration) : that.preTokenGeneration != null) return false;
            if (this.userMigration != null ? !this.userMigration.equals(that.userMigration) : that.userMigration != null) return false;
            return this.verifyAuthChallengeResponse != null ? this.verifyAuthChallengeResponse.equals(that.verifyAuthChallengeResponse) : that.verifyAuthChallengeResponse == null;
        }

        @Override
        public final int hashCode() {
            int result = this.createAuthChallenge != null ? this.createAuthChallenge.hashCode() : 0;
            result = 31 * result + (this.customEmailSender != null ? this.customEmailSender.hashCode() : 0);
            result = 31 * result + (this.customMessage != null ? this.customMessage.hashCode() : 0);
            result = 31 * result + (this.customSmsSender != null ? this.customSmsSender.hashCode() : 0);
            result = 31 * result + (this.defineAuthChallenge != null ? this.defineAuthChallenge.hashCode() : 0);
            result = 31 * result + (this.postAuthentication != null ? this.postAuthentication.hashCode() : 0);
            result = 31 * result + (this.postConfirmation != null ? this.postConfirmation.hashCode() : 0);
            result = 31 * result + (this.preAuthentication != null ? this.preAuthentication.hashCode() : 0);
            result = 31 * result + (this.preSignUp != null ? this.preSignUp.hashCode() : 0);
            result = 31 * result + (this.preTokenGeneration != null ? this.preTokenGeneration.hashCode() : 0);
            result = 31 * result + (this.userMigration != null ? this.userMigration.hashCode() : 0);
            result = 31 * result + (this.verifyAuthChallengeResponse != null ? this.verifyAuthChallengeResponse.hashCode() : 0);
            return result;
        }
    }
}
