package software.amazon.awscdk.services.connect;

/**
 * Creates a new routing profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnRoutingProfile cfnRoutingProfile = CfnRoutingProfile.Builder.create(this, "MyCfnRoutingProfile")
 *         .defaultOutboundQueueArn("defaultOutboundQueueArn")
 *         .description("description")
 *         .instanceArn("instanceArn")
 *         .mediaConcurrencies(List.of(MediaConcurrencyProperty.builder()
 *                 .channel("channel")
 *                 .concurrency(123)
 *                 // the properties below are optional
 *                 .crossChannelBehavior(CrossChannelBehaviorProperty.builder()
 *                         .behaviorType("behaviorType")
 *                         .build())
 *                 .build()))
 *         .name("name")
 *         // the properties below are optional
 *         .agentAvailabilityTimer("agentAvailabilityTimer")
 *         .queueConfigs(List.of(RoutingProfileQueueConfigProperty.builder()
 *                 .delay(123)
 *                 .priority(123)
 *                 .queueReference(RoutingProfileQueueReferenceProperty.builder()
 *                         .channel("channel")
 *                         .queueArn("queueArn")
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:35.739Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRoutingProfile")
public class CfnRoutingProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnRoutingProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRoutingProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnRoutingProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRoutingProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnRoutingProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRoutingProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRoutingProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the default outbound queue for the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultOutboundQueueArn() {
        return software.amazon.jsii.Kernel.get(this, "defaultOutboundQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the default outbound queue for the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultOutboundQueueArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultOutboundQueueArn", java.util.Objects.requireNonNull(value, "defaultOutboundQueueArn is required"));
    }

    /**
     * The description of the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMediaConcurrencies() {
        return software.amazon.jsii.Kernel.get(this, "mediaConcurrencies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaConcurrencies(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mediaConcurrencies", java.util.Objects.requireNonNull(value, "mediaConcurrencies is required"));
    }

    /**
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMediaConcurrencies(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.connect.CfnRoutingProfile.MediaConcurrencyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.connect.CfnRoutingProfile.MediaConcurrencyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "mediaConcurrencies", java.util.Objects.requireNonNull(value, "mediaConcurrencies is required"));
    }

    /**
     * The name of the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Whether agents with this routing profile will have their routing order calculated based on <em>time since their last inbound contact</em> or <em>longest idle time</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAgentAvailabilityTimer() {
        return software.amazon.jsii.Kernel.get(this, "agentAvailabilityTimer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether agents with this routing profile will have their routing order calculated based on <em>time since their last inbound contact</em> or <em>longest idle time</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentAvailabilityTimer(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentAvailabilityTimer", value);
    }

    /**
     * The inbound queues associated with the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQueueConfigs() {
        return software.amazon.jsii.Kernel.get(this, "queueConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The inbound queues associated with the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueueConfigs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "queueConfigs", value);
    }

    /**
     * The inbound queues associated with the routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueueConfigs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.connect.CfnRoutingProfile.RoutingProfileQueueConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.connect.CfnRoutingProfile.RoutingProfileQueueConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "queueConfigs", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Defines the cross-channel routing behavior that allows an agent working on a contact in one channel to be offered a contact from a different channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * CrossChannelBehaviorProperty crossChannelBehaviorProperty = CrossChannelBehaviorProperty.builder()
     *         .behaviorType("behaviorType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-crosschannelbehavior.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-crosschannelbehavior.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRoutingProfile.CrossChannelBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossChannelBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossChannelBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the other channels that can be routed to an agent handling their current channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-crosschannelbehavior.html#cfn-connect-routingprofile-crosschannelbehavior-behaviortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-crosschannelbehavior.html#cfn-connect-routingprofile-crosschannelbehavior-behaviortype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBehaviorType();

        /**
         * @return a {@link Builder} of {@link CrossChannelBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossChannelBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossChannelBehaviorProperty> {
            java.lang.String behaviorType;

            /**
             * Sets the value of {@link CrossChannelBehaviorProperty#getBehaviorType}
             * @param behaviorType Specifies the other channels that can be routed to an agent handling their current channel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behaviorType(java.lang.String behaviorType) {
                this.behaviorType = behaviorType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossChannelBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossChannelBehaviorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossChannelBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossChannelBehaviorProperty {
            private final java.lang.String behaviorType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behaviorType = software.amazon.jsii.Kernel.get(this, "behaviorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behaviorType = java.util.Objects.requireNonNull(builder.behaviorType, "behaviorType is required");
            }

            @Override
            public final java.lang.String getBehaviorType() {
                return this.behaviorType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("behaviorType", om.valueToTree(this.getBehaviorType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnRoutingProfile.CrossChannelBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossChannelBehaviorProperty.Jsii$Proxy that = (CrossChannelBehaviorProperty.Jsii$Proxy) o;

                return this.behaviorType.equals(that.behaviorType);
            }

            @Override
            public final int hashCode() {
                int result = this.behaviorType.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about which channels are supported, and how many contacts an agent can have on a channel simultaneously.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * MediaConcurrencyProperty mediaConcurrencyProperty = MediaConcurrencyProperty.builder()
     *         .channel("channel")
     *         .concurrency(123)
     *         // the properties below are optional
     *         .crossChannelBehavior(CrossChannelBehaviorProperty.builder()
     *                 .behaviorType("behaviorType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRoutingProfile.MediaConcurrencyProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaConcurrencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaConcurrencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The channels that agents can handle in the Contact Control Panel (CCP).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html#cfn-connect-routingprofile-mediaconcurrency-channel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html#cfn-connect-routingprofile-mediaconcurrency-channel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChannel();

        /**
         * The number of contacts an agent can have on a channel simultaneously.
         * <p>
         * Valid Range for <code>VOICE</code> : Minimum value of 1. Maximum value of 1.
         * <p>
         * Valid Range for <code>CHAT</code> : Minimum value of 1. Maximum value of 10.
         * <p>
         * Valid Range for <code>TASK</code> : Minimum value of 1. Maximum value of 10.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html#cfn-connect-routingprofile-mediaconcurrency-concurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html#cfn-connect-routingprofile-mediaconcurrency-concurrency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getConcurrency();

        /**
         * Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile.
         * <p>
         * For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html#cfn-connect-routingprofile-mediaconcurrency-crosschannelbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-mediaconcurrency.html#cfn-connect-routingprofile-mediaconcurrency-crosschannelbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrossChannelBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaConcurrencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaConcurrencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaConcurrencyProperty> {
            java.lang.String channel;
            java.lang.Number concurrency;
            java.lang.Object crossChannelBehavior;

            /**
             * Sets the value of {@link MediaConcurrencyProperty#getChannel}
             * @param channel The channels that agents can handle in the Contact Control Panel (CCP). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channel(java.lang.String channel) {
                this.channel = channel;
                return this;
            }

            /**
             * Sets the value of {@link MediaConcurrencyProperty#getConcurrency}
             * @param concurrency The number of contacts an agent can have on a channel simultaneously. This parameter is required.
             *                    Valid Range for <code>VOICE</code> : Minimum value of 1. Maximum value of 1.
             *                    <p>
             *                    Valid Range for <code>CHAT</code> : Minimum value of 1. Maximum value of 10.
             *                    <p>
             *                    Valid Range for <code>TASK</code> : Minimum value of 1. Maximum value of 10.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder concurrency(java.lang.Number concurrency) {
                this.concurrency = concurrency;
                return this;
            }

            /**
             * Sets the value of {@link MediaConcurrencyProperty#getCrossChannelBehavior}
             * @param crossChannelBehavior Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile.
             *                             For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossChannelBehavior(software.amazon.awscdk.IResolvable crossChannelBehavior) {
                this.crossChannelBehavior = crossChannelBehavior;
                return this;
            }

            /**
             * Sets the value of {@link MediaConcurrencyProperty#getCrossChannelBehavior}
             * @param crossChannelBehavior Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile.
             *                             For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossChannelBehavior(software.amazon.awscdk.services.connect.CfnRoutingProfile.CrossChannelBehaviorProperty crossChannelBehavior) {
                this.crossChannelBehavior = crossChannelBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaConcurrencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaConcurrencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaConcurrencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaConcurrencyProperty {
            private final java.lang.String channel;
            private final java.lang.Number concurrency;
            private final java.lang.Object crossChannelBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channel = software.amazon.jsii.Kernel.get(this, "channel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.concurrency = software.amazon.jsii.Kernel.get(this, "concurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.crossChannelBehavior = software.amazon.jsii.Kernel.get(this, "crossChannelBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channel = java.util.Objects.requireNonNull(builder.channel, "channel is required");
                this.concurrency = java.util.Objects.requireNonNull(builder.concurrency, "concurrency is required");
                this.crossChannelBehavior = builder.crossChannelBehavior;
            }

            @Override
            public final java.lang.String getChannel() {
                return this.channel;
            }

            @Override
            public final java.lang.Number getConcurrency() {
                return this.concurrency;
            }

            @Override
            public final java.lang.Object getCrossChannelBehavior() {
                return this.crossChannelBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("channel", om.valueToTree(this.getChannel()));
                data.set("concurrency", om.valueToTree(this.getConcurrency()));
                if (this.getCrossChannelBehavior() != null) {
                    data.set("crossChannelBehavior", om.valueToTree(this.getCrossChannelBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnRoutingProfile.MediaConcurrencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaConcurrencyProperty.Jsii$Proxy that = (MediaConcurrencyProperty.Jsii$Proxy) o;

                if (!channel.equals(that.channel)) return false;
                if (!concurrency.equals(that.concurrency)) return false;
                return this.crossChannelBehavior != null ? this.crossChannelBehavior.equals(that.crossChannelBehavior) : that.crossChannelBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channel.hashCode();
                result = 31 * result + (this.concurrency.hashCode());
                result = 31 * result + (this.crossChannelBehavior != null ? this.crossChannelBehavior.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the queue and channel for which priority and delay can be set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * RoutingProfileQueueConfigProperty routingProfileQueueConfigProperty = RoutingProfileQueueConfigProperty.builder()
     *         .delay(123)
     *         .priority(123)
     *         .queueReference(RoutingProfileQueueReferenceProperty.builder()
     *                 .channel("channel")
     *                 .queueArn("queueArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRoutingProfile.RoutingProfileQueueConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingProfileQueueConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingProfileQueueConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The delay, in seconds, a contact should be in the queue before they are routed to an available agent.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> in the <em>Amazon Connect Administrator Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html#cfn-connect-routingprofile-routingprofilequeueconfig-delay">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html#cfn-connect-routingprofile-routingprofilequeueconfig-delay</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDelay();

        /**
         * The order in which contacts are to be handled for the queue.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html#cfn-connect-routingprofile-routingprofilequeueconfig-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html#cfn-connect-routingprofile-routingprofilequeueconfig-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * Contains information about a queue resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html#cfn-connect-routingprofile-routingprofilequeueconfig-queuereference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeueconfig.html#cfn-connect-routingprofile-routingprofilequeueconfig-queuereference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueueReference();

        /**
         * @return a {@link Builder} of {@link RoutingProfileQueueConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingProfileQueueConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingProfileQueueConfigProperty> {
            java.lang.Number delay;
            java.lang.Number priority;
            java.lang.Object queueReference;

            /**
             * Sets the value of {@link RoutingProfileQueueConfigProperty#getDelay}
             * @param delay The delay, in seconds, a contact should be in the queue before they are routed to an available agent. This parameter is required.
             *              For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> in the <em>Amazon Connect Administrator Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delay(java.lang.Number delay) {
                this.delay = delay;
                return this;
            }

            /**
             * Sets the value of {@link RoutingProfileQueueConfigProperty#getPriority}
             * @param priority The order in which contacts are to be handled for the queue. This parameter is required.
             *                 For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link RoutingProfileQueueConfigProperty#getQueueReference}
             * @param queueReference Contains information about a queue resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueReference(software.amazon.awscdk.IResolvable queueReference) {
                this.queueReference = queueReference;
                return this;
            }

            /**
             * Sets the value of {@link RoutingProfileQueueConfigProperty#getQueueReference}
             * @param queueReference Contains information about a queue resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueReference(software.amazon.awscdk.services.connect.CfnRoutingProfile.RoutingProfileQueueReferenceProperty queueReference) {
                this.queueReference = queueReference;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingProfileQueueConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingProfileQueueConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoutingProfileQueueConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingProfileQueueConfigProperty {
            private final java.lang.Number delay;
            private final java.lang.Number priority;
            private final java.lang.Object queueReference;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delay = software.amazon.jsii.Kernel.get(this, "delay", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.queueReference = software.amazon.jsii.Kernel.get(this, "queueReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delay = java.util.Objects.requireNonNull(builder.delay, "delay is required");
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.queueReference = java.util.Objects.requireNonNull(builder.queueReference, "queueReference is required");
            }

            @Override
            public final java.lang.Number getDelay() {
                return this.delay;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Object getQueueReference() {
                return this.queueReference;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("delay", om.valueToTree(this.getDelay()));
                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("queueReference", om.valueToTree(this.getQueueReference()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnRoutingProfile.RoutingProfileQueueConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingProfileQueueConfigProperty.Jsii$Proxy that = (RoutingProfileQueueConfigProperty.Jsii$Proxy) o;

                if (!delay.equals(that.delay)) return false;
                if (!priority.equals(that.priority)) return false;
                return this.queueReference.equals(that.queueReference);
            }

            @Override
            public final int hashCode() {
                int result = this.delay.hashCode();
                result = 31 * result + (this.priority.hashCode());
                result = 31 * result + (this.queueReference.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains the channel and queue identifier for a routing profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * RoutingProfileQueueReferenceProperty routingProfileQueueReferenceProperty = RoutingProfileQueueReferenceProperty.builder()
     *         .channel("channel")
     *         .queueArn("queueArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeuereference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeuereference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnRoutingProfile.RoutingProfileQueueReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingProfileQueueReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingProfileQueueReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeuereference.html#cfn-connect-routingprofile-routingprofilequeuereference-channel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeuereference.html#cfn-connect-routingprofile-routingprofilequeuereference-channel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChannel();

        /**
         * The Amazon Resource Name (ARN) of the queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeuereference.html#cfn-connect-routingprofile-routingprofilequeuereference-queuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-routingprofile-routingprofilequeuereference.html#cfn-connect-routingprofile-routingprofilequeuereference-queuearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueArn();

        /**
         * @return a {@link Builder} of {@link RoutingProfileQueueReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingProfileQueueReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingProfileQueueReferenceProperty> {
            java.lang.String channel;
            java.lang.String queueArn;

            /**
             * Sets the value of {@link RoutingProfileQueueReferenceProperty#getChannel}
             * @param channel The channels agents can handle in the Contact Control Panel (CCP) for this routing profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channel(java.lang.String channel) {
                this.channel = channel;
                return this;
            }

            /**
             * Sets the value of {@link RoutingProfileQueueReferenceProperty#getQueueArn}
             * @param queueArn The Amazon Resource Name (ARN) of the queue. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueArn(java.lang.String queueArn) {
                this.queueArn = queueArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingProfileQueueReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingProfileQueueReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoutingProfileQueueReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingProfileQueueReferenceProperty {
            private final java.lang.String channel;
            private final java.lang.String queueArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channel = software.amazon.jsii.Kernel.get(this, "channel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queueArn = software.amazon.jsii.Kernel.get(this, "queueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channel = java.util.Objects.requireNonNull(builder.channel, "channel is required");
                this.queueArn = java.util.Objects.requireNonNull(builder.queueArn, "queueArn is required");
            }

            @Override
            public final java.lang.String getChannel() {
                return this.channel;
            }

            @Override
            public final java.lang.String getQueueArn() {
                return this.queueArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("channel", om.valueToTree(this.getChannel()));
                data.set("queueArn", om.valueToTree(this.getQueueArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnRoutingProfile.RoutingProfileQueueReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingProfileQueueReferenceProperty.Jsii$Proxy that = (RoutingProfileQueueReferenceProperty.Jsii$Proxy) o;

                if (!channel.equals(that.channel)) return false;
                return this.queueArn.equals(that.queueArn);
            }

            @Override
            public final int hashCode() {
                int result = this.channel.hashCode();
                result = 31 * result + (this.queueArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnRoutingProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnRoutingProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnRoutingProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnRoutingProfileProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the default outbound queue for the routing profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-defaultoutboundqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-defaultoutboundqueuearn</a>
         * @param defaultOutboundQueueArn The Amazon Resource Name (ARN) of the default outbound queue for the routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultOutboundQueueArn(final java.lang.String defaultOutboundQueueArn) {
            this.props.defaultOutboundQueueArn(defaultOutboundQueueArn);
            return this;
        }

        /**
         * The description of the routing profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-description</a>
         * @param description The description of the routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-instancearn</a>
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-mediaconcurrencies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-mediaconcurrencies</a>
         * @param mediaConcurrencies The channels agents can handle in the Contact Control Panel (CCP) for this routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaConcurrencies(final software.amazon.awscdk.IResolvable mediaConcurrencies) {
            this.props.mediaConcurrencies(mediaConcurrencies);
            return this;
        }
        /**
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-mediaconcurrencies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-mediaconcurrencies</a>
         * @param mediaConcurrencies The channels agents can handle in the Contact Control Panel (CCP) for this routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaConcurrencies(final java.util.List<? extends java.lang.Object> mediaConcurrencies) {
            this.props.mediaConcurrencies(mediaConcurrencies);
            return this;
        }

        /**
         * The name of the routing profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-name</a>
         * @param name The name of the routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Whether agents with this routing profile will have their routing order calculated based on <em>time since their last inbound contact</em> or <em>longest idle time</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-agentavailabilitytimer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-agentavailabilitytimer</a>
         * @param agentAvailabilityTimer Whether agents with this routing profile will have their routing order calculated based on <em>time since their last inbound contact</em> or <em>longest idle time</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentAvailabilityTimer(final java.lang.String agentAvailabilityTimer) {
            this.props.agentAvailabilityTimer(agentAvailabilityTimer);
            return this;
        }

        /**
         * The inbound queues associated with the routing profile.
         * <p>
         * If no queue is added, the agent can make only outbound calls.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-queueconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-queueconfigs</a>
         * @param queueConfigs The inbound queues associated with the routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueConfigs(final software.amazon.awscdk.IResolvable queueConfigs) {
            this.props.queueConfigs(queueConfigs);
            return this;
        }
        /**
         * The inbound queues associated with the routing profile.
         * <p>
         * If no queue is added, the agent can make only outbound calls.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-queueconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-queueconfigs</a>
         * @param queueConfigs The inbound queues associated with the routing profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueConfigs(final java.util.List<? extends java.lang.Object> queueConfigs) {
            this.props.queueConfigs(queueConfigs);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-routingprofile.html#cfn-connect-routingprofile-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connect.CfnRoutingProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnRoutingProfile build() {
            return new software.amazon.awscdk.services.connect.CfnRoutingProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
