package software.amazon.awscdk.services.deadline;

/**
 * Creates a queue to coordinate the order in which jobs run on a farm.
 * <p>
 * A queue can also specify where to pull resources and indicate where to output completed jobs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnQueue cfnQueue = CfnQueue.Builder.create(this, "MyCfnQueue")
 *         .displayName("displayName")
 *         .farmId("farmId")
 *         // the properties below are optional
 *         .allowedStorageProfileIds(List.of("allowedStorageProfileIds"))
 *         .defaultBudgetAction("defaultBudgetAction")
 *         .description("description")
 *         .jobAttachmentSettings(JobAttachmentSettingsProperty.builder()
 *                 .rootPrefix("rootPrefix")
 *                 .s3BucketName("s3BucketName")
 *                 .build())
 *         .jobRunAsUser(JobRunAsUserProperty.builder()
 *                 .runAs("runAs")
 *                 // the properties below are optional
 *                 .posix(PosixUserProperty.builder()
 *                         .group("group")
 *                         .user("user")
 *                         .build())
 *                 .windows(WindowsUserProperty.builder()
 *                         .passwordArn("passwordArn")
 *                         .user("user")
 *                         .build())
 *                 .build())
 *         .requiredFileSystemLocationNames(List.of("requiredFileSystemLocationNames"))
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:36.149Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnQueue")
public class CfnQueue extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.deadline.CfnQueue.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnQueue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.deadline.CfnQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The queue ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrQueueId() {
        return software.amazon.jsii.Kernel.get(this, "attrQueueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The display name of the queue summary to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name of the queue summary to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * The farm ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFarmId() {
        return software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The farm ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFarmId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "farmId", java.util.Objects.requireNonNull(value, "farmId is required"));
    }

    /**
     * The identifiers of the storage profiles that this queue can use to share assets between workers using different operating systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedStorageProfileIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedStorageProfileIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The identifiers of the storage profiles that this queue can use to share assets between workers using different operating systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedStorageProfileIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedStorageProfileIds", value);
    }

    /**
     * The default action taken on a queue summary if a budget wasn't configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultBudgetAction() {
        return software.amazon.jsii.Kernel.get(this, "defaultBudgetAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default action taken on a queue summary if a budget wasn't configured.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultBudgetAction(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultBudgetAction", value);
    }

    /**
     * A description of the queue that helps identify what the queue is used for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the queue that helps identify what the queue is used for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The job attachment settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJobAttachmentSettings() {
        return software.amazon.jsii.Kernel.get(this, "jobAttachmentSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The job attachment settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobAttachmentSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobAttachmentSettings", value);
    }

    /**
     * The job attachment settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobAttachmentSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.deadline.CfnQueue.JobAttachmentSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobAttachmentSettings", value);
    }

    /**
     * Identifies the user for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJobRunAsUser() {
        return software.amazon.jsii.Kernel.get(this, "jobRunAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Identifies the user for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobRunAsUser(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobRunAsUser", value);
    }

    /**
     * Identifies the user for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobRunAsUser(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.deadline.CfnQueue.JobRunAsUserProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobRunAsUser", value);
    }

    /**
     * The file system location that the queue uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequiredFileSystemLocationNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "requiredFileSystemLocationNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The file system location that the queue uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequiredFileSystemLocationNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "requiredFileSystemLocationNames", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that workers use when running jobs in this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that workers use when running jobs in this queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * The tags to add to your queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to add to your queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The job attachment settings.
     * <p>
     * These are the Amazon S3 bucket name and the Amazon S3 prefix.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * JobAttachmentSettingsProperty jobAttachmentSettingsProperty = JobAttachmentSettingsProperty.builder()
     *         .rootPrefix("rootPrefix")
     *         .s3BucketName("s3BucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobattachmentsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobattachmentsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnQueue.JobAttachmentSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(JobAttachmentSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobAttachmentSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The root prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobattachmentsettings.html#cfn-deadline-queue-jobattachmentsettings-rootprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobattachmentsettings.html#cfn-deadline-queue-jobattachmentsettings-rootprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRootPrefix();

        /**
         * The Amazon S3 bucket name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobattachmentsettings.html#cfn-deadline-queue-jobattachmentsettings-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobattachmentsettings.html#cfn-deadline-queue-jobattachmentsettings-s3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

        /**
         * @return a {@link Builder} of {@link JobAttachmentSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobAttachmentSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobAttachmentSettingsProperty> {
            java.lang.String rootPrefix;
            java.lang.String s3BucketName;

            /**
             * Sets the value of {@link JobAttachmentSettingsProperty#getRootPrefix}
             * @param rootPrefix The root prefix. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootPrefix(java.lang.String rootPrefix) {
                this.rootPrefix = rootPrefix;
                return this;
            }

            /**
             * Sets the value of {@link JobAttachmentSettingsProperty#getS3BucketName}
             * @param s3BucketName The Amazon S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobAttachmentSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobAttachmentSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobAttachmentSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobAttachmentSettingsProperty {
            private final java.lang.String rootPrefix;
            private final java.lang.String s3BucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rootPrefix = software.amazon.jsii.Kernel.get(this, "rootPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rootPrefix = java.util.Objects.requireNonNull(builder.rootPrefix, "rootPrefix is required");
                this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
            }

            @Override
            public final java.lang.String getRootPrefix() {
                return this.rootPrefix;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rootPrefix", om.valueToTree(this.getRootPrefix()));
                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnQueue.JobAttachmentSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobAttachmentSettingsProperty.Jsii$Proxy that = (JobAttachmentSettingsProperty.Jsii$Proxy) o;

                if (!rootPrefix.equals(that.rootPrefix)) return false;
                return this.s3BucketName.equals(that.s3BucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.rootPrefix.hashCode();
                result = 31 * result + (this.s3BucketName.hashCode());
                return result;
            }
        }
    }
    /**
     * Identifies the user for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * JobRunAsUserProperty jobRunAsUserProperty = JobRunAsUserProperty.builder()
     *         .runAs("runAs")
     *         // the properties below are optional
     *         .posix(PosixUserProperty.builder()
     *                 .group("group")
     *                 .user("user")
     *                 .build())
     *         .windows(WindowsUserProperty.builder()
     *                 .passwordArn("passwordArn")
     *                 .user("user")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnQueue.JobRunAsUserProperty")
    @software.amazon.jsii.Jsii.Proxy(JobRunAsUserProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobRunAsUserProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the job should run using the queue's system user or if the job should run using the worker agent system user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html#cfn-deadline-queue-jobrunasuser-runas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html#cfn-deadline-queue-jobrunasuser-runas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRunAs();

        /**
         * The user and group that the jobs in the queue run as.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html#cfn-deadline-queue-jobrunasuser-posix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html#cfn-deadline-queue-jobrunasuser-posix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPosix() {
            return null;
        }

        /**
         * Identifies a Microsoft Windows user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html#cfn-deadline-queue-jobrunasuser-windows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-jobrunasuser.html#cfn-deadline-queue-jobrunasuser-windows</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWindows() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobRunAsUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobRunAsUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobRunAsUserProperty> {
            java.lang.String runAs;
            java.lang.Object posix;
            java.lang.Object windows;

            /**
             * Sets the value of {@link JobRunAsUserProperty#getRunAs}
             * @param runAs Specifies whether the job should run using the queue's system user or if the job should run using the worker agent system user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAs(java.lang.String runAs) {
                this.runAs = runAs;
                return this;
            }

            /**
             * Sets the value of {@link JobRunAsUserProperty#getPosix}
             * @param posix The user and group that the jobs in the queue run as.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder posix(software.amazon.awscdk.IResolvable posix) {
                this.posix = posix;
                return this;
            }

            /**
             * Sets the value of {@link JobRunAsUserProperty#getPosix}
             * @param posix The user and group that the jobs in the queue run as.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder posix(software.amazon.awscdk.services.deadline.CfnQueue.PosixUserProperty posix) {
                this.posix = posix;
                return this;
            }

            /**
             * Sets the value of {@link JobRunAsUserProperty#getWindows}
             * @param windows Identifies a Microsoft Windows user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windows(software.amazon.awscdk.IResolvable windows) {
                this.windows = windows;
                return this;
            }

            /**
             * Sets the value of {@link JobRunAsUserProperty#getWindows}
             * @param windows Identifies a Microsoft Windows user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windows(software.amazon.awscdk.services.deadline.CfnQueue.WindowsUserProperty windows) {
                this.windows = windows;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobRunAsUserProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobRunAsUserProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobRunAsUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobRunAsUserProperty {
            private final java.lang.String runAs;
            private final java.lang.Object posix;
            private final java.lang.Object windows;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.runAs = software.amazon.jsii.Kernel.get(this, "runAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.posix = software.amazon.jsii.Kernel.get(this, "posix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.windows = software.amazon.jsii.Kernel.get(this, "windows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.runAs = java.util.Objects.requireNonNull(builder.runAs, "runAs is required");
                this.posix = builder.posix;
                this.windows = builder.windows;
            }

            @Override
            public final java.lang.String getRunAs() {
                return this.runAs;
            }

            @Override
            public final java.lang.Object getPosix() {
                return this.posix;
            }

            @Override
            public final java.lang.Object getWindows() {
                return this.windows;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("runAs", om.valueToTree(this.getRunAs()));
                if (this.getPosix() != null) {
                    data.set("posix", om.valueToTree(this.getPosix()));
                }
                if (this.getWindows() != null) {
                    data.set("windows", om.valueToTree(this.getWindows()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnQueue.JobRunAsUserProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobRunAsUserProperty.Jsii$Proxy that = (JobRunAsUserProperty.Jsii$Proxy) o;

                if (!runAs.equals(that.runAs)) return false;
                if (this.posix != null ? !this.posix.equals(that.posix) : that.posix != null) return false;
                return this.windows != null ? this.windows.equals(that.windows) : that.windows == null;
            }

            @Override
            public final int hashCode() {
                int result = this.runAs.hashCode();
                result = 31 * result + (this.posix != null ? this.posix.hashCode() : 0);
                result = 31 * result + (this.windows != null ? this.windows.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The POSIX user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * PosixUserProperty posixUserProperty = PosixUserProperty.builder()
     *         .group("group")
     *         .user("user")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-posixuser.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-posixuser.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnQueue.PosixUserProperty")
    @software.amazon.jsii.Jsii.Proxy(PosixUserProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PosixUserProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the POSIX user's group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-posixuser.html#cfn-deadline-queue-posixuser-group">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-posixuser.html#cfn-deadline-queue-posixuser-group</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroup();

        /**
         * The name of the POSIX user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-posixuser.html#cfn-deadline-queue-posixuser-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-posixuser.html#cfn-deadline-queue-posixuser-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUser();

        /**
         * @return a {@link Builder} of {@link PosixUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PosixUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PosixUserProperty> {
            java.lang.String group;
            java.lang.String user;

            /**
             * Sets the value of {@link PosixUserProperty#getGroup}
             * @param group The name of the POSIX user's group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder group(java.lang.String group) {
                this.group = group;
                return this;
            }

            /**
             * Sets the value of {@link PosixUserProperty#getUser}
             * @param user The name of the POSIX user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PosixUserProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PosixUserProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PosixUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PosixUserProperty {
            private final java.lang.String group;
            private final java.lang.String user;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.group = java.util.Objects.requireNonNull(builder.group, "group is required");
                this.user = java.util.Objects.requireNonNull(builder.user, "user is required");
            }

            @Override
            public final java.lang.String getGroup() {
                return this.group;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("group", om.valueToTree(this.getGroup()));
                data.set("user", om.valueToTree(this.getUser()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnQueue.PosixUserProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PosixUserProperty.Jsii$Proxy that = (PosixUserProperty.Jsii$Proxy) o;

                if (!group.equals(that.group)) return false;
                return this.user.equals(that.user);
            }

            @Override
            public final int hashCode() {
                int result = this.group.hashCode();
                result = 31 * result + (this.user.hashCode());
                return result;
            }
        }
    }
    /**
     * The Windows user details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.deadline.*;
     * WindowsUserProperty windowsUserProperty = WindowsUserProperty.builder()
     *         .passwordArn("passwordArn")
     *         .user("user")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-windowsuser.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-windowsuser.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnQueue.WindowsUserProperty")
    @software.amazon.jsii.Jsii.Proxy(WindowsUserProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WindowsUserProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password ARN for the Windows user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-windowsuser.html#cfn-deadline-queue-windowsuser-passwordarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-windowsuser.html#cfn-deadline-queue-windowsuser-passwordarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPasswordArn();

        /**
         * The user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-windowsuser.html#cfn-deadline-queue-windowsuser-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-deadline-queue-windowsuser.html#cfn-deadline-queue-windowsuser-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUser();

        /**
         * @return a {@link Builder} of {@link WindowsUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WindowsUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WindowsUserProperty> {
            java.lang.String passwordArn;
            java.lang.String user;

            /**
             * Sets the value of {@link WindowsUserProperty#getPasswordArn}
             * @param passwordArn The password ARN for the Windows user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordArn(java.lang.String passwordArn) {
                this.passwordArn = passwordArn;
                return this;
            }

            /**
             * Sets the value of {@link WindowsUserProperty#getUser}
             * @param user The user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WindowsUserProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WindowsUserProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WindowsUserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowsUserProperty {
            private final java.lang.String passwordArn;
            private final java.lang.String user;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.passwordArn = software.amazon.jsii.Kernel.get(this, "passwordArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.passwordArn = java.util.Objects.requireNonNull(builder.passwordArn, "passwordArn is required");
                this.user = java.util.Objects.requireNonNull(builder.user, "user is required");
            }

            @Override
            public final java.lang.String getPasswordArn() {
                return this.passwordArn;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("passwordArn", om.valueToTree(this.getPasswordArn()));
                data.set("user", om.valueToTree(this.getUser()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnQueue.WindowsUserProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WindowsUserProperty.Jsii$Proxy that = (WindowsUserProperty.Jsii$Proxy) o;

                if (!passwordArn.equals(that.passwordArn)) return false;
                return this.user.equals(that.user);
            }

            @Override
            public final int hashCode() {
                int result = this.passwordArn.hashCode();
                result = 31 * result + (this.user.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.deadline.CfnQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.deadline.CfnQueue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.deadline.CfnQueueProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.deadline.CfnQueueProps.Builder();
        }

        /**
         * The display name of the queue summary to update.
         * <p>
         * <blockquote>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-displayname</a>
         * @param displayName The display name of the queue summary to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The farm ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-farmid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-farmid</a>
         * @param farmId The farm ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(final java.lang.String farmId) {
            this.props.farmId(farmId);
            return this;
        }

        /**
         * The identifiers of the storage profiles that this queue can use to share assets between workers using different operating systems.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-allowedstorageprofileids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-allowedstorageprofileids</a>
         * @param allowedStorageProfileIds The identifiers of the storage profiles that this queue can use to share assets between workers using different operating systems. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedStorageProfileIds(final java.util.List<java.lang.String> allowedStorageProfileIds) {
            this.props.allowedStorageProfileIds(allowedStorageProfileIds);
            return this;
        }

        /**
         * The default action taken on a queue summary if a budget wasn't configured.
         * <p>
         * Default: - "NONE"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-defaultbudgetaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-defaultbudgetaction</a>
         * @param defaultBudgetAction The default action taken on a queue summary if a budget wasn't configured. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBudgetAction(final java.lang.String defaultBudgetAction) {
            this.props.defaultBudgetAction(defaultBudgetAction);
            return this;
        }

        /**
         * A description of the queue that helps identify what the queue is used for.
         * <p>
         * <blockquote>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         * <p>
         * </blockquote>
         * <p>
         * Default: - ""
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-description</a>
         * @param description A description of the queue that helps identify what the queue is used for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The job attachment settings.
         * <p>
         * These are the Amazon S3 bucket name and the Amazon S3 prefix.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobattachmentsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobattachmentsettings</a>
         * @param jobAttachmentSettings The job attachment settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobAttachmentSettings(final software.amazon.awscdk.IResolvable jobAttachmentSettings) {
            this.props.jobAttachmentSettings(jobAttachmentSettings);
            return this;
        }
        /**
         * The job attachment settings.
         * <p>
         * These are the Amazon S3 bucket name and the Amazon S3 prefix.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobattachmentsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobattachmentsettings</a>
         * @param jobAttachmentSettings The job attachment settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobAttachmentSettings(final software.amazon.awscdk.services.deadline.CfnQueue.JobAttachmentSettingsProperty jobAttachmentSettings) {
            this.props.jobAttachmentSettings(jobAttachmentSettings);
            return this;
        }

        /**
         * Identifies the user for a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobrunasuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobrunasuser</a>
         * @param jobRunAsUser Identifies the user for a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRunAsUser(final software.amazon.awscdk.IResolvable jobRunAsUser) {
            this.props.jobRunAsUser(jobRunAsUser);
            return this;
        }
        /**
         * Identifies the user for a job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobrunasuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-jobrunasuser</a>
         * @param jobRunAsUser Identifies the user for a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobRunAsUser(final software.amazon.awscdk.services.deadline.CfnQueue.JobRunAsUserProperty jobRunAsUser) {
            this.props.jobRunAsUser(jobRunAsUser);
            return this;
        }

        /**
         * The file system location that the queue uses.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-requiredfilesystemlocationnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-requiredfilesystemlocationnames</a>
         * @param requiredFileSystemLocationNames The file system location that the queue uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiredFileSystemLocationNames(final java.util.List<java.lang.String> requiredFileSystemLocationNames) {
            this.props.requiredFileSystemLocationNames(requiredFileSystemLocationNames);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that workers use when running jobs in this queue.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that workers use when running jobs in this queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The tags to add to your queue.
         * <p>
         * Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-queue.html#cfn-deadline-queue-tags</a>
         * @param tags The tags to add to your queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.deadline.CfnQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.deadline.CfnQueue build() {
            return new software.amazon.awscdk.services.deadline.CfnQueue(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
