package software.amazon.awscdk.services.docdb;

/**
 * Options to add the multi user rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Secret myImportedSecret;
 * DatabaseCluster cluster;
 * cluster.addRotationMultiUser("MyUser", RotationMultiUserOptions.builder()
 *         .secret(myImportedSecret)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:36.399Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.RotationMultiUserOptions")
@software.amazon.jsii.Jsii.Proxy(RotationMultiUserOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RotationMultiUserOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The secret to rotate.
     * <p>
     * It must be a JSON string with the following format:
     * <p>
     * <blockquote><pre>
     * {
     *   "engine": &lt;required: must be set to 'mongo'&gt;,
     *   "host": &lt;required: instance host name&gt;,
     *   "username": &lt;required: username&gt;,
     *   "password": &lt;required: password&gt;,
     *   "dbname": &lt;optional: database name&gt;,
     *   "port": &lt;optional: if not specified, default port 27017 will be used&gt;,
     *   "masterarn": &lt;required: the arn of the master secret which will be used to create users/change passwords&gt;
     *   "ssl": &lt;optional: if not specified, defaults to false. This must be true if being used for DocumentDB rotations
     *          where the cluster has TLS enabled&gt;
     * }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     * <p>
     * Default: Duration.days(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutomaticallyAfter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RotationMultiUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RotationMultiUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RotationMultiUserOptions> {
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        software.amazon.awscdk.Duration automaticallyAfter;

        /**
         * Sets the value of {@link RotationMultiUserOptions#getSecret}
         * @param secret The secret to rotate. This parameter is required.
         *               It must be a JSON string with the following format:
         *               <p>
         *               <blockquote><pre>
         *               {
         *                 "engine": &lt;required: must be set to 'mongo'&gt;,
         *                 "host": &lt;required: instance host name&gt;,
         *                 "username": &lt;required: username&gt;,
         *                 "password": &lt;required: password&gt;,
         *                 "dbname": &lt;optional: database name&gt;,
         *                 "port": &lt;optional: if not specified, default port 27017 will be used&gt;,
         *                 "masterarn": &lt;required: the arn of the master secret which will be used to create users/change passwords&gt;
         *                 "ssl": &lt;optional: if not specified, defaults to false. This must be true if being used for DocumentDB rotations
         *                        where the cluster has TLS enabled&gt;
         *               }
         *               </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link RotationMultiUserOptions#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RotationMultiUserOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RotationMultiUserOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RotationMultiUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationMultiUserOptions {
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final software.amazon.awscdk.Duration automaticallyAfter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.automaticallyAfter = software.amazon.jsii.Kernel.get(this, "automaticallyAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secret = java.util.Objects.requireNonNull(builder.secret, "secret is required");
            this.automaticallyAfter = builder.automaticallyAfter;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secret", om.valueToTree(this.getSecret()));
            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.RotationMultiUserOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RotationMultiUserOptions.Jsii$Proxy that = (RotationMultiUserOptions.Jsii$Proxy) o;

            if (!secret.equals(that.secret)) return false;
            return this.automaticallyAfter != null ? this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.secret.hashCode();
            result = 31 * result + (this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0);
            return result;
        }
    }
}
