package software.amazon.awscdk.services.dynamodb;

/**
 * Represents how capacity is managed and how you are charged for read and write throughput for a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .billing(Billing.provisioned(ThroughputProps.builder()
 *                 .readCapacity(Capacity.fixed(10))
 *                 .writeCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(15).build()))
 *                 .build()))
 *         .replicas(List.of(ReplicaTableProps.builder()
 *                 .region("us-east-1")
 *                 .build(), ReplicaTableProps.builder()
 *                 .region("us-east-2")
 *                 .readCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(20).targetUtilizationPercent(50).build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:36.417Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.Billing")
public abstract class Billing extends software.amazon.jsii.JsiiObject {

    protected Billing(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Billing(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Flexible billing option capable of serving requests without capacity planning.
     * <p>
     * Note: Billing mode will be PAY_PER_REQUEST.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Billing onDemand(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.MaxThroughputProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Billing.class, "onDemand", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Billing.class), new Object[] { props });
    }

    /**
     * Flexible billing option capable of serving requests without capacity planning.
     * <p>
     * Note: Billing mode will be PAY_PER_REQUEST.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Billing onDemand() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Billing.class, "onDemand", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Billing.class));
    }

    /**
     * Specify the number of reads and writes per second that you need for your application.
     * <p>
     * @param props specify read and write capacity configurations. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Billing provisioned(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ThroughputProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Billing.class, "provisioned", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Billing.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.BillingMode getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.BillingMode.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.dynamodb.Billing {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
