package software.amazon.awscdk.services.ec2;

/**
 * Specifies a security group.
 * <p>
 * You must specify ingress rules to allow inbound traffic. By default, no inbound traffic is allowed.
 * <p>
 * If you do not specify an egress rule, we add egress rules that allow outbound IPv4 and IPv6 traffic on all ports and protocols to any destination. We do not add these rules if you specify your own egress rules.
 * <p>
 * This type supports updates. For more information about updating stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">AWS CloudFormation Stacks Updates</a> .
 * <p>
 * <blockquote>
 * <p>
 * To cross-reference two security groups in the ingress and egress rules of those security groups, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html">AWS::EC2::SecurityGroupEgress</a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-ingress.html">AWS::EC2::SecurityGroupIngress</a> resources to define your rules. Do not use the embedded ingress and egress rules in the <code>AWS::EC2::SecurityGroup</code> . Doing so creates a circular dependency, which AWS CloudFormation doesn't allow.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnSecurityGroup cfnSecurityGroup = CfnSecurityGroup.Builder.create(this, "MyCfnSecurityGroup")
 *         .groupDescription("groupDescription")
 *         // the properties below are optional
 *         .groupName("groupName")
 *         .securityGroupEgress(List.of(EgressProperty.builder()
 *                 .ipProtocol("ipProtocol")
 *                 // the properties below are optional
 *                 .cidrIp("cidrIp")
 *                 .cidrIpv6("cidrIpv6")
 *                 .description("description")
 *                 .destinationPrefixListId("destinationPrefixListId")
 *                 .destinationSecurityGroupId("destinationSecurityGroupId")
 *                 .fromPort(123)
 *                 .toPort(123)
 *                 .build()))
 *         .securityGroupIngress(List.of(IngressProperty.builder()
 *                 .ipProtocol("ipProtocol")
 *                 // the properties below are optional
 *                 .cidrIp("cidrIp")
 *                 .cidrIpv6("cidrIpv6")
 *                 .description("description")
 *                 .fromPort(123)
 *                 .sourcePrefixListId("sourcePrefixListId")
 *                 .sourceSecurityGroupId("sourceSecurityGroupId")
 *                 .sourceSecurityGroupName("sourceSecurityGroupName")
 *                 .sourceSecurityGroupOwnerId("sourceSecurityGroupOwnerId")
 *                 .toPort(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:36.893Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnSecurityGroup")
public class CfnSecurityGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSecurityGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSecurityGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the security group, such as <code>sg-94b3a1f6</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGroupId() {
        return software.amazon.jsii.Kernel.get(this, "attrGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The group name or group ID depending on whether the SG is created in default or specific VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC, such as <code>vpc-0669f8f9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpcId() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A description for the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupDescription() {
        return software.amazon.jsii.Kernel.get(this, "groupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupDescription", java.util.Objects.requireNonNull(value, "groupDescription is required"));
    }

    /**
     * The name of the security group.
     * <p>
     * Names are case-insensitive and must be unique within the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the security group.
     * <p>
     * Names are case-insensitive and must be unique within the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupName", value);
    }

    /**
     * The outbound rules associated with the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupEgress() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupEgress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The outbound rules associated with the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupEgress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupEgress", value);
    }

    /**
     * The outbound rules associated with the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupEgress(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnSecurityGroup.EgressProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnSecurityGroup.EgressProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "securityGroupEgress", value);
    }

    /**
     * The inbound rules associated with the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupIngress() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupIngress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The inbound rules associated with the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIngress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIngress", value);
    }

    /**
     * The inbound rules associated with the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIngress(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnSecurityGroup.IngressProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnSecurityGroup.IngressProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "securityGroupIngress", value);
    }

    /**
     * Any tags assigned to the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Any tags assigned to the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The ID of the VPC for the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC for the security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", value);
    }
    /**
     * Adds the specified outbound (egress) rule to a security group.
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address range, the IP address ranges that are specified by a prefix list, or the instances that are associated with a destination security group. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a> .
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 address range, an IPv6 address range, a prefix list, or a security group.
     * <p>
     * You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6 type and code.
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a small delay might occur.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * EgressProperty egressProperty = EgressProperty.builder()
     *         .ipProtocol("ipProtocol")
     *         // the properties below are optional
     *         .cidrIp("cidrIp")
     *         .cidrIpv6("cidrIpv6")
     *         .description("description")
     *         .destinationPrefixListId("destinationPrefixListId")
     *         .destinationSecurityGroupId("destinationSecurityGroupId")
     *         .fromPort(123)
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnSecurityGroup.EgressProperty")
    @software.amazon.jsii.Jsii.Proxy(EgressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EgressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP protocol name ( <code>tcp</code> , <code>udp</code> , <code>icmp</code> , <code>icmpv6</code> ) or number (see <a href="https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> ).
         * <p>
         * Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-ipprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-ipprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol();

        /**
         * The IPv4 address range, in CIDR format.
         * <p>
         * You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
         * <p>
         * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-cidrip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-cidrip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
            return null;
        }

        /**
         * The IPv6 address range, in CIDR format.
         * <p>
         * You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
         * <p>
         * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-cidripv6">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-cidripv6</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
            return null;
        }

        /**
         * A description for the security group rule.
         * <p>
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The prefix list IDs for the destination AWS service.
         * <p>
         * This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
         * <p>
         * You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-destinationprefixlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-destinationprefixlistid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPrefixListId() {
            return null;
        }

        /**
         * The ID of the destination VPC security group.
         * <p>
         * You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-destinationsecuritygroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-destinationsecuritygroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationSecurityGroupId() {
            return null;
        }

        /**
         * If the protocol is TCP or UDP, this is the start of the port range.
         * <p>
         * If the protocol is ICMP or ICMPv6, this is the ICMP type or -1 (all ICMP types).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
            return null;
        }

        /**
         * If the protocol is TCP or UDP, this is the end of the port range.
         * <p>
         * If the protocol is ICMP or ICMPv6, this is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1 (all ICMP codes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-egress.html#cfn-ec2-securitygroup-egress-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EgressProperty> {
            java.lang.String ipProtocol;
            java.lang.String cidrIp;
            java.lang.String cidrIpv6;
            java.lang.String description;
            java.lang.String destinationPrefixListId;
            java.lang.String destinationSecurityGroupId;
            java.lang.Number fromPort;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link EgressProperty#getIpProtocol}
             * @param ipProtocol The IP protocol name ( <code>tcp</code> , <code>udp</code> , <code>icmp</code> , <code>icmpv6</code> ) or number (see <a href="https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> ). This parameter is required.
             *                   Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipProtocol(java.lang.String ipProtocol) {
                this.ipProtocol = ipProtocol;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getCidrIp}
             * @param cidrIp The IPv4 address range, in CIDR format.
             *               You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
             *               <p>
             *               For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrIp(java.lang.String cidrIp) {
                this.cidrIp = cidrIp;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getCidrIpv6}
             * @param cidrIpv6 The IPv6 address range, in CIDR format.
             *                 You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
             *                 <p>
             *                 For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrIpv6(java.lang.String cidrIpv6) {
                this.cidrIpv6 = cidrIpv6;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getDescription}
             * @param description A description for the security group rule.
             *                    Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getDestinationPrefixListId}
             * @param destinationPrefixListId The prefix list IDs for the destination AWS service.
             *                                This is the AWS service that you want to access through a VPC endpoint from instances associated with the security group.
             *                                <p>
             *                                You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPrefixListId(java.lang.String destinationPrefixListId) {
                this.destinationPrefixListId = destinationPrefixListId;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getDestinationSecurityGroupId}
             * @param destinationSecurityGroupId The ID of the destination VPC security group.
             *                                   You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>DestinationPrefixListId</code> , or <code>DestinationSecurityGroupId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSecurityGroupId(java.lang.String destinationSecurityGroupId) {
                this.destinationSecurityGroupId = destinationSecurityGroupId;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getFromPort}
             * @param fromPort If the protocol is TCP or UDP, this is the start of the port range.
             *                 If the protocol is ICMP or ICMPv6, this is the ICMP type or -1 (all ICMP types).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getToPort}
             * @param toPort If the protocol is TCP or UDP, this is the end of the port range.
             *               If the protocol is ICMP or ICMPv6, this is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1 (all ICMP codes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EgressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EgressProperty {
            private final java.lang.String ipProtocol;
            private final java.lang.String cidrIp;
            private final java.lang.String cidrIpv6;
            private final java.lang.String description;
            private final java.lang.String destinationPrefixListId;
            private final java.lang.String destinationSecurityGroupId;
            private final java.lang.Number fromPort;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipProtocol = software.amazon.jsii.Kernel.get(this, "ipProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cidrIp = software.amazon.jsii.Kernel.get(this, "cidrIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cidrIpv6 = software.amazon.jsii.Kernel.get(this, "cidrIpv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPrefixListId = software.amazon.jsii.Kernel.get(this, "destinationPrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationSecurityGroupId = software.amazon.jsii.Kernel.get(this, "destinationSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipProtocol = java.util.Objects.requireNonNull(builder.ipProtocol, "ipProtocol is required");
                this.cidrIp = builder.cidrIp;
                this.cidrIpv6 = builder.cidrIpv6;
                this.description = builder.description;
                this.destinationPrefixListId = builder.destinationPrefixListId;
                this.destinationSecurityGroupId = builder.destinationSecurityGroupId;
                this.fromPort = builder.fromPort;
                this.toPort = builder.toPort;
            }

            @Override
            public final java.lang.String getIpProtocol() {
                return this.ipProtocol;
            }

            @Override
            public final java.lang.String getCidrIp() {
                return this.cidrIp;
            }

            @Override
            public final java.lang.String getCidrIpv6() {
                return this.cidrIpv6;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getDestinationPrefixListId() {
                return this.destinationPrefixListId;
            }

            @Override
            public final java.lang.String getDestinationSecurityGroupId() {
                return this.destinationSecurityGroupId;
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                if (this.getCidrIp() != null) {
                    data.set("cidrIp", om.valueToTree(this.getCidrIp()));
                }
                if (this.getCidrIpv6() != null) {
                    data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDestinationPrefixListId() != null) {
                    data.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
                }
                if (this.getDestinationSecurityGroupId() != null) {
                    data.set("destinationSecurityGroupId", om.valueToTree(this.getDestinationSecurityGroupId()));
                }
                if (this.getFromPort() != null) {
                    data.set("fromPort", om.valueToTree(this.getFromPort()));
                }
                if (this.getToPort() != null) {
                    data.set("toPort", om.valueToTree(this.getToPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnSecurityGroup.EgressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EgressProperty.Jsii$Proxy that = (EgressProperty.Jsii$Proxy) o;

                if (!ipProtocol.equals(that.ipProtocol)) return false;
                if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
                if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.destinationPrefixListId != null ? !this.destinationPrefixListId.equals(that.destinationPrefixListId) : that.destinationPrefixListId != null) return false;
                if (this.destinationSecurityGroupId != null ? !this.destinationSecurityGroupId.equals(that.destinationSecurityGroupId) : that.destinationSecurityGroupId != null) return false;
                if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
                return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipProtocol.hashCode();
                result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
                result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.destinationPrefixListId != null ? this.destinationPrefixListId.hashCode() : 0);
                result = 31 * result + (this.destinationSecurityGroupId != null ? this.destinationSecurityGroupId.hashCode() : 0);
                result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
                result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Adds an inbound (ingress) rule to a security group.
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP address ranges that are specified by a prefix list, or the instances that are associated with a source security group. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a> .
     * <p>
     * You must specify exactly one of the following sources: an IPv4 address range, an IPv6 address range, a prefix list, or a security group.
     * <p>
     * You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6 type and code.
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a small delay might occur.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IngressProperty ingressProperty = IngressProperty.builder()
     *         .ipProtocol("ipProtocol")
     *         // the properties below are optional
     *         .cidrIp("cidrIp")
     *         .cidrIpv6("cidrIpv6")
     *         .description("description")
     *         .fromPort(123)
     *         .sourcePrefixListId("sourcePrefixListId")
     *         .sourceSecurityGroupId("sourceSecurityGroupId")
     *         .sourceSecurityGroupName("sourceSecurityGroupName")
     *         .sourceSecurityGroupOwnerId("sourceSecurityGroupOwnerId")
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnSecurityGroup.IngressProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP protocol name ( <code>tcp</code> , <code>udp</code> , <code>icmp</code> , <code>icmpv6</code> ) or number (see <a href="https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> ).
         * <p>
         * Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-ipprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-ipprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol();

        /**
         * The IPv4 address range, in CIDR format.
         * <p>
         * You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>SourcePrefixListId</code> , or <code>SourceSecurityGroupId</code> .
         * <p>
         * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-cidrip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-cidrip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
            return null;
        }

        /**
         * The IPv6 address range, in CIDR format.
         * <p>
         * You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>SourcePrefixListId</code> , or <code>SourceSecurityGroupId</code> .
         * <p>
         * For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-cidripv6">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-cidripv6</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
            return null;
        }

        /**
         * Updates the description of an ingress (inbound) security group rule.
         * <p>
         * You can replace an existing description, or add a description to a rule that did not have one previously.
         * <p>
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * If the protocol is TCP or UDP, this is the start of the port range.
         * <p>
         * If the protocol is ICMP or ICMPv6, this is the ICMP type or -1 (all ICMP types).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
            return null;
        }

        /**
         * The ID of a prefix list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePrefixListId() {
            return null;
        }

        /**
         * The ID of the security group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourcesecuritygroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourcesecuritygroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupId() {
            return null;
        }

        /**
         * [Default VPC] The name of the source security group.
         * <p>
         * You must specify either the security group ID or the security group name. You can't specify the group name in combination with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
         * <p>
         * For security groups in a nondefault VPC, you must specify the group ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourcesecuritygroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourcesecuritygroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupName() {
            return null;
        }

        /**
         * [nondefault VPC] The AWS account ID for the source security group, if the source security group is in a different account.
         * <p>
         * You can't specify this property with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
         * <p>
         * If you specify <code>SourceSecurityGroupName</code> or <code>SourceSecurityGroupId</code> and that security group is owned by a different account than the account creating the stack, you must specify the <code>SourceSecurityGroupOwnerId</code> ; otherwise, this property is optional.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourcesecuritygroupownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-sourcesecuritygroupownerid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupOwnerId() {
            return null;
        }

        /**
         * If the protocol is TCP or UDP, this is the end of the port range.
         * <p>
         * If the protocol is ICMP or ICMPv6, this is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1 (all ICMP codes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-securitygroup-ingress.html#cfn-ec2-securitygroup-ingress-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressProperty> {
            java.lang.String ipProtocol;
            java.lang.String cidrIp;
            java.lang.String cidrIpv6;
            java.lang.String description;
            java.lang.Number fromPort;
            java.lang.String sourcePrefixListId;
            java.lang.String sourceSecurityGroupId;
            java.lang.String sourceSecurityGroupName;
            java.lang.String sourceSecurityGroupOwnerId;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link IngressProperty#getIpProtocol}
             * @param ipProtocol The IP protocol name ( <code>tcp</code> , <code>udp</code> , <code>icmp</code> , <code>icmpv6</code> ) or number (see <a href="https://docs.aws.amazon.com/http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> ). This parameter is required.
             *                   Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code> , <code>udp</code> , <code>icmp</code> , or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code> , <code>udp</code> , and <code>icmp</code> , you must specify a port range. For <code>icmpv6</code> , the port range is optional; if you omit the port range, traffic for all types and codes is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipProtocol(java.lang.String ipProtocol) {
                this.ipProtocol = ipProtocol;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getCidrIp}
             * @param cidrIp The IPv4 address range, in CIDR format.
             *               You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>SourcePrefixListId</code> , or <code>SourceSecurityGroupId</code> .
             *               <p>
             *               For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrIp(java.lang.String cidrIp) {
                this.cidrIp = cidrIp;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getCidrIpv6}
             * @param cidrIpv6 The IPv6 address range, in CIDR format.
             *                 You must specify exactly one of the following: <code>CidrIp</code> , <code>CidrIpv6</code> , <code>SourcePrefixListId</code> , or <code>SourceSecurityGroupId</code> .
             *                 <p>
             *                 For examples of rules that you can add to security groups for specific access scenarios, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group rules for different use cases</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrIpv6(java.lang.String cidrIpv6) {
                this.cidrIpv6 = cidrIpv6;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getDescription}
             * @param description Updates the description of an ingress (inbound) security group rule.
             *                    You can replace an existing description, or add a description to a rule that did not have one previously.
             *                    <p>
             *                    Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=;{}!$*
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getFromPort}
             * @param fromPort If the protocol is TCP or UDP, this is the start of the port range.
             *                 If the protocol is ICMP or ICMPv6, this is the ICMP type or -1 (all ICMP types).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourcePrefixListId}
             * @param sourcePrefixListId The ID of a prefix list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePrefixListId(java.lang.String sourcePrefixListId) {
                this.sourcePrefixListId = sourcePrefixListId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourceSecurityGroupId}
             * @param sourceSecurityGroupId The ID of the security group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSecurityGroupId(java.lang.String sourceSecurityGroupId) {
                this.sourceSecurityGroupId = sourceSecurityGroupId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourceSecurityGroupName}
             * @param sourceSecurityGroupName [Default VPC] The name of the source security group.
             *                                You must specify either the security group ID or the security group name. You can't specify the group name in combination with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
             *                                <p>
             *                                For security groups in a nondefault VPC, you must specify the group ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSecurityGroupName(java.lang.String sourceSecurityGroupName) {
                this.sourceSecurityGroupName = sourceSecurityGroupName;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourceSecurityGroupOwnerId}
             * @param sourceSecurityGroupOwnerId [nondefault VPC] The AWS account ID for the source security group, if the source security group is in a different account.
             *                                   You can't specify this property with an IP address range. Creates rules that grant full ICMP, UDP, and TCP access.
             *                                   <p>
             *                                   If you specify <code>SourceSecurityGroupName</code> or <code>SourceSecurityGroupId</code> and that security group is owned by a different account than the account creating the stack, you must specify the <code>SourceSecurityGroupOwnerId</code> ; otherwise, this property is optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSecurityGroupOwnerId(java.lang.String sourceSecurityGroupOwnerId) {
                this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getToPort}
             * @param toPort If the protocol is TCP or UDP, this is the end of the port range.
             *               If the protocol is ICMP or ICMPv6, this is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1 (all ICMP codes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressProperty {
            private final java.lang.String ipProtocol;
            private final java.lang.String cidrIp;
            private final java.lang.String cidrIpv6;
            private final java.lang.String description;
            private final java.lang.Number fromPort;
            private final java.lang.String sourcePrefixListId;
            private final java.lang.String sourceSecurityGroupId;
            private final java.lang.String sourceSecurityGroupName;
            private final java.lang.String sourceSecurityGroupOwnerId;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipProtocol = software.amazon.jsii.Kernel.get(this, "ipProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cidrIp = software.amazon.jsii.Kernel.get(this, "cidrIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cidrIpv6 = software.amazon.jsii.Kernel.get(this, "cidrIpv6", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sourcePrefixListId = software.amazon.jsii.Kernel.get(this, "sourcePrefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceSecurityGroupId = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceSecurityGroupName = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceSecurityGroupOwnerId = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroupOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipProtocol = java.util.Objects.requireNonNull(builder.ipProtocol, "ipProtocol is required");
                this.cidrIp = builder.cidrIp;
                this.cidrIpv6 = builder.cidrIpv6;
                this.description = builder.description;
                this.fromPort = builder.fromPort;
                this.sourcePrefixListId = builder.sourcePrefixListId;
                this.sourceSecurityGroupId = builder.sourceSecurityGroupId;
                this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
                this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
                this.toPort = builder.toPort;
            }

            @Override
            public final java.lang.String getIpProtocol() {
                return this.ipProtocol;
            }

            @Override
            public final java.lang.String getCidrIp() {
                return this.cidrIp;
            }

            @Override
            public final java.lang.String getCidrIpv6() {
                return this.cidrIpv6;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.String getSourcePrefixListId() {
                return this.sourcePrefixListId;
            }

            @Override
            public final java.lang.String getSourceSecurityGroupId() {
                return this.sourceSecurityGroupId;
            }

            @Override
            public final java.lang.String getSourceSecurityGroupName() {
                return this.sourceSecurityGroupName;
            }

            @Override
            public final java.lang.String getSourceSecurityGroupOwnerId() {
                return this.sourceSecurityGroupOwnerId;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                if (this.getCidrIp() != null) {
                    data.set("cidrIp", om.valueToTree(this.getCidrIp()));
                }
                if (this.getCidrIpv6() != null) {
                    data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFromPort() != null) {
                    data.set("fromPort", om.valueToTree(this.getFromPort()));
                }
                if (this.getSourcePrefixListId() != null) {
                    data.set("sourcePrefixListId", om.valueToTree(this.getSourcePrefixListId()));
                }
                if (this.getSourceSecurityGroupId() != null) {
                    data.set("sourceSecurityGroupId", om.valueToTree(this.getSourceSecurityGroupId()));
                }
                if (this.getSourceSecurityGroupName() != null) {
                    data.set("sourceSecurityGroupName", om.valueToTree(this.getSourceSecurityGroupName()));
                }
                if (this.getSourceSecurityGroupOwnerId() != null) {
                    data.set("sourceSecurityGroupOwnerId", om.valueToTree(this.getSourceSecurityGroupOwnerId()));
                }
                if (this.getToPort() != null) {
                    data.set("toPort", om.valueToTree(this.getToPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnSecurityGroup.IngressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressProperty.Jsii$Proxy that = (IngressProperty.Jsii$Proxy) o;

                if (!ipProtocol.equals(that.ipProtocol)) return false;
                if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
                if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
                if (this.sourcePrefixListId != null ? !this.sourcePrefixListId.equals(that.sourcePrefixListId) : that.sourcePrefixListId != null) return false;
                if (this.sourceSecurityGroupId != null ? !this.sourceSecurityGroupId.equals(that.sourceSecurityGroupId) : that.sourceSecurityGroupId != null) return false;
                if (this.sourceSecurityGroupName != null ? !this.sourceSecurityGroupName.equals(that.sourceSecurityGroupName) : that.sourceSecurityGroupName != null) return false;
                if (this.sourceSecurityGroupOwnerId != null ? !this.sourceSecurityGroupOwnerId.equals(that.sourceSecurityGroupOwnerId) : that.sourceSecurityGroupOwnerId != null) return false;
                return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipProtocol.hashCode();
                result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
                result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
                result = 31 * result + (this.sourcePrefixListId != null ? this.sourcePrefixListId.hashCode() : 0);
                result = 31 * result + (this.sourceSecurityGroupId != null ? this.sourceSecurityGroupId.hashCode() : 0);
                result = 31 * result + (this.sourceSecurityGroupName != null ? this.sourceSecurityGroupName.hashCode() : 0);
                result = 31 * result + (this.sourceSecurityGroupOwnerId != null ? this.sourceSecurityGroupOwnerId.hashCode() : 0);
                result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSecurityGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnSecurityGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.Builder();
        }

        /**
         * A description for the security group.
         * <p>
         * Constraints: Up to 255 characters in length
         * <p>
         * Valid characters: a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=&amp;;{}!$*
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-groupdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-groupdescription</a>
         * @param groupDescription A description for the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupDescription(final java.lang.String groupDescription) {
            this.props.groupDescription(groupDescription);
            return this;
        }

        /**
         * The name of the security group. Names are case-insensitive and must be unique within the VPC.
         * <p>
         * Constraints: Up to 255 characters in length. Can't start with <code>sg-</code> .
         * <p>
         * Valid characters: a-z, A-Z, 0-9, spaces, and ._-:/()#,&#64;[]+=&amp;;{}!$*
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-groupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-groupname</a>
         * @param groupName The name of the security group. Names are case-insensitive and must be unique within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(final java.lang.String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        /**
         * The outbound rules associated with the security group.
         * <p>
         * There is a short interruption during which you cannot connect to the security group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupegress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupegress</a>
         * @param securityGroupEgress The outbound rules associated with the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupEgress(final software.amazon.awscdk.IResolvable securityGroupEgress) {
            this.props.securityGroupEgress(securityGroupEgress);
            return this;
        }
        /**
         * The outbound rules associated with the security group.
         * <p>
         * There is a short interruption during which you cannot connect to the security group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupegress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupegress</a>
         * @param securityGroupEgress The outbound rules associated with the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupEgress(final java.util.List<? extends java.lang.Object> securityGroupEgress) {
            this.props.securityGroupEgress(securityGroupEgress);
            return this;
        }

        /**
         * The inbound rules associated with the security group.
         * <p>
         * There is a short interruption during which you cannot connect to the security group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupingress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupingress</a>
         * @param securityGroupIngress The inbound rules associated with the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIngress(final software.amazon.awscdk.IResolvable securityGroupIngress) {
            this.props.securityGroupIngress(securityGroupIngress);
            return this;
        }
        /**
         * The inbound rules associated with the security group.
         * <p>
         * There is a short interruption during which you cannot connect to the security group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupingress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-securitygroupingress</a>
         * @param securityGroupIngress The inbound rules associated with the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIngress(final java.util.List<? extends java.lang.Object> securityGroupIngress) {
            this.props.securityGroupIngress(securityGroupIngress);
            return this;
        }

        /**
         * Any tags assigned to the security group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-tags</a>
         * @param tags Any tags assigned to the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The ID of the VPC for the security group.
         * <p>
         * If you do not specify a VPC, the default is to use the default VPC for the Region. If there's no specified VPC and no default VPC, security group creation fails.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-securitygroup.html#cfn-ec2-securitygroup-vpcid</a>
         * @param vpcId The ID of the VPC for the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSecurityGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnSecurityGroup build() {
            return new software.amazon.awscdk.services.ec2.CfnSecurityGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
