package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVPCBlockPublicAccessOptions</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCBlockPublicAccessOptionsProps cfnVPCBlockPublicAccessOptionsProps = CfnVPCBlockPublicAccessOptionsProps.builder()
 *         .internetGatewayBlockMode("internetGatewayBlockMode")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcblockpublicaccessoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcblockpublicaccessoptions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.017Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPCBlockPublicAccessOptionsProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCBlockPublicAccessOptionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCBlockPublicAccessOptionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The desired VPC Block Public Access mode for internet gateways in your account.
     * <p>
     * We do not allow you to create this resource type in an "off" mode since off is the default value.
     * <p>
     * <ul>
     * <li><code>block-bidirectional</code> : Block all traffic to and from internet gateways and egress-only internet gateways in this Region (except for excluded VPCs and subnets).</li>
     * <li><code>block-ingress</code> : Block all internet traffic to the VPCs in this Region (except for VPCs or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed because these gateways only allow outbound connections to be established.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcblockpublicaccessoptions.html#cfn-ec2-vpcblockpublicaccessoptions-internetgatewayblockmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcblockpublicaccessoptions.html#cfn-ec2-vpcblockpublicaccessoptions-internetgatewayblockmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInternetGatewayBlockMode();

    /**
     * @return a {@link Builder} of {@link CfnVPCBlockPublicAccessOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCBlockPublicAccessOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCBlockPublicAccessOptionsProps> {
        java.lang.String internetGatewayBlockMode;

        /**
         * Sets the value of {@link CfnVPCBlockPublicAccessOptionsProps#getInternetGatewayBlockMode}
         * @param internetGatewayBlockMode The desired VPC Block Public Access mode for internet gateways in your account. This parameter is required.
         *                                 We do not allow you to create this resource type in an "off" mode since off is the default value.
         *                                 <p>
         *                                 <ul>
         *                                 <li><code>block-bidirectional</code> : Block all traffic to and from internet gateways and egress-only internet gateways in this Region (except for excluded VPCs and subnets).</li>
         *                                 <li><code>block-ingress</code> : Block all internet traffic to the VPCs in this Region (except for VPCs or subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed because these gateways only allow outbound connections to be established.</li>
         *                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetGatewayBlockMode(java.lang.String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCBlockPublicAccessOptionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCBlockPublicAccessOptionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCBlockPublicAccessOptionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCBlockPublicAccessOptionsProps {
        private final java.lang.String internetGatewayBlockMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.internetGatewayBlockMode = software.amazon.jsii.Kernel.get(this, "internetGatewayBlockMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.internetGatewayBlockMode = java.util.Objects.requireNonNull(builder.internetGatewayBlockMode, "internetGatewayBlockMode is required");
        }

        @Override
        public final java.lang.String getInternetGatewayBlockMode() {
            return this.internetGatewayBlockMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("internetGatewayBlockMode", om.valueToTree(this.getInternetGatewayBlockMode()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPCBlockPublicAccessOptionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCBlockPublicAccessOptionsProps.Jsii$Proxy that = (CfnVPCBlockPublicAccessOptionsProps.Jsii$Proxy) o;

            return this.internetGatewayBlockMode.equals(that.internetGatewayBlockMode);
        }

        @Override
        public final int hashCode() {
            int result = this.internetGatewayBlockMode.hashCode();
            return result;
        }
    }
}
