package software.amazon.awscdk.services.ec2;

/**
 * Options to add a flow log to a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = new Vpc(this, "Vpc");
 * vpc.addFlowLog("FlowLogS3", FlowLogOptions.builder()
 *         .destination(FlowLogDestination.toS3())
 *         .build());
 * // Only reject traffic and interval every minute.
 * vpc.addFlowLog("FlowLogCloudWatch", FlowLogOptions.builder()
 *         .trafficType(FlowLogTrafficType.REJECT)
 *         .maxAggregationInterval(FlowLogMaxAggregationInterval.ONE_MINUTE)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.134Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.FlowLogOptions")
@software.amazon.jsii.Jsii.Proxy(FlowLogOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FlowLogOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the type of destination to which the flow log data is to be published.
     * <p>
     * Flow log data can be published to CloudWatch Logs or Amazon S3
     * <p>
     * Default: FlowLogDestinationType.toCloudWatchLogs()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.FlowLogDestination getDestination() {
        return null;
    }

    /**
     * The fields to include in the flow log record, in the order in which they should appear.
     * <p>
     * If multiple fields are specified, they will be separated by spaces. For full control over the literal log format
     * string, pass a single field constructed with <code>LogFormat.custom()</code>.
     * <p>
     * See https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
     * <p>
     * Default: - default log format is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.LogFormat> getLogFormat() {
        return null;
    }

    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
     * <p>
     * When creating flow logs for a Transit Gateway or Transit Gateway Attachment,
     * this property must be ONE_MINUTES.
     * <p>
     * Default: - FlowLogMaxAggregationInterval.ONE_MINUTES if creating flow logs for Transit Gateway, otherwise FlowLogMaxAggregationInterval.TEN_MINUTES.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-maxaggregationinterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval getMaxAggregationInterval() {
        return null;
    }

    /**
     * The type of traffic to log.
     * <p>
     * You can log traffic that the resource accepts or rejects, or all traffic.
     * When the target is either <code>TransitGateway</code> or <code>TransitGatewayAttachment</code>, setting the traffic type is not possible.
     * <p>
     * Default: ALL
     * <p>
     * @see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/working-with-flow-logs.html">https://docs.aws.amazon.com/vpc/latest/tgw/working-with-flow-logs.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.FlowLogTrafficType getTrafficType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FlowLogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowLogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FlowLogOptions> {
        software.amazon.awscdk.services.ec2.FlowLogDestination destination;
        java.util.List<software.amazon.awscdk.services.ec2.LogFormat> logFormat;
        software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval maxAggregationInterval;
        software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType;

        /**
         * Sets the value of {@link FlowLogOptions#getDestination}
         * @param destination Specifies the type of destination to which the flow log data is to be published.
         *                    Flow log data can be published to CloudWatch Logs or Amazon S3
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.ec2.FlowLogDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogOptions#getLogFormat}
         * @param logFormat The fields to include in the flow log record, in the order in which they should appear.
         *                  If multiple fields are specified, they will be separated by spaces. For full control over the literal log format
         *                  string, pass a single field constructed with <code>LogFormat.custom()</code>.
         *                  <p>
         *                  See https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder logFormat(java.util.List<? extends software.amazon.awscdk.services.ec2.LogFormat> logFormat) {
            this.logFormat = (java.util.List<software.amazon.awscdk.services.ec2.LogFormat>)logFormat;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogOptions#getMaxAggregationInterval}
         * @param maxAggregationInterval The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record.
         *                               When creating flow logs for a Transit Gateway or Transit Gateway Attachment,
         *                               this property must be ONE_MINUTES.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAggregationInterval(software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogOptions#getTrafficType}
         * @param trafficType The type of traffic to log.
         *                    You can log traffic that the resource accepts or rejects, or all traffic.
         *                    When the target is either <code>TransitGateway</code> or <code>TransitGatewayAttachment</code>, setting the traffic type is not possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowLogOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FlowLogOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FlowLogOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowLogOptions {
        private final software.amazon.awscdk.services.ec2.FlowLogDestination destination;
        private final java.util.List<software.amazon.awscdk.services.ec2.LogFormat> logFormat;
        private final software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval maxAggregationInterval;
        private final software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogDestination.class));
            this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.LogFormat.class)));
            this.maxAggregationInterval = software.amazon.jsii.Kernel.get(this, "maxAggregationInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval.class));
            this.trafficType = software.amazon.jsii.Kernel.get(this, "trafficType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogTrafficType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = builder.destination;
            this.logFormat = (java.util.List<software.amazon.awscdk.services.ec2.LogFormat>)builder.logFormat;
            this.maxAggregationInterval = builder.maxAggregationInterval;
            this.trafficType = builder.trafficType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.FlowLogDestination getDestination() {
            return this.destination;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.LogFormat> getLogFormat() {
            return this.logFormat;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.FlowLogMaxAggregationInterval getMaxAggregationInterval() {
            return this.maxAggregationInterval;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.FlowLogTrafficType getTrafficType() {
            return this.trafficType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDestination() != null) {
                data.set("destination", om.valueToTree(this.getDestination()));
            }
            if (this.getLogFormat() != null) {
                data.set("logFormat", om.valueToTree(this.getLogFormat()));
            }
            if (this.getMaxAggregationInterval() != null) {
                data.set("maxAggregationInterval", om.valueToTree(this.getMaxAggregationInterval()));
            }
            if (this.getTrafficType() != null) {
                data.set("trafficType", om.valueToTree(this.getTrafficType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.FlowLogOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowLogOptions.Jsii$Proxy that = (FlowLogOptions.Jsii$Proxy) o;

            if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
            if (this.logFormat != null ? !this.logFormat.equals(that.logFormat) : that.logFormat != null) return false;
            if (this.maxAggregationInterval != null ? !this.maxAggregationInterval.equals(that.maxAggregationInterval) : that.maxAggregationInterval != null) return false;
            return this.trafficType != null ? this.trafficType.equals(that.trafficType) : that.trafficType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination != null ? this.destination.hashCode() : 0;
            result = 31 * result + (this.logFormat != null ? this.logFormat.hashCode() : 0);
            result = 31 * result + (this.maxAggregationInterval != null ? this.maxAggregationInterval.hashCode() : 0);
            result = 31 * result + (this.trafficType != null ? this.trafficType.hashCode() : 0);
            return result;
        }
    }
}
