package software.amazon.awscdk.services.ec2;

/**
 * Direction of traffic to allow all by default.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NatInstanceProviderV2 natGatewayProvider = NatProvider.instanceV2(NatInstanceProps.builder()
 *         .instanceType(new InstanceType("t3.small"))
 *         .defaultAllowedTraffic(NatTrafficDirection.NONE)
 *         .build());
 * Vpc vpc = Vpc.Builder.create(this, "Vpc").natGatewayProvider(natGatewayProvider).build();
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup")
 *         .vpc(vpc)
 *         .allowAllOutbound(false)
 *         .build();
 * securityGroup.addEgressRule(Peer.anyIpv4(), Port.tcp(443));
 * for (Object gatewayInstance : natGatewayProvider.getGatewayInstances()) {
 *     gatewayInstance.addSecurityGroup(securityGroup);
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.254Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatTrafficDirection")
public enum NatTrafficDirection {
    /**
     * Allow all outbound traffic and disallow all inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OUTBOUND_ONLY,
    /**
     * Allow all outbound and inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INBOUND_AND_OUTBOUND,
    /**
     * Disallow all outbound and inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
