package software.amazon.awscdk.services.ec2;

/**
 * A VPC endpoint service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NetworkLoadBalancer networkLoadBalancer1;
 * NetworkLoadBalancer networkLoadBalancer2;
 * VpcEndpointService.Builder.create(this, "EndpointService")
 *         .vpcEndpointServiceLoadBalancers(List.of(networkLoadBalancer1, networkLoadBalancer2))
 *         .acceptanceRequired(true)
 *         .allowedPrincipals(List.of(new ArnPrincipal("arn:aws:iam::123456789012:root")))
 *         .contributorInsights(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.307Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VpcEndpointService")
public class VpcEndpointService extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IVpcEndpointService {

    protected VpcEndpointService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcEndpointService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_PREFIX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.VpcEndpointService.class, "DEFAULT_PREFIX", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VpcEndpointService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.VpcEndpointServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The default value for a VPC Endpoint Service name prefix, useful if you do not have a synthesize-time region literal available (all you have is <code>{ "Ref": "AWS::Region" }</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_PREFIX;

    /**
     * Whether to require manual acceptance of new connections to the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAcceptanceRequired() {
        return software.amazon.jsii.Kernel.get(this, "acceptanceRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * One or more Principal ARNs to allow inbound connections to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.ArnPrincipal> getAllowedPrincipals() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "allowedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.ArnPrincipal.class))));
    }

    /**
     * The id of the VPC Endpoint Service, like vpce-svc-xxxxxxxxxxxxxxxx.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcEndpointServiceId() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * One or more network load balancers to host the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> getVpcEndpointServiceLoadBalancers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceLoadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer.class))));
    }

    /**
     * The service name of the VPC Endpoint Service that clients use to connect to, like com.amazonaws.vpce.<region>.vpce-svc-xxxxxxxxxxxxxxxx.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcEndpointServiceName() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getContributorInsightsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "contributorInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.VpcEndpointService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.VpcEndpointService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.VpcEndpointServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.VpcEndpointServiceProps.Builder();
        }

        /**
         * One or more load balancers to host the VPC Endpoint Service.
         * <p>
         * @return {@code this}
         * @param vpcEndpointServiceLoadBalancers One or more load balancers to host the VPC Endpoint Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointServiceLoadBalancers(final java.util.List<? extends software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer> vpcEndpointServiceLoadBalancers) {
            this.props.vpcEndpointServiceLoadBalancers(vpcEndpointServiceLoadBalancers);
            return this;
        }

        /**
         * Whether requests from service consumers to connect to the service through an endpoint must be accepted.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param acceptanceRequired Whether requests from service consumers to connect to the service through an endpoint must be accepted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(final java.lang.Boolean acceptanceRequired) {
            this.props.acceptanceRequired(acceptanceRequired);
            return this;
        }

        /**
         * IAM users, IAM roles, or AWS accounts to allow inbound connections from.
         * <p>
         * These principals can connect to your service using VPC endpoints. Takes a
         * list of one or more ArnPrincipal.
         * <p>
         * Default: - no principals
         * <p>
         * @return {@code this}
         * @param allowedPrincipals IAM users, IAM roles, or AWS accounts to allow inbound connections from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPrincipals(final java.util.List<? extends software.amazon.awscdk.services.iam.ArnPrincipal> allowedPrincipals) {
            this.props.allowedPrincipals(allowedPrincipals);
            return this;
        }

        /**
         * Indicates whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param contributorInsights Indicates whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsights(final java.lang.Boolean contributorInsights) {
            this.props.contributorInsights(contributorInsights);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.VpcEndpointService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.VpcEndpointService build() {
            return new software.amazon.awscdk.services.ec2.VpcEndpointService(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
