package software.amazon.awscdk.services.ecs;

/**
 * The options for creating an Auto Scaling Group Capacity Provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LaunchTemplate launchTemplate = LaunchTemplate.Builder.create(this, "ASG-LaunchTemplate")
 *         .instanceType(new InstanceType("t3.medium"))
 *         .machineImage(EcsOptimizedImage.amazonLinux2())
 *         .userData(UserData.forLinux())
 *         .build();
 * AutoScalingGroup autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .mixedInstancesPolicy(MixedInstancesPolicy.builder()
 *                 .instancesDistribution(InstancesDistribution.builder()
 *                         .onDemandPercentageAboveBaseCapacity(50)
 *                         .build())
 *                 .launchTemplate(launchTemplate)
 *                 .build())
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * AsgCapacityProvider capacityProvider = AsgCapacityProvider.Builder.create(this, "AsgCapacityProvider")
 *         .autoScalingGroup(autoScalingGroup)
 *         .machineImageType(MachineImageType.AMAZON_LINUX_2)
 *         .build();
 * cluster.addAsgCapacityProvider(capacityProvider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.429Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AsgCapacityProviderProps")
@software.amazon.jsii.Jsii.Proxy(AsgCapacityProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AsgCapacityProviderProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions {

    /**
     * The autoscaling group to add as a Capacity Provider.
     * <p>
     * Warning: When passing an imported resource using <code>AutoScalingGroup.fromAutoScalingGroupName</code> along with <code>enableManagedTerminationProtection: true</code>,
     * the <code>AsgCapacityProvider</code> construct will not be able to enforce the option <code>newInstancesProtectedFromScaleIn</code> of the <code>AutoScalingGroup</code>.
     * In this case the constructor of <code>AsgCapacityProvider</code> will throw an exception.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * The name of the capacity provider.
     * <p>
     * If a name is specified,
     * it cannot start with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>. If no name is specified,
     * a default name in the CFNStackName-CFNResourceName-RandomString format is used.
     * If the stack name starts with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>, a unique resource name
     * is generated that starts with <code>cp-</code>.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProviderName() {
        return null;
    }

    /**
     * Managed instance draining facilitates graceful termination of Amazon ECS instances.
     * <p>
     * This allows your service workloads to stop safely and be rescheduled to non-terminating instances.
     * Infrastructure maintenance and updates are preformed without disruptions to workloads.
     * To use managed instance draining, set enableManagedDraining to true.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedDraining() {
        return null;
    }

    /**
     * When enabled the scale-in and scale-out actions of the cluster's Auto Scaling Group will be managed for you.
     * <p>
     * This means your cluster will automatically scale instances based on the load your tasks put on the cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling">Using Managed Scaling</a> in the ECS Developer Guide.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedScaling() {
        return null;
    }

    /**
     * When enabled the Auto Scaling Group will only terminate EC2 instances that no longer have running non-daemon tasks.
     * <p>
     * Scale-in protection will be automatically enabled on instances. When all non-daemon tasks are
     * stopped on an instance, ECS initiates the scale-in process and turns off scale-in protection for the
     * instance. The Auto Scaling Group can then terminate the instance. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-auto-scaling.html#managed-termination-protection">Managed termination
     * protection</a>
     * in the ECS Developer Guide.
     * <p>
     * Managed scaling must also be enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedTerminationProtection() {
        return null;
    }

    /**
     * The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group.
     * <p>
     * Must be between 0 and 10000.
     * <p>
     * Default: 300
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceWarmupPeriod() {
        return null;
    }

    /**
     * Maximum scaling step size.
     * <p>
     * In most cases this should be left alone.
     * <p>
     * Default: 1000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumScalingStepSize() {
        return null;
    }

    /**
     * Minimum scaling step size.
     * <p>
     * In most cases this should be left alone.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumScalingStepSize() {
        return null;
    }

    /**
     * Target capacity percent.
     * <p>
     * In most cases this should be left alone.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetCapacityPercent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AsgCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AsgCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AsgCapacityProviderProps> {
        software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        java.lang.String capacityProviderName;
        java.lang.Boolean enableManagedDraining;
        java.lang.Boolean enableManagedScaling;
        java.lang.Boolean enableManagedTerminationProtection;
        java.lang.Number instanceWarmupPeriod;
        java.lang.Number maximumScalingStepSize;
        java.lang.Number minimumScalingStepSize;
        java.lang.Number targetCapacityPercent;
        java.lang.Boolean canContainersAccessInstanceRole;
        software.amazon.awscdk.services.ecs.MachineImageType machineImageType;
        java.lang.Boolean spotInstanceDraining;
        software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getAutoScalingGroup}
         * @param autoScalingGroup The autoscaling group to add as a Capacity Provider. This parameter is required.
         *                         Warning: When passing an imported resource using <code>AutoScalingGroup.fromAutoScalingGroupName</code> along with <code>enableManagedTerminationProtection: true</code>,
         *                         the <code>AsgCapacityProvider</code> construct will not be able to enforce the option <code>newInstancesProtectedFromScaleIn</code> of the <code>AutoScalingGroup</code>.
         *                         In this case the constructor of <code>AsgCapacityProvider</code> will throw an exception.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getCapacityProviderName}
         * @param capacityProviderName The name of the capacity provider.
         *                             If a name is specified,
         *                             it cannot start with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>. If no name is specified,
         *                             a default name in the CFNStackName-CFNResourceName-RandomString format is used.
         *                             If the stack name starts with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>, a unique resource name
         *                             is generated that starts with <code>cp-</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(java.lang.String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getEnableManagedDraining}
         * @param enableManagedDraining Managed instance draining facilitates graceful termination of Amazon ECS instances.
         *                              This allows your service workloads to stop safely and be rescheduled to non-terminating instances.
         *                              Infrastructure maintenance and updates are preformed without disruptions to workloads.
         *                              To use managed instance draining, set enableManagedDraining to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableManagedDraining(java.lang.Boolean enableManagedDraining) {
            this.enableManagedDraining = enableManagedDraining;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getEnableManagedScaling}
         * @param enableManagedScaling When enabled the scale-in and scale-out actions of the cluster's Auto Scaling Group will be managed for you.
         *                             This means your cluster will automatically scale instances based on the load your tasks put on the cluster.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling">Using Managed Scaling</a> in the ECS Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableManagedScaling(java.lang.Boolean enableManagedScaling) {
            this.enableManagedScaling = enableManagedScaling;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getEnableManagedTerminationProtection}
         * @param enableManagedTerminationProtection When enabled the Auto Scaling Group will only terminate EC2 instances that no longer have running non-daemon tasks.
         *                                           Scale-in protection will be automatically enabled on instances. When all non-daemon tasks are
         *                                           stopped on an instance, ECS initiates the scale-in process and turns off scale-in protection for the
         *                                           instance. The Auto Scaling Group can then terminate the instance. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-auto-scaling.html#managed-termination-protection">Managed termination
         *                                           protection</a>
         *                                           in the ECS Developer Guide.
         *                                           <p>
         *                                           Managed scaling must also be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableManagedTerminationProtection(java.lang.Boolean enableManagedTerminationProtection) {
            this.enableManagedTerminationProtection = enableManagedTerminationProtection;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getInstanceWarmupPeriod}
         * @param instanceWarmupPeriod The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group.
         *                             Must be between 0 and 10000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceWarmupPeriod(java.lang.Number instanceWarmupPeriod) {
            this.instanceWarmupPeriod = instanceWarmupPeriod;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getMaximumScalingStepSize}
         * @param maximumScalingStepSize Maximum scaling step size.
         *                               In most cases this should be left alone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumScalingStepSize(java.lang.Number maximumScalingStepSize) {
            this.maximumScalingStepSize = maximumScalingStepSize;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getMinimumScalingStepSize}
         * @param minimumScalingStepSize Minimum scaling step size.
         *                               In most cases this should be left alone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumScalingStepSize(java.lang.Number minimumScalingStepSize) {
            this.minimumScalingStepSize = minimumScalingStepSize;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getTargetCapacityPercent}
         * @param targetCapacityPercent Target capacity percent.
         *                              In most cases this should be left alone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacityPercent(java.lang.Number targetCapacityPercent) {
            this.targetCapacityPercent = targetCapacityPercent;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getCanContainersAccessInstanceRole}
         * @param canContainersAccessInstanceRole Specifies whether the containers can access the container instance role.
         * @return {@code this}
         * @deprecated See https://github.com/aws/aws-cdk/discussions/32609
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder canContainersAccessInstanceRole(java.lang.Boolean canContainersAccessInstanceRole) {
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getMachineImageType}
         * @param machineImageType What type of machine image this is.
         *                         Depending on the setting, different UserData will automatically be added
         *                         to the <code>AutoScalingGroup</code> to configure it properly for use with ECS.
         *                         <p>
         *                         If you create an <code>AutoScalingGroup</code> yourself and are adding it via
         *                         <code>addAutoScalingGroup()</code>, you must specify this value. If you are adding an
         *                         <code>autoScalingGroup</code> via <code>addCapacity</code>, this value will be determined
         *                         from the <code>machineImage</code> you pass.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImageType(software.amazon.awscdk.services.ecs.MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getSpotInstanceDraining}
         * @param spotInstanceDraining Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotInstanceDraining(java.lang.Boolean spotInstanceDraining) {
            this.spotInstanceDraining = spotInstanceDraining;
            return this;
        }

        /**
         * Sets the value of {@link AsgCapacityProviderProps#getTopicEncryptionKey}
         * @param topicEncryptionKey If <code>AddAutoScalingGroupCapacityOptions.taskDrainTime</code> is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html">SNS Data Encryption</a> for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicEncryptionKey(software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            this.topicEncryptionKey = topicEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AsgCapacityProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AsgCapacityProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AsgCapacityProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsgCapacityProviderProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final java.lang.String capacityProviderName;
        private final java.lang.Boolean enableManagedDraining;
        private final java.lang.Boolean enableManagedScaling;
        private final java.lang.Boolean enableManagedTerminationProtection;
        private final java.lang.Number instanceWarmupPeriod;
        private final java.lang.Number maximumScalingStepSize;
        private final java.lang.Number minimumScalingStepSize;
        private final java.lang.Number targetCapacityPercent;
        private final java.lang.Boolean canContainersAccessInstanceRole;
        private final software.amazon.awscdk.services.ecs.MachineImageType machineImageType;
        private final java.lang.Boolean spotInstanceDraining;
        private final software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.capacityProviderName = software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableManagedDraining = software.amazon.jsii.Kernel.get(this, "enableManagedDraining", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableManagedScaling = software.amazon.jsii.Kernel.get(this, "enableManagedScaling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableManagedTerminationProtection = software.amazon.jsii.Kernel.get(this, "enableManagedTerminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceWarmupPeriod = software.amazon.jsii.Kernel.get(this, "instanceWarmupPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumScalingStepSize = software.amazon.jsii.Kernel.get(this, "maximumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minimumScalingStepSize = software.amazon.jsii.Kernel.get(this, "minimumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetCapacityPercent = software.amazon.jsii.Kernel.get(this, "targetCapacityPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.canContainersAccessInstanceRole = software.amazon.jsii.Kernel.get(this, "canContainersAccessInstanceRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.machineImageType = software.amazon.jsii.Kernel.get(this, "machineImageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MachineImageType.class));
            this.spotInstanceDraining = software.amazon.jsii.Kernel.get(this, "spotInstanceDraining", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.topicEncryptionKey = software.amazon.jsii.Kernel.get(this, "topicEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(builder.autoScalingGroup, "autoScalingGroup is required");
            this.capacityProviderName = builder.capacityProviderName;
            this.enableManagedDraining = builder.enableManagedDraining;
            this.enableManagedScaling = builder.enableManagedScaling;
            this.enableManagedTerminationProtection = builder.enableManagedTerminationProtection;
            this.instanceWarmupPeriod = builder.instanceWarmupPeriod;
            this.maximumScalingStepSize = builder.maximumScalingStepSize;
            this.minimumScalingStepSize = builder.minimumScalingStepSize;
            this.targetCapacityPercent = builder.targetCapacityPercent;
            this.canContainersAccessInstanceRole = builder.canContainersAccessInstanceRole;
            this.machineImageType = builder.machineImageType;
            this.spotInstanceDraining = builder.spotInstanceDraining;
            this.topicEncryptionKey = builder.topicEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final java.lang.String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        @Override
        public final java.lang.Boolean getEnableManagedDraining() {
            return this.enableManagedDraining;
        }

        @Override
        public final java.lang.Boolean getEnableManagedScaling() {
            return this.enableManagedScaling;
        }

        @Override
        public final java.lang.Boolean getEnableManagedTerminationProtection() {
            return this.enableManagedTerminationProtection;
        }

        @Override
        public final java.lang.Number getInstanceWarmupPeriod() {
            return this.instanceWarmupPeriod;
        }

        @Override
        public final java.lang.Number getMaximumScalingStepSize() {
            return this.maximumScalingStepSize;
        }

        @Override
        public final java.lang.Number getMinimumScalingStepSize() {
            return this.minimumScalingStepSize;
        }

        @Override
        public final java.lang.Number getTargetCapacityPercent() {
            return this.targetCapacityPercent;
        }

        @Override
        public final java.lang.Boolean getCanContainersAccessInstanceRole() {
            return this.canContainersAccessInstanceRole;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.MachineImageType getMachineImageType() {
            return this.machineImageType;
        }

        @Override
        public final java.lang.Boolean getSpotInstanceDraining() {
            return this.spotInstanceDraining;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getTopicEncryptionKey() {
            return this.topicEncryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            if (this.getCapacityProviderName() != null) {
                data.set("capacityProviderName", om.valueToTree(this.getCapacityProviderName()));
            }
            if (this.getEnableManagedDraining() != null) {
                data.set("enableManagedDraining", om.valueToTree(this.getEnableManagedDraining()));
            }
            if (this.getEnableManagedScaling() != null) {
                data.set("enableManagedScaling", om.valueToTree(this.getEnableManagedScaling()));
            }
            if (this.getEnableManagedTerminationProtection() != null) {
                data.set("enableManagedTerminationProtection", om.valueToTree(this.getEnableManagedTerminationProtection()));
            }
            if (this.getInstanceWarmupPeriod() != null) {
                data.set("instanceWarmupPeriod", om.valueToTree(this.getInstanceWarmupPeriod()));
            }
            if (this.getMaximumScalingStepSize() != null) {
                data.set("maximumScalingStepSize", om.valueToTree(this.getMaximumScalingStepSize()));
            }
            if (this.getMinimumScalingStepSize() != null) {
                data.set("minimumScalingStepSize", om.valueToTree(this.getMinimumScalingStepSize()));
            }
            if (this.getTargetCapacityPercent() != null) {
                data.set("targetCapacityPercent", om.valueToTree(this.getTargetCapacityPercent()));
            }
            if (this.getCanContainersAccessInstanceRole() != null) {
                data.set("canContainersAccessInstanceRole", om.valueToTree(this.getCanContainersAccessInstanceRole()));
            }
            if (this.getMachineImageType() != null) {
                data.set("machineImageType", om.valueToTree(this.getMachineImageType()));
            }
            if (this.getSpotInstanceDraining() != null) {
                data.set("spotInstanceDraining", om.valueToTree(this.getSpotInstanceDraining()));
            }
            if (this.getTopicEncryptionKey() != null) {
                data.set("topicEncryptionKey", om.valueToTree(this.getTopicEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AsgCapacityProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AsgCapacityProviderProps.Jsii$Proxy that = (AsgCapacityProviderProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (this.capacityProviderName != null ? !this.capacityProviderName.equals(that.capacityProviderName) : that.capacityProviderName != null) return false;
            if (this.enableManagedDraining != null ? !this.enableManagedDraining.equals(that.enableManagedDraining) : that.enableManagedDraining != null) return false;
            if (this.enableManagedScaling != null ? !this.enableManagedScaling.equals(that.enableManagedScaling) : that.enableManagedScaling != null) return false;
            if (this.enableManagedTerminationProtection != null ? !this.enableManagedTerminationProtection.equals(that.enableManagedTerminationProtection) : that.enableManagedTerminationProtection != null) return false;
            if (this.instanceWarmupPeriod != null ? !this.instanceWarmupPeriod.equals(that.instanceWarmupPeriod) : that.instanceWarmupPeriod != null) return false;
            if (this.maximumScalingStepSize != null ? !this.maximumScalingStepSize.equals(that.maximumScalingStepSize) : that.maximumScalingStepSize != null) return false;
            if (this.minimumScalingStepSize != null ? !this.minimumScalingStepSize.equals(that.minimumScalingStepSize) : that.minimumScalingStepSize != null) return false;
            if (this.targetCapacityPercent != null ? !this.targetCapacityPercent.equals(that.targetCapacityPercent) : that.targetCapacityPercent != null) return false;
            if (this.canContainersAccessInstanceRole != null ? !this.canContainersAccessInstanceRole.equals(that.canContainersAccessInstanceRole) : that.canContainersAccessInstanceRole != null) return false;
            if (this.machineImageType != null ? !this.machineImageType.equals(that.machineImageType) : that.machineImageType != null) return false;
            if (this.spotInstanceDraining != null ? !this.spotInstanceDraining.equals(that.spotInstanceDraining) : that.spotInstanceDraining != null) return false;
            return this.topicEncryptionKey != null ? this.topicEncryptionKey.equals(that.topicEncryptionKey) : that.topicEncryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.capacityProviderName != null ? this.capacityProviderName.hashCode() : 0);
            result = 31 * result + (this.enableManagedDraining != null ? this.enableManagedDraining.hashCode() : 0);
            result = 31 * result + (this.enableManagedScaling != null ? this.enableManagedScaling.hashCode() : 0);
            result = 31 * result + (this.enableManagedTerminationProtection != null ? this.enableManagedTerminationProtection.hashCode() : 0);
            result = 31 * result + (this.instanceWarmupPeriod != null ? this.instanceWarmupPeriod.hashCode() : 0);
            result = 31 * result + (this.maximumScalingStepSize != null ? this.maximumScalingStepSize.hashCode() : 0);
            result = 31 * result + (this.minimumScalingStepSize != null ? this.minimumScalingStepSize.hashCode() : 0);
            result = 31 * result + (this.targetCapacityPercent != null ? this.targetCapacityPercent.hashCode() : 0);
            result = 31 * result + (this.canContainersAccessInstanceRole != null ? this.canContainersAccessInstanceRole.hashCode() : 0);
            result = 31 * result + (this.machineImageType != null ? this.machineImageType.hashCode() : 0);
            result = 31 * result + (this.spotInstanceDraining != null ? this.spotInstanceDraining.hashCode() : 0);
            result = 31 * result + (this.topicEncryptionKey != null ? this.topicEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
