package software.amazon.awscdk.services.ecs;

/**
 * Base construct for a credential specification (CredSpec).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CredentialSpec credentialSpec = new CredentialSpec("prefixId", "fileLocation");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.606Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CredentialSpec")
public class CredentialSpec extends software.amazon.jsii.JsiiObject {

    protected CredentialSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CredentialSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param prefixId This parameter is required.
     * @param fileLocation Location or ARN from where to retrieve the CredSpec file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CredentialSpec(final @org.jetbrains.annotations.NotNull java.lang.String prefixId, final @org.jetbrains.annotations.NotNull java.lang.String fileLocation) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(prefixId, "prefixId is required"), java.util.Objects.requireNonNull(fileLocation, "fileLocation is required") });
    }

    /**
     * Helper method to generate the ARN for a S3 object.
     * <p>
     * Used to avoid duplication of logic in derived classes.
     * <p>
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected static @org.jetbrains.annotations.NotNull java.lang.String arnForS3Object(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CredentialSpec.class, "arnForS3Object", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Helper method to generate the ARN for a SSM parameter.
     * <p>
     * Used to avoid duplication of logic in derived classes.
     * <p>
     * @param parameter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected static @org.jetbrains.annotations.NotNull java.lang.String arnForSsmParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CredentialSpec.class, "arnForSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(parameter, "parameter is required") });
    }

    /**
     * Called when the container is initialized to allow this object to bind to the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CredentialSpecConfig bind() {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CredentialSpecConfig.class));
    }

    /**
     * Location or ARN from where to retrieve the CredSpec file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileLocation() {
        return software.amazon.jsii.Kernel.get(this, "fileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Prefix string based on the type of CredSpec.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrefixId() {
        return software.amazon.jsii.Kernel.get(this, "prefixId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
