package software.amazon.awscdk.services.ecs;

/**
 * The configuration to use when creating a log driver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .memoryLimitMiB(256)
 *         .logging(GenericLogDriver.Builder.create()
 *                 .logDriver("fluentd")
 *                 .options(Map.of(
 *                         "tag", "example-tag"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.678Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.GenericLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(GenericLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GenericLogDriverProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log driver to use for the container.
     * <p>
     * The valid values listed for this parameter are log drivers
     * that the Amazon ECS container agent can communicate with by default.
     * <p>
     * For tasks using the Fargate launch type, the supported log drivers are awslogs and splunk.
     * For tasks using the EC2 launch type, the supported log drivers are awslogs, syslog, gelf, fluentd, splunk, journald, and json-file.
     * <p>
     * For more information about using the awslogs log driver, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
     * in the Amazon Elastic Container Service Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogDriver();

    /**
     * The configuration options to send to the log driver.
     * <p>
     * Default: - the log driver options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOptions() {
        return null;
    }

    /**
     * The secrets to pass to the log configuration.
     * <p>
     * Default: - no secret options provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecretOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GenericLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GenericLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GenericLogDriverProps> {
        java.lang.String logDriver;
        java.util.Map<java.lang.String, java.lang.String> options;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secretOptions;

        /**
         * Sets the value of {@link GenericLogDriverProps#getLogDriver}
         * @param logDriver The log driver to use for the container. This parameter is required.
         *                  The valid values listed for this parameter are log drivers
         *                  that the Amazon ECS container agent can communicate with by default.
         *                  <p>
         *                  For tasks using the Fargate launch type, the supported log drivers are awslogs and splunk.
         *                  For tasks using the EC2 launch type, the supported log drivers are awslogs, syslog, gelf, fluentd, splunk, journald, and json-file.
         *                  <p>
         *                  For more information about using the awslogs log driver, see
         *                  <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
         *                  in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(java.lang.String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link GenericLogDriverProps#getOptions}
         * @param options The configuration options to send to the log driver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link GenericLogDriverProps#getSecretOptions}
         * @param secretOptions The secrets to pass to the log configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secretOptions(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secretOptions) {
            this.secretOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secretOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GenericLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GenericLogDriverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GenericLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GenericLogDriverProps {
        private final java.lang.String logDriver;
        private final java.util.Map<java.lang.String, java.lang.String> options;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secretOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDriver = java.util.Objects.requireNonNull(builder.logDriver, "logDriver is required");
            this.options = builder.options;
            this.secretOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)builder.secretOptions;
        }

        @Override
        public final java.lang.String getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getOptions() {
            return this.options;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecretOptions() {
            return this.secretOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDriver", om.valueToTree(this.getLogDriver()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getSecretOptions() != null) {
                data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.GenericLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GenericLogDriverProps.Jsii$Proxy that = (GenericLogDriverProps.Jsii$Proxy) o;

            if (!logDriver.equals(that.logDriver)) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logDriver.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
            return result;
        }
    }
}
