package software.amazon.awscdk.services.ecs;

/**
 * Interface for ECS load balancer target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.682Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.IEcsLoadBalancerTarget")
@software.amazon.jsii.Jsii.Proxy(IEcsLoadBalancerTarget.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsLoadBalancerTarget extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget {

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * Attach load-balanced target to a TargetGroup.
         * <p>
         * May return JSON to directly add to the [Targets] list, or return undefined
         * if the target will register itself with the load balancer.
         * <p>
         * @param targetGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
            return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
        }

        /**
         * Attach load-balanced target to a TargetGroup.
         * <p>
         * May return JSON to directly add to the [Targets] list, or return undefined
         * if the target will register itself with the load balancer.
         * <p>
         * @param targetGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
            return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
        }

        /**
         * Attach load-balanced target to a classic ELB.
         * <p>
         * @param loadBalancer [disable-awslint:ref-via-interface] The load balancer to attach the target to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
            software.amazon.jsii.Kernel.call(this, "attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEcsLoadBalancerTarget}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEcsLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget.Jsii$Default {

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * Attach load-balanced target to a TargetGroup.
         * <p>
         * May return JSON to directly add to the [Targets] list, or return undefined
         * if the target will register itself with the load balancer.
         * <p>
         * @param targetGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
            return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
        }

        /**
         * Attach load-balanced target to a TargetGroup.
         * <p>
         * May return JSON to directly add to the [Targets] list, or return undefined
         * if the target will register itself with the load balancer.
         * <p>
         * @param targetGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
            return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
        }

        /**
         * Attach load-balanced target to a classic ELB.
         * <p>
         * @param loadBalancer [disable-awslint:ref-via-interface] The load balancer to attach the target to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
            software.amazon.jsii.Kernel.call(this, "attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
        }
    }
}
