package software.amazon.awscdk.services.efs;

/**
 * EFS Replication Configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * // auto generate a regional replication destination file system
 * // auto generate a regional replication destination file system
 * FileSystem.Builder.create(this, "RegionalReplicationFileSystem")
 *         .vpc(vpc)
 *         .replicationConfiguration(ReplicationConfiguration.regionalFileSystem("us-west-2"))
 *         .build();
 * // auto generate a one zone replication destination file system
 * // auto generate a one zone replication destination file system
 * FileSystem.Builder.create(this, "OneZoneReplicationFileSystem")
 *         .vpc(vpc)
 *         .replicationConfiguration(ReplicationConfiguration.oneZoneFileSystem("us-east-1", "us-east-1a"))
 *         .build();
 * FileSystem destinationFileSystem = FileSystem.Builder.create(this, "DestinationFileSystem")
 *         .vpc(vpc)
 *         // set as the read-only file system for use as a replication destination
 *         .replicationOverwriteProtection(ReplicationOverwriteProtection.DISABLED)
 *         .build();
 * // specify the replication destination file system
 * // specify the replication destination file system
 * FileSystem.Builder.create(this, "ReplicationFileSystem")
 *         .vpc(vpc)
 *         .replicationConfiguration(ReplicationConfiguration.existingFileSystem(destinationFileSystem))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.918Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.ReplicationConfiguration")
public abstract class ReplicationConfiguration extends software.amazon.jsii.JsiiObject {

    protected ReplicationConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReplicationConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ReplicationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfigurationProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Specify the existing destination file system for the replication.
     * <p>
     * @param destinationFileSystem The existing destination file system for the replication. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfiguration existingFileSystem(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.ReplicationConfiguration.class, "existingFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class), new Object[] { java.util.Objects.requireNonNull(destinationFileSystem, "destinationFileSystem is required") });
    }

    /**
     * Create a new one zone destination file system for the replication.
     * <p>
     * @param region The AWS Region in which the specified availability zone belongs to. This parameter is required.
     * @param availabilityZone The availability zone name of the destination file system. This parameter is required.
     * @param kmsKey AWS KMS key used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfiguration oneZoneFileSystem(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.NotNull java.lang.String availabilityZone, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey kmsKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.ReplicationConfiguration.class, "oneZoneFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(availabilityZone, "availabilityZone is required"), kmsKey });
    }

    /**
     * Create a new one zone destination file system for the replication.
     * <p>
     * @param region The AWS Region in which the specified availability zone belongs to. This parameter is required.
     * @param availabilityZone The availability zone name of the destination file system. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfiguration oneZoneFileSystem(final @org.jetbrains.annotations.NotNull java.lang.String region, final @org.jetbrains.annotations.NotNull java.lang.String availabilityZone) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.ReplicationConfiguration.class, "oneZoneFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class), new Object[] { java.util.Objects.requireNonNull(region, "region is required"), java.util.Objects.requireNonNull(availabilityZone, "availabilityZone is required") });
    }

    /**
     * Create a new regional destination file system for the replication.
     * <p>
     * @param region The AWS Region in which the destination file system is located.
     * @param kmsKey AWS KMS key used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfiguration regionalFileSystem(final @org.jetbrains.annotations.Nullable java.lang.String region, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey kmsKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.ReplicationConfiguration.class, "regionalFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class), new Object[] { region, kmsKey });
    }

    /**
     * Create a new regional destination file system for the replication.
     * <p>
     * @param region The AWS Region in which the destination file system is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfiguration regionalFileSystem(final @org.jetbrains.annotations.Nullable java.lang.String region) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.ReplicationConfiguration.class, "regionalFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class), new Object[] { region });
    }

    /**
     * Create a new regional destination file system for the replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.ReplicationConfiguration regionalFileSystem() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.ReplicationConfiguration.class, "regionalFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ReplicationConfiguration.class));
    }

    /**
     * The availability zone name of the destination file system.
     * <p>
     * One zone file system is used as the destination file system when this property is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The existing destination file system for the replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.IFileSystem getDestinationFileSystem() {
        return software.amazon.jsii.Kernel.get(this, "destinationFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
    }

    /**
     * AWS KMS key used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The AWS Region in which the destination file system is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.efs.ReplicationConfiguration {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
