package software.amazon.awscdk.services.eks;

/**
 * Represents the options required to create an Amazon EKS Access Policy using the <code>fromAccessPolicyName()</code> method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // AmazonEKSClusterAdminPolicy with `cluster` scope
 * AccessPolicy.fromAccessPolicyName("AmazonEKSClusterAdminPolicy", AccessPolicyNameOptions.builder()
 *         .accessScopeType(AccessScopeType.CLUSTER)
 *         .build());
 * // AmazonEKSAdminPolicy with `namespace` scope
 * AccessPolicy.fromAccessPolicyName("AmazonEKSAdminPolicy", AccessPolicyNameOptions.builder()
 *         .accessScopeType(AccessScopeType.NAMESPACE)
 *         .namespaces(List.of("foo", "bar"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:37.946Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessPolicyNameOptions")
@software.amazon.jsii.Jsii.Proxy(AccessPolicyNameOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessPolicyNameOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The scope of the access policy.
     * <p>
     * This determines the level of access granted by the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessScopeType getAccessScopeType();

    /**
     * An optional array of Kubernetes namespaces to which the access policy applies.
     * <p>
     * Default: - no specific namespaces for this scope
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNamespaces() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AccessPolicyNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPolicyNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPolicyNameOptions> {
        software.amazon.awscdk.services.eks.AccessScopeType accessScopeType;
        java.util.List<java.lang.String> namespaces;

        /**
         * Sets the value of {@link AccessPolicyNameOptions#getAccessScopeType}
         * @param accessScopeType The scope of the access policy. This parameter is required.
         *                        This determines the level of access granted by the policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessScopeType(software.amazon.awscdk.services.eks.AccessScopeType accessScopeType) {
            this.accessScopeType = accessScopeType;
            return this;
        }

        /**
         * Sets the value of {@link AccessPolicyNameOptions#getNamespaces}
         * @param namespaces An optional array of Kubernetes namespaces to which the access policy applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaces(java.util.List<java.lang.String> namespaces) {
            this.namespaces = namespaces;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPolicyNameOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessPolicyNameOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPolicyNameOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPolicyNameOptions {
        private final software.amazon.awscdk.services.eks.AccessScopeType accessScopeType;
        private final java.util.List<java.lang.String> namespaces;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessScopeType = software.amazon.jsii.Kernel.get(this, "accessScopeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessScopeType.class));
            this.namespaces = software.amazon.jsii.Kernel.get(this, "namespaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessScopeType = java.util.Objects.requireNonNull(builder.accessScopeType, "accessScopeType is required");
            this.namespaces = builder.namespaces;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AccessScopeType getAccessScopeType() {
            return this.accessScopeType;
        }

        @Override
        public final java.util.List<java.lang.String> getNamespaces() {
            return this.namespaces;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessScopeType", om.valueToTree(this.getAccessScopeType()));
            if (this.getNamespaces() != null) {
                data.set("namespaces", om.valueToTree(this.getNamespaces()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AccessPolicyNameOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPolicyNameOptions.Jsii$Proxy that = (AccessPolicyNameOptions.Jsii$Proxy) o;

            if (!accessScopeType.equals(that.accessScopeType)) return false;
            return this.namespaces != null ? this.namespaces.equals(that.namespaces) : that.namespaces == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessScopeType.hashCode();
            result = 31 * result + (this.namespaces != null ? this.namespaces.hashCode() : 0);
            return result;
        }
    }
}
