package software.amazon.awscdk.services.eks;

/**
 * The remote access (SSH) configuration to use with your node group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.eks.*;
 * SecurityGroup securityGroup;
 * NodegroupRemoteAccess nodegroupRemoteAccess = NodegroupRemoteAccess.builder()
 *         .sshKeyName("sshKeyName")
 *         // the properties below are optional
 *         .sourceSecurityGroups(List.of(securityGroup))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:38.090Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.NodegroupRemoteAccess")
@software.amazon.jsii.Jsii.Proxy(NodegroupRemoteAccess.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NodegroupRemoteAccess extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon EC2 SSH key that provides access for SSH communication with the worker nodes in the managed node group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSshKeyName();

    /**
     * The security groups that are allowed SSH access (port 22) to the worker nodes.
     * <p>
     * If you specify an Amazon EC2 SSH
     * key but do not specify a source security group when you create a managed node group, then port 22 on the worker
     * nodes is opened to the internet (0.0.0.0/0).
     * <p>
     * Default: - port 22 on the worker nodes is opened to the internet (0.0.0.0/0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSourceSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NodegroupRemoteAccess}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NodegroupRemoteAccess}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NodegroupRemoteAccess> {
        java.lang.String sshKeyName;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> sourceSecurityGroups;

        /**
         * Sets the value of {@link NodegroupRemoteAccess#getSshKeyName}
         * @param sshKeyName The Amazon EC2 SSH key that provides access for SSH communication with the worker nodes in the managed node group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshKeyName(java.lang.String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupRemoteAccess#getSourceSecurityGroups}
         * @param sourceSecurityGroups The security groups that are allowed SSH access (port 22) to the worker nodes.
         *                             If you specify an Amazon EC2 SSH
         *                             key but do not specify a source security group when you create a managed node group, then port 22 on the worker
         *                             nodes is opened to the internet (0.0.0.0/0).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sourceSecurityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> sourceSecurityGroups) {
            this.sourceSecurityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)sourceSecurityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NodegroupRemoteAccess}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NodegroupRemoteAccess build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NodegroupRemoteAccess}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodegroupRemoteAccess {
        private final java.lang.String sshKeyName;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> sourceSecurityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sshKeyName = software.amazon.jsii.Kernel.get(this, "sshKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceSecurityGroups = software.amazon.jsii.Kernel.get(this, "sourceSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sshKeyName = java.util.Objects.requireNonNull(builder.sshKeyName, "sshKeyName is required");
            this.sourceSecurityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.sourceSecurityGroups;
        }

        @Override
        public final java.lang.String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSourceSecurityGroups() {
            return this.sourceSecurityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sshKeyName", om.valueToTree(this.getSshKeyName()));
            if (this.getSourceSecurityGroups() != null) {
                data.set("sourceSecurityGroups", om.valueToTree(this.getSourceSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.NodegroupRemoteAccess"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NodegroupRemoteAccess.Jsii$Proxy that = (NodegroupRemoteAccess.Jsii$Proxy) o;

            if (!sshKeyName.equals(that.sshKeyName)) return false;
            return this.sourceSecurityGroups != null ? this.sourceSecurityGroups.equals(that.sourceSecurityGroups) : that.sourceSecurityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sshKeyName.hashCode();
            result = 31 * result + (this.sourceSecurityGroups != null ? this.sourceSecurityGroups.hashCode() : 0);
            return result;
        }
    }
}
