package software.amazon.awscdk.services.elasticache;

/**
 * Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region.
 * <p>
 * The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.
 * <p>
 * <ul>
 * <li>The <em>GlobalReplicationGroupIdSuffix</em> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnGlobalReplicationGroup cfnGlobalReplicationGroup = CfnGlobalReplicationGroup.Builder.create(this, "MyCfnGlobalReplicationGroup")
 *         .members(List.of(GlobalReplicationGroupMemberProperty.builder()
 *                 .replicationGroupId("replicationGroupId")
 *                 .replicationGroupRegion("replicationGroupRegion")
 *                 .role("role")
 *                 .build()))
 *         // the properties below are optional
 *         .automaticFailoverEnabled(false)
 *         .cacheNodeType("cacheNodeType")
 *         .cacheParameterGroupName("cacheParameterGroupName")
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .globalNodeGroupCount(123)
 *         .globalReplicationGroupDescription("globalReplicationGroupDescription")
 *         .globalReplicationGroupIdSuffix("globalReplicationGroupIdSuffix")
 *         .regionalConfigurations(List.of(RegionalConfigurationProperty.builder()
 *                 .replicationGroupId("replicationGroupId")
 *                 .replicationGroupRegion("replicationGroupRegion")
 *                 .reshardingConfigurations(List.of(ReshardingConfigurationProperty.builder()
 *                         .nodeGroupId("nodeGroupId")
 *                         .preferredAvailabilityZones(List.of("preferredAvailabilityZones"))
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:38.123Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup")
public class CfnGlobalReplicationGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnGlobalReplicationGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGlobalReplicationGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGlobalReplicationGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID used to associate a secondary cluster to the Global Replication Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGlobalReplicationGroupId() {
        return software.amazon.jsii.Kernel.get(this, "attrGlobalReplicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the Global Datastore.
     * <p>
     * Can be <code>Creating</code> , <code>Modifying</code> , <code>Available</code> , <code>Deleting</code> or <code>Primary-Only</code> . Primary-only status indicates the global datastore contains only a primary cluster. Either all secondary clusters are deleted or not successfully created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The replication groups that comprise the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMembers() {
        return software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The replication groups that comprise the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMembers(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "members", java.util.Objects.requireNonNull(value, "members is required"));
    }

    /**
     * The replication groups that comprise the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMembers(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.GlobalReplicationGroupMemberProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.GlobalReplicationGroupMemberProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "members", java.util.Objects.requireNonNull(value, "members is required"));
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFailoverEnabled() {
        return software.amazon.jsii.Kernel.get(this, "automaticFailoverEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticFailoverEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "automaticFailoverEnabled", value);
    }

    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutomaticFailoverEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "automaticFailoverEnabled", value);
    }

    /**
     * The cache node type of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheNodeType() {
        return software.amazon.jsii.Kernel.get(this, "cacheNodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cache node type of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheNodeType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheNodeType", value);
    }

    /**
     * The name of the cache parameter group to use with the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "cacheParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cache parameter group to use with the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheParameterGroupName", value);
    }

    /**
     * The ElastiCache engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ElastiCache engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The Elasticache Valkey or Redis OSS engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Elasticache Valkey or Redis OSS engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The number of node groups that comprise the Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getGlobalNodeGroupCount() {
        return software.amazon.jsii.Kernel.get(this, "globalNodeGroupCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of node groups that comprise the Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalNodeGroupCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "globalNodeGroupCount", value);
    }

    /**
     * The optional description of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalReplicationGroupDescription() {
        return software.amazon.jsii.Kernel.get(this, "globalReplicationGroupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The optional description of the Global datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalReplicationGroupDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalReplicationGroupDescription", value);
    }

    /**
     * The suffix name of a Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalReplicationGroupIdSuffix() {
        return software.amazon.jsii.Kernel.get(this, "globalReplicationGroupIdSuffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The suffix name of a Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalReplicationGroupIdSuffix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalReplicationGroupIdSuffix", value);
    }

    /**
     * The Regions that comprise the Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRegionalConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "regionalConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Regions that comprise the Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegionalConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "regionalConfigurations", value);
    }

    /**
     * The Regions that comprise the Global Datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegionalConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.RegionalConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup.RegionalConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "regionalConfigurations", value);
    }
    /**
     * A member of a Global datastore.
     * <p>
     * It contains the Replication Group Id, the Amazon region and the role of the replication group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * GlobalReplicationGroupMemberProperty globalReplicationGroupMemberProperty = GlobalReplicationGroupMemberProperty.builder()
     *         .replicationGroupId("replicationGroupId")
     *         .replicationGroupRegion("replicationGroupRegion")
     *         .role("role")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup.GlobalReplicationGroupMemberProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalReplicationGroupMemberProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalReplicationGroupMemberProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The replication group id of the Global datastore member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupmember-replicationgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupmember-replicationgroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationGroupId() {
            return null;
        }

        /**
         * The Amazon region of the Global datastore member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupmember-replicationgroupregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupmember-replicationgroupregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationGroupRegion() {
            return null;
        }

        /**
         * Indicates the role of the replication group, <code>PRIMARY</code> or <code>SECONDARY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupmember-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-globalreplicationgroupmember.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupmember-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalReplicationGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalReplicationGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalReplicationGroupMemberProperty> {
            java.lang.String replicationGroupId;
            java.lang.String replicationGroupRegion;
            java.lang.String role;

            /**
             * Sets the value of {@link GlobalReplicationGroupMemberProperty#getReplicationGroupId}
             * @param replicationGroupId The replication group id of the Global datastore member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationGroupId(java.lang.String replicationGroupId) {
                this.replicationGroupId = replicationGroupId;
                return this;
            }

            /**
             * Sets the value of {@link GlobalReplicationGroupMemberProperty#getReplicationGroupRegion}
             * @param replicationGroupRegion The Amazon region of the Global datastore member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationGroupRegion(java.lang.String replicationGroupRegion) {
                this.replicationGroupRegion = replicationGroupRegion;
                return this;
            }

            /**
             * Sets the value of {@link GlobalReplicationGroupMemberProperty#getRole}
             * @param role Indicates the role of the replication group, <code>PRIMARY</code> or <code>SECONDARY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalReplicationGroupMemberProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalReplicationGroupMemberProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalReplicationGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalReplicationGroupMemberProperty {
            private final java.lang.String replicationGroupId;
            private final java.lang.String replicationGroupRegion;
            private final java.lang.String role;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replicationGroupId = software.amazon.jsii.Kernel.get(this, "replicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replicationGroupRegion = software.amazon.jsii.Kernel.get(this, "replicationGroupRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicationGroupId = builder.replicationGroupId;
                this.replicationGroupRegion = builder.replicationGroupRegion;
                this.role = builder.role;
            }

            @Override
            public final java.lang.String getReplicationGroupId() {
                return this.replicationGroupId;
            }

            @Override
            public final java.lang.String getReplicationGroupRegion() {
                return this.replicationGroupRegion;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplicationGroupId() != null) {
                    data.set("replicationGroupId", om.valueToTree(this.getReplicationGroupId()));
                }
                if (this.getReplicationGroupRegion() != null) {
                    data.set("replicationGroupRegion", om.valueToTree(this.getReplicationGroupRegion()));
                }
                if (this.getRole() != null) {
                    data.set("role", om.valueToTree(this.getRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup.GlobalReplicationGroupMemberProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalReplicationGroupMemberProperty.Jsii$Proxy that = (GlobalReplicationGroupMemberProperty.Jsii$Proxy) o;

                if (this.replicationGroupId != null ? !this.replicationGroupId.equals(that.replicationGroupId) : that.replicationGroupId != null) return false;
                if (this.replicationGroupRegion != null ? !this.replicationGroupRegion.equals(that.replicationGroupRegion) : that.replicationGroupRegion != null) return false;
                return this.role != null ? this.role.equals(that.role) : that.role == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replicationGroupId != null ? this.replicationGroupId.hashCode() : 0;
                result = 31 * result + (this.replicationGroupRegion != null ? this.replicationGroupRegion.hashCode() : 0);
                result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of the replication groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * RegionalConfigurationProperty regionalConfigurationProperty = RegionalConfigurationProperty.builder()
     *         .replicationGroupId("replicationGroupId")
     *         .replicationGroupRegion("replicationGroupRegion")
     *         .reshardingConfigurations(List.of(ReshardingConfigurationProperty.builder()
     *                 .nodeGroupId("nodeGroupId")
     *                 .preferredAvailabilityZones(List.of("preferredAvailabilityZones"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup.RegionalConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RegionalConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegionalConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secondary cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html#cfn-elasticache-globalreplicationgroup-regionalconfiguration-replicationgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html#cfn-elasticache-globalreplicationgroup-regionalconfiguration-replicationgroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationGroupId() {
            return null;
        }

        /**
         * The Amazon region where the cluster is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html#cfn-elasticache-globalreplicationgroup-regionalconfiguration-replicationgroupregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html#cfn-elasticache-globalreplicationgroup-regionalconfiguration-replicationgroupregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplicationGroupRegion() {
            return null;
        }

        /**
         * A list of PreferredAvailabilityZones objects that specifies the configuration of a node group in the resharded cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html#cfn-elasticache-globalreplicationgroup-regionalconfiguration-reshardingconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-regionalconfiguration.html#cfn-elasticache-globalreplicationgroup-regionalconfiguration-reshardingconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReshardingConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegionalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegionalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegionalConfigurationProperty> {
            java.lang.String replicationGroupId;
            java.lang.String replicationGroupRegion;
            java.lang.Object reshardingConfigurations;

            /**
             * Sets the value of {@link RegionalConfigurationProperty#getReplicationGroupId}
             * @param replicationGroupId The name of the secondary cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationGroupId(java.lang.String replicationGroupId) {
                this.replicationGroupId = replicationGroupId;
                return this;
            }

            /**
             * Sets the value of {@link RegionalConfigurationProperty#getReplicationGroupRegion}
             * @param replicationGroupRegion The Amazon region where the cluster is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationGroupRegion(java.lang.String replicationGroupRegion) {
                this.replicationGroupRegion = replicationGroupRegion;
                return this;
            }

            /**
             * Sets the value of {@link RegionalConfigurationProperty#getReshardingConfigurations}
             * @param reshardingConfigurations A list of PreferredAvailabilityZones objects that specifies the configuration of a node group in the resharded cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reshardingConfigurations(software.amazon.awscdk.IResolvable reshardingConfigurations) {
                this.reshardingConfigurations = reshardingConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link RegionalConfigurationProperty#getReshardingConfigurations}
             * @param reshardingConfigurations A list of PreferredAvailabilityZones objects that specifies the configuration of a node group in the resharded cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reshardingConfigurations(java.util.List<? extends java.lang.Object> reshardingConfigurations) {
                this.reshardingConfigurations = reshardingConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegionalConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegionalConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegionalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegionalConfigurationProperty {
            private final java.lang.String replicationGroupId;
            private final java.lang.String replicationGroupRegion;
            private final java.lang.Object reshardingConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replicationGroupId = software.amazon.jsii.Kernel.get(this, "replicationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replicationGroupRegion = software.amazon.jsii.Kernel.get(this, "replicationGroupRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.reshardingConfigurations = software.amazon.jsii.Kernel.get(this, "reshardingConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replicationGroupId = builder.replicationGroupId;
                this.replicationGroupRegion = builder.replicationGroupRegion;
                this.reshardingConfigurations = builder.reshardingConfigurations;
            }

            @Override
            public final java.lang.String getReplicationGroupId() {
                return this.replicationGroupId;
            }

            @Override
            public final java.lang.String getReplicationGroupRegion() {
                return this.replicationGroupRegion;
            }

            @Override
            public final java.lang.Object getReshardingConfigurations() {
                return this.reshardingConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplicationGroupId() != null) {
                    data.set("replicationGroupId", om.valueToTree(this.getReplicationGroupId()));
                }
                if (this.getReplicationGroupRegion() != null) {
                    data.set("replicationGroupRegion", om.valueToTree(this.getReplicationGroupRegion()));
                }
                if (this.getReshardingConfigurations() != null) {
                    data.set("reshardingConfigurations", om.valueToTree(this.getReshardingConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup.RegionalConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegionalConfigurationProperty.Jsii$Proxy that = (RegionalConfigurationProperty.Jsii$Proxy) o;

                if (this.replicationGroupId != null ? !this.replicationGroupId.equals(that.replicationGroupId) : that.replicationGroupId != null) return false;
                if (this.replicationGroupRegion != null ? !this.replicationGroupRegion.equals(that.replicationGroupRegion) : that.replicationGroupRegion != null) return false;
                return this.reshardingConfigurations != null ? this.reshardingConfigurations.equals(that.reshardingConfigurations) : that.reshardingConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replicationGroupId != null ? this.replicationGroupId.hashCode() : 0;
                result = 31 * result + (this.replicationGroupRegion != null ? this.replicationGroupRegion.hashCode() : 0);
                result = 31 * result + (this.reshardingConfigurations != null ? this.reshardingConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * ReshardingConfigurationProperty reshardingConfigurationProperty = ReshardingConfigurationProperty.builder()
     *         .nodeGroupId("nodeGroupId")
     *         .preferredAvailabilityZones(List.of("preferredAvailabilityZones"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-reshardingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-reshardingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup.ReshardingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReshardingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReshardingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Either the ElastiCache supplied 4-digit id or a user supplied id for the node group these configuration values apply to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-reshardingconfiguration.html#cfn-elasticache-globalreplicationgroup-reshardingconfiguration-nodegroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-reshardingconfiguration.html#cfn-elasticache-globalreplicationgroup-reshardingconfiguration-nodegroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNodeGroupId() {
            return null;
        }

        /**
         * A list of preferred availability zones for the nodes in this cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-reshardingconfiguration.html#cfn-elasticache-globalreplicationgroup-reshardingconfiguration-preferredavailabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-globalreplicationgroup-reshardingconfiguration.html#cfn-elasticache-globalreplicationgroup-reshardingconfiguration-preferredavailabilityzones</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreferredAvailabilityZones() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReshardingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReshardingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReshardingConfigurationProperty> {
            java.lang.String nodeGroupId;
            java.util.List<java.lang.String> preferredAvailabilityZones;

            /**
             * Sets the value of {@link ReshardingConfigurationProperty#getNodeGroupId}
             * @param nodeGroupId Either the ElastiCache supplied 4-digit id or a user supplied id for the node group these configuration values apply to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeGroupId(java.lang.String nodeGroupId) {
                this.nodeGroupId = nodeGroupId;
                return this;
            }

            /**
             * Sets the value of {@link ReshardingConfigurationProperty#getPreferredAvailabilityZones}
             * @param preferredAvailabilityZones A list of preferred availability zones for the nodes in this cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredAvailabilityZones(java.util.List<java.lang.String> preferredAvailabilityZones) {
                this.preferredAvailabilityZones = preferredAvailabilityZones;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReshardingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReshardingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReshardingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReshardingConfigurationProperty {
            private final java.lang.String nodeGroupId;
            private final java.util.List<java.lang.String> preferredAvailabilityZones;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nodeGroupId = software.amazon.jsii.Kernel.get(this, "nodeGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preferredAvailabilityZones = software.amazon.jsii.Kernel.get(this, "preferredAvailabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nodeGroupId = builder.nodeGroupId;
                this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
            }

            @Override
            public final java.lang.String getNodeGroupId() {
                return this.nodeGroupId;
            }

            @Override
            public final java.util.List<java.lang.String> getPreferredAvailabilityZones() {
                return this.preferredAvailabilityZones;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNodeGroupId() != null) {
                    data.set("nodeGroupId", om.valueToTree(this.getNodeGroupId()));
                }
                if (this.getPreferredAvailabilityZones() != null) {
                    data.set("preferredAvailabilityZones", om.valueToTree(this.getPreferredAvailabilityZones()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnGlobalReplicationGroup.ReshardingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReshardingConfigurationProperty.Jsii$Proxy that = (ReshardingConfigurationProperty.Jsii$Proxy) o;

                if (this.nodeGroupId != null ? !this.nodeGroupId.equals(that.nodeGroupId) : that.nodeGroupId != null) return false;
                return this.preferredAvailabilityZones != null ? this.preferredAvailabilityZones.equals(that.preferredAvailabilityZones) : that.preferredAvailabilityZones == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nodeGroupId != null ? this.nodeGroupId.hashCode() : 0;
                result = 31 * result + (this.preferredAvailabilityZones != null ? this.preferredAvailabilityZones.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroupProps.Builder();
        }

        /**
         * The replication groups that comprise the Global datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-members</a>
         * @param members The replication groups that comprise the Global datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(final software.amazon.awscdk.IResolvable members) {
            this.props.members(members);
            return this;
        }
        /**
         * The replication groups that comprise the Global datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-members</a>
         * @param members The replication groups that comprise the Global datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(final java.util.List<? extends java.lang.Object> members) {
            this.props.members(members);
            return this;
        }

        /**
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         * <p>
         * <code>AutomaticFailoverEnabled</code> must be enabled for Valkey or Redis OSS (cluster mode enabled) replication groups.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-automaticfailoverenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-automaticfailoverenabled</a>
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(final java.lang.Boolean automaticFailoverEnabled) {
            this.props.automaticFailoverEnabled(automaticFailoverEnabled);
            return this;
        }
        /**
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         * <p>
         * <code>AutomaticFailoverEnabled</code> must be enabled for Valkey or Redis OSS (cluster mode enabled) replication groups.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-automaticfailoverenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-automaticfailoverenabled</a>
         * @param automaticFailoverEnabled Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticFailoverEnabled(final software.amazon.awscdk.IResolvable automaticFailoverEnabled) {
            this.props.automaticFailoverEnabled(automaticFailoverEnabled);
            return this;
        }

        /**
         * The cache node type of the Global datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cachenodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cachenodetype</a>
         * @param cacheNodeType The cache node type of the Global datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNodeType(final java.lang.String cacheNodeType) {
            this.props.cacheNodeType(cacheNodeType);
            return this;
        }

        /**
         * The name of the cache parameter group to use with the Global datastore.
         * <p>
         * It must be compatible with the major engine version used by the Global datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cacheparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-cacheparametergroupname</a>
         * @param cacheParameterGroupName The name of the cache parameter group to use with the Global datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheParameterGroupName(final java.lang.String cacheParameterGroupName) {
            this.props.cacheParameterGroupName(cacheParameterGroupName);
            return this;
        }

        /**
         * The ElastiCache engine.
         * <p>
         * For Valkey or Redis OSS only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engine</a>
         * @param engine The ElastiCache engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The Elasticache Valkey or Redis OSS engine version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-engineversion</a>
         * @param engineVersion The Elasticache Valkey or Redis OSS engine version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * The number of node groups that comprise the Global Datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalnodegroupcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalnodegroupcount</a>
         * @param globalNodeGroupCount The number of node groups that comprise the Global Datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNodeGroupCount(final java.lang.Number globalNodeGroupCount) {
            this.props.globalNodeGroupCount(globalNodeGroupCount);
            return this;
        }

        /**
         * The optional description of the Global datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupdescription</a>
         * @param globalReplicationGroupDescription The optional description of the Global datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalReplicationGroupDescription(final java.lang.String globalReplicationGroupDescription) {
            this.props.globalReplicationGroupDescription(globalReplicationGroupDescription);
            return this;
        }

        /**
         * The suffix name of a Global Datastore.
         * <p>
         * The suffix guarantees uniqueness of the Global Datastore name across multiple regions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupidsuffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-globalreplicationgroupidsuffix</a>
         * @param globalReplicationGroupIdSuffix The suffix name of a Global Datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalReplicationGroupIdSuffix(final java.lang.String globalReplicationGroupIdSuffix) {
            this.props.globalReplicationGroupIdSuffix(globalReplicationGroupIdSuffix);
            return this;
        }

        /**
         * The Regions that comprise the Global Datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-regionalconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-regionalconfigurations</a>
         * @param regionalConfigurations The Regions that comprise the Global Datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalConfigurations(final software.amazon.awscdk.IResolvable regionalConfigurations) {
            this.props.regionalConfigurations(regionalConfigurations);
            return this;
        }
        /**
         * The Regions that comprise the Global Datastore.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-regionalconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-globalreplicationgroup.html#cfn-elasticache-globalreplicationgroup-regionalconfigurations</a>
         * @param regionalConfigurations The Regions that comprise the Global Datastore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalConfigurations(final java.util.List<? extends java.lang.Object> regionalConfigurations) {
            this.props.regionalConfigurations(regionalConfigurations);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup build() {
            return new software.amazon.awscdk.services.elasticache.CfnGlobalReplicationGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
