package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a <code>CfnCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:38.490Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A specification of the number and type of Amazon EC2 instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-instances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-instances</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInstances();

    /**
     * Also called instance profile and Amazon EC2 role.
     * <p>
     * An IAM role for an Amazon EMR cluster. The Amazon EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code> . In order to use the default role, you must have already created it using the AWS CLI or console.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-jobflowrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-jobflowrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobFlowRole();

    /**
     * The name of the cluster.
     * <p>
     * This parameter can't contain the characters &lt;, &gt;, $, |, or ` (backtick).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The IAM role that Amazon EMR assumes in order to access AWS resources on your behalf.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-servicerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-servicerole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceRole();

    /**
     * A JSON string for selecting additional features.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-additionalinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-additionalinfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInfo() {
        return null;
    }

    /**
     * The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-applications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-applications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplications() {
        return null;
    }

    /**
     * An IAM role for automatic scaling policies.
     * <p>
     * The default role is <code>EMR_AutoScaling_DefaultRole</code> . The IAM role provides permissions that the automatic scaling feature requires to launch and terminate Amazon EC2 instances in an instance group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-autoscalingrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-autoscalingrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingRole() {
        return null;
    }

    /**
     * An auto-termination policy for an Amazon EMR cluster.
     * <p>
     * An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-autoterminationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-autoterminationpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoTerminationPolicy() {
        return null;
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-bootstrapactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-bootstrapactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBootstrapActions() {
        return null;
    }

    /**
     * Applies only to Amazon EMR releases 4.x and later. The list of configurations that are supplied to the Amazon EMR cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-configurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
        return null;
    }

    /**
     * Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-customamiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-customamiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return null;
    }

    /**
     * The IOPS, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2 instance.
     * <p>
     * Available in Amazon EMR releases 6.15.0 and later.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-ebsrootvolumeiops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-ebsrootvolumeiops</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEbsRootVolumeIops() {
        return null;
    }

    /**
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2 instance.
     * <p>
     * Available in Amazon EMR releases 4.x and later.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-ebsrootvolumesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-ebsrootvolumesize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEbsRootVolumeSize() {
        return null;
    }

    /**
     * The throughput, in MiB/s, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2 instance.
     * <p>
     * Available in Amazon EMR releases 6.15.0 and later.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-ebsrootvolumethroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-ebsrootvolumethroughput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEbsRootVolumeThroughput() {
        return null;
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-kerberosattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-kerberosattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKerberosAttributes() {
        return null;
    }

    /**
     * The AWS KMS key used for encrypting log files.
     * <p>
     * This attribute is only available with Amazon EMR 5.30.0 and later, excluding Amazon EMR 6.0.0.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-logencryptionkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-logencryptionkmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogEncryptionKmsKeyId() {
        return null;
    }

    /**
     * The path to the Amazon S3 location where logs for this cluster are stored.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-loguri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-loguri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
        return null;
    }

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster.
     * <p>
     * The managed scaling policy defines the limits for resources, such as Amazon EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-managedscalingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-managedscalingpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManagedScalingPolicy() {
        return null;
    }

    /**
     * The Amazon Linux release specified in a cluster launch RunJobFlow request.
     * <p>
     * If no Amazon Linux release was specified, the default Amazon Linux release is shown in the response.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-osreleaselabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-osreleaselabel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOsReleaseLabel() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-placementgroupconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-placementgroupconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementGroupConfigs() {
        return null;
    }

    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     * <p>
     * Release labels are in the form <code>emr-x.x.x</code> , where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code> . For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"></a> . The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-releaselabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-releaselabel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseLabel() {
        return null;
    }

    /**
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR releases 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-scaledownbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-scaledownbehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScaleDownBehavior() {
        return null;
    }

    /**
     * The name of the security configuration applied to the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-securityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-securityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * Specifies the number of steps that can be executed concurrently.
     * <p>
     * The default value is <code>1</code> . The maximum value is <code>256</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-stepconcurrencylevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-stepconcurrencylevel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStepConcurrencyLevel() {
        return null;
    }

    /**
     * A list of steps to run.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-steps</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSteps() {
        return null;
    }

    /**
     * A list of tags associated with a cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
     * <p>
     * If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
     * <p>
     * <blockquote>
     * <p>
     * When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-visibletoallusers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-cluster.html#cfn-emr-cluster-visibletoallusers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVisibleToAllUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object instances;
        java.lang.String jobFlowRole;
        java.lang.String name;
        java.lang.String serviceRole;
        java.lang.Object additionalInfo;
        java.lang.Object applications;
        java.lang.String autoScalingRole;
        java.lang.Object autoTerminationPolicy;
        java.lang.Object bootstrapActions;
        java.lang.Object configurations;
        java.lang.String customAmiId;
        java.lang.Number ebsRootVolumeIops;
        java.lang.Number ebsRootVolumeSize;
        java.lang.Number ebsRootVolumeThroughput;
        java.lang.Object kerberosAttributes;
        java.lang.String logEncryptionKmsKeyId;
        java.lang.String logUri;
        java.lang.Object managedScalingPolicy;
        java.lang.String osReleaseLabel;
        java.lang.Object placementGroupConfigs;
        java.lang.String releaseLabel;
        java.lang.String scaleDownBehavior;
        java.lang.String securityConfiguration;
        java.lang.Number stepConcurrencyLevel;
        java.lang.Object steps;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object visibleToAllUsers;

        /**
         * Sets the value of {@link CfnClusterProps#getInstances}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(software.amazon.awscdk.IResolvable instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getInstances}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(software.amazon.awscdk.services.emr.CfnCluster.JobFlowInstancesConfigProperty instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getJobFlowRole}
         * @param jobFlowRole Also called instance profile and Amazon EC2 role. This parameter is required.
         *                    An IAM role for an Amazon EMR cluster. The Amazon EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code> . In order to use the default role, you must have already created it using the AWS CLI or console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobFlowRole(java.lang.String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getName}
         * @param name The name of the cluster. This parameter is required.
         *             This parameter can't contain the characters &lt;, &gt;, $, |, or ` (backtick).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getServiceRole}
         * @param serviceRole The IAM role that Amazon EMR assumes in order to access AWS resources on your behalf. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(java.lang.String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAdditionalInfo}
         * @param additionalInfo A JSON string for selecting additional features.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInfo(java.lang.Object additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getApplications}
         * @param applications The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(software.amazon.awscdk.IResolvable applications) {
            this.applications = applications;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getApplications}
         * @param applications The applications to install on this cluster, for example, Spark, Flink, Oozie, Zeppelin, and so on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(java.util.List<? extends java.lang.Object> applications) {
            this.applications = applications;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAutoScalingRole}
         * @param autoScalingRole An IAM role for automatic scaling policies.
         *                        The default role is <code>EMR_AutoScaling_DefaultRole</code> . The IAM role provides permissions that the automatic scaling feature requires to launch and terminate Amazon EC2 instances in an instance group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingRole(java.lang.String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAutoTerminationPolicy}
         * @param autoTerminationPolicy An auto-termination policy for an Amazon EMR cluster.
         *                              An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoTerminationPolicy(software.amazon.awscdk.IResolvable autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAutoTerminationPolicy}
         * @param autoTerminationPolicy An auto-termination policy for an Amazon EMR cluster.
         *                              An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoTerminationPolicy(software.amazon.awscdk.services.emr.CfnCluster.AutoTerminationPolicyProperty autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getBootstrapActions}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapActions(software.amazon.awscdk.IResolvable bootstrapActions) {
            this.bootstrapActions = bootstrapActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getBootstrapActions}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapActions(java.util.List<? extends java.lang.Object> bootstrapActions) {
            this.bootstrapActions = bootstrapActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getConfigurations}
         * @param configurations Applies only to Amazon EMR releases 4.x and later. The list of configurations that are supplied to the Amazon EMR cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
            this.configurations = configurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getConfigurations}
         * @param configurations Applies only to Amazon EMR releases 4.x and later. The list of configurations that are supplied to the Amazon EMR cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
            this.configurations = configurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getCustomAmiId}
         * @param customAmiId Available only in Amazon EMR releases 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAmiId(java.lang.String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEbsRootVolumeIops}
         * @param ebsRootVolumeIops The IOPS, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2 instance.
         *                          Available in Amazon EMR releases 6.15.0 and later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsRootVolumeIops(java.lang.Number ebsRootVolumeIops) {
            this.ebsRootVolumeIops = ebsRootVolumeIops;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEbsRootVolumeSize}
         * @param ebsRootVolumeSize The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2 instance.
         *                          Available in Amazon EMR releases 4.x and later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsRootVolumeSize(java.lang.Number ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEbsRootVolumeThroughput}
         * @param ebsRootVolumeThroughput The throughput, in MiB/s, of the Amazon EBS root device volume of the Linux AMI that is used for each Amazon EC2 instance.
         *                                Available in Amazon EMR releases 6.15.0 and later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsRootVolumeThroughput(java.lang.Number ebsRootVolumeThroughput) {
            this.ebsRootVolumeThroughput = ebsRootVolumeThroughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKerberosAttributes}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         *                           For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosAttributes(software.amazon.awscdk.IResolvable kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKerberosAttributes}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         *                           For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <em>Amazon EMR Management Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosAttributes(software.amazon.awscdk.services.emr.CfnCluster.KerberosAttributesProperty kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLogEncryptionKmsKeyId}
         * @param logEncryptionKmsKeyId The AWS KMS key used for encrypting log files.
         *                              This attribute is only available with Amazon EMR 5.30.0 and later, excluding Amazon EMR 6.0.0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logEncryptionKmsKeyId(java.lang.String logEncryptionKmsKeyId) {
            this.logEncryptionKmsKeyId = logEncryptionKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLogUri}
         * @param logUri The path to the Amazon S3 location where logs for this cluster are stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logUri(java.lang.String logUri) {
            this.logUri = logUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getManagedScalingPolicy}
         * @param managedScalingPolicy Creates or updates a managed scaling policy for an Amazon EMR cluster.
         *                             The managed scaling policy defines the limits for resources, such as Amazon EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedScalingPolicy(software.amazon.awscdk.IResolvable managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getManagedScalingPolicy}
         * @param managedScalingPolicy Creates or updates a managed scaling policy for an Amazon EMR cluster.
         *                             The managed scaling policy defines the limits for resources, such as Amazon EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedScalingPolicy(software.amazon.awscdk.services.emr.CfnCluster.ManagedScalingPolicyProperty managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOsReleaseLabel}
         * @param osReleaseLabel The Amazon Linux release specified in a cluster launch RunJobFlow request.
         *                       If no Amazon Linux release was specified, the default Amazon Linux release is shown in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder osReleaseLabel(java.lang.String osReleaseLabel) {
            this.osReleaseLabel = osReleaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPlacementGroupConfigs}
         * @param placementGroupConfigs the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupConfigs(software.amazon.awscdk.IResolvable placementGroupConfigs) {
            this.placementGroupConfigs = placementGroupConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getPlacementGroupConfigs}
         * @param placementGroupConfigs the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupConfigs(java.util.List<? extends java.lang.Object> placementGroupConfigs) {
            this.placementGroupConfigs = placementGroupConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getReleaseLabel}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         *                     Release labels are in the form <code>emr-x.x.x</code> , where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code> . For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/"></a> . The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(java.lang.String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getScaleDownBehavior}
         * @param scaleDownBehavior The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         *                          <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR releases 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleDownBehavior(java.lang.String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSecurityConfiguration}
         * @param securityConfiguration The name of the security configuration applied to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getStepConcurrencyLevel}
         * @param stepConcurrencyLevel Specifies the number of steps that can be executed concurrently.
         *                             The default value is <code>1</code> . The maximum value is <code>256</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepConcurrencyLevel(java.lang.Number stepConcurrencyLevel) {
            this.stepConcurrencyLevel = stepConcurrencyLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSteps}
         * @param steps A list of steps to run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(software.amazon.awscdk.IResolvable steps) {
            this.steps = steps;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getSteps}
         * @param steps A list of steps to run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(java.util.List<? extends java.lang.Object> steps) {
            this.steps = steps;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags A list of tags associated with a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVisibleToAllUsers}
         * @param visibleToAllUsers Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
         *                          If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibleToAllUsers(java.lang.Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVisibleToAllUsers}
         * @param visibleToAllUsers Indicates whether the cluster is visible to all IAM users of the AWS account associated with the cluster.
         *                          If this value is set to <code>true</code> , all IAM users of that AWS account can view and manage the cluster if they have the proper policy permissions set. If this value is <code>false</code> , only the IAM user that created the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers action.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          When you create clusters directly through the EMR console or API, this value is set to <code>true</code> by default. However, for <code>AWS::EMR::Cluster</code> resources in CloudFormation, the default is <code>false</code> .
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibleToAllUsers(software.amazon.awscdk.IResolvable visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object instances;
        private final java.lang.String jobFlowRole;
        private final java.lang.String name;
        private final java.lang.String serviceRole;
        private final java.lang.Object additionalInfo;
        private final java.lang.Object applications;
        private final java.lang.String autoScalingRole;
        private final java.lang.Object autoTerminationPolicy;
        private final java.lang.Object bootstrapActions;
        private final java.lang.Object configurations;
        private final java.lang.String customAmiId;
        private final java.lang.Number ebsRootVolumeIops;
        private final java.lang.Number ebsRootVolumeSize;
        private final java.lang.Number ebsRootVolumeThroughput;
        private final java.lang.Object kerberosAttributes;
        private final java.lang.String logEncryptionKmsKeyId;
        private final java.lang.String logUri;
        private final java.lang.Object managedScalingPolicy;
        private final java.lang.String osReleaseLabel;
        private final java.lang.Object placementGroupConfigs;
        private final java.lang.String releaseLabel;
        private final java.lang.String scaleDownBehavior;
        private final java.lang.String securityConfiguration;
        private final java.lang.Number stepConcurrencyLevel;
        private final java.lang.Object steps;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object visibleToAllUsers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobFlowRole = software.amazon.jsii.Kernel.get(this, "jobFlowRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalInfo = software.amazon.jsii.Kernel.get(this, "additionalInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applications = software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoScalingRole = software.amazon.jsii.Kernel.get(this, "autoScalingRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoTerminationPolicy = software.amazon.jsii.Kernel.get(this, "autoTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bootstrapActions = software.amazon.jsii.Kernel.get(this, "bootstrapActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsRootVolumeIops = software.amazon.jsii.Kernel.get(this, "ebsRootVolumeIops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ebsRootVolumeSize = software.amazon.jsii.Kernel.get(this, "ebsRootVolumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ebsRootVolumeThroughput = software.amazon.jsii.Kernel.get(this, "ebsRootVolumeThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kerberosAttributes = software.amazon.jsii.Kernel.get(this, "kerberosAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logEncryptionKmsKeyId = software.amazon.jsii.Kernel.get(this, "logEncryptionKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logUri = software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedScalingPolicy = software.amazon.jsii.Kernel.get(this, "managedScalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.osReleaseLabel = software.amazon.jsii.Kernel.get(this, "osReleaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.placementGroupConfigs = software.amazon.jsii.Kernel.get(this, "placementGroupConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.releaseLabel = software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scaleDownBehavior = software.amazon.jsii.Kernel.get(this, "scaleDownBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stepConcurrencyLevel = software.amazon.jsii.Kernel.get(this, "stepConcurrencyLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.steps = software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.visibleToAllUsers = software.amazon.jsii.Kernel.get(this, "visibleToAllUsers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instances = java.util.Objects.requireNonNull(builder.instances, "instances is required");
            this.jobFlowRole = java.util.Objects.requireNonNull(builder.jobFlowRole, "jobFlowRole is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.serviceRole = java.util.Objects.requireNonNull(builder.serviceRole, "serviceRole is required");
            this.additionalInfo = builder.additionalInfo;
            this.applications = builder.applications;
            this.autoScalingRole = builder.autoScalingRole;
            this.autoTerminationPolicy = builder.autoTerminationPolicy;
            this.bootstrapActions = builder.bootstrapActions;
            this.configurations = builder.configurations;
            this.customAmiId = builder.customAmiId;
            this.ebsRootVolumeIops = builder.ebsRootVolumeIops;
            this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
            this.ebsRootVolumeThroughput = builder.ebsRootVolumeThroughput;
            this.kerberosAttributes = builder.kerberosAttributes;
            this.logEncryptionKmsKeyId = builder.logEncryptionKmsKeyId;
            this.logUri = builder.logUri;
            this.managedScalingPolicy = builder.managedScalingPolicy;
            this.osReleaseLabel = builder.osReleaseLabel;
            this.placementGroupConfigs = builder.placementGroupConfigs;
            this.releaseLabel = builder.releaseLabel;
            this.scaleDownBehavior = builder.scaleDownBehavior;
            this.securityConfiguration = builder.securityConfiguration;
            this.stepConcurrencyLevel = builder.stepConcurrencyLevel;
            this.steps = builder.steps;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.visibleToAllUsers = builder.visibleToAllUsers;
        }

        @Override
        public final java.lang.Object getInstances() {
            return this.instances;
        }

        @Override
        public final java.lang.String getJobFlowRole() {
            return this.jobFlowRole;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final java.lang.Object getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final java.lang.Object getApplications() {
            return this.applications;
        }

        @Override
        public final java.lang.String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final java.lang.Object getAutoTerminationPolicy() {
            return this.autoTerminationPolicy;
        }

        @Override
        public final java.lang.Object getBootstrapActions() {
            return this.bootstrapActions;
        }

        @Override
        public final java.lang.Object getConfigurations() {
            return this.configurations;
        }

        @Override
        public final java.lang.String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final java.lang.Number getEbsRootVolumeIops() {
            return this.ebsRootVolumeIops;
        }

        @Override
        public final java.lang.Number getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public final java.lang.Number getEbsRootVolumeThroughput() {
            return this.ebsRootVolumeThroughput;
        }

        @Override
        public final java.lang.Object getKerberosAttributes() {
            return this.kerberosAttributes;
        }

        @Override
        public final java.lang.String getLogEncryptionKmsKeyId() {
            return this.logEncryptionKmsKeyId;
        }

        @Override
        public final java.lang.String getLogUri() {
            return this.logUri;
        }

        @Override
        public final java.lang.Object getManagedScalingPolicy() {
            return this.managedScalingPolicy;
        }

        @Override
        public final java.lang.String getOsReleaseLabel() {
            return this.osReleaseLabel;
        }

        @Override
        public final java.lang.Object getPlacementGroupConfigs() {
            return this.placementGroupConfigs;
        }

        @Override
        public final java.lang.String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final java.lang.String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final java.lang.Number getStepConcurrencyLevel() {
            return this.stepConcurrencyLevel;
        }

        @Override
        public final java.lang.Object getSteps() {
            return this.steps;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instances", om.valueToTree(this.getInstances()));
            data.set("jobFlowRole", om.valueToTree(this.getJobFlowRole()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            if (this.getAdditionalInfo() != null) {
                data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
            }
            if (this.getApplications() != null) {
                data.set("applications", om.valueToTree(this.getApplications()));
            }
            if (this.getAutoScalingRole() != null) {
                data.set("autoScalingRole", om.valueToTree(this.getAutoScalingRole()));
            }
            if (this.getAutoTerminationPolicy() != null) {
                data.set("autoTerminationPolicy", om.valueToTree(this.getAutoTerminationPolicy()));
            }
            if (this.getBootstrapActions() != null) {
                data.set("bootstrapActions", om.valueToTree(this.getBootstrapActions()));
            }
            if (this.getConfigurations() != null) {
                data.set("configurations", om.valueToTree(this.getConfigurations()));
            }
            if (this.getCustomAmiId() != null) {
                data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
            }
            if (this.getEbsRootVolumeIops() != null) {
                data.set("ebsRootVolumeIops", om.valueToTree(this.getEbsRootVolumeIops()));
            }
            if (this.getEbsRootVolumeSize() != null) {
                data.set("ebsRootVolumeSize", om.valueToTree(this.getEbsRootVolumeSize()));
            }
            if (this.getEbsRootVolumeThroughput() != null) {
                data.set("ebsRootVolumeThroughput", om.valueToTree(this.getEbsRootVolumeThroughput()));
            }
            if (this.getKerberosAttributes() != null) {
                data.set("kerberosAttributes", om.valueToTree(this.getKerberosAttributes()));
            }
            if (this.getLogEncryptionKmsKeyId() != null) {
                data.set("logEncryptionKmsKeyId", om.valueToTree(this.getLogEncryptionKmsKeyId()));
            }
            if (this.getLogUri() != null) {
                data.set("logUri", om.valueToTree(this.getLogUri()));
            }
            if (this.getManagedScalingPolicy() != null) {
                data.set("managedScalingPolicy", om.valueToTree(this.getManagedScalingPolicy()));
            }
            if (this.getOsReleaseLabel() != null) {
                data.set("osReleaseLabel", om.valueToTree(this.getOsReleaseLabel()));
            }
            if (this.getPlacementGroupConfigs() != null) {
                data.set("placementGroupConfigs", om.valueToTree(this.getPlacementGroupConfigs()));
            }
            if (this.getReleaseLabel() != null) {
                data.set("releaseLabel", om.valueToTree(this.getReleaseLabel()));
            }
            if (this.getScaleDownBehavior() != null) {
                data.set("scaleDownBehavior", om.valueToTree(this.getScaleDownBehavior()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getStepConcurrencyLevel() != null) {
                data.set("stepConcurrencyLevel", om.valueToTree(this.getStepConcurrencyLevel()));
            }
            if (this.getSteps() != null) {
                data.set("steps", om.valueToTree(this.getSteps()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisibleToAllUsers() != null) {
                data.set("visibleToAllUsers", om.valueToTree(this.getVisibleToAllUsers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!instances.equals(that.instances)) return false;
            if (!jobFlowRole.equals(that.jobFlowRole)) return false;
            if (!name.equals(that.name)) return false;
            if (!serviceRole.equals(that.serviceRole)) return false;
            if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
            if (this.applications != null ? !this.applications.equals(that.applications) : that.applications != null) return false;
            if (this.autoScalingRole != null ? !this.autoScalingRole.equals(that.autoScalingRole) : that.autoScalingRole != null) return false;
            if (this.autoTerminationPolicy != null ? !this.autoTerminationPolicy.equals(that.autoTerminationPolicy) : that.autoTerminationPolicy != null) return false;
            if (this.bootstrapActions != null ? !this.bootstrapActions.equals(that.bootstrapActions) : that.bootstrapActions != null) return false;
            if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
            if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
            if (this.ebsRootVolumeIops != null ? !this.ebsRootVolumeIops.equals(that.ebsRootVolumeIops) : that.ebsRootVolumeIops != null) return false;
            if (this.ebsRootVolumeSize != null ? !this.ebsRootVolumeSize.equals(that.ebsRootVolumeSize) : that.ebsRootVolumeSize != null) return false;
            if (this.ebsRootVolumeThroughput != null ? !this.ebsRootVolumeThroughput.equals(that.ebsRootVolumeThroughput) : that.ebsRootVolumeThroughput != null) return false;
            if (this.kerberosAttributes != null ? !this.kerberosAttributes.equals(that.kerberosAttributes) : that.kerberosAttributes != null) return false;
            if (this.logEncryptionKmsKeyId != null ? !this.logEncryptionKmsKeyId.equals(that.logEncryptionKmsKeyId) : that.logEncryptionKmsKeyId != null) return false;
            if (this.logUri != null ? !this.logUri.equals(that.logUri) : that.logUri != null) return false;
            if (this.managedScalingPolicy != null ? !this.managedScalingPolicy.equals(that.managedScalingPolicy) : that.managedScalingPolicy != null) return false;
            if (this.osReleaseLabel != null ? !this.osReleaseLabel.equals(that.osReleaseLabel) : that.osReleaseLabel != null) return false;
            if (this.placementGroupConfigs != null ? !this.placementGroupConfigs.equals(that.placementGroupConfigs) : that.placementGroupConfigs != null) return false;
            if (this.releaseLabel != null ? !this.releaseLabel.equals(that.releaseLabel) : that.releaseLabel != null) return false;
            if (this.scaleDownBehavior != null ? !this.scaleDownBehavior.equals(that.scaleDownBehavior) : that.scaleDownBehavior != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.stepConcurrencyLevel != null ? !this.stepConcurrencyLevel.equals(that.stepConcurrencyLevel) : that.stepConcurrencyLevel != null) return false;
            if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.visibleToAllUsers != null ? this.visibleToAllUsers.equals(that.visibleToAllUsers) : that.visibleToAllUsers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instances.hashCode();
            result = 31 * result + (this.jobFlowRole.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.serviceRole.hashCode());
            result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
            result = 31 * result + (this.applications != null ? this.applications.hashCode() : 0);
            result = 31 * result + (this.autoScalingRole != null ? this.autoScalingRole.hashCode() : 0);
            result = 31 * result + (this.autoTerminationPolicy != null ? this.autoTerminationPolicy.hashCode() : 0);
            result = 31 * result + (this.bootstrapActions != null ? this.bootstrapActions.hashCode() : 0);
            result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
            result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
            result = 31 * result + (this.ebsRootVolumeIops != null ? this.ebsRootVolumeIops.hashCode() : 0);
            result = 31 * result + (this.ebsRootVolumeSize != null ? this.ebsRootVolumeSize.hashCode() : 0);
            result = 31 * result + (this.ebsRootVolumeThroughput != null ? this.ebsRootVolumeThroughput.hashCode() : 0);
            result = 31 * result + (this.kerberosAttributes != null ? this.kerberosAttributes.hashCode() : 0);
            result = 31 * result + (this.logEncryptionKmsKeyId != null ? this.logEncryptionKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
            result = 31 * result + (this.managedScalingPolicy != null ? this.managedScalingPolicy.hashCode() : 0);
            result = 31 * result + (this.osReleaseLabel != null ? this.osReleaseLabel.hashCode() : 0);
            result = 31 * result + (this.placementGroupConfigs != null ? this.placementGroupConfigs.hashCode() : 0);
            result = 31 * result + (this.releaseLabel != null ? this.releaseLabel.hashCode() : 0);
            result = 31 * result + (this.scaleDownBehavior != null ? this.scaleDownBehavior.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.stepConcurrencyLevel != null ? this.stepConcurrencyLevel.hashCode() : 0);
            result = 31 * result + (this.steps != null ? this.steps.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visibleToAllUsers != null ? this.visibleToAllUsers.hashCode() : 0);
            return result;
        }
    }
}
