package software.amazon.awscdk.services.events;

/**
 * The input properties for an event target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * RuleTargetInputProperties ruleTargetInputProperties = RuleTargetInputProperties.builder()
 *         .input("input")
 *         .inputPath("inputPath")
 *         .inputPathsMap(Map.of(
 *                 "inputPathsMapKey", "inputPathsMap"))
 *         .inputTemplate("inputTemplate")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:38.683Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.RuleTargetInputProperties")
@software.amazon.jsii.Jsii.Proxy(RuleTargetInputProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuleTargetInputProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * Literal input to the target service (must be valid JSON).
     * <p>
     * Default: - input for the event target. If the input contains a paths map
     * values wil be extracted from event and inserted into the `inputTemplate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
        return null;
    }

    /**
     * JsonPath to take input from the input event.
     * <p>
     * Default: - None. The entire matched event is passed as input
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
        return null;
    }

    /**
     * Paths map to extract values from event and insert into <code>inputTemplate</code>.
     * <p>
     * Default: - No values extracted from event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getInputPathsMap() {
        return null;
    }

    /**
     * Input template to insert paths map into.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuleTargetInputProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuleTargetInputProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuleTargetInputProperties> {
        java.lang.String input;
        java.lang.String inputPath;
        java.util.Map<java.lang.String, java.lang.String> inputPathsMap;
        java.lang.String inputTemplate;

        /**
         * Sets the value of {@link RuleTargetInputProperties#getInput}
         * @param input Literal input to the target service (must be valid JSON).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(java.lang.String input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetInputProperties#getInputPath}
         * @param inputPath JsonPath to take input from the input event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetInputProperties#getInputPathsMap}
         * @param inputPathsMap Paths map to extract values from event and insert into <code>inputTemplate</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPathsMap(java.util.Map<java.lang.String, java.lang.String> inputPathsMap) {
            this.inputPathsMap = inputPathsMap;
            return this;
        }

        /**
         * Sets the value of {@link RuleTargetInputProperties#getInputTemplate}
         * @param inputTemplate Input template to insert paths map into.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputTemplate(java.lang.String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleTargetInputProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuleTargetInputProperties build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuleTargetInputProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleTargetInputProperties {
        private final java.lang.String input;
        private final java.lang.String inputPath;
        private final java.util.Map<java.lang.String, java.lang.String> inputPathsMap;
        private final java.lang.String inputTemplate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputPathsMap = software.amazon.jsii.Kernel.get(this, "inputPathsMap", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.inputTemplate = software.amazon.jsii.Kernel.get(this, "inputTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.input = builder.input;
            this.inputPath = builder.inputPath;
            this.inputPathsMap = builder.inputPathsMap;
            this.inputTemplate = builder.inputTemplate;
        }

        @Override
        public final java.lang.String getInput() {
            return this.input;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getInputPathsMap() {
            return this.inputPathsMap;
        }

        @Override
        public final java.lang.String getInputTemplate() {
            return this.inputTemplate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getInputPathsMap() != null) {
                data.set("inputPathsMap", om.valueToTree(this.getInputPathsMap()));
            }
            if (this.getInputTemplate() != null) {
                data.set("inputTemplate", om.valueToTree(this.getInputTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.RuleTargetInputProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuleTargetInputProperties.Jsii$Proxy that = (RuleTargetInputProperties.Jsii$Proxy) o;

            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.inputPathsMap != null ? !this.inputPathsMap.equals(that.inputPathsMap) : that.inputPathsMap != null) return false;
            return this.inputTemplate != null ? this.inputTemplate.equals(that.inputTemplate) : that.inputTemplate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.input != null ? this.input.hashCode() : 0;
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.inputPathsMap != null ? this.inputPathsMap.hashCode() : 0);
            result = 31 * result + (this.inputTemplate != null ? this.inputTemplate.hashCode() : 0);
            return result;
        }
    }
}
