package software.amazon.awscdk.services.evidently;

/**
 * Properties for defining a <code>CfnFeature</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnFeatureProps cfnFeatureProps = CfnFeatureProps.builder()
 *         .name("name")
 *         .project("project")
 *         .variations(List.of(VariationObjectProperty.builder()
 *                 .variationName("variationName")
 *                 // the properties below are optional
 *                 .booleanValue(false)
 *                 .doubleValue(123)
 *                 .longValue(123)
 *                 .stringValue("stringValue")
 *                 .build()))
 *         // the properties below are optional
 *         .defaultVariation("defaultVariation")
 *         .description("description")
 *         .entityOverrides(List.of(EntityOverrideProperty.builder()
 *                 .entityId("entityId")
 *                 .variation("variation")
 *                 .build()))
 *         .evaluationStrategy("evaluationStrategy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:38.748Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnFeatureProps")
@software.amazon.jsii.Jsii.Proxy(CfnFeatureProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFeatureProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name for the feature.
     * <p>
     * It can include up to 127 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The name or ARN of the project that is to contain the new feature.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-project">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-project</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProject();

    /**
     * An array of structures that contain the configuration of the feature's different variations.
     * <p>
     * Each <code>VariationObject</code> in the <code>Variations</code> array for a feature must have the same type of value ( <code>BooleanValue</code> , <code>DoubleValue</code> , <code>LongValue</code> or <code>StringValue</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-variations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-variations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVariations();

    /**
     * The name of the variation to use as the default variation.
     * <p>
     * The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.
     * <p>
     * This variation must also be listed in the <code>Variations</code> structure.
     * <p>
     * If you omit <code>DefaultVariation</code> , the first variation listed in the <code>Variations</code> structure is used as the default variation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-defaultvariation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-defaultvariation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultVariation() {
        return null;
    }

    /**
     * An optional description of the feature.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specify users that should always be served a specific variation of a feature.
     * <p>
     * Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-entityoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-entityoverrides</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEntityOverrides() {
        return null;
    }

    /**
     * Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments.
     * <p>
     * Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-evaluationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-evaluationstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEvaluationStrategy() {
        return null;
    }

    /**
     * Assigns one or more tags (key-value pairs) to the feature.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with a feature.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-feature.html#cfn-evidently-feature-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFeatureProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFeatureProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFeatureProps> {
        java.lang.String name;
        java.lang.String project;
        java.lang.Object variations;
        java.lang.String defaultVariation;
        java.lang.String description;
        java.lang.Object entityOverrides;
        java.lang.String evaluationStrategy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFeatureProps#getName}
         * @param name The name for the feature. This parameter is required.
         *             It can include up to 127 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getProject}
         * @param project The name or ARN of the project that is to contain the new feature. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getVariations}
         * @param variations An array of structures that contain the configuration of the feature's different variations. This parameter is required.
         *                   Each <code>VariationObject</code> in the <code>Variations</code> array for a feature must have the same type of value ( <code>BooleanValue</code> , <code>DoubleValue</code> , <code>LongValue</code> or <code>StringValue</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variations(software.amazon.awscdk.IResolvable variations) {
            this.variations = variations;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getVariations}
         * @param variations An array of structures that contain the configuration of the feature's different variations. This parameter is required.
         *                   Each <code>VariationObject</code> in the <code>Variations</code> array for a feature must have the same type of value ( <code>BooleanValue</code> , <code>DoubleValue</code> , <code>LongValue</code> or <code>StringValue</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variations(java.util.List<? extends java.lang.Object> variations) {
            this.variations = variations;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getDefaultVariation}
         * @param defaultVariation The name of the variation to use as the default variation.
         *                         The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.
         *                         <p>
         *                         This variation must also be listed in the <code>Variations</code> structure.
         *                         <p>
         *                         If you omit <code>DefaultVariation</code> , the first variation listed in the <code>Variations</code> structure is used as the default variation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultVariation(java.lang.String defaultVariation) {
            this.defaultVariation = defaultVariation;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getDescription}
         * @param description An optional description of the feature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getEntityOverrides}
         * @param entityOverrides Specify users that should always be served a specific variation of a feature.
         *                        Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityOverrides(software.amazon.awscdk.IResolvable entityOverrides) {
            this.entityOverrides = entityOverrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getEntityOverrides}
         * @param entityOverrides Specify users that should always be served a specific variation of a feature.
         *                        Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityOverrides(java.util.List<? extends java.lang.Object> entityOverrides) {
            this.entityOverrides = entityOverrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getEvaluationStrategy}
         * @param evaluationStrategy Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments.
         *                           Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationStrategy(java.lang.String evaluationStrategy) {
            this.evaluationStrategy = evaluationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFeatureProps#getTags}
         * @param tags Assigns one or more tags (key-value pairs) to the feature.
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *             <p>
         *             Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         *             <p>
         *             You can associate as many as 50 tags with a feature.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFeatureProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFeatureProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFeatureProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFeatureProps {
        private final java.lang.String name;
        private final java.lang.String project;
        private final java.lang.Object variations;
        private final java.lang.String defaultVariation;
        private final java.lang.String description;
        private final java.lang.Object entityOverrides;
        private final java.lang.String evaluationStrategy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.variations = software.amazon.jsii.Kernel.get(this, "variations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultVariation = software.amazon.jsii.Kernel.get(this, "defaultVariation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entityOverrides = software.amazon.jsii.Kernel.get(this, "entityOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.evaluationStrategy = software.amazon.jsii.Kernel.get(this, "evaluationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.project = java.util.Objects.requireNonNull(builder.project, "project is required");
            this.variations = java.util.Objects.requireNonNull(builder.variations, "variations is required");
            this.defaultVariation = builder.defaultVariation;
            this.description = builder.description;
            this.entityOverrides = builder.entityOverrides;
            this.evaluationStrategy = builder.evaluationStrategy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.Object getVariations() {
            return this.variations;
        }

        @Override
        public final java.lang.String getDefaultVariation() {
            return this.defaultVariation;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEntityOverrides() {
            return this.entityOverrides;
        }

        @Override
        public final java.lang.String getEvaluationStrategy() {
            return this.evaluationStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("project", om.valueToTree(this.getProject()));
            data.set("variations", om.valueToTree(this.getVariations()));
            if (this.getDefaultVariation() != null) {
                data.set("defaultVariation", om.valueToTree(this.getDefaultVariation()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEntityOverrides() != null) {
                data.set("entityOverrides", om.valueToTree(this.getEntityOverrides()));
            }
            if (this.getEvaluationStrategy() != null) {
                data.set("evaluationStrategy", om.valueToTree(this.getEvaluationStrategy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnFeatureProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFeatureProps.Jsii$Proxy that = (CfnFeatureProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!project.equals(that.project)) return false;
            if (!variations.equals(that.variations)) return false;
            if (this.defaultVariation != null ? !this.defaultVariation.equals(that.defaultVariation) : that.defaultVariation != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.entityOverrides != null ? !this.entityOverrides.equals(that.entityOverrides) : that.entityOverrides != null) return false;
            if (this.evaluationStrategy != null ? !this.evaluationStrategy.equals(that.evaluationStrategy) : that.evaluationStrategy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.project.hashCode());
            result = 31 * result + (this.variations.hashCode());
            result = 31 * result + (this.defaultVariation != null ? this.defaultVariation.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.entityOverrides != null ? this.entityOverrides.hashCode() : 0);
            result = 31 * result + (this.evaluationStrategy != null ? this.evaluationStrategy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
