package software.amazon.awscdk.services.gameliftstreams;

/**
 * Properties for defining a <code>CfnStreamGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gameliftstreams.*;
 * CfnStreamGroupProps cfnStreamGroupProps = CfnStreamGroupProps.builder()
 *         .description("description")
 *         .locationConfigurations(List.of(LocationConfigurationProperty.builder()
 *                 .locationName("locationName")
 *                 // the properties below are optional
 *                 .alwaysOnCapacity(123)
 *                 .onDemandCapacity(123)
 *                 .build()))
 *         .streamClass("streamClass")
 *         // the properties below are optional
 *         .defaultApplication(DefaultApplicationProperty.builder()
 *                 .arn("arn")
 *                 .id("id")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:39.029Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gameliftstreams.CfnStreamGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnStreamGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStreamGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-locationconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLocationConfigurations();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-streamclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-streamclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamClass();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-defaultapplication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultApplication() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-streamgroup.html#cfn-gameliftstreams-streamgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStreamGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStreamGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStreamGroupProps> {
        java.lang.String description;
        java.lang.Object locationConfigurations;
        java.lang.String streamClass;
        java.lang.Object defaultApplication;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnStreamGroupProps#getDescription}
         * @param description the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamGroupProps#getLocationConfigurations}
         * @param locationConfigurations the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationConfigurations(software.amazon.awscdk.IResolvable locationConfigurations) {
            this.locationConfigurations = locationConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamGroupProps#getLocationConfigurations}
         * @param locationConfigurations the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationConfigurations(java.util.List<? extends java.lang.Object> locationConfigurations) {
            this.locationConfigurations = locationConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamGroupProps#getStreamClass}
         * @param streamClass the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamClass(java.lang.String streamClass) {
            this.streamClass = streamClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamGroupProps#getDefaultApplication}
         * @param defaultApplication the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultApplication(software.amazon.awscdk.IResolvable defaultApplication) {
            this.defaultApplication = defaultApplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamGroupProps#getDefaultApplication}
         * @param defaultApplication the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultApplication(software.amazon.awscdk.services.gameliftstreams.CfnStreamGroup.DefaultApplicationProperty defaultApplication) {
            this.defaultApplication = defaultApplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamGroupProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStreamGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStreamGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStreamGroupProps {
        private final java.lang.String description;
        private final java.lang.Object locationConfigurations;
        private final java.lang.String streamClass;
        private final java.lang.Object defaultApplication;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locationConfigurations = software.amazon.jsii.Kernel.get(this, "locationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.streamClass = software.amazon.jsii.Kernel.get(this, "streamClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultApplication = software.amazon.jsii.Kernel.get(this, "defaultApplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.locationConfigurations = java.util.Objects.requireNonNull(builder.locationConfigurations, "locationConfigurations is required");
            this.streamClass = java.util.Objects.requireNonNull(builder.streamClass, "streamClass is required");
            this.defaultApplication = builder.defaultApplication;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getLocationConfigurations() {
            return this.locationConfigurations;
        }

        @Override
        public final java.lang.String getStreamClass() {
            return this.streamClass;
        }

        @Override
        public final java.lang.Object getDefaultApplication() {
            return this.defaultApplication;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("locationConfigurations", om.valueToTree(this.getLocationConfigurations()));
            data.set("streamClass", om.valueToTree(this.getStreamClass()));
            if (this.getDefaultApplication() != null) {
                data.set("defaultApplication", om.valueToTree(this.getDefaultApplication()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gameliftstreams.CfnStreamGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStreamGroupProps.Jsii$Proxy that = (CfnStreamGroupProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!locationConfigurations.equals(that.locationConfigurations)) return false;
            if (!streamClass.equals(that.streamClass)) return false;
            if (this.defaultApplication != null ? !this.defaultApplication.equals(that.defaultApplication) : that.defaultApplication != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.locationConfigurations.hashCode());
            result = 31 * result + (this.streamClass.hashCode());
            result = 31 * result + (this.defaultApplication != null ? this.defaultApplication.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
