package software.amazon.awscdk.services.glue;

/**
 * The <code>AWS::Glue::SchemaVersion</code> is an AWS Glue resource type that manages schema versions of schemas in the AWS Glue Schema Registry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnSchemaVersion cfnSchemaVersion = CfnSchemaVersion.Builder.create(this, "MyCfnSchemaVersion")
 *         .schema(SchemaProperty.builder()
 *                 .registryName("registryName")
 *                 .schemaArn("schemaArn")
 *                 .schemaName("schemaName")
 *                 .build())
 *         .schemaDefinition("schemaDefinition")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:39.148Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnSchemaVersion")
public class CfnSchemaVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSchemaVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSchemaVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnSchemaVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchemaVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnSchemaVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Represents the version ID associated with the schema version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersionId() {
        return software.amazon.jsii.Kernel.get(this, "attrVersionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The schema that includes the schema version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSchema() {
        return software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schema that includes the schema version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchema(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schema", java.util.Objects.requireNonNull(value, "schema is required"));
    }

    /**
     * The schema that includes the schema version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchema(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnSchemaVersion.SchemaProperty value) {
        software.amazon.jsii.Kernel.set(this, "schema", java.util.Objects.requireNonNull(value, "schema is required"));
    }

    /**
     * The schema definition for the schema version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSchemaDefinition() {
        return software.amazon.jsii.Kernel.get(this, "schemaDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The schema definition for the schema version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaDefinition(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schemaDefinition", java.util.Objects.requireNonNull(value, "schemaDefinition is required"));
    }
    /**
     * A wrapper structure to contain schema identity fields.
     * <p>
     * Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * SchemaProperty schemaProperty = SchemaProperty.builder()
     *         .registryName("registryName")
     *         .schemaArn("schemaArn")
     *         .schemaName("schemaName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnSchemaVersion.SchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the registry where the schema is stored.
         * <p>
         * Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-registryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-registryname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegistryName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the schema.
         * <p>
         * Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-schemaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-schemaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaArn() {
            return null;
        }

        /**
         * The name of the schema.
         * <p>
         * Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-schemaname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-schemaversion-schema.html#cfn-glue-schemaversion-schema-schemaname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaProperty> {
            java.lang.String registryName;
            java.lang.String schemaArn;
            java.lang.String schemaName;

            /**
             * Sets the value of {@link SchemaProperty#getRegistryName}
             * @param registryName The name of the registry where the schema is stored.
             *                     Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryName(java.lang.String registryName) {
                this.registryName = registryName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaProperty#getSchemaArn}
             * @param schemaArn The Amazon Resource Name (ARN) of the schema.
             *                  Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaArn(java.lang.String schemaArn) {
                this.schemaArn = schemaArn;
                return this;
            }

            /**
             * Sets the value of {@link SchemaProperty#getSchemaName}
             * @param schemaName The name of the schema.
             *                   Either <code>SchemaArn</code> , or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaName(java.lang.String schemaName) {
                this.schemaName = schemaName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaProperty {
            private final java.lang.String registryName;
            private final java.lang.String schemaArn;
            private final java.lang.String schemaName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.registryName = software.amazon.jsii.Kernel.get(this, "registryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaArn = software.amazon.jsii.Kernel.get(this, "schemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaName = software.amazon.jsii.Kernel.get(this, "schemaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.registryName = builder.registryName;
                this.schemaArn = builder.schemaArn;
                this.schemaName = builder.schemaName;
            }

            @Override
            public final java.lang.String getRegistryName() {
                return this.registryName;
            }

            @Override
            public final java.lang.String getSchemaArn() {
                return this.schemaArn;
            }

            @Override
            public final java.lang.String getSchemaName() {
                return this.schemaName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRegistryName() != null) {
                    data.set("registryName", om.valueToTree(this.getRegistryName()));
                }
                if (this.getSchemaArn() != null) {
                    data.set("schemaArn", om.valueToTree(this.getSchemaArn()));
                }
                if (this.getSchemaName() != null) {
                    data.set("schemaName", om.valueToTree(this.getSchemaName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnSchemaVersion.SchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaProperty.Jsii$Proxy that = (SchemaProperty.Jsii$Proxy) o;

                if (this.registryName != null ? !this.registryName.equals(that.registryName) : that.registryName != null) return false;
                if (this.schemaArn != null ? !this.schemaArn.equals(that.schemaArn) : that.schemaArn != null) return false;
                return this.schemaName != null ? this.schemaName.equals(that.schemaName) : that.schemaName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.registryName != null ? this.registryName.hashCode() : 0;
                result = 31 * result + (this.schemaArn != null ? this.schemaArn.hashCode() : 0);
                result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnSchemaVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnSchemaVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnSchemaVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnSchemaVersionProps.Builder();
        }

        /**
         * The schema that includes the schema version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schema</a>
         * @param schema The schema that includes the schema version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(final software.amazon.awscdk.IResolvable schema) {
            this.props.schema(schema);
            return this;
        }
        /**
         * The schema that includes the schema version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schema</a>
         * @param schema The schema that includes the schema version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(final software.amazon.awscdk.services.glue.CfnSchemaVersion.SchemaProperty schema) {
            this.props.schema(schema);
            return this;
        }

        /**
         * The schema definition for the schema version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schemadefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-schemaversion.html#cfn-glue-schemaversion-schemadefinition</a>
         * @param schemaDefinition The schema definition for the schema version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaDefinition(final java.lang.String schemaDefinition) {
            this.props.schemaDefinition(schemaDefinition);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnSchemaVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnSchemaVersion build() {
            return new software.amazon.awscdk.services.glue.CfnSchemaVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
