package software.amazon.awscdk.services.greengrass;

/**
 * The <code>AWS::Greengrass::LoggerDefinition</code> resource represents a logger definition for AWS IoT Greengrass .
 * <p>
 * Logger definitions are used to organize your logger definition versions.
 * <p>
 * Logger definitions can reference multiple logger definition versions. All logger definition versions must be associated with a logger definition. Each logger definition version can contain one or more loggers.
 * <p>
 * <blockquote>
 * <p>
 * When you create a logger definition, you can optionally include an initial logger definition version. To associate a logger definition version later, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html"><code>AWS::Greengrass::LoggerDefinitionVersion</code></a> resource and specify the ID of this logger definition.
 * <p>
 * After you create the logger definition version that contains the loggers you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object tags;
 * CfnLoggerDefinition cfnLoggerDefinition = CfnLoggerDefinition.Builder.create(this, "MyCfnLoggerDefinition")
 *         .name("name")
 *         // the properties below are optional
 *         .initialVersion(LoggerDefinitionVersionProperty.builder()
 *                 .loggers(List.of(LoggerProperty.builder()
 *                         .component("component")
 *                         .id("id")
 *                         .level("level")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .space(123)
 *                         .build()))
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:39.253Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnLoggerDefinition")
public class CfnLoggerDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnLoggerDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoggerDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnLoggerDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoggerDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnLoggerDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the <code>LoggerDefinition</code> , such as <code>arn:aws:greengrass:us-east-1:  :/greengrass/definition/loggers/1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the <code>LoggerDefinition</code> , such as <code>1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the last <code>LoggerDefinitionVersion</code> that was added to the <code>LoggerDefinition</code> , such as <code>arn:aws:greengrass:us-east-1:  :/greengrass/definition/loggers/1234a5b6-78cd-901e-2fgh-3i45j6k178l9/versions/9876ac30-4bdb-4f9d-95af-b5fdb66be1a2</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>LoggerDefinition</code> , such as <code>MyLoggerDefinition</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the logger definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the logger definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The logger definition version to include when the logger definition is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialVersion() {
        return software.amazon.jsii.Kernel.get(this, "initialVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The logger definition version to include when the logger definition is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * The logger definition version to include when the logger definition is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrass.CfnLoggerDefinition.LoggerDefinitionVersionProperty value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * Application-specific metadata to attach to the logger definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Application-specific metadata to attach to the logger definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A logger definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html">loggers</a> .
     * <p>
     * <blockquote>
     * <p>
     * After you create a logger definition version that contains the loggers you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>LoggerDefinitionVersion</code> is the property type of the <code>InitialVersion</code> property in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html"><code>AWS::Greengrass::LoggerDefinition</code></a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * LoggerDefinitionVersionProperty loggerDefinitionVersionProperty = LoggerDefinitionVersionProperty.builder()
     *         .loggers(List.of(LoggerProperty.builder()
     *                 .component("component")
     *                 .id("id")
     *                 .level("level")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .space(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnLoggerDefinition.LoggerDefinitionVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggerDefinitionVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggerDefinitionVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The loggers in this version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html#cfn-greengrass-loggerdefinition-loggerdefinitionversion-loggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html#cfn-greengrass-loggerdefinition-loggerdefinitionversion-loggers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLoggers();

        /**
         * @return a {@link Builder} of {@link LoggerDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggerDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggerDefinitionVersionProperty> {
            java.lang.Object loggers;

            /**
             * Sets the value of {@link LoggerDefinitionVersionProperty#getLoggers}
             * @param loggers The loggers in this version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggers(software.amazon.awscdk.IResolvable loggers) {
                this.loggers = loggers;
                return this;
            }

            /**
             * Sets the value of {@link LoggerDefinitionVersionProperty#getLoggers}
             * @param loggers The loggers in this version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggers(java.util.List<? extends java.lang.Object> loggers) {
                this.loggers = loggers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggerDefinitionVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggerDefinitionVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggerDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggerDefinitionVersionProperty {
            private final java.lang.Object loggers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.loggers = software.amazon.jsii.Kernel.get(this, "loggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.loggers = java.util.Objects.requireNonNull(builder.loggers, "loggers is required");
            }

            @Override
            public final java.lang.Object getLoggers() {
                return this.loggers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("loggers", om.valueToTree(this.getLoggers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnLoggerDefinition.LoggerDefinitionVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggerDefinitionVersionProperty.Jsii$Proxy that = (LoggerDefinitionVersionProperty.Jsii$Proxy) o;

                return this.loggers.equals(that.loggers);
            }

            @Override
            public final int hashCode() {
                int result = this.loggers.hashCode();
                return result;
            }
        }
    }
    /**
     * A logger represents logging settings for the AWS IoT Greengrass group, which can be stored in CloudWatch and the local file system of your core device.
     * <p>
     * All log entries include a timestamp, log level, and information about the event. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/greengrass-logs-overview.html">Monitoring with AWS IoT Greengrass Logs</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, the <code>Loggers</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html"><code>LoggerDefinitionVersion</code></a> property type contains a list of <code>Logger</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * LoggerProperty loggerProperty = LoggerProperty.builder()
     *         .component("component")
     *         .id("id")
     *         .level("level")
     *         .type("type")
     *         // the properties below are optional
     *         .space(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnLoggerDefinition.LoggerProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the log event.
         * <p>
         * Valid values are <code>GreengrassSystem</code> or <code>Lambda</code> . When <code>GreengrassSystem</code> is used, events from Greengrass system components are logged. When <code>Lambda</code> is used, events from user-defined Lambda functions are logged.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-component">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-component</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComponent();

        /**
         * A descriptive or arbitrary ID for the logger.
         * <p>
         * This value must be unique within the logger definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The log-level threshold.
         * <p>
         * Log events below this threshold are filtered out and aren't stored. Valid values are <code>DEBUG</code> , <code>INFO</code> (recommended), <code>WARN</code> , <code>ERROR</code> , or <code>FATAL</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-level">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-level</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLevel();

        /**
         * The storage mechanism for log events.
         * <p>
         * Valid values are <code>FileSystem</code> or <code>AWSCloudWatch</code> . When <code>AWSCloudWatch</code> is used, log events are sent to CloudWatch Logs . When <code>FileSystem</code> is used, log events are stored on the local file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The amount of file space (in KB) to use when writing logs to the local file system.
         * <p>
         * This property does not apply for CloudWatch Logs .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-space">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-space</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggerProperty> {
            java.lang.String component;
            java.lang.String id;
            java.lang.String level;
            java.lang.String type;
            java.lang.Number space;

            /**
             * Sets the value of {@link LoggerProperty#getComponent}
             * @param component The source of the log event. This parameter is required.
             *                  Valid values are <code>GreengrassSystem</code> or <code>Lambda</code> . When <code>GreengrassSystem</code> is used, events from Greengrass system components are logged. When <code>Lambda</code> is used, events from user-defined Lambda functions are logged.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder component(java.lang.String component) {
                this.component = component;
                return this;
            }

            /**
             * Sets the value of {@link LoggerProperty#getId}
             * @param id A descriptive or arbitrary ID for the logger. This parameter is required.
             *           This value must be unique within the logger definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link LoggerProperty#getLevel}
             * @param level The log-level threshold. This parameter is required.
             *              Log events below this threshold are filtered out and aren't stored. Valid values are <code>DEBUG</code> , <code>INFO</code> (recommended), <code>WARN</code> , <code>ERROR</code> , or <code>FATAL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.String level) {
                this.level = level;
                return this;
            }

            /**
             * Sets the value of {@link LoggerProperty#getType}
             * @param type The storage mechanism for log events. This parameter is required.
             *             Valid values are <code>FileSystem</code> or <code>AWSCloudWatch</code> . When <code>AWSCloudWatch</code> is used, log events are sent to CloudWatch Logs . When <code>FileSystem</code> is used, log events are stored on the local file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link LoggerProperty#getSpace}
             * @param space The amount of file space (in KB) to use when writing logs to the local file system.
             *              This property does not apply for CloudWatch Logs .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder space(java.lang.Number space) {
                this.space = space;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggerProperty {
            private final java.lang.String component;
            private final java.lang.String id;
            private final java.lang.String level;
            private final java.lang.String type;
            private final java.lang.Number space;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.component = software.amazon.jsii.Kernel.get(this, "component", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.space = software.amazon.jsii.Kernel.get(this, "space", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.component = java.util.Objects.requireNonNull(builder.component, "component is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.level = java.util.Objects.requireNonNull(builder.level, "level is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.space = builder.space;
            }

            @Override
            public final java.lang.String getComponent() {
                return this.component;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getLevel() {
                return this.level;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getSpace() {
                return this.space;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("component", om.valueToTree(this.getComponent()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("level", om.valueToTree(this.getLevel()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getSpace() != null) {
                    data.set("space", om.valueToTree(this.getSpace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnLoggerDefinition.LoggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggerProperty.Jsii$Proxy that = (LoggerProperty.Jsii$Proxy) o;

                if (!component.equals(that.component)) return false;
                if (!id.equals(that.id)) return false;
                if (!level.equals(that.level)) return false;
                if (!type.equals(that.type)) return false;
                return this.space != null ? this.space.equals(that.space) : that.space == null;
            }

            @Override
            public final int hashCode() {
                int result = this.component.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.level.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.space != null ? this.space.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnLoggerDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnLoggerDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnLoggerDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnLoggerDefinitionProps.Builder();
        }

        /**
         * The name of the logger definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-name</a>
         * @param name The name of the logger definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The logger definition version to include when the logger definition is created.
         * <p>
         * A logger definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html"><code>logger</code></a> property types.
         * <p>
         * <blockquote>
         * <p>
         * To associate a logger definition version after the logger definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html"><code>AWS::Greengrass::LoggerDefinitionVersion</code></a> resource and specify the ID of this logger definition.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion</a>
         * @param initialVersion The logger definition version to include when the logger definition is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.IResolvable initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }
        /**
         * The logger definition version to include when the logger definition is created.
         * <p>
         * A logger definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html"><code>logger</code></a> property types.
         * <p>
         * <blockquote>
         * <p>
         * To associate a logger definition version after the logger definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html"><code>AWS::Greengrass::LoggerDefinitionVersion</code></a> resource and specify the ID of this logger definition.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion</a>
         * @param initialVersion The logger definition version to include when the logger definition is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.services.greengrass.CfnLoggerDefinition.LoggerDefinitionVersionProperty initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }

        /**
         * Application-specific metadata to attach to the logger definition.
         * <p>
         * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
         * <p>
         * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         * <p>
         * <blockquote><pre>
         * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-tags</a>
         * @param tags Application-specific metadata to attach to the logger definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnLoggerDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnLoggerDefinition build() {
            return new software.amazon.awscdk.services.greengrass.CfnLoggerDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
