package software.amazon.awscdk.services.iam;

/**
 * Define a new IAM Access Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a new IAM user, access and secret keys, and stores the secret access key in a Secret.
 * User user = new User(this, "User");
 * AccessKey accessKey = AccessKey.Builder.create(this, "AccessKey").user(user).build();
 * Secret secret = Secret.Builder.create(this, "Secret")
 *         .secretStringValue(accessKey.getSecretAccessKey())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:39.393Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.AccessKey")
public class AccessKey extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.iam.IAccessKey {

    protected AccessKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AccessKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The Access Key ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessKeyId() {
        return software.amazon.jsii.Kernel.get(this, "accessKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Secret Access Key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getSecretAccessKey() {
        return software.amazon.jsii.Kernel.get(this, "secretAccessKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.AccessKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.AccessKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iam.AccessKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iam.AccessKeyProps.Builder();
        }

        /**
         * The IAM user this key will belong to.
         * <p>
         * Changing this value will result in the access key being deleted and a new
         * access key (with a different ID and secret value) being assigned to the new
         * user.
         * <p>
         * @return {@code this}
         * @param user The IAM user this key will belong to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(final software.amazon.awscdk.services.iam.IUser user) {
            this.props.user(user);
            return this;
        }

        /**
         * A CloudFormation-specific value that signifies the access key should be replaced/rotated.
         * <p>
         * This value can only be incremented. Incrementing this
         * value will cause CloudFormation to replace the Access Key resource.
         * <p>
         * Default: - No serial value
         * <p>
         * @return {@code this}
         * @param serial A CloudFormation-specific value that signifies the access key should be replaced/rotated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serial(final java.lang.Number serial) {
            this.props.serial(serial);
            return this;
        }

        /**
         * The status of the access key.
         * <p>
         * An Active access key is allowed to be used
         * to make API calls; An Inactive key cannot.
         * <p>
         * Default: - The access key is active
         * <p>
         * @return {@code this}
         * @param status The status of the access key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final software.amazon.awscdk.services.iam.AccessKeyStatus status) {
            this.props.status(status);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iam.AccessKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.AccessKey build() {
            return new software.amazon.awscdk.services.iam.AccessKey(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
