package software.amazon.awscdk.services.iot;

/**
 * Specifies a domain configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnDomainConfiguration cfnDomainConfiguration = CfnDomainConfiguration.Builder.create(this, "MyCfnDomainConfiguration")
 *         .applicationProtocol("applicationProtocol")
 *         .authenticationType("authenticationType")
 *         .authorizerConfig(AuthorizerConfigProperty.builder()
 *                 .allowAuthorizerOverride(false)
 *                 .defaultAuthorizerName("defaultAuthorizerName")
 *                 .build())
 *         .clientCertificateConfig(ClientCertificateConfigProperty.builder()
 *                 .clientCertificateCallbackArn("clientCertificateCallbackArn")
 *                 .build())
 *         .domainConfigurationName("domainConfigurationName")
 *         .domainConfigurationStatus("domainConfigurationStatus")
 *         .domainName("domainName")
 *         .serverCertificateArns(List.of("serverCertificateArns"))
 *         .serverCertificateConfig(ServerCertificateConfigProperty.builder()
 *                 .enableOcspCheck(false)
 *                 .ocspAuthorizedResponderArn("ocspAuthorizedResponderArn")
 *                 .ocspLambdaArn("ocspLambdaArn")
 *                 .build())
 *         .serviceType("serviceType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tlsConfig(TlsConfigProperty.builder()
 *                 .securityPolicy("securityPolicy")
 *                 .build())
 *         .validationCertificateArn("validationCertificateArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:39.654Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration")
public class CfnDomainConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDomainConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomainConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnDomainConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomainConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomainConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the domain configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of service delivered by the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainType() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     * <p>
     * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServerCertificates() {
        return software.amazon.jsii.Kernel.get(this, "attrServerCertificates", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An enumerated string that speciﬁes the application-layer protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationProtocol() {
        return software.amazon.jsii.Kernel.get(this, "applicationProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An enumerated string that speciﬁes the application-layer protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationProtocol", value);
    }

    /**
     * An enumerated string that speciﬁes the authentication type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
        return software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An enumerated string that speciﬁes the authentication type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authenticationType", value);
    }

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizerConfig() {
        return software.amazon.jsii.Kernel.get(this, "authorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authorizerConfig", value);
    }

    /**
     * An object that specifies the authorization service for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfiguration.AuthorizerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "authorizerConfig", value);
    }

    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClientCertificateConfig() {
        return software.amazon.jsii.Kernel.get(this, "clientCertificateConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientCertificateConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clientCertificateConfig", value);
    }

    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientCertificateConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfiguration.ClientCertificateConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "clientCertificateConfig", value);
    }

    /**
     * The name of the domain configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationName() {
        return software.amazon.jsii.Kernel.get(this, "domainConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the domain configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainConfigurationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainConfigurationName", value);
    }

    /**
     * The status to which the domain configuration should be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainConfigurationStatus() {
        return software.amazon.jsii.Kernel.get(this, "domainConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status to which the domain configuration should be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainConfigurationStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainConfigurationStatus", value);
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", value);
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getServerCertificateArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "serverCertificateArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerCertificateArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "serverCertificateArns", value);
    }

    /**
     * The server certificate configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerCertificateConfig() {
        return software.amazon.jsii.Kernel.get(this, "serverCertificateConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The server certificate configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerCertificateConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverCertificateConfig", value);
    }

    /**
     * The server certificate configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerCertificateConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfiguration.ServerCertificateConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverCertificateConfig", value);
    }

    /**
     * The type of service delivered by the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceType() {
        return software.amazon.jsii.Kernel.get(this, "serviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of service delivered by the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceType", value);
    }

    /**
     * Metadata which can be used to manage the domain configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata which can be used to manage the domain configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * An object that specifies the TLS configuration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTlsConfig() {
        return software.amazon.jsii.Kernel.get(this, "tlsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that specifies the TLS configuration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tlsConfig", value);
    }

    /**
     * An object that specifies the TLS configuration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnDomainConfiguration.TlsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "tlsConfig", value);
    }

    /**
     * The certificate used to validate the server certificate and prove domain name ownership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidationCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "validationCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The certificate used to validate the server certificate and prove domain name ownership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationCertificateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validationCertificateArn", value);
    }
    /**
     * An object that specifies the authorization service for a domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AuthorizerConfigProperty authorizerConfigProperty = AuthorizerConfigProperty.builder()
     *         .allowAuthorizerOverride(false)
     *         .defaultAuthorizerName("defaultAuthorizerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.AuthorizerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean that specifies whether the domain configuration's authorization service can be overridden.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html#cfn-iot-domainconfiguration-authorizerconfig-allowauthorizeroverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html#cfn-iot-domainconfiguration-authorizerconfig-allowauthorizeroverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowAuthorizerOverride() {
            return null;
        }

        /**
         * The name of the authorization service for a domain configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html#cfn-iot-domainconfiguration-authorizerconfig-defaultauthorizername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html#cfn-iot-domainconfiguration-authorizerconfig-defaultauthorizername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAuthorizerName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizerConfigProperty> {
            java.lang.Object allowAuthorizerOverride;
            java.lang.String defaultAuthorizerName;

            /**
             * Sets the value of {@link AuthorizerConfigProperty#getAllowAuthorizerOverride}
             * @param allowAuthorizerOverride A Boolean that specifies whether the domain configuration's authorization service can be overridden.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAuthorizerOverride(java.lang.Boolean allowAuthorizerOverride) {
                this.allowAuthorizerOverride = allowAuthorizerOverride;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizerConfigProperty#getAllowAuthorizerOverride}
             * @param allowAuthorizerOverride A Boolean that specifies whether the domain configuration's authorization service can be overridden.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowAuthorizerOverride(software.amazon.awscdk.IResolvable allowAuthorizerOverride) {
                this.allowAuthorizerOverride = allowAuthorizerOverride;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizerConfigProperty#getDefaultAuthorizerName}
             * @param defaultAuthorizerName The name of the authorization service for a domain configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAuthorizerName(java.lang.String defaultAuthorizerName) {
                this.defaultAuthorizerName = defaultAuthorizerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizerConfigProperty {
            private final java.lang.Object allowAuthorizerOverride;
            private final java.lang.String defaultAuthorizerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowAuthorizerOverride = software.amazon.jsii.Kernel.get(this, "allowAuthorizerOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultAuthorizerName = software.amazon.jsii.Kernel.get(this, "defaultAuthorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowAuthorizerOverride = builder.allowAuthorizerOverride;
                this.defaultAuthorizerName = builder.defaultAuthorizerName;
            }

            @Override
            public final java.lang.Object getAllowAuthorizerOverride() {
                return this.allowAuthorizerOverride;
            }

            @Override
            public final java.lang.String getDefaultAuthorizerName() {
                return this.defaultAuthorizerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowAuthorizerOverride() != null) {
                    data.set("allowAuthorizerOverride", om.valueToTree(this.getAllowAuthorizerOverride()));
                }
                if (this.getDefaultAuthorizerName() != null) {
                    data.set("defaultAuthorizerName", om.valueToTree(this.getDefaultAuthorizerName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.AuthorizerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizerConfigProperty.Jsii$Proxy that = (AuthorizerConfigProperty.Jsii$Proxy) o;

                if (this.allowAuthorizerOverride != null ? !this.allowAuthorizerOverride.equals(that.allowAuthorizerOverride) : that.allowAuthorizerOverride != null) return false;
                return this.defaultAuthorizerName != null ? this.defaultAuthorizerName.equals(that.defaultAuthorizerName) : that.defaultAuthorizerName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowAuthorizerOverride != null ? this.allowAuthorizerOverride.hashCode() : 0;
                result = 31 * result + (this.defaultAuthorizerName != null ? this.defaultAuthorizerName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that speciﬁes the client certificate conﬁguration for a domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ClientCertificateConfigProperty clientCertificateConfigProperty = ClientCertificateConfigProperty.builder()
     *         .clientCertificateCallbackArn("clientCertificateCallbackArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-clientcertificateconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-clientcertificateconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.ClientCertificateConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientCertificateConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientCertificateConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Lambda function that IoT invokes after mutual TLS authentication during the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-clientcertificateconfig.html#cfn-iot-domainconfiguration-clientcertificateconfig-clientcertificatecallbackarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-clientcertificateconfig.html#cfn-iot-domainconfiguration-clientcertificateconfig-clientcertificatecallbackarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateCallbackArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientCertificateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientCertificateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientCertificateConfigProperty> {
            java.lang.String clientCertificateCallbackArn;

            /**
             * Sets the value of {@link ClientCertificateConfigProperty#getClientCertificateCallbackArn}
             * @param clientCertificateCallbackArn The ARN of the Lambda function that IoT invokes after mutual TLS authentication during the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCertificateCallbackArn(java.lang.String clientCertificateCallbackArn) {
                this.clientCertificateCallbackArn = clientCertificateCallbackArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientCertificateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientCertificateConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientCertificateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientCertificateConfigProperty {
            private final java.lang.String clientCertificateCallbackArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientCertificateCallbackArn = software.amazon.jsii.Kernel.get(this, "clientCertificateCallbackArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientCertificateCallbackArn = builder.clientCertificateCallbackArn;
            }

            @Override
            public final java.lang.String getClientCertificateCallbackArn() {
                return this.clientCertificateCallbackArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientCertificateCallbackArn() != null) {
                    data.set("clientCertificateCallbackArn", om.valueToTree(this.getClientCertificateCallbackArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.ClientCertificateConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientCertificateConfigProperty.Jsii$Proxy that = (ClientCertificateConfigProperty.Jsii$Proxy) o;

                return this.clientCertificateCallbackArn != null ? this.clientCertificateCallbackArn.equals(that.clientCertificateCallbackArn) : that.clientCertificateCallbackArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientCertificateCallbackArn != null ? this.clientCertificateCallbackArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The server certificate configuration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ServerCertificateConfigProperty serverCertificateConfigProperty = ServerCertificateConfigProperty.builder()
     *         .enableOcspCheck(false)
     *         .ocspAuthorizedResponderArn("ocspAuthorizedResponderArn")
     *         .ocspLambdaArn("ocspLambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.ServerCertificateConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerCertificateConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerCertificateConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate check is enabled or not.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html#cfn-iot-domainconfiguration-servercertificateconfig-enableocspcheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html#cfn-iot-domainconfiguration-servercertificateconfig-enableocspcheck</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableOcspCheck() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for an X.509 certificate stored in ACM. If provided, AWS IoT Core will use this certificate to validate the signature of the received OCSP response. The OCSP responder must sign responses using either this authorized responder certificate or the issuing certificate, depending on whether the ARN is provided or not. The certificate must be in the same account and region as the domain configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html#cfn-iot-domainconfiguration-servercertificateconfig-ocspauthorizedresponderarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html#cfn-iot-domainconfiguration-servercertificateconfig-ocspauthorizedresponderarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOcspAuthorizedResponderArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for a Lambda function that acts as a Request for Comments (RFC) 6960-compliant Online Certificate Status Protocol (OCSP) responder, supporting basic OCSP responses.
         * <p>
         * The Lambda function accepts a base64-encoding of the OCSP request in the Distinguished Encoding Rules (DER) format. The Lambda function's response is also a base64-encoded OCSP response in the DER format. The response size must not exceed 4 kilobytes (KiB). The Lambda function must be in the same account and region as the domain configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html#cfn-iot-domainconfiguration-servercertificateconfig-ocsplambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificateconfig.html#cfn-iot-domainconfiguration-servercertificateconfig-ocsplambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOcspLambdaArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerCertificateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerCertificateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateConfigProperty> {
            java.lang.Object enableOcspCheck;
            java.lang.String ocspAuthorizedResponderArn;
            java.lang.String ocspLambdaArn;

            /**
             * Sets the value of {@link ServerCertificateConfigProperty#getEnableOcspCheck}
             * @param enableOcspCheck A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate check is enabled or not.
             *                        For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableOcspCheck(java.lang.Boolean enableOcspCheck) {
                this.enableOcspCheck = enableOcspCheck;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigProperty#getEnableOcspCheck}
             * @param enableOcspCheck A Boolean value that indicates whether Online Certificate Status Protocol (OCSP) server certificate check is enabled or not.
             *                        For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableOcspCheck(software.amazon.awscdk.IResolvable enableOcspCheck) {
                this.enableOcspCheck = enableOcspCheck;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigProperty#getOcspAuthorizedResponderArn}
             * @param ocspAuthorizedResponderArn The Amazon Resource Name (ARN) for an X.509 certificate stored in ACM. If provided, AWS IoT Core will use this certificate to validate the signature of the received OCSP response. The OCSP responder must sign responses using either this authorized responder certificate or the issuing certificate, depending on whether the ARN is provided or not. The certificate must be in the same account and region as the domain configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocspAuthorizedResponderArn(java.lang.String ocspAuthorizedResponderArn) {
                this.ocspAuthorizedResponderArn = ocspAuthorizedResponderArn;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateConfigProperty#getOcspLambdaArn}
             * @param ocspLambdaArn The Amazon Resource Name (ARN) for a Lambda function that acts as a Request for Comments (RFC) 6960-compliant Online Certificate Status Protocol (OCSP) responder, supporting basic OCSP responses.
             *                      The Lambda function accepts a base64-encoding of the OCSP request in the Distinguished Encoding Rules (DER) format. The Lambda function's response is also a base64-encoded OCSP response in the DER format. The response size must not exceed 4 kilobytes (KiB). The Lambda function must be in the same account and region as the domain configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocspLambdaArn(java.lang.String ocspLambdaArn) {
                this.ocspLambdaArn = ocspLambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerCertificateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerCertificateConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerCertificateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateConfigProperty {
            private final java.lang.Object enableOcspCheck;
            private final java.lang.String ocspAuthorizedResponderArn;
            private final java.lang.String ocspLambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableOcspCheck = software.amazon.jsii.Kernel.get(this, "enableOcspCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ocspAuthorizedResponderArn = software.amazon.jsii.Kernel.get(this, "ocspAuthorizedResponderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ocspLambdaArn = software.amazon.jsii.Kernel.get(this, "ocspLambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableOcspCheck = builder.enableOcspCheck;
                this.ocspAuthorizedResponderArn = builder.ocspAuthorizedResponderArn;
                this.ocspLambdaArn = builder.ocspLambdaArn;
            }

            @Override
            public final java.lang.Object getEnableOcspCheck() {
                return this.enableOcspCheck;
            }

            @Override
            public final java.lang.String getOcspAuthorizedResponderArn() {
                return this.ocspAuthorizedResponderArn;
            }

            @Override
            public final java.lang.String getOcspLambdaArn() {
                return this.ocspLambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableOcspCheck() != null) {
                    data.set("enableOcspCheck", om.valueToTree(this.getEnableOcspCheck()));
                }
                if (this.getOcspAuthorizedResponderArn() != null) {
                    data.set("ocspAuthorizedResponderArn", om.valueToTree(this.getOcspAuthorizedResponderArn()));
                }
                if (this.getOcspLambdaArn() != null) {
                    data.set("ocspLambdaArn", om.valueToTree(this.getOcspLambdaArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.ServerCertificateConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerCertificateConfigProperty.Jsii$Proxy that = (ServerCertificateConfigProperty.Jsii$Proxy) o;

                if (this.enableOcspCheck != null ? !this.enableOcspCheck.equals(that.enableOcspCheck) : that.enableOcspCheck != null) return false;
                if (this.ocspAuthorizedResponderArn != null ? !this.ocspAuthorizedResponderArn.equals(that.ocspAuthorizedResponderArn) : that.ocspAuthorizedResponderArn != null) return false;
                return this.ocspLambdaArn != null ? this.ocspLambdaArn.equals(that.ocspLambdaArn) : that.ocspLambdaArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableOcspCheck != null ? this.enableOcspCheck.hashCode() : 0;
                result = 31 * result + (this.ocspAuthorizedResponderArn != null ? this.ocspAuthorizedResponderArn.hashCode() : 0);
                result = 31 * result + (this.ocspLambdaArn != null ? this.ocspLambdaArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains information about a server certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ServerCertificateSummaryProperty serverCertificateSummaryProperty = ServerCertificateSummaryProperty.builder()
     *         .serverCertificateArn("serverCertificateArn")
     *         .serverCertificateStatus("serverCertificateStatus")
     *         .serverCertificateStatusDetail("serverCertificateStatusDetail")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.ServerCertificateSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerCertificateSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerCertificateSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the server certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerCertificateArn() {
            return null;
        }

        /**
         * The status of the server certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatestatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerCertificateStatus() {
            return null;
        }

        /**
         * Details that explain the status of the server certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatestatusdetail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatestatusdetail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerCertificateStatusDetail() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerCertificateSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerCertificateSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerCertificateSummaryProperty> {
            java.lang.String serverCertificateArn;
            java.lang.String serverCertificateStatus;
            java.lang.String serverCertificateStatusDetail;

            /**
             * Sets the value of {@link ServerCertificateSummaryProperty#getServerCertificateArn}
             * @param serverCertificateArn The ARN of the server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
                this.serverCertificateArn = serverCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateSummaryProperty#getServerCertificateStatus}
             * @param serverCertificateStatus The status of the server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateStatus(java.lang.String serverCertificateStatus) {
                this.serverCertificateStatus = serverCertificateStatus;
                return this;
            }

            /**
             * Sets the value of {@link ServerCertificateSummaryProperty#getServerCertificateStatusDetail}
             * @param serverCertificateStatusDetail Details that explain the status of the server certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverCertificateStatusDetail(java.lang.String serverCertificateStatusDetail) {
                this.serverCertificateStatusDetail = serverCertificateStatusDetail;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerCertificateSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerCertificateSummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerCertificateSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerCertificateSummaryProperty {
            private final java.lang.String serverCertificateArn;
            private final java.lang.String serverCertificateStatus;
            private final java.lang.String serverCertificateStatusDetail;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverCertificateArn = software.amazon.jsii.Kernel.get(this, "serverCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverCertificateStatus = software.amazon.jsii.Kernel.get(this, "serverCertificateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverCertificateStatusDetail = software.amazon.jsii.Kernel.get(this, "serverCertificateStatusDetail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverCertificateArn = builder.serverCertificateArn;
                this.serverCertificateStatus = builder.serverCertificateStatus;
                this.serverCertificateStatusDetail = builder.serverCertificateStatusDetail;
            }

            @Override
            public final java.lang.String getServerCertificateArn() {
                return this.serverCertificateArn;
            }

            @Override
            public final java.lang.String getServerCertificateStatus() {
                return this.serverCertificateStatus;
            }

            @Override
            public final java.lang.String getServerCertificateStatusDetail() {
                return this.serverCertificateStatusDetail;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServerCertificateArn() != null) {
                    data.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
                }
                if (this.getServerCertificateStatus() != null) {
                    data.set("serverCertificateStatus", om.valueToTree(this.getServerCertificateStatus()));
                }
                if (this.getServerCertificateStatusDetail() != null) {
                    data.set("serverCertificateStatusDetail", om.valueToTree(this.getServerCertificateStatusDetail()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.ServerCertificateSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerCertificateSummaryProperty.Jsii$Proxy that = (ServerCertificateSummaryProperty.Jsii$Proxy) o;

                if (this.serverCertificateArn != null ? !this.serverCertificateArn.equals(that.serverCertificateArn) : that.serverCertificateArn != null) return false;
                if (this.serverCertificateStatus != null ? !this.serverCertificateStatus.equals(that.serverCertificateStatus) : that.serverCertificateStatus != null) return false;
                return this.serverCertificateStatusDetail != null ? this.serverCertificateStatusDetail.equals(that.serverCertificateStatusDetail) : that.serverCertificateStatusDetail == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serverCertificateArn != null ? this.serverCertificateArn.hashCode() : 0;
                result = 31 * result + (this.serverCertificateStatus != null ? this.serverCertificateStatus.hashCode() : 0);
                result = 31 * result + (this.serverCertificateStatusDetail != null ? this.serverCertificateStatusDetail.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies the TLS configuration for a domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TlsConfigProperty tlsConfigProperty = TlsConfigProperty.builder()
     *         .securityPolicy("securityPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-tlsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-tlsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnDomainConfiguration.TlsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The security policy for a domain configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html#tls-policy-table">Security policies</a> in the <em>AWS IoT Core developer guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-tlsconfig.html#cfn-iot-domainconfiguration-tlsconfig-securitypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-tlsconfig.html#cfn-iot-domainconfiguration-tlsconfig-securitypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TlsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsConfigProperty> {
            java.lang.String securityPolicy;

            /**
             * Sets the value of {@link TlsConfigProperty#getSecurityPolicy}
             * @param securityPolicy The security policy for a domain configuration.
             *                       For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/transport-security.html#tls-policy-table">Security policies</a> in the <em>AWS IoT Core developer guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityPolicy(java.lang.String securityPolicy) {
                this.securityPolicy = securityPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsConfigProperty {
            private final java.lang.String securityPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityPolicy = builder.securityPolicy;
            }

            @Override
            public final java.lang.String getSecurityPolicy() {
                return this.securityPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityPolicy() != null) {
                    data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnDomainConfiguration.TlsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsConfigProperty.Jsii$Proxy that = (TlsConfigProperty.Jsii$Proxy) o;

                return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityPolicy != null ? this.securityPolicy.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnDomainConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnDomainConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iot.CfnDomainConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An enumerated string that speciﬁes the application-layer protocol.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-applicationprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-applicationprotocol</a>
         * @param applicationProtocol An enumerated string that speciﬁes the application-layer protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationProtocol(final java.lang.String applicationProtocol) {
            this.props().applicationProtocol(applicationProtocol);
            return this;
        }

        /**
         * An enumerated string that speciﬁes the authentication type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authenticationtype</a>
         * @param authenticationType An enumerated string that speciﬁes the authentication type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(final java.lang.String authenticationType) {
            this.props().authenticationType(authenticationType);
            return this;
        }

        /**
         * An object that specifies the authorization service for a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig</a>
         * @param authorizerConfig An object that specifies the authorization service for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(final software.amazon.awscdk.IResolvable authorizerConfig) {
            this.props().authorizerConfig(authorizerConfig);
            return this;
        }
        /**
         * An object that specifies the authorization service for a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig</a>
         * @param authorizerConfig An object that specifies the authorization service for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfig(final software.amazon.awscdk.services.iot.CfnDomainConfiguration.AuthorizerConfigProperty authorizerConfig) {
            this.props().authorizerConfig(authorizerConfig);
            return this;
        }

        /**
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-clientcertificateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-clientcertificateconfig</a>
         * @param clientCertificateConfig An object that speciﬁes the client certificate conﬁguration for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateConfig(final software.amazon.awscdk.IResolvable clientCertificateConfig) {
            this.props().clientCertificateConfig(clientCertificateConfig);
            return this;
        }
        /**
         * An object that speciﬁes the client certificate conﬁguration for a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-clientcertificateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-clientcertificateconfig</a>
         * @param clientCertificateConfig An object that speciﬁes the client certificate conﬁguration for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateConfig(final software.amazon.awscdk.services.iot.CfnDomainConfiguration.ClientCertificateConfigProperty clientCertificateConfig) {
            this.props().clientCertificateConfig(clientCertificateConfig);
            return this;
        }

        /**
         * The name of the domain configuration.
         * <p>
         * This value must be unique to a region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationname</a>
         * @param domainConfigurationName The name of the domain configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationName(final java.lang.String domainConfigurationName) {
            this.props().domainConfigurationName(domainConfigurationName);
            return this;
        }

        /**
         * The status to which the domain configuration should be updated.
         * <p>
         * Valid values: <code>ENABLED</code> | <code>DISABLED</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationstatus</a>
         * @param domainConfigurationStatus The status to which the domain configuration should be updated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainConfigurationStatus(final java.lang.String domainConfigurationStatus) {
            this.props().domainConfigurationStatus(domainConfigurationStatus);
            return this;
        }

        /**
         * The name of the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainname</a>
         * @param domainName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake.
         * <p>
         * Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificatearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificatearns</a>
         * @param serverCertificateArns The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArns(final java.util.List<java.lang.String> serverCertificateArns) {
            this.props().serverCertificateArns(serverCertificateArns);
            return this;
        }

        /**
         * The server certificate configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificateconfig</a>
         * @param serverCertificateConfig The server certificate configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateConfig(final software.amazon.awscdk.IResolvable serverCertificateConfig) {
            this.props().serverCertificateConfig(serverCertificateConfig);
            return this;
        }
        /**
         * The server certificate configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-custom-endpoints-configurable.html">Configurable endpoints</a> from the AWS IoT Core Developer Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificateconfig</a>
         * @param serverCertificateConfig The server certificate configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateConfig(final software.amazon.awscdk.services.iot.CfnDomainConfiguration.ServerCertificateConfigProperty serverCertificateConfig) {
            this.props().serverCertificateConfig(serverCertificateConfig);
            return this;
        }

        /**
         * The type of service delivered by the endpoint.
         * <p>
         * <blockquote>
         * <p>
         * AWS IoT Core currently supports only the <code>DATA</code> service type.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servicetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servicetype</a>
         * @param serviceType The type of service delivered by the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceType(final java.lang.String serviceType) {
            this.props().serviceType(serviceType);
            return this;
        }

        /**
         * Metadata which can be used to manage the domain configuration.
         * <p>
         * <blockquote>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * <p>
         * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tags</a>
         * @param tags Metadata which can be used to manage the domain configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * An object that specifies the TLS configuration for a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tlsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tlsconfig</a>
         * @param tlsConfig An object that specifies the TLS configuration for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(final software.amazon.awscdk.IResolvable tlsConfig) {
            this.props().tlsConfig(tlsConfig);
            return this;
        }
        /**
         * An object that specifies the TLS configuration for a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tlsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tlsconfig</a>
         * @param tlsConfig An object that specifies the TLS configuration for a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(final software.amazon.awscdk.services.iot.CfnDomainConfiguration.TlsConfigProperty tlsConfig) {
            this.props().tlsConfig(tlsConfig);
            return this;
        }

        /**
         * The certificate used to validate the server certificate and prove domain name ownership.
         * <p>
         * This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-validationcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-validationcertificatearn</a>
         * @param validationCertificateArn The certificate used to validate the server certificate and prove domain name ownership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationCertificateArn(final java.lang.String validationCertificateArn) {
            this.props().validationCertificateArn(validationCertificateArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnDomainConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnDomainConfiguration build() {
            return new software.amazon.awscdk.services.iot.CfnDomainConfiguration(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.CfnDomainConfigurationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.CfnDomainConfigurationProps.Builder();
            }
            return this.props;
        }
    }
}
