package software.amazon.awscdk.services.lambda;

/**
 * Represents the Lambda Handler Code.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.signer.*;
 * SigningProfile signingProfile = SigningProfile.Builder.create(this, "SigningProfile")
 *         .platform(Platform.AWS_LAMBDA_SHA384_ECDSA)
 *         .build();
 * CodeSigningConfig codeSigningConfig = CodeSigningConfig.Builder.create(this, "CodeSigningConfig")
 *         .signingProfiles(List.of(signingProfile))
 *         .build();
 * Function.Builder.create(this, "Function")
 *         .codeSigningConfig(codeSigningConfig)
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:40.632Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Code")
public abstract class Code extends software.amazon.jsii.JsiiObject {

    protected Code(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Code(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Code() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Loads the function code from a local disk path.
     * <p>
     * @param path Either a directory with the Lambda code bundle or a .zip file. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Loads the function code from a local disk path.
     * <p>
     * @param path Either a directory with the Lambda code bundle or a .zip file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * <p>
     * @param directory the directory from which the asset must be created. This parameter is required.
     * @param props properties to further configure the selected image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetImageCode fromAssetImage(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.AssetImageCodeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromAssetImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetImageCode.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), props });
    }

    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * <p>
     * @param directory the directory from which the asset must be created. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetImageCode fromAssetImage(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromAssetImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetImageCode.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Lambda handler code as an S3 object.
     * <p>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     * @param objectVersion Optional S3 object version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.S3Code fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.S3Code.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), objectVersion });
    }

    /**
     * Lambda handler code as an S3 object.
     * <p>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.S3Code fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.S3Code.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Lambda handler code as an S3 object.
     * <p>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     * @param options Optional parameters for setting the code, current optional parameters to set here are 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.S3CodeV2 fromBucketV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.BucketOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromBucketV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.S3CodeV2.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), options });
    }

    /**
     * Lambda handler code as an S3 object.
     * <p>
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.S3CodeV2 fromBucketV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromBucketV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.S3CodeV2.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Creates a new Lambda source defined using CloudFormation parameters.
     * <p>
     * @return a new instance of <code>CfnParametersCode</code>
     * @param props optional construction properties of <code>CfnParametersCode</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnParametersCode fromCfnParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CfnParametersCodeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromCfnParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CfnParametersCode.class), new Object[] { props });
    }

    /**
     * Creates a new Lambda source defined using CloudFormation parameters.
     * <p>
     * @return a new instance of <code>CfnParametersCode</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnParametersCode fromCfnParameters() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromCfnParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CfnParametersCode.class));
    }

    /**
     * Runs a command to build the code asset that will be used.
     * <p>
     * @param output Where the output of the command will be directed, either a directory or a .zip file with the output Lambda code bundle * For example, if you use the command to run a build script (e.g., [ 'node', 'bundle_code.js' ]), and the build script generates a directory <code>/my/lambda/code</code> containing code that should be ran in a Lambda function, then output should be set to <code>/my/lambda/code</code>. This parameter is required.
     * @param command The command which will be executed to generate the output, for example, [ 'node', 'bundle_code.js' ]. This parameter is required.
     * @param options options for the custom command, and other asset options -- but bundling options are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetCode fromCustomCommand(final @org.jetbrains.annotations.NotNull java.lang.String output, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> command, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CustomCommandOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromCustomCommand", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(output, "output is required"), java.util.Objects.requireNonNull(command, "command is required"), options });
    }

    /**
     * Runs a command to build the code asset that will be used.
     * <p>
     * @param output Where the output of the command will be directed, either a directory or a .zip file with the output Lambda code bundle * For example, if you use the command to run a build script (e.g., [ 'node', 'bundle_code.js' ]), and the build script generates a directory <code>/my/lambda/code</code> containing code that should be ran in a Lambda function, then output should be set to <code>/my/lambda/code</code>. This parameter is required.
     * @param command The command which will be executed to generate the output, for example, [ 'node', 'bundle_code.js' ]. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetCode fromCustomCommand(final @org.jetbrains.annotations.NotNull java.lang.String output, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> command) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromCustomCommand", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(output, "output is required"), java.util.Objects.requireNonNull(command, "command is required") });
    }

    /**
     * Loads the function code from an asset created by a Docker build.
     * <p>
     * By default, the asset is expected to be located at <code>/asset</code> in the
     * image.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     * @param options Docker build options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetCode fromDockerBuild(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.DockerBuildAssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromDockerBuild", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Loads the function code from an asset created by a Docker build.
     * <p>
     * By default, the asset is expected to be located at <code>/asset</code> in the
     * image.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.AssetCode fromDockerBuild(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromDockerBuild", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Use an existing ECR image as the Lambda code.
     * <p>
     * @param repository the ECR repository that the image is in. This parameter is required.
     * @param props properties to further configure the selected image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EcrImageCode fromEcrImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.EcrImageCodeProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromEcrImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EcrImageCode.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), props });
    }

    /**
     * Use an existing ECR image as the Lambda code.
     * <p>
     * @param repository the ECR repository that the image is in. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EcrImageCode fromEcrImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromEcrImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EcrImageCode.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Inline code for Lambda handler.
     * <p>
     * @return <code>LambdaInlineCode</code> with inline code.
     * @param code The actual handler code (the resulting zip file cannot exceed 4MB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.InlineCode fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Code.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.InlineCode.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope The binding scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     * <p>
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     * <p>
     * @param _resource This parameter is required.
     * @param _options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bindToResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource _resource, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.ResourceBindOptions _options) {
        software.amazon.jsii.Kernel.call(this, "bindToResource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_resource, "_resource is required"), _options });
    }

    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     * <p>
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     * <p>
     * @param _resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bindToResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource _resource) {
        software.amazon.jsii.Kernel.call(this, "bindToResource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_resource, "_resource is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.lambda.Code {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the lambda or layer is initialized to allow this object to bind to the stack, add resources and have fun.
         * <p>
         * @param scope The binding scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
