package software.amazon.awscdk.services.logs;

/**
 * Define a QueryString.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * QueryDefinition.Builder.create(this, "QueryDefinition")
 *         .queryDefinitionName("MyQuery")
 *         .queryString(QueryString.Builder.create()
 *                 .fields(List.of("&#64;timestamp", "&#64;message"))
 *                 .parseStatements(List.of("&#64;message \"[*] *\" as loggingType, loggingMessage", "&#64;message \"&lt;*&gt;: *\" as differentLoggingType, differentLoggingMessage"))
 *                 .filterStatements(List.of("loggingType = \"ERROR\"", "loggingMessage = \"A very strange error occurred!\""))
 *                 .sort("&#64;timestamp desc")
 *                 .limit(20)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:41.107Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.QueryString")
public class QueryString extends software.amazon.jsii.JsiiObject {

    protected QueryString(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueryString(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueryString(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.QueryStringProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueryString() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * String representation of this QueryString.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.QueryString}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.QueryString> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.logs.QueryStringProps.Builder props;

        private Builder() {
        }

        /**
         * Specifies which fields to display in the query results.
         * <p>
         * Default: - no display in QueryString
         * <p>
         * @return {@code this}
         * @param display Specifies which fields to display in the query results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder display(final java.lang.String display) {
            this.props().display(display);
            return this;
        }

        /**
         * Retrieves the specified fields from log events for display.
         * <p>
         * Default: - no fields in QueryString
         * <p>
         * @return {@code this}
         * @param fields Retrieves the specified fields from log events for display. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(final java.util.List<java.lang.String> fields) {
            this.props().fields(fields);
            return this;
        }

        /**
         * (deprecated) A single statement for filtering the results of a query based on a boolean expression.
         * <p>
         * Default: - no filter in QueryString
         * <p>
         * @return {@code this}
         * @deprecated Use <code>filterStatements</code> instead
         * @param filter A single statement for filtering the results of a query based on a boolean expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder filter(final java.lang.String filter) {
            this.props().filter(filter);
            return this;
        }

        /**
         * An array of one or more statements for filtering the results of a query based on a boolean expression.
         * <p>
         * Each provided statement generates a separate filter line in the query string.
         * <p>
         * Note: If provided, this property overrides any value provided for the <code>filter</code> property.
         * <p>
         * Default: - no filter in QueryString
         * <p>
         * @return {@code this}
         * @param filterStatements An array of one or more statements for filtering the results of a query based on a boolean expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterStatements(final java.util.List<java.lang.String> filterStatements) {
            this.props().filterStatements(filterStatements);
            return this;
        }

        /**
         * Specifies the number of log events returned by the query.
         * <p>
         * Default: - no limit in QueryString
         * <p>
         * @return {@code this}
         * @param limit Specifies the number of log events returned by the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limit(final java.lang.Number limit) {
            this.props().limit(limit);
            return this;
        }

        /**
         * (deprecated) A single statement for parsing data from a log field and creating ephemeral fields that can be processed further in the query.
         * <p>
         * Default: - no parse in QueryString
         * <p>
         * @return {@code this}
         * @deprecated Use <code>parseStatements</code> instead
         * @param parse A single statement for parsing data from a log field and creating ephemeral fields that can be processed further in the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder parse(final java.lang.String parse) {
            this.props().parse(parse);
            return this;
        }

        /**
         * An array of one or more statements for parsing data from a log field and creating ephemeral fields that can be processed further in the query.
         * <p>
         * Each provided statement generates a separate
         * parse line in the query string.
         * <p>
         * Note: If provided, this property overrides any value provided for the <code>parse</code> property.
         * <p>
         * Default: - no parse in QueryString
         * <p>
         * @return {@code this}
         * @param parseStatements An array of one or more statements for parsing data from a log field and creating ephemeral fields that can be processed further in the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parseStatements(final java.util.List<java.lang.String> parseStatements) {
            this.props().parseStatements(parseStatements);
            return this;
        }

        /**
         * Sorts the retrieved log events.
         * <p>
         * Default: - no sort in QueryString
         * <p>
         * @return {@code this}
         * @param sort Sorts the retrieved log events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sort(final java.lang.String sort) {
            this.props().sort(sort);
            return this;
        }

        /**
         * Uses log field values to calculate aggregate statistics.
         * <p>
         * Default: - no stats in QueryString
         * <p>
         * @return {@code this}
         * @param stats Uses log field values to calculate aggregate statistics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stats(final java.lang.String stats) {
            this.props().stats(stats);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.QueryString}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.QueryString build() {
            return new software.amazon.awscdk.services.logs.QueryString(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.logs.QueryStringProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.logs.QueryStringProps.Builder();
            }
            return this.props;
        }
    }
}
