package software.amazon.awscdk.services.qbusiness;

/**
 * Properties for defining a <code>CfnWebExperience</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * CfnWebExperienceProps cfnWebExperienceProps = CfnWebExperienceProps.builder()
 *         .applicationId("applicationId")
 *         // the properties below are optional
 *         .browserExtensionConfiguration(BrowserExtensionConfigurationProperty.builder()
 *                 .enabledBrowserExtensions(List.of("enabledBrowserExtensions"))
 *                 .build())
 *         .customizationConfiguration(CustomizationConfigurationProperty.builder()
 *                 .customCssUrl("customCssUrl")
 *                 .faviconUrl("faviconUrl")
 *                 .fontUrl("fontUrl")
 *                 .logoUrl("logoUrl")
 *                 .build())
 *         .identityProviderConfiguration(IdentityProviderConfigurationProperty.builder()
 *                 .openIdConnectConfiguration(OpenIDConnectProviderConfigurationProperty.builder()
 *                         .secretsArn("secretsArn")
 *                         .secretsRole("secretsRole")
 *                         .build())
 *                 .samlConfiguration(SamlProviderConfigurationProperty.builder()
 *                         .authenticationUrl("authenticationUrl")
 *                         .build())
 *                 .build())
 *         .origins(List.of("origins"))
 *         .roleArn("roleArn")
 *         .samplePromptsControlMode("samplePromptsControlMode")
 *         .subtitle("subtitle")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .title("title")
 *         .welcomeMessage("welcomeMessage")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:42.390Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnWebExperienceProps")
@software.amazon.jsii.Jsii.Proxy(CfnWebExperienceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWebExperienceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Q Business web experience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The container for browser extension configuration for an Amazon Q Business web experience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-browserextensionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-browserextensionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBrowserExtensionConfiguration() {
        return null;
    }

    /**
     * Contains the configuration information to customize the logo, font, and color of an Amazon Q Business web experience with individual files for each property or a CSS file for them all.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-customizationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-customizationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizationConfiguration() {
        return null;
    }

    /**
     * Provides information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-identityproviderconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-identityproviderconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderConfiguration() {
        return null;
    }

    /**
     * Sets the website domain origins that are allowed to embed the Amazon Q Business web experience.
     * <p>
     * The <em>domain origin</em> refers to the base URL for accessing a website including the protocol ( <code>http/https</code> ), the domain name, and the port number (if specified).
     * <p>
     * <blockquote>
     * <p>
     * You must only submit a <em>base URL</em> and not a full path. For example, <code>https://docs.aws.amazon.com</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-origins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-origins</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrigins() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the service role attached to your web experience.
     * <p>
     * <blockquote>
     * <p>
     * You must provide this value if you're using IAM Identity Center to manage end user access to your application. If you're using legacy identity management to manage user access, you don't need to provide this value.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * Determines whether sample prompts are enabled in the web experience for an end user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-samplepromptscontrolmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-samplepromptscontrolmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSamplePromptsControlMode() {
        return null;
    }

    /**
     * A subtitle to personalize your Amazon Q Business web experience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-subtitle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-subtitle</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubtitle() {
        return null;
    }

    /**
     * A list of key-value pairs that identify or categorize your Amazon Q Business web experience.
     * <p>
     * You can also use tags to help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The title for your Amazon Q Business web experience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-title</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
        return null;
    }

    /**
     * A message in an Amazon Q Business web experience.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-welcomemessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-webexperience.html#cfn-qbusiness-webexperience-welcomemessage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWelcomeMessage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWebExperienceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWebExperienceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWebExperienceProps> {
        java.lang.String applicationId;
        java.lang.Object browserExtensionConfiguration;
        java.lang.Object customizationConfiguration;
        java.lang.Object identityProviderConfiguration;
        java.util.List<java.lang.String> origins;
        java.lang.String roleArn;
        java.lang.String samplePromptsControlMode;
        java.lang.String subtitle;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String title;
        java.lang.String welcomeMessage;

        /**
         * Sets the value of {@link CfnWebExperienceProps#getApplicationId}
         * @param applicationId The identifier of the Amazon Q Business web experience. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getBrowserExtensionConfiguration}
         * @param browserExtensionConfiguration The container for browser extension configuration for an Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder browserExtensionConfiguration(software.amazon.awscdk.IResolvable browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getBrowserExtensionConfiguration}
         * @param browserExtensionConfiguration The container for browser extension configuration for an Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder browserExtensionConfiguration(software.amazon.awscdk.services.qbusiness.CfnWebExperience.BrowserExtensionConfigurationProperty browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getCustomizationConfiguration}
         * @param customizationConfiguration Contains the configuration information to customize the logo, font, and color of an Amazon Q Business web experience with individual files for each property or a CSS file for them all.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizationConfiguration(software.amazon.awscdk.IResolvable customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getCustomizationConfiguration}
         * @param customizationConfiguration Contains the configuration information to customize the logo, font, and color of an Amazon Q Business web experience with individual files for each property or a CSS file for them all.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizationConfiguration(software.amazon.awscdk.services.qbusiness.CfnWebExperience.CustomizationConfigurationProperty customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getIdentityProviderConfiguration}
         * @param identityProviderConfiguration Provides information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfiguration(software.amazon.awscdk.IResolvable identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getIdentityProviderConfiguration}
         * @param identityProviderConfiguration Provides information about the identity provider (IdP) used to authenticate end users of an Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfiguration(software.amazon.awscdk.services.qbusiness.CfnWebExperience.IdentityProviderConfigurationProperty identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getOrigins}
         * @param origins Sets the website domain origins that are allowed to embed the Amazon Q Business web experience.
         *                The <em>domain origin</em> refers to the base URL for accessing a website including the protocol ( <code>http/https</code> ), the domain name, and the port number (if specified).
         *                <p>
         *                <blockquote>
         *                <p>
         *                You must only submit a <em>base URL</em> and not a full path. For example, <code>https://docs.aws.amazon.com</code> .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origins(java.util.List<java.lang.String> origins) {
            this.origins = origins;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the service role attached to your web experience.
         *                <blockquote>
         *                <p>
         *                You must provide this value if you're using IAM Identity Center to manage end user access to your application. If you're using legacy identity management to manage user access, you don't need to provide this value.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getSamplePromptsControlMode}
         * @param samplePromptsControlMode Determines whether sample prompts are enabled in the web experience for an end user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplePromptsControlMode(java.lang.String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getSubtitle}
         * @param subtitle A subtitle to personalize your Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtitle(java.lang.String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getTags}
         * @param tags A list of key-value pairs that identify or categorize your Amazon Q Business web experience.
         *             You can also use tags to help control access to the web experience. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getTitle}
         * @param title The title for your Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebExperienceProps#getWelcomeMessage}
         * @param welcomeMessage A message in an Amazon Q Business web experience.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder welcomeMessage(java.lang.String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWebExperienceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWebExperienceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWebExperienceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWebExperienceProps {
        private final java.lang.String applicationId;
        private final java.lang.Object browserExtensionConfiguration;
        private final java.lang.Object customizationConfiguration;
        private final java.lang.Object identityProviderConfiguration;
        private final java.util.List<java.lang.String> origins;
        private final java.lang.String roleArn;
        private final java.lang.String samplePromptsControlMode;
        private final java.lang.String subtitle;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String title;
        private final java.lang.String welcomeMessage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.browserExtensionConfiguration = software.amazon.jsii.Kernel.get(this, "browserExtensionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customizationConfiguration = software.amazon.jsii.Kernel.get(this, "customizationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.identityProviderConfiguration = software.amazon.jsii.Kernel.get(this, "identityProviderConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.origins = software.amazon.jsii.Kernel.get(this, "origins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.samplePromptsControlMode = software.amazon.jsii.Kernel.get(this, "samplePromptsControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subtitle = software.amazon.jsii.Kernel.get(this, "subtitle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.welcomeMessage = software.amazon.jsii.Kernel.get(this, "welcomeMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.browserExtensionConfiguration = builder.browserExtensionConfiguration;
            this.customizationConfiguration = builder.customizationConfiguration;
            this.identityProviderConfiguration = builder.identityProviderConfiguration;
            this.origins = builder.origins;
            this.roleArn = builder.roleArn;
            this.samplePromptsControlMode = builder.samplePromptsControlMode;
            this.subtitle = builder.subtitle;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.title = builder.title;
            this.welcomeMessage = builder.welcomeMessage;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.Object getBrowserExtensionConfiguration() {
            return this.browserExtensionConfiguration;
        }

        @Override
        public final java.lang.Object getCustomizationConfiguration() {
            return this.customizationConfiguration;
        }

        @Override
        public final java.lang.Object getIdentityProviderConfiguration() {
            return this.identityProviderConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getOrigins() {
            return this.origins;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getSamplePromptsControlMode() {
            return this.samplePromptsControlMode;
        }

        @Override
        public final java.lang.String getSubtitle() {
            return this.subtitle;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.String getWelcomeMessage() {
            return this.welcomeMessage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            if (this.getBrowserExtensionConfiguration() != null) {
                data.set("browserExtensionConfiguration", om.valueToTree(this.getBrowserExtensionConfiguration()));
            }
            if (this.getCustomizationConfiguration() != null) {
                data.set("customizationConfiguration", om.valueToTree(this.getCustomizationConfiguration()));
            }
            if (this.getIdentityProviderConfiguration() != null) {
                data.set("identityProviderConfiguration", om.valueToTree(this.getIdentityProviderConfiguration()));
            }
            if (this.getOrigins() != null) {
                data.set("origins", om.valueToTree(this.getOrigins()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getSamplePromptsControlMode() != null) {
                data.set("samplePromptsControlMode", om.valueToTree(this.getSamplePromptsControlMode()));
            }
            if (this.getSubtitle() != null) {
                data.set("subtitle", om.valueToTree(this.getSubtitle()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWelcomeMessage() != null) {
                data.set("welcomeMessage", om.valueToTree(this.getWelcomeMessage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnWebExperienceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWebExperienceProps.Jsii$Proxy that = (CfnWebExperienceProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (this.browserExtensionConfiguration != null ? !this.browserExtensionConfiguration.equals(that.browserExtensionConfiguration) : that.browserExtensionConfiguration != null) return false;
            if (this.customizationConfiguration != null ? !this.customizationConfiguration.equals(that.customizationConfiguration) : that.customizationConfiguration != null) return false;
            if (this.identityProviderConfiguration != null ? !this.identityProviderConfiguration.equals(that.identityProviderConfiguration) : that.identityProviderConfiguration != null) return false;
            if (this.origins != null ? !this.origins.equals(that.origins) : that.origins != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.samplePromptsControlMode != null ? !this.samplePromptsControlMode.equals(that.samplePromptsControlMode) : that.samplePromptsControlMode != null) return false;
            if (this.subtitle != null ? !this.subtitle.equals(that.subtitle) : that.subtitle != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.welcomeMessage != null ? this.welcomeMessage.equals(that.welcomeMessage) : that.welcomeMessage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.browserExtensionConfiguration != null ? this.browserExtensionConfiguration.hashCode() : 0);
            result = 31 * result + (this.customizationConfiguration != null ? this.customizationConfiguration.hashCode() : 0);
            result = 31 * result + (this.identityProviderConfiguration != null ? this.identityProviderConfiguration.hashCode() : 0);
            result = 31 * result + (this.origins != null ? this.origins.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.samplePromptsControlMode != null ? this.samplePromptsControlMode.hashCode() : 0);
            result = 31 * result + (this.subtitle != null ? this.subtitle.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.welcomeMessage != null ? this.welcomeMessage.hashCode() : 0);
            return result;
        }
    }
}
