package software.amazon.awscdk.services.rds;

/**
 * The <code>AWS::RDS::DBProxyTargetGroup</code> resource represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to.
 * <p>
 * Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.
 * <p>
 * This data type is used as a response element in the <code>DescribeDBProxyTargetGroups</code> action.
 * <p>
 * For information about RDS Proxy for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html">Managing Connections with Amazon RDS Proxy</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about RDS Proxy for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html">Managing Connections with Amazon RDS Proxy</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * For a sample template that creates a DB proxy and registers a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#aws-resource-rds-dbproxy--examples">Examples</a> in AWS::RDS::DBProxy.
 * <p>
 * <blockquote>
 * <p>
 * Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * <p>
 * For information about limitations that apply to RDS Proxy for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations">Limitations for RDS Proxy</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about that apply to RDS Proxy for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations">Limitations for RDS Proxy</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBProxyTargetGroup cfnDBProxyTargetGroup = CfnDBProxyTargetGroup.Builder.create(this, "MyCfnDBProxyTargetGroup")
 *         .dbProxyName("dbProxyName")
 *         .targetGroupName("targetGroupName")
 *         // the properties below are optional
 *         .connectionPoolConfigurationInfo(ConnectionPoolConfigurationInfoFormatProperty.builder()
 *                 .connectionBorrowTimeout(123)
 *                 .initQuery("initQuery")
 *                 .maxConnectionsPercent(123)
 *                 .maxIdleConnectionsPercent(123)
 *                 .sessionPinningFilters(List.of("sessionPinningFilters"))
 *                 .build())
 *         .dbClusterIdentifiers(List.of("dbClusterIdentifiers"))
 *         .dbInstanceIdentifiers(List.of("dbInstanceIdentifiers"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:44.308Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup")
public class CfnDBProxyTargetGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBProxyTargetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBProxyTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBProxyTargetGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBProxyTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) representing the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTargetGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTargetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbProxyName() {
        return software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbProxyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbProxyName", java.util.Objects.requireNonNull(value, "dbProxyName is required"));
    }

    /**
     * The identifier for the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "targetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetGroupName", java.util.Objects.requireNonNull(value, "targetGroupName is required"));
    }

    /**
     * Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectionPoolConfigurationInfo() {
        return software.amazon.jsii.Kernel.get(this, "connectionPoolConfigurationInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionPoolConfigurationInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectionPoolConfigurationInfo", value);
    }

    /**
     * Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionPoolConfigurationInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectionPoolConfigurationInfo", value);
    }

    /**
     * One or more DB cluster identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbClusterIdentifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbClusterIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more DB cluster identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifiers", value);
    }

    /**
     * One or more DB instance identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbInstanceIdentifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more DB instance identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceIdentifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceIdentifiers", value);
    }
    /**
     * Specifies the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTargetGroup</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ConnectionPoolConfigurationInfoFormatProperty connectionPoolConfigurationInfoFormatProperty = ConnectionPoolConfigurationInfoFormatProperty.builder()
     *         .connectionBorrowTimeout(123)
     *         .initQuery("initQuery")
     *         .maxConnectionsPercent(123)
     *         .maxIdleConnectionsPercent(123)
     *         .sessionPinningFilters(List.of("sessionPinningFilters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionPoolConfigurationInfoFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionPoolConfigurationInfoFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of seconds for a proxy to wait for a connection to become available in the connection pool.
         * <p>
         * This setting only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
         * <p>
         * Default: <code>120</code>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be between 0 and 3600.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-connectionborrowtimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-connectionborrowtimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionBorrowTimeout() {
            return null;
        }

        /**
         * Add an initialization query, or modify the current one.
         * <p>
         * You can specify one or more SQL statements for the proxy to run when opening each new database connection. The setting is typically used with <code>SET</code> statements to make sure that each connection has identical settings. Make sure that the query you add is valid. To include multiple variables in a single <code>SET</code> statement, use comma separators.
         * <p>
         * For example: <code>SET variable1=value1, variable2=value2</code>
         * <p>
         * For multiple statements, use semicolons as the separator.
         * <p>
         * Default: no initialization query
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-initquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-initquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInitQuery() {
            return null;
        }

        /**
         * The maximum size of the connection pool for each target in a target group.
         * <p>
         * The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.
         * <p>
         * If you specify <code>MaxIdleConnectionsPercent</code> , then you must also include a value for this parameter.
         * <p>
         * Default: <code>10</code> for RDS for Microsoft SQL Server, and <code>100</code> for all other engines
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be between 1 and 100.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxconnectionspercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxconnectionspercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConnectionsPercent() {
            return null;
        }

        /**
         * A value that controls how actively the proxy closes idle database connections in the connection pool.
         * <p>
         * The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.
         * <p>
         * If you specify this parameter, then you must also include a value for <code>MaxConnectionsPercent</code> .
         * <p>
         * Default: The default value is half of the value of <code>MaxConnectionsPercent</code> . For example, if <code>MaxConnectionsPercent</code> is 80, then the default value of <code>MaxIdleConnectionsPercent</code> is 40. If the value of <code>MaxConnectionsPercent</code> isn't specified, then for SQL Server, <code>MaxIdleConnectionsPercent</code> is <code>5</code> , and for all other engines, the default is <code>50</code> .
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be between 0 and the value of <code>MaxConnectionsPercent</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxidleconnectionspercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxidleconnectionspercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxIdleConnectionsPercent() {
            return null;
        }

        /**
         * Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
         * <p>
         * Including an item in the list exempts that class of SQL operations from the pinning behavior.
         * <p>
         * Default: no session pinning filters
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-sessionpinningfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-sessionpinningfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSessionPinningFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionPoolConfigurationInfoFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionPoolConfigurationInfoFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionPoolConfigurationInfoFormatProperty> {
            java.lang.Number connectionBorrowTimeout;
            java.lang.String initQuery;
            java.lang.Number maxConnectionsPercent;
            java.lang.Number maxIdleConnectionsPercent;
            java.util.List<java.lang.String> sessionPinningFilters;

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getConnectionBorrowTimeout}
             * @param connectionBorrowTimeout The number of seconds for a proxy to wait for a connection to become available in the connection pool.
             *                                This setting only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
             *                                <p>
             *                                Default: <code>120</code>
             *                                <p>
             *                                Constraints:
             *                                <p>
             *                                <ul>
             *                                <li>Must be between 0 and 3600.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionBorrowTimeout(java.lang.Number connectionBorrowTimeout) {
                this.connectionBorrowTimeout = connectionBorrowTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getInitQuery}
             * @param initQuery Add an initialization query, or modify the current one.
             *                  You can specify one or more SQL statements for the proxy to run when opening each new database connection. The setting is typically used with <code>SET</code> statements to make sure that each connection has identical settings. Make sure that the query you add is valid. To include multiple variables in a single <code>SET</code> statement, use comma separators.
             *                  <p>
             *                  For example: <code>SET variable1=value1, variable2=value2</code>
             *                  <p>
             *                  For multiple statements, use semicolons as the separator.
             *                  <p>
             *                  Default: no initialization query
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initQuery(java.lang.String initQuery) {
                this.initQuery = initQuery;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getMaxConnectionsPercent}
             * @param maxConnectionsPercent The maximum size of the connection pool for each target in a target group.
             *                              The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.
             *                              <p>
             *                              If you specify <code>MaxIdleConnectionsPercent</code> , then you must also include a value for this parameter.
             *                              <p>
             *                              Default: <code>10</code> for RDS for Microsoft SQL Server, and <code>100</code> for all other engines
             *                              <p>
             *                              Constraints:
             *                              <p>
             *                              <ul>
             *                              <li>Must be between 1 and 100.</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConnectionsPercent(java.lang.Number maxConnectionsPercent) {
                this.maxConnectionsPercent = maxConnectionsPercent;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getMaxIdleConnectionsPercent}
             * @param maxIdleConnectionsPercent A value that controls how actively the proxy closes idle database connections in the connection pool.
             *                                  The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.
             *                                  <p>
             *                                  If you specify this parameter, then you must also include a value for <code>MaxConnectionsPercent</code> .
             *                                  <p>
             *                                  Default: The default value is half of the value of <code>MaxConnectionsPercent</code> . For example, if <code>MaxConnectionsPercent</code> is 80, then the default value of <code>MaxIdleConnectionsPercent</code> is 40. If the value of <code>MaxConnectionsPercent</code> isn't specified, then for SQL Server, <code>MaxIdleConnectionsPercent</code> is <code>5</code> , and for all other engines, the default is <code>50</code> .
             *                                  <p>
             *                                  Constraints:
             *                                  <p>
             *                                  <ul>
             *                                  <li>Must be between 0 and the value of <code>MaxConnectionsPercent</code> .</li>
             *                                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxIdleConnectionsPercent(java.lang.Number maxIdleConnectionsPercent) {
                this.maxIdleConnectionsPercent = maxIdleConnectionsPercent;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionPoolConfigurationInfoFormatProperty#getSessionPinningFilters}
             * @param sessionPinningFilters Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
             *                              Including an item in the list exempts that class of SQL operations from the pinning behavior.
             *                              <p>
             *                              Default: no session pinning filters
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionPinningFilters(java.util.List<java.lang.String> sessionPinningFilters) {
                this.sessionPinningFilters = sessionPinningFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionPoolConfigurationInfoFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionPoolConfigurationInfoFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionPoolConfigurationInfoFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionPoolConfigurationInfoFormatProperty {
            private final java.lang.Number connectionBorrowTimeout;
            private final java.lang.String initQuery;
            private final java.lang.Number maxConnectionsPercent;
            private final java.lang.Number maxIdleConnectionsPercent;
            private final java.util.List<java.lang.String> sessionPinningFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionBorrowTimeout = software.amazon.jsii.Kernel.get(this, "connectionBorrowTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.initQuery = software.amazon.jsii.Kernel.get(this, "initQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxConnectionsPercent = software.amazon.jsii.Kernel.get(this, "maxConnectionsPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxIdleConnectionsPercent = software.amazon.jsii.Kernel.get(this, "maxIdleConnectionsPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sessionPinningFilters = software.amazon.jsii.Kernel.get(this, "sessionPinningFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionBorrowTimeout = builder.connectionBorrowTimeout;
                this.initQuery = builder.initQuery;
                this.maxConnectionsPercent = builder.maxConnectionsPercent;
                this.maxIdleConnectionsPercent = builder.maxIdleConnectionsPercent;
                this.sessionPinningFilters = builder.sessionPinningFilters;
            }

            @Override
            public final java.lang.Number getConnectionBorrowTimeout() {
                return this.connectionBorrowTimeout;
            }

            @Override
            public final java.lang.String getInitQuery() {
                return this.initQuery;
            }

            @Override
            public final java.lang.Number getMaxConnectionsPercent() {
                return this.maxConnectionsPercent;
            }

            @Override
            public final java.lang.Number getMaxIdleConnectionsPercent() {
                return this.maxIdleConnectionsPercent;
            }

            @Override
            public final java.util.List<java.lang.String> getSessionPinningFilters() {
                return this.sessionPinningFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectionBorrowTimeout() != null) {
                    data.set("connectionBorrowTimeout", om.valueToTree(this.getConnectionBorrowTimeout()));
                }
                if (this.getInitQuery() != null) {
                    data.set("initQuery", om.valueToTree(this.getInitQuery()));
                }
                if (this.getMaxConnectionsPercent() != null) {
                    data.set("maxConnectionsPercent", om.valueToTree(this.getMaxConnectionsPercent()));
                }
                if (this.getMaxIdleConnectionsPercent() != null) {
                    data.set("maxIdleConnectionsPercent", om.valueToTree(this.getMaxIdleConnectionsPercent()));
                }
                if (this.getSessionPinningFilters() != null) {
                    data.set("sessionPinningFilters", om.valueToTree(this.getSessionPinningFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionPoolConfigurationInfoFormatProperty.Jsii$Proxy that = (ConnectionPoolConfigurationInfoFormatProperty.Jsii$Proxy) o;

                if (this.connectionBorrowTimeout != null ? !this.connectionBorrowTimeout.equals(that.connectionBorrowTimeout) : that.connectionBorrowTimeout != null) return false;
                if (this.initQuery != null ? !this.initQuery.equals(that.initQuery) : that.initQuery != null) return false;
                if (this.maxConnectionsPercent != null ? !this.maxConnectionsPercent.equals(that.maxConnectionsPercent) : that.maxConnectionsPercent != null) return false;
                if (this.maxIdleConnectionsPercent != null ? !this.maxIdleConnectionsPercent.equals(that.maxIdleConnectionsPercent) : that.maxIdleConnectionsPercent != null) return false;
                return this.sessionPinningFilters != null ? this.sessionPinningFilters.equals(that.sessionPinningFilters) : that.sessionPinningFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionBorrowTimeout != null ? this.connectionBorrowTimeout.hashCode() : 0;
                result = 31 * result + (this.initQuery != null ? this.initQuery.hashCode() : 0);
                result = 31 * result + (this.maxConnectionsPercent != null ? this.maxConnectionsPercent.hashCode() : 0);
                result = 31 * result + (this.maxIdleConnectionsPercent != null ? this.maxIdleConnectionsPercent.hashCode() : 0);
                result = 31 * result + (this.sessionPinningFilters != null ? this.sessionPinningFilters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBProxyTargetGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBProxyTargetGroupProps.Builder();
        }

        /**
         * The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname</a>
         * @param dbProxyName The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(final java.lang.String dbProxyName) {
            this.props.dbProxyName(dbProxyName);
            return this;
        }

        /**
         * The identifier for the target group.
         * <p>
         * <blockquote>
         * <p>
         * Currently, this property must be set to <code>default</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname</a>
         * @param targetGroupName The identifier for the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(final java.lang.String targetGroupName) {
            this.props.targetGroupName(targetGroupName);
            return this;
        }

        /**
         * Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo</a>
         * @param connectionPoolConfigurationInfo Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPoolConfigurationInfo(final software.amazon.awscdk.IResolvable connectionPoolConfigurationInfo) {
            this.props.connectionPoolConfigurationInfo(connectionPoolConfigurationInfo);
            return this;
        }
        /**
         * Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo</a>
         * @param connectionPoolConfigurationInfo Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPoolConfigurationInfo(final software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty connectionPoolConfigurationInfo) {
            this.props.connectionPoolConfigurationInfo(connectionPoolConfigurationInfo);
            return this;
        }

        /**
         * One or more DB cluster identifiers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers</a>
         * @param dbClusterIdentifiers One or more DB cluster identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifiers(final java.util.List<java.lang.String> dbClusterIdentifiers) {
            this.props.dbClusterIdentifiers(dbClusterIdentifiers);
            return this;
        }

        /**
         * One or more DB instance identifiers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers</a>
         * @param dbInstanceIdentifiers One or more DB instance identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifiers(final java.util.List<java.lang.String> dbInstanceIdentifiers) {
            this.props.dbInstanceIdentifiers(dbInstanceIdentifiers);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup build() {
            return new software.amazon.awscdk.services.rds.CfnDBProxyTargetGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
