package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnOptionGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnOptionGroupProps cfnOptionGroupProps = CfnOptionGroupProps.builder()
 *         .engineName("engineName")
 *         .majorEngineVersion("majorEngineVersion")
 *         .optionGroupDescription("optionGroupDescription")
 *         // the properties below are optional
 *         .optionConfigurations(List.of(OptionConfigurationProperty.builder()
 *                 .optionName("optionName")
 *                 // the properties below are optional
 *                 .dbSecurityGroupMemberships(List.of("dbSecurityGroupMemberships"))
 *                 .optionSettings(List.of(OptionSettingProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .optionVersion("optionVersion")
 *                 .port(123)
 *                 .vpcSecurityGroupMemberships(List.of("vpcSecurityGroupMemberships"))
 *                 .build()))
 *         .optionGroupName("optionGroupName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-03-12T01:36:44.340Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnOptionGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnOptionGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOptionGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the name of the engine that this option group should be associated with.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>mariadb</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-ee-cdb</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se2-cdb</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineName();

    /**
     * Specifies the major version of the engine that this option group should be associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMajorEngineVersion();

    /**
     * The description of the option group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOptionGroupDescription();

    /**
     * A list of all available options for an option group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptionConfigurations() {
        return null;
    }

    /**
     * The name of the option group to be created.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be 1 to 255 letters, numbers, or hyphens</li>
     * <li>First character must be a letter</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens</li>
     * </ul>
     * <p>
     * Example: <code>myoptiongroup</code>
     * <p>
     * If you don't specify a value for <code>OptionGroupName</code> property, a name is automatically created for the option group.
     * <p>
     * <blockquote>
     * <p>
     * This value is stored as a lowercase string.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOptionGroupName() {
        return null;
    }

    /**
     * Tags to assign to the option group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOptionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOptionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOptionGroupProps> {
        java.lang.String engineName;
        java.lang.String majorEngineVersion;
        java.lang.String optionGroupDescription;
        java.lang.Object optionConfigurations;
        java.lang.String optionGroupName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnOptionGroupProps#getEngineName}
         * @param engineName Specifies the name of the engine that this option group should be associated with. This parameter is required.
         *                   Valid Values:
         *                   <p>
         *                   <ul>
         *                   <li><code>mariadb</code></li>
         *                   <li><code>mysql</code></li>
         *                   <li><code>oracle-ee</code></li>
         *                   <li><code>oracle-ee-cdb</code></li>
         *                   <li><code>oracle-se2</code></li>
         *                   <li><code>oracle-se2-cdb</code></li>
         *                   <li><code>postgres</code></li>
         *                   <li><code>sqlserver-ee</code></li>
         *                   <li><code>sqlserver-se</code></li>
         *                   <li><code>sqlserver-ex</code></li>
         *                   <li><code>sqlserver-web</code></li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineName(java.lang.String engineName) {
            this.engineName = engineName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOptionGroupProps#getMajorEngineVersion}
         * @param majorEngineVersion Specifies the major version of the engine that this option group should be associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder majorEngineVersion(java.lang.String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnOptionGroupProps#getOptionGroupDescription}
         * @param optionGroupDescription The description of the option group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroupDescription(java.lang.String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnOptionGroupProps#getOptionConfigurations}
         * @param optionConfigurations A list of all available options for an option group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionConfigurations(software.amazon.awscdk.IResolvable optionConfigurations) {
            this.optionConfigurations = optionConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnOptionGroupProps#getOptionConfigurations}
         * @param optionConfigurations A list of all available options for an option group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionConfigurations(java.util.List<? extends java.lang.Object> optionConfigurations) {
            this.optionConfigurations = optionConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnOptionGroupProps#getOptionGroupName}
         * @param optionGroupName The name of the option group to be created.
         *                        Constraints:
         *                        <p>
         *                        <ul>
         *                        <li>Must be 1 to 255 letters, numbers, or hyphens</li>
         *                        <li>First character must be a letter</li>
         *                        <li>Can't end with a hyphen or contain two consecutive hyphens</li>
         *                        </ul>
         *                        <p>
         *                        Example: <code>myoptiongroup</code>
         *                        <p>
         *                        If you don't specify a value for <code>OptionGroupName</code> property, a name is automatically created for the option group.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        This value is stored as a lowercase string.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroupName(java.lang.String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnOptionGroupProps#getTags}
         * @param tags Tags to assign to the option group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOptionGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOptionGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOptionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOptionGroupProps {
        private final java.lang.String engineName;
        private final java.lang.String majorEngineVersion;
        private final java.lang.String optionGroupDescription;
        private final java.lang.Object optionConfigurations;
        private final java.lang.String optionGroupName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engineName = software.amazon.jsii.Kernel.get(this, "engineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.majorEngineVersion = software.amazon.jsii.Kernel.get(this, "majorEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.optionGroupDescription = software.amazon.jsii.Kernel.get(this, "optionGroupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.optionConfigurations = software.amazon.jsii.Kernel.get(this, "optionConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.optionGroupName = software.amazon.jsii.Kernel.get(this, "optionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engineName = java.util.Objects.requireNonNull(builder.engineName, "engineName is required");
            this.majorEngineVersion = java.util.Objects.requireNonNull(builder.majorEngineVersion, "majorEngineVersion is required");
            this.optionGroupDescription = java.util.Objects.requireNonNull(builder.optionGroupDescription, "optionGroupDescription is required");
            this.optionConfigurations = builder.optionConfigurations;
            this.optionGroupName = builder.optionGroupName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getEngineName() {
            return this.engineName;
        }

        @Override
        public final java.lang.String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final java.lang.String getOptionGroupDescription() {
            return this.optionGroupDescription;
        }

        @Override
        public final java.lang.Object getOptionConfigurations() {
            return this.optionConfigurations;
        }

        @Override
        public final java.lang.String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engineName", om.valueToTree(this.getEngineName()));
            data.set("majorEngineVersion", om.valueToTree(this.getMajorEngineVersion()));
            data.set("optionGroupDescription", om.valueToTree(this.getOptionGroupDescription()));
            if (this.getOptionConfigurations() != null) {
                data.set("optionConfigurations", om.valueToTree(this.getOptionConfigurations()));
            }
            if (this.getOptionGroupName() != null) {
                data.set("optionGroupName", om.valueToTree(this.getOptionGroupName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnOptionGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOptionGroupProps.Jsii$Proxy that = (CfnOptionGroupProps.Jsii$Proxy) o;

            if (!engineName.equals(that.engineName)) return false;
            if (!majorEngineVersion.equals(that.majorEngineVersion)) return false;
            if (!optionGroupDescription.equals(that.optionGroupDescription)) return false;
            if (this.optionConfigurations != null ? !this.optionConfigurations.equals(that.optionConfigurations) : that.optionConfigurations != null) return false;
            if (this.optionGroupName != null ? !this.optionGroupName.equals(that.optionGroupName) : that.optionGroupName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engineName.hashCode();
            result = 31 * result + (this.majorEngineVersion.hashCode());
            result = 31 * result + (this.optionGroupDescription.hashCode());
            result = 31 * result + (this.optionConfigurations != null ? this.optionConfigurations.hashCode() : 0);
            result = 31 * result + (this.optionGroupName != null ? this.optionGroupName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
